/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.validators;

import com.kingdee.bos.tool.validators.Messages;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CommonValidator {
    static final int INT_VALIDATOR = 1;
    static final int LONG_VALIDATOR = 2;
    static final int FLOAT_VALIDATOR = 3;
    static final int DOUBLE_VALIDATOR = 4;
    static final int STRING_VALIDATOR = 5;
    private static final int SUPPROTABLE_VALIDATOR_NUM = 5;
    private static final long SUPPROTABLE_VALIDATOR_ALL = 31L;

    private CommonValidator() {
    }

    static String isValid(Object value, boolean isNullable, int validatorType, Object[] argvs) {
        if (value == null) {
            return CommonValidator.isValid(isNullable);
        }
        long tempLong = 1 << validatorType - 1;
        if ((tempLong & 0x1FL) != tempLong) {
            return Messages.CommonValidator_BuZhiChiGaiLeiXingDeXiaoYanQi + validatorType;
        }
        switch (validatorType) {
            case 1: {
                return CommonValidator.validateInteger(value, argvs);
            }
            case 2: {
                return CommonValidator.validateLong(value, argvs);
            }
            case 3: {
                return CommonValidator.validateFloat(value, argvs);
            }
            case 4: {
                return CommonValidator.validateDouble(value, argvs);
            }
            case 5: {
                return CommonValidator.validateString(value, argvs);
            }
        }
        return Messages.CommonValidator_BuZhiChiGaiLeiXingDeXiaoYanQi + validatorType;
    }

    private static String isValid(boolean isNullable) {
        if (isNullable) {
            return null;
        }
        return Messages.CommonValidator_BuJieShouKongZhi;
    }

    private static String changeToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    private static String validateInteger(Object value, Object[] ranges) {
        try {
            int intValue = value instanceof Integer ? (Integer)value : Integer.parseInt(CommonValidator.changeToString(value));
            if (ranges != null && ranges.length == 2 && ranges[0] instanceof Integer && ranges[1] instanceof Integer) {
                int min = (Integer)ranges[0];
                int max = (Integer)ranges[1];
                if (max < min) {
                    int temp = max;
                    max = min;
                    min = temp;
                }
                if (intValue < min || intValue > max) {
                    return Messages.CommonValidator_QingShuRuYouXiaoDeZhengXingShuZhi + Messages.CommonValidator_YouXiaoShuZhiFanWeiWei + min + "," + max + Messages.CommonValidator_End;
                }
            }
        }
        catch (Exception e) {
            return Messages.CommonValidator_QingShuRuYouXiaoDeZhengXingShuZhiE;
        }
        return null;
    }

    private static String validateLong(Object value, Object[] ranges) {
        try {
            long longValue = value instanceof Long ? (Long)value : Long.parseLong(CommonValidator.changeToString(value));
            if (ranges != null && ranges.length == 2 && ranges[0] instanceof Long && ranges[1] instanceof Long) {
                long min = (Long)ranges[0];
                long max = (Long)ranges[1];
                if (max < min) {
                    long temp = max;
                    max = min;
                    min = temp;
                }
                if (longValue < min || longValue > max) {
                    return Messages.CommonValidator_QingShuRuYouXiaoDeChangZhengXingShuZhi + Messages.CommonValidator_YouXiaoShuZhiFanWeiWei + min + "," + max + Messages.CommonValidator_End;
                }
            }
        }
        catch (Exception e) {
            return Messages.CommonValidator_QingShuRuYouXiaoDeChangZhengXingShuZhiE;
        }
        return null;
    }

    private static String validateFloat(Object value, Object[] ranges) {
        try {
            float floatValue = value instanceof Float ? ((Float)value).floatValue() : Float.parseFloat(CommonValidator.changeToString(value));
            if (ranges != null && ranges.length == 2 && ranges[0] instanceof Float && ranges[1] instanceof Float) {
                float min = ((Float)ranges[0]).floatValue();
                float max = ((Float)ranges[1]).floatValue();
                if (Float.compare(max, min) == -1) {
                    float temp = max;
                    max = min;
                    min = temp;
                }
                if (Float.compare(floatValue, min) == -1 || Float.compare(floatValue, max) == 1) {
                    return Messages.CommonValidator_QingShuRuYouXiaoDeFuDianXingShuZhi + Messages.CommonValidator_YouXiaoShuZhiFanWeiWei + min + "," + max + Messages.CommonValidator_End;
                }
            }
        }
        catch (Exception e) {
            return Messages.CommonValidator_QingShuRuYouXiaoDeFuDianXingShuZhiE;
        }
        return null;
    }

    private static String validateDouble(Object value, Object[] ranges) {
        try {
            double doubleValue = value instanceof Double ? (Double)value : Double.parseDouble(CommonValidator.changeToString(value));
            float floatValue = Float.parseFloat(CommonValidator.changeToString(value));
            if (ranges != null && ranges.length == 2 && ranges[0] instanceof Double && ranges[1] instanceof Double) {
                double min = ((Double)ranges[0]).floatValue();
                double max = ((Double)ranges[1]).floatValue();
                if (Double.compare(max, min) == -1) {
                    double temp = max;
                    max = min;
                    min = temp;
                }
                if (Double.compare(doubleValue, min) == -1 || Double.compare(doubleValue, max) == 1) {
                    return Messages.CommonValidator_QingShuRuYouXiaoDeShuangJingDuFuDianXingShuZhi + Messages.CommonValidator_YouXiaoShuZhiFanWeiWei + min + "," + max + Messages.CommonValidator_End;
                }
            }
        }
        catch (Exception e) {
            return Messages.CommonValidator_QingShuRuYouXiaoDeShuangJingDuFuDianXingShuZhiE;
        }
        return null;
    }

    private static String validateString(Object value, Object[] argvs) {
        Pattern pattern;
        Matcher matcher;
        if (argvs != null && argvs[0] instanceof Pattern && !(matcher = (pattern = (Pattern)argvs[0]).matcher(CommonValidator.changeToString(value))).matches()) {
            return Messages.CommonValidator_QingShuRuYouXiaoDeZiFuChuanYouXiaoDeZiFuChuanYingFuHeZhengZeBiaoDaShi + pattern.pattern();
        }
        return null;
    }
}

