/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bundle;

import com.kingdee.bos.bundle.BundleDependInfo;
import com.kingdee.bos.bundle.BundleInfo;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class BundleUtil {
    private static final Logger logger = Logger.getLogger(BundleUtil.class);
    public static final BundleInfo[] ESP_BUNDLES = new BundleInfo[]{new BundleInfo("org.eclipse.core.runtime", null, null, 4, true), new BundleInfo("org.eclipse.equinox.common", null, null, 2, true), new BundleInfo("org.eclipse.equinox.p2.reconciler.dropins", null, null, 4, true), new BundleInfo("org.eclipse.equinox.simpleconfigurator", null, null, 1, true), new BundleInfo("org.eclipse.osgi", null, null, -1, true)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateBunleConfigFile(File configFile, File[] pluginRoots) throws IOException {
        File baseFile = configFile;
        while (!"eclipse".equals(baseFile.getName())) {
            baseFile = baseFile.getParentFile();
        }
        File p = baseFile.getParentFile();
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < pluginRoots.length; ++i) {
            if (p.equals(pluginRoots[i])) continue;
            list.add(pluginRoots[i]);
        }
        pluginRoots = list.toArray(new File[list.size()]);
        BundleInfo[] newInfos = BundleUtil.readBundlesFromDir(pluginRoots);
        FileWriter fileWriter = null;
        PrintWriter writer = null;
        try {
            fileWriter = new FileWriter(configFile);
            writer = new PrintWriter(fileWriter);
            for (BundleInfo info : newInfos) {
                File file = new File(info.getPath());
                info.setPath("file:" + BundleUtil.getRelativePath(baseFile, file) + (file.isDirectory() ? File.separator : ""));
                writer.println(info.toString());
            }
            BundleInfo[] elpInfos = BundleUtil.readBundlesFromDir(new File[]{baseFile.getParentFile()});
            int m = ESP_BUNDLES.length;
            block5: for (int j = 0; j < m; ++j) {
                String id = ESP_BUNDLES[j].getId();
                int n = elpInfos.length;
                for (int i = 0; i < n; ++i) {
                    BundleInfo info = elpInfos[i];
                    if (!id.equals(info.getId())) continue;
                    info.setAutoStart(ESP_BUNDLES[j].isAutoStart());
                    info.setStartLevel(ESP_BUNDLES[j].getStartLevel());
                    continue block5;
                }
            }
            for (BundleInfo info : elpInfos) {
                File file = new File(info.getPath());
                info.setPath("file:" + BundleUtil.getRelativePath(baseFile, file) + (file.isDirectory() ? File.separator : ""));
                writer.println(info.toString());
            }
            writer.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(writer);
            FileUtils.close(fileWriter);
            throw throwable;
        }
        FileUtils.close(writer);
        FileUtils.close(fileWriter);
    }

    public static BundleDependInfo listRelatedBundles(File bundlesInfoFile, String bundleId) throws IOException {
        File baseDir = bundlesInfoFile.getParentFile().getParentFile().getParentFile();
        HashMap<String, BundleInfo> allBundleInfo = new HashMap<String, BundleInfo>();
        BundleInfo[] infos = BundleUtil.readBundlesFromConfig(bundlesInfoFile);
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            allBundleInfo.put(infos[i].getId(), infos[i]);
        }
        if (bundleId == null) {
            return null;
        }
        BundleInfo info = (BundleInfo)allBundleInfo.get(bundleId = bundleId.trim());
        if (info == null) {
            return null;
        }
        BundleDependInfo dependInfo = new BundleDependInfo(info);
        HashSet tempSet = new HashSet();
        BundleUtil.getRelateBundles(dependInfo, allBundleInfo, tempSet, baseDir);
        return dependInfo;
    }

    private static void getRelateBundles(BundleDependInfo dependInfo, Map allBundleInfo, Set tempSet, File baseDir) throws IOException {
        File root;
        String content;
        BundleInfo info = dependInfo.getInfo();
        String path = info.getPath().trim();
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if ((content = BundleUtil.getMainFestContent(root = new File(baseDir, path))) != null) {
            String[] items = BundleUtil.getRelateBunldes(content);
            if (items == null) {
                return;
            }
            for (String id : items) {
                if (tempSet.contains(id)) continue;
                tempSet.add(id);
                BundleInfo bi = (BundleInfo)allBundleInfo.get(id);
                if (bi == null) continue;
                BundleDependInfo dep = dependInfo.addDepend(bi);
                BundleUtil.getRelateBundles(dep, allBundleInfo, tempSet, baseDir);
            }
        }
    }

    public static void adjustBunleConfigFile(File configFile, File[] pluginRoots) throws IOException {
        File baseFile = configFile;
        while (!"eclipse".equals(baseFile.getName())) {
            baseFile = baseFile.getParentFile();
        }
        BundleInfo[] oldInfos = BundleUtil.readBundlesFromConfig(configFile);
        TreeMap<String, BundleInfo> oldMap = new TreeMap<String, BundleInfo>();
        for (BundleInfo info : oldInfos) {
            BundleInfo otherInfo = (BundleInfo)oldMap.get(info.getId());
            if (otherInfo != null && info.getVersion().compareTo(otherInfo.getVersion()) < 0) {
                info = otherInfo;
            }
            oldMap.put(info.getId(), info);
        }
        BundleInfo[] newInfos = BundleUtil.readBundlesFromDir(pluginRoots);
        HashMap newMap = new HashMap();
        for (BundleInfo info : newInfos) {
            BundleInfo otherInfo = (BundleInfo)newMap.get(info.getId());
            if (otherInfo != null && info.getVersion().compareTo(otherInfo.getVersion()) < 0) {
                info = otherInfo;
            }
            File file = new File(info.getPath());
            info.setPath("file:" + BundleUtil.getRelativePath(baseFile, file) + (file.isDirectory() ? File.separator : ""));
            otherInfo = (BundleInfo)oldMap.get(info.getId());
            if (otherInfo != null) {
                if (info.getVersion().compareTo(otherInfo.getVersion()) < 0) {
                    info = otherInfo;
                } else {
                    info.setAutoStart(otherInfo.isAutoStart());
                    info.setStartLevel(otherInfo.getStartLevel());
                }
            }
            oldMap.put(info.getId(), info);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(configFile));
        Iterator iter = oldMap.keySet().iterator();
        while (iter.hasNext()) {
            BundleInfo info;
            info = (BundleInfo)oldMap.get(iter.next());
            writer.println(info.getId() + "," + info.getVersion() + "," + info.getPath() + "," + info.getStartLevel() + "," + info.isAutoStart());
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleInfo[] readBundlesFromConfig(File configFile) throws IOException {
        ArrayList<BundleInfo> list = new ArrayList<BundleInfo>();
        FileReader fileReader = new FileReader(configFile);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(",");
                if (parts.length == 5) {
                    BundleInfo info = new BundleInfo();
                    info.setId(parts[0]);
                    info.setVersion(parts[1]);
                    info.setPath(parts[2]);
                    info.setStartLevel(Integer.parseInt(parts[3]));
                    info.setAutoStart(Boolean.valueOf(parts[4]));
                    list.add(info);
                } else {
                    logger.info((Object)("error config line:" + line));
                }
                line = reader.readLine();
            }
        }
        finally {
            FileUtils.close(fileReader);
            FileUtils.close(reader);
        }
        return list.toArray(new BundleInfo[list.size()]);
    }

    public static BundleInfo[] readBundlesFromDir(File[] roots) throws IOException {
        ArrayList<BundleInfo> list = new ArrayList<BundleInfo>();
        for (int i = 0; i < roots.length; ++i) {
            File pluginFile = new File(roots[i], "eclipse/plugins");
            File[] files = pluginFile.listFiles();
            if (files == null) continue;
            for (int j = 0; j < files.length; ++j) {
                BundleInfo info;
                File file = files[j];
                if (file.isDirectory()) {
                    info = BundleUtil.readBundleFromDir(file);
                    if (info != null) {
                        list.add(info);
                        continue;
                    }
                    logger.info((Object)("can't read bundle from " + file));
                    continue;
                }
                if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                info = BundleUtil.readBundleFromJar(file);
                if (info != null) {
                    list.add(info);
                    continue;
                }
                logger.info((Object)("can't read bundle from " + file));
            }
        }
        return list.toArray(new BundleInfo[list.size()]);
    }

    public static BundleInfo readBundleFromDir(File dir) {
        File maineFest = new File(dir, "META-INF/MANIFEST.MF");
        if (maineFest.exists()) {
            String content = BundleUtil.getFileContent(maineFest);
            BundleInfo info = BundleUtil.readFromManifest(content);
            info.setPath(dir.getAbsolutePath());
            return info;
        }
        BundleInfo info = new BundleInfo();
        File pluginFile = new File(dir, "plugin.xml");
        if (!pluginFile.exists()) {
            return null;
        }
        String content = BundleUtil.getFileContent(pluginFile);
        info = BundleUtil.readFromPluginXML(content);
        info.setPath(dir.getAbsolutePath());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(File file) {
        if (!file.isFile() || !file.exists()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        byte[] bs = new byte[1024];
        try {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                int len = input.read(bs);
                while (len != -1) {
                    String s = new String(bs, 0, len, "UTF-8");
                    sb.append(s);
                    len = input.read(bs);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(input);
                throw throwable;
            }
            FileUtils.close(input);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return sb.toString();
    }

    public static BundleInfo readBundleFromJar(File jar) throws IOException {
        String content;
        InputStream input;
        BundleInfo info = null;
        JarFile jarFile = new JarFile(jar);
        ZipEntry entry = jarFile.getEntry("META-INF/MANIFEST.MF");
        if (entry != null) {
            try {
                input = jarFile.getInputStream(entry);
                content = BundleUtil.getContent(input);
                info = BundleUtil.readFromManifest(content);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        if (info == null && (entry = jarFile.getEntry("plugin.xml")) != null) {
            try {
                input = jarFile.getInputStream(entry);
                content = BundleUtil.getContent(input);
                info = BundleUtil.readFromPluginXML(content);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        jarFile.close();
        if (info != null) {
            info.setPath(jar.getAbsolutePath());
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMainFestContent(File root) throws IOException {
        if (root.isDirectory()) {
            File manifest = new File(root, "META-INF/MANIFEST.MF");
            if (manifest.exists()) {
                return BundleUtil.getFileContent(manifest);
            }
        } else if (root.getName().endsWith(".jar")) {
            try (JarFile jarFile = new JarFile(root);){
                ZipEntry entry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (entry != null) {
                    InputStream input = jarFile.getInputStream(entry);
                    String string = BundleUtil.getContent(input);
                    return string;
                }
            }
        }
        return null;
    }

    public static String[] getRelateBunldes(String manifestContent) {
        String content = manifestContent;
        int index = content.indexOf("Require-Bundle:");
        if (index == -1) {
            return null;
        }
        content = content.substring(index + "Require-Bundle:".length()).trim();
        int length = content.length();
        for (index = 0; index < length && (content.charAt(index) != '\n' || index >= length - 1 || content.charAt(index + 1) == ' '); ++index) {
        }
        content = content.substring(0, index);
        StringUtils.replace((String)content, (String)"\n", (String)"");
        String[] items = StringUtils.split((String)content, (int)44);
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            String id = items[i].trim();
            if (id.indexOf(";") != -1) {
                id = id.substring(0, id.indexOf(";")).trim();
            }
            items[i] = id;
        }
        return items;
    }

    private static String getContent(InputStream input) throws IOException {
        StringBuffer sb = new StringBuffer();
        byte[] bs = new byte[1024];
        try {
            int len = input.read(bs);
            while (len != -1) {
                String s = new String(bs, 0, len, "utf-8");
                sb.append(s);
                len = input.read(bs);
            }
            input.close();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        input.close();
        return sb.toString();
    }

    private static BundleInfo readFromManifest(String content) {
        int temp;
        int sIndex = content.indexOf("Bundle-SymbolicName:");
        if (sIndex == -1) {
            return null;
        }
        int eIndex = content.indexOf(10, sIndex += "Bundle-SymbolicName:".length());
        if (eIndex > (temp = content.indexOf(59, sIndex)) && temp != -1) {
            eIndex = temp;
        }
        String id = content.substring(sIndex, eIndex).trim();
        sIndex = content.indexOf("Bundle-Version:") + "Bundle-Version:".length();
        eIndex = content.indexOf(10, sIndex);
        String version = content.substring(sIndex, eIndex).trim();
        BundleInfo info = new BundleInfo();
        info.setId(id);
        info.setVersion(version);
        return info;
    }

    private static BundleInfo readFromPluginXML(String content) {
        int sIndex = content.indexOf("id=\"") + "id=\"".length();
        int eIndex = content.indexOf(34, sIndex);
        String id = content.substring(sIndex, eIndex).trim();
        sIndex = content.indexOf("version=\"", eIndex) + "version=\"".length();
        eIndex = content.indexOf(34, sIndex);
        String version = content.substring(sIndex, eIndex).trim();
        BundleInfo info = new BundleInfo();
        info.setId(id);
        info.setVersion(version);
        return info;
    }

    public static String getRelativePath(File baseFile, File compFile) {
        int i;
        File compParent;
        File baseParent;
        int sameLevel;
        File p;
        ArrayList<File> baseList = new ArrayList<File>();
        for (p = baseFile; p != null; p = p.getParentFile()) {
            baseList.add(0, p);
        }
        ArrayList<File> compList = new ArrayList<File>();
        for (p = compFile; p != null; p = p.getParentFile()) {
            compList.add(0, p);
        }
        File sameParent = null;
        int n = baseList.size();
        int m = compList.size();
        for (sameLevel = 0; sameLevel < n && sameLevel < m && (baseParent = (File)baseList.get(sameLevel)).equals(compParent = (File)compList.get(sameLevel)); ++sameLevel) {
            sameParent = baseParent;
        }
        String path = null;
        if (sameLevel == 0) {
            path = compFile.getAbsolutePath();
        } else if (sameLevel == compList.size()) {
            if (sameLevel == baseList.size()) {
                path = ".";
            } else {
                path = "";
                for (i = baseList.size() - sameLevel; i > 0; --i) {
                    path = path + "../";
                }
            }
        } else if (sameLevel == baseList.size()) {
            path = compFile.getAbsolutePath().substring(sameParent.getAbsolutePath().length() + 1);
        } else {
            path = compFile.getAbsolutePath().substring(sameParent.getAbsolutePath().length() + 1);
            for (i = baseList.size() - sameLevel; i > 0; --i) {
                path = "../" + path;
            }
        }
        return path;
    }
}

