/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.command;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.dao.ICommand;
import org.eclipse.core.runtime.IProgressMonitor;

public class MDCreatePackageCommand
implements ICommand {
    private PackageInfo info;
    private IMDProject project;

    public MDCreatePackageCommand(IMDProject project, PackageInfo info) {
        this.info = info;
        this.project = project;
    }

    @Override
    public void exec(IProgressMonitor monitor) {
        try {
            this.innerCreatePackage(this.info, monitor);
        }
        catch (Exception e) {
            LogTool.logError("\u521b\u5efapackage\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    private void innerCreatePackage(PackageInfo pInfo, IProgressMonitor monitor) throws IDEException {
        IMDFile file = MDResourceUtil.getFile(this.project, (IObjectValue)this.info);
        if (file.toFile().exists()) {
            return;
        }
        IMDFolder folder = file.getParent();
        if (!folder.toFile().exists()) {
            folder.toFile().mkdirs();
        }
        MDORMUtil.store(this.project, (IObjectValue)this.info, monitor);
        MDResourceUtil.fireResourceCreated(file);
    }
}

