/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.dialog;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.ui.MDTypeImages;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.UIHelper;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;

public class SearchMDDialog
extends Dialog {
    private Label textPath;
    private Text textPattern;
    private IMDProject project;
    private TableViewer listFile;
    private Label labeImage;
    private Label labelSize;
    private Combo comboProject;
    private IMDFile[] files = null;
    private SearchPattern patternMatcher = new SearchPattern();

    protected boolean isResizable() {
        return true;
    }

    public SearchMDDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(1808));
        UIHelper.createLabelLeft(comp, "\u8f93\u5165\u6587\u4ef6\u540d\u79f0\u5305\u542b\u7684\u5b57\u7b26\u4e32(*\u8868\u793a\u4efb\u610f\u5b57\u7b26\uff0c?\u8868\u793a\u5355\u4e2a\u5b57\u7b26):");
        Composite panel = UIHelper.createPanel(comp, 768, 1, 3);
        UIHelper.createLabel(panel, "\u641c\u7d22\u8303\u56f4(&P):");
        this.comboProject = UIHelper.createCombo(panel, 12, 1);
        IMDProject[] projects = MDResourceUtil.listMDProject();
        String[] names = new String[projects.length];
        for (int i = 0; i < projects.length; ++i) {
            names[i] = projects[i].getName();
        }
        this.comboProject.setItems(names);
        this.project = MDResourceUtil.getLatestProject();
        if (this.project == null && projects.length > 0) {
            this.project = projects[0];
        }
        if (this.project != null) {
            this.comboProject.setText(this.project.getName());
        }
        this.comboProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = SearchMDDialog.this.comboProject.getText();
                IMDProject[] projects = MDResourceUtil.listMDProject();
                for (int i = 0; i < projects.length; ++i) {
                    if (!projects[i].getName().equals(name)) continue;
                    SearchMDDialog.this.project = projects[i];
                    SearchMDDialog.access$202(SearchMDDialog.this, null);
                    SearchMDDialog.this.search();
                    break;
                }
            }
        });
        this.textPattern = UIHelper.createText(panel);
        this.textPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchMDDialog.this.search();
            }
        });
        UIHelper.createLabelLeft(comp, "\u5339\u914d\u9879(&M)");
        this.listFile = new TableViewer(comp, 268503556);
        Table table = this.listFile.getTable();
        table.setLayoutData((Object)new GridData(1808));
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setWidth(250);
        TableColumn valColumn = new TableColumn(table, 16384);
        valColumn.setWidth(300);
        table.setHeaderVisible(true);
        this.listFile.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SearchMDDialog.this.okPressed();
            }
        });
        this.listFile.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)SearchMDDialog.this.listFile.getSelection();
                if (sel.isEmpty()) {
                    SearchMDDialog.this.textPath.setText("");
                    SearchMDDialog.this.labeImage.setImage(null);
                    SearchMDDialog.this.getButton(0).setEnabled(false);
                } else {
                    IMDFile file = (IMDFile)sel.getFirstElement();
                    if (file.toFile().exists()) {
                        SearchMDDialog.this.textPath.setText(file.toFile().getAbsolutePath());
                    } else {
                        File[] fs = file.getMDProject().getLibFiles(file.getPath());
                        if (fs != null && fs.length > 0) {
                            SearchMDDialog.this.textPath.setText(fs[0].getAbsolutePath());
                        } else {
                            SearchMDDialog.this.textPath.setText("");
                        }
                    }
                    SearchMDDialog.this.labeImage.setImage(MDTypeImages.getImage(file));
                    SearchMDDialog.this.getButton(0).setEnabled(true);
                }
                SearchMDDialog.this.textPath.getParent().layout();
            }
        });
        this.listFile.setContentProvider((IContentProvider)new MDTableContentProvider());
        this.listFile.setLabelProvider((IBaseLabelProvider)new MDTableLabelProvider());
        panel = UIHelper.createPanel(comp, 768, 1, 2);
        this.labeImage = UIHelper.createLabelLeft(panel, "");
        this.textPath = UIHelper.createLabelLeft(panel, "");
        this.textPath.setToolTipText("\u53cc\u51fb\u6253\u5f00\u6240\u5728\u76ee\u5f55");
        this.textPath.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String path = SearchMDDialog.this.textPath.getText();
                if (StringUtils.isEmpty((String)path)) {
                    return;
                }
                try {
                    Runtime.getRuntime().exec("explorer /e, " + new File(path).getParent());
                }
                catch (Exception ex) {
                    LogTool.logError("\u6253\u5f00\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", ex);
                }
            }
        });
        UIHelper.createLabelLeft(panel, "");
        this.labelSize = UIHelper.createLabelLeft(panel, "");
        UIHelper.setHeight((Control)comp, 400);
        UIHelper.setWidth((Control)comp, 600);
        this.getShell().setText("\u6253\u5f00\u5143\u6570\u636e");
        this.textPattern.forceFocus();
        return comp;
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.listFile.getSelection();
        if (!sel.isEmpty()) {
            IMDFile file = (IMDFile)sel.getFirstElement();
            EditorHelper.openFile(file);
        }
        super.okPressed();
    }

    private void search() {
        if (this.project == null) {
            return;
        }
        long t = System.currentTimeMillis();
        if (this.files == null) {
            this.files = this.project.getRoot().listAllFile(null);
        }
        String p = this.textPattern.getText();
        this.patternMatcher.setPattern(p);
        ArrayList<IMDFile> list = new ArrayList<IMDFile>();
        for (int i = 0; i < this.files.length; ++i) {
            String name = this.files[i].getName();
            if (!this.patternMatcher.matches(name)) continue;
            list.add(this.files[i]);
        }
        if (list.size() < 100) {
            Collections.sort(list);
        }
        this.listFile.setInput(list);
        if (!list.isEmpty()) {
            this.listFile.setSelection((ISelection)new StructuredSelection(list.get(0)));
        }
        this.labelSize.setText("\u641c\u7d22\u5230 " + list.size() + " \u4e2a\u7ed3\u679c, \u8017\u65f6  " + (System.currentTimeMillis() - t) + " \u6beb\u79d2");
        this.labelSize.getParent().layout();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    static /* synthetic */ IMDFile[] access$202(SearchMDDialog x0, IMDFile[] x1) {
        x0.files = x1;
        return x1;
    }

    private class MDTableContentProvider
    implements IStructuredContentProvider {
        private MDTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MDTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MDTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IMDFile && columnIndex == 0) {
                return MDTypeImages.getImage((IMDFile)element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IMDFile) {
                IMDFile file = (IMDFile)element;
                if (columnIndex == 0) {
                    return file.getName();
                }
                String path = StringUtils.replace((String)file.getParent().getPath(), (String)"/", (String)".");
                if (path.endsWith(".")) {
                    path = path.substring(0, path.length() - 1);
                }
                return path;
            }
            return null;
        }
    }
}

