/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.connection;

import com.kingdee.bos.tool.connection.Group;
import com.kingdee.bos.tool.connection.Property;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.WorkbenchException;

public class GroupExtensionPointProcess {
    private static final String EXTENSION_POINT = "com.kingdee.bos.tool.toolcommon.connection";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.connection.GroupExtensionPointProcess");
    private static Map groups;

    private static void process() throws WorkbenchException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        if (extensionPoint == null) {
            throw new WorkbenchException("unable to resolve extension-point: com.kingdee.bos.tool.toolcommon.connection");
        }
        IConfigurationElement[] setElements = extensionPoint.getConfigurationElements();
        GroupExtensionPointProcess.config(setElements);
    }

    public static Map getGroups() {
        if (groups == null) {
            try {
                GroupExtensionPointProcess.process();
            }
            catch (WorkbenchException e) {
                groups = new HashMap();
                logger.error((Object)"", (Throwable)e);
            }
        }
        return groups;
    }

    private static void config(IConfigurationElement[] elements) {
        groups = new HashMap();
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (!element.getName().equals("group")) continue;
            Group group = new Group();
            group.setId(element.getAttribute("id"));
            group.setName(element.getAttribute("name"));
            group.setClassName(element.getAttribute("class"));
            group.setBundle(Platform.getBundle((String)element.getDeclaringExtension().getNamespace()));
            IConfigurationElement[] children = element.getChildren();
            Property[] properties = new Property[children.length];
            for (int j = 0; j < children.length; ++j) {
                IConfigurationElement child = children[j];
                Property prop = new Property();
                prop.setId(child.getAttribute("id"));
                prop.setName(child.getAttribute("name"));
                prop.setType(child.getAttribute("type"));
                properties[j] = prop;
            }
            group.setProperties(properties);
            groups.put(group.getId(), group);
        }
    }
}

