/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.dbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Vector;

public class SQLSERVERSchemaDAO
extends DBSchemaDAO {
    private static int maxDataLength = 0x40000000;

    public static Vector getAllTableName(Connection cn) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Vector<String> vector = new Vector<String>(0);
        try {
            String sql = "SELECT NAME FROM SYSOBJECTS WHERE TYPE='U'";
            stmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
            rs = stmt.executeQuery();
            while (rs.next()) {
                vector.addElement(rs.getString("NAME"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return vector;
    }

    public static void renameTable(String oldName, String newName, DBUpdateList dbUpdateList) throws SQLException {
        String sql = "EXEC sp_rename N'[dbo].[" + oldName + "]', N'" + newName + "', N'object'";
        SQLSERVERSchemaDAO.addSQLToList(9, newName, sql, dbUpdateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        AbstractTableInfo abstractTableInfo;
        ResultSet subrs2;
        ResultSet subrs;
        ResultSet rs;
        PreparedStatement substmt2;
        PreparedStatement substmt;
        PreparedStatement stmt;
        block28: {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            stmt = null;
            substmt = null;
            substmt2 = null;
            rs = null;
            subrs = null;
            subrs2 = null;
            String sql = "sp_tables ?";
            stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
            rs = stmt.executeQuery();
            if (!rs.next()) break block28;
            String tbowner = rs.getString("TABLE_OWNER");
            AbstractTableInfo table = new AbstractTableInfo();
            table.setName(tableName);
            sql = "sp_columns ?,?";
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, tbowner});
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                ColumnInfo col = new ColumnInfo();
                col.setName(subrs.getString("Column_Name"));
                String typeName = subrs.getString("Type_Name");
                typeName = StringUtils.replace((String)typeName, (String)"identity", (String)"");
                SQLType dataType = SQLSERVERSchemaDAO.getSQLType(typeName);
                if (dataType == null) {
                    sql = "select t1.name from systypes t1,systypes t2 where t1.xusertype = t2.xtype and t2.name = ?";
                    substmt2 = DBUtils.createPreparedStatement(cn, sql, typeName);
                    subrs2 = substmt2.executeQuery();
                    if (subrs2.next()) {
                        typeName = subrs2.getString("name");
                        dataType = SQLSERVERSchemaDAO.getSQLType(typeName);
                        if (dataType == null) {
                            throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                        }
                    } else {
                        throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                    }
                    SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
                }
                col.setTypeName(dataType);
                String strDef = subrs.getString("Column_Def");
                col.setDefaultValue(strDef);
                if (!StringUtils.isEmpty((String)strDef)) {
                    String defsql = "Select t1.name From sysobjects t1 ";
                    defsql = defsql + " Inner join sysobjects t2 on t2.id=t1.parent_obj ";
                    defsql = defsql + " Inner join syscolumns t3 on t3.id =t2.id And t1.id =t3.cdefault ";
                    defsql = defsql + "\tWhere  t3.name='fid2' and t1.xtype='D'";
                    defsql = "/*dialect*/" + defsql;
                    PreparedStatement stmtdef = cn.prepareStatement(defsql);
                    ResultSet rstmp = stmtdef.executeQuery();
                    if (rstmp.next()) {
                        col.setExtendedProperty("defaultName", rstmp.getString("name"));
                    }
                }
                if (typeName.toLowerCase(Locale.ENGLISH).equals("nchar") || typeName.toLowerCase(Locale.ENGLISH).equals("nvarchar")) {
                    col.setLength(subrs.getInt("Precision"));
                } else {
                    col.setLength(subrs.getInt("Length"));
                }
                if (col.getLength() > maxDataLength) {
                    col.setLength(maxDataLength);
                }
                col.setNullable(subrs.getInt("Nullable") == 1);
                col.setPrecision(subrs.getInt("Precision"));
                col.setScale(subrs.getInt("Scale"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "sp_pkeys ?,?";
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, tbowner});
            subrs = substmt.executeQuery();
            if (subrs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(subrs.getString("PK_Name"));
                table.setPrimaryKey(pk);
                ColumnInfo col = DBUtils.getColumnByName(table, subrs.getString("Column_Name"));
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
                while (subrs.next()) {
                    col = DBUtils.getColumnByName(table, subrs.getString("Column_Name"));
                    pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            try {
                sql = "sp_helpindex ?";
                substmt = DBUtils.createPreparedStatement(cn, sql, tableName);
                subrs = substmt.executeQuery();
                while (subrs.next()) {
                    String indexName = subrs.getString("Index_Name");
                    if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
                    IndexInfo index = new IndexInfo();
                    index.setName(subrs.getString("Index_Name"));
                    index.setUnique(subrs.getString("index_description").toUpperCase(Locale.ENGLISH).indexOf("UNIQUE") > 0);
                    String[] indexColumns = StringUtils.split((String)subrs.getString("Index_Keys"), (String)",");
                    for (int i = 0; i < indexColumns.length; ++i) {
                        IndexColumnInfo indexColumn = new IndexColumnInfo();
                        String columnName = StringUtils.replace((String)indexColumns[i], (String)"(-)", (String)"");
                        indexColumn.setColumn(DBUtils.getColumnByName(table, columnName.trim()));
                        if (!columnName.equals(indexColumns[i])) {
                            indexColumn.setSortType(SortType.DESCEND);
                        }
                        index.getIndexColumns().add(indexColumn);
                    }
                    table.getIndexes().add(index);
                }
            }
            catch (SQLException indexName) {
            }
            finally {
                SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            }
            sql = "sp_fkeys @fktable_name = ? ,@fktable_owner=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, tbowner});
            subrs = substmt.executeQuery();
            ForeignKeyInfo prevFK = null;
            while (subrs.next()) {
                String fkName = subrs.getString("FK_Name");
                FKColumnPairInfo fkcol = new FKColumnPairInfo();
                fkcol.setForeignKeyColumn(DBUtils.getColumnByName(table, subrs.getString("FKColumn_Name")));
                ColumnInfo pkcolumn = new ColumnInfo();
                pkcolumn.setName(subrs.getString("PKColumn_Name"));
                fkcol.setPrimaryKeyColumn(pkcolumn);
                if (prevFK != null && prevFK.getName().equals(fkName)) {
                    prevFK.getFKColumnPairs().add(fkcol);
                    continue;
                }
                prevFK = new ForeignKeyInfo();
                AbstractTableInfo refTable = new AbstractTableInfo();
                refTable.setName(subrs.getString("PKTable_Name"));
                prevFK.setRefTable(refTable);
                prevFK.setName(fkName);
                prevFK.getFKColumnPairs().add(fkcol);
                table.getForeignKeys().add(prevFK);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            AbstractTableInfo abstractTableInfo2 = table;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
            return abstractTableInfo2;
        }
        try {
            abstractTableInfo = null;
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                SQLUtils.cleanup(subrs, substmt);
                SQLUtils.cleanup(subrs2, substmt2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup(subrs, substmt);
        SQLUtils.cleanup(subrs2, substmt2);
        return abstractTableInfo;
    }

    protected static void createRefFk(Connection conn, String tableName, DBUpdateList dbUpdateList) throws SQLException {
        String sql = "Select object_name(constid), '   Alter Table ' + object_name(v2.id) + ' ADD CONSTRAINT ' + object_name(constid) \r\n     + '   FOREIGN KEY (' + col_name(fkeyid,fkey1) + \r\n     +(Case When fkey2>0 then ','+ col_name(fkeyid,fkey2) Else '' End)\r\n     +(Case When fkey3>0 then ','+ col_name(fkeyid,fkey3) Else '' End) \r\n     +(Case When fkey4>0 then ','+ col_name(fkeyid,fkey4) Else '' End )\r\n     +(Case When fkey5>0 then ','+ col_name(fkeyid,fkey5) Else '' End )\r\n     +(Case When fkey6>0 then ','+ col_name(fkeyid,fkey6) Else '' End )\r\n     +(Case When fkey7>0 then ','+ col_name(fkeyid,fkey7) Else '' End )\r\n     +(Case When fkey8>0 then ','+ col_name(fkeyid,fkey8) Else '' End )\r\n     +(Case When fkey9>0 then ','+ col_name(fkeyid,fkey9) Else '' End )\r\n     +(Case When fkey10>0 then ','+ col_name(fkeyid,fkey10) Else '' End )\r\n     +(Case When fkey11>0 then ','+ col_name(fkeyid,fkey11) Else '' End )\r\n     +(Case When fkey12>0 then ','+ col_name(fkeyid,fkey12) Else '' End )\r\n     +(Case When fkey13>0 then ','+ col_name(fkeyid,fkey13) Else '' End )\r\n     +(Case When fkey14>0 then ','+ col_name(fkeyid,fkey14) Else '' End )\r\n     +(Case When fkey15>0 then ','+ col_name(fkeyid,fkey15) Else '' End )\r\n     +(Case When fkey16>0 then ','+ col_name(fkeyid,fkey16) Else '' End )\r\n      + ')'\r\n     + '  REFERENCES ' + object_name(rkeyid) + '(' + col_name(rkeyid,rkey1) + \r\n     +(Case When rkey2>0 then ','+ col_name(rkeyid,rkey2) Else '' End)\r\n     +(Case When rkey3>0 then ','+ col_name(rkeyid,rkey3) Else '' End) \r\n     +(Case When rkey4>0 then ','+ col_name(rkeyid,rkey4) Else '' End )\r\n     +(Case When rkey5>0 then ','+ col_name(rkeyid,rkey5) Else '' End )\r\n     +(Case When rkey6>0 then ','+ col_name(rkeyid,rkey6) Else '' End )\r\n     +(Case When rkey7>0 then ','+ col_name(rkeyid,rkey7) Else '' End )\r\n     +(Case When rkey8>0 then ','+ col_name(rkeyid,rkey8) Else '' End )\r\n     +(Case When rkey9>0 then ','+ col_name(rkeyid,rkey9) Else '' End )\r\n     +(Case When rkey10>0 then ','+ col_name(rkeyid,rkey10) Else '' End )\r\n     +(Case When rkey11>0 then ','+ col_name(rkeyid,rkey11) Else '' End )\r\n     +(Case When rkey12>0 then ','+ col_name(rkeyid,rkey12) Else '' End )\r\n     +(Case When rkey13>0 then ','+ col_name(rkeyid,rkey13) Else '' End )\r\n     +(Case When rkey14>0 then ','+ col_name(rkeyid,rkey14) Else '' End )\r\n     +(Case When rkey15>0 then ','+ col_name(rkeyid,rkey15) Else '' End )\r\n     +(Case When rkey16>0 then ','+ col_name(rkeyid,rkey16) Else '' End )\r\n     + ')'\r\n From sysreferences v1\r\n      Inner join sysobjects v2 on v1.fkeyid =v2.id \r\n Where v2.xtype='u' and v2.status>0 And rkeyid =object_id('" + tableName + "')";
        PreparedStatement substmt = null;
        ResultSet rs = null;
        if (conn instanceof KDConnection) {
            conn = ((KDConnection)conn).getNativeConnection();
        }
        try {
            substmt = DBUtils.createPreparedStatement(conn, sql, new String[0]);
            rs = substmt.executeQuery();
            while (rs.next()) {
                String pkName = rs.getString(1);
                String add_sql = rs.getString(2);
                SQLSERVERSchemaDAO.addSQLToList(17, pkName, add_sql, dbUpdateList);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, substmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)substmt);
    }

    public static void dropRefForeignKey(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        String tableName = table.getName();
        String sql = "Select object_name(constid),'Alter Table ' + object_name(v2.id) + ' DROP CONSTRAINT ' + object_name(constid) \r\n from sysreferences v1\r\n      inner join sysobjects v2 on v1.fkeyid =v2.id \r\n where v2.xtype='u'  and v2.status>0 And rkeyid =object_id('" + tableName + "')\r\n";
        sql = "/*dialect*/" + sql;
        PreparedStatement substmt = null;
        ResultSet rs = null;
        try {
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
            rs = substmt.executeQuery();
            while (rs.next()) {
                String fkName = rs.getString(1);
                String drop_sql = rs.getString(2);
                SQLSERVERSchemaDAO.addSQLToList(0, fkName, drop_sql, dbUpdateList);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, substmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)substmt);
    }

    public static void createRefForeignKey(Connection cn, AbstractTableInfo oldTable, AbstractTableInfo newTable, DBUpdateList dbUpdateList) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        String tableName = oldTable.getName();
        String sql = "Select object_name(constid), '   Alter Table ' + object_name(v2.id) + ' ADD CONSTRAINT ' + object_name(constid) \r\n     + '   FOREIGN KEY (' + col_name(fkeyid,fkey1) + \r\n     +(Case When fkey2>0 then ','+ col_name(fkeyid,fkey2) Else '' End)\r\n     +(Case When fkey3>0 then ','+ col_name(fkeyid,fkey3) Else '' End) \r\n     +(Case When fkey4>0 then ','+ col_name(fkeyid,fkey4) Else '' End )\r\n     +(Case When fkey5>0 then ','+ col_name(fkeyid,fkey5) Else '' End )\r\n     +(Case When fkey6>0 then ','+ col_name(fkeyid,fkey6) Else '' End )\r\n     +(Case When fkey7>0 then ','+ col_name(fkeyid,fkey7) Else '' End )\r\n     +(Case When fkey8>0 then ','+ col_name(fkeyid,fkey8) Else '' End )\r\n     +(Case When fkey9>0 then ','+ col_name(fkeyid,fkey9) Else '' End )\r\n     +(Case When fkey10>0 then ','+ col_name(fkeyid,fkey10) Else '' End )\r\n     +(Case When fkey11>0 then ','+ col_name(fkeyid,fkey11) Else '' End )\r\n     +(Case When fkey12>0 then ','+ col_name(fkeyid,fkey12) Else '' End )\r\n     +(Case When fkey13>0 then ','+ col_name(fkeyid,fkey13) Else '' End )\r\n     +(Case When fkey14>0 then ','+ col_name(fkeyid,fkey14) Else '' End )\r\n     +(Case When fkey15>0 then ','+ col_name(fkeyid,fkey15) Else '' End )\r\n     +(Case When fkey16>0 then ','+ col_name(fkeyid,fkey16) Else '' End )\r\n      + ')'\r\n     + '  REFERENCES ' + object_name(rkeyid) + '(' + col_name(rkeyid,rkey1) + \r\n     +(Case When rkey2>0 then ','+ col_name(rkeyid,rkey2) Else '' End)\r\n     +(Case When rkey3>0 then ','+ col_name(rkeyid,rkey3) Else '' End) \r\n     +(Case When rkey4>0 then ','+ col_name(rkeyid,rkey4) Else '' End )\r\n     +(Case When rkey5>0 then ','+ col_name(rkeyid,rkey5) Else '' End )\r\n     +(Case When rkey6>0 then ','+ col_name(rkeyid,rkey6) Else '' End )\r\n     +(Case When rkey7>0 then ','+ col_name(rkeyid,rkey7) Else '' End )\r\n     +(Case When rkey8>0 then ','+ col_name(rkeyid,rkey8) Else '' End )\r\n     +(Case When rkey9>0 then ','+ col_name(rkeyid,rkey9) Else '' End )\r\n     +(Case When rkey10>0 then ','+ col_name(rkeyid,rkey10) Else '' End )\r\n     +(Case When rkey11>0 then ','+ col_name(rkeyid,rkey11) Else '' End )\r\n     +(Case When rkey12>0 then ','+ col_name(rkeyid,rkey12) Else '' End )\r\n     +(Case When rkey13>0 then ','+ col_name(rkeyid,rkey13) Else '' End )\r\n     +(Case When rkey14>0 then ','+ col_name(rkeyid,rkey14) Else '' End )\r\n     +(Case When rkey15>0 then ','+ col_name(rkeyid,rkey15) Else '' End )\r\n     +(Case When rkey16>0 then ','+ col_name(rkeyid,rkey16) Else '' End )\r\n     + ')'\r\n From sysreferences v1\r\n      Inner join sysobjects v2 on v1.fkeyid =v2.id \r\n Where v2.xtype='u' and v2.status>0 And rkeyid =object_id('" + tableName + "')";
        sql = "/*dialect*/" + sql;
        PreparedStatement substmt = null;
        ResultSet rs = null;
        try {
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
            rs = substmt.executeQuery();
            while (rs.next()) {
                String pkName = rs.getString(1);
                SQLSERVERSchemaDAO.addSQLToList(17, pkName, sql, dbUpdateList);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, substmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)substmt);
    }

    protected static SQLType getSQLType(String typeName) {
        if (typeName.equals("char")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("nchar")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("varchar")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("nvarchar")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("text")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("ntext")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("sysname")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("binary")) {
            return SQLType.BINARY;
        }
        if (typeName.equals("varbinary")) {
            return SQLType.VARBINARY;
        }
        if (typeName.equals("image")) {
            return SQLType.BLOB;
        }
        if (typeName.equals("bigint")) {
            return SQLType.INT;
        }
        if (typeName.equals("int")) {
            return SQLType.INT;
        }
        if (typeName.equals("smallint")) {
            return SQLType.INT;
        }
        if (typeName.equals("tinyint")) {
            return SQLType.INT;
        }
        if (typeName.equals("bit")) {
            return SQLType.INT;
        }
        if (typeName.equals("real")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("float")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("money")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("smallmoney")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("numeric")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("decimal")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("datetime")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("smalldatetime")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("timestamp")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("GUID")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("uniqueidentifier")) {
            return SQLType.CHAR;
        }
        return null;
    }
}

