/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.report.TableReportCollection;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class KDBUtils {
    public static void sortReport(TableReportCollection items) {
        int i;
        ArrayList<TableReportItem> list = new ArrayList<TableReportItem>();
        int n = items.size();
        for (i = 0; i < n; ++i) {
            list.add(items.get(i));
        }
        Collections.sort(list);
        items.clear();
        n = list.size();
        for (i = 0; i < n; ++i) {
            items.add((TableReportItem)list.get(i));
        }
    }

    public static boolean dbHaveData(Connection cn, String tableName) throws SQLException {
        boolean bl;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT 1 FROM " + tableName + " WHERE EXISTS (SELECT 1  FROM " + tableName + ")";
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            bl = rs.next();
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((ResultSet)rs);
        return bl;
    }

    public static boolean isTableExists(Connection cn, String tableName) throws SQLException {
        boolean bl;
        ResultSet rs = null;
        try {
            tableName = tableName.toUpperCase();
            String sql = "SELECT 1 FROM KSQL_USERTABLES WHERE EXISTS (SELECT 1  FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ?)";
            int dbType = DBUtils.getDbType(cn);
            if (5 == dbType) {
                tableName = tableName.toLowerCase();
            }
            PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return bl;
    }

    public static Vector getAllTableName(Connection cn) throws SQLException {
        ResultSet rs = null;
        Vector<String> vector = new Vector<String>(0);
        try {
            rs = DBUtils.isOracle(DBUtils.getDbType(cn)) ? cn.getMetaData().getTables(null, KSqlUtil.getOracleCurrentUser((Connection)cn), null, new String[]{"TABLE"}) : cn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                vector.addElement(rs.getString("TABLE_NAME"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        Collections.sort(vector);
        return vector;
    }

    public static SQLType getSQLType(short dataType) {
        switch (dataType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return SQLType.INT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return SQLType.NUMERIC;
            }
            case 1: {
                return SQLType.CHAR;
            }
            case 12: {
                return SQLType.VARCHAR;
            }
            case -1: {
                return SQLType.CLOB;
            }
            case 91: 
            case 92: 
            case 93: {
                return SQLType.DATETIME;
            }
            case -2: {
                return SQLType.BINARY;
            }
            case -3: {
                return SQLType.VARBINARY;
            }
            case -4: {
                return SQLType.BLOB;
            }
            case 2004: {
                return SQLType.BLOB;
            }
            case 2005: {
                return SQLType.CLOB;
            }
        }
        return null;
    }

    public static String getColSQL(ColumnInfo col) {
        String sql = col.getName() + " " + KDBUtils.getDataType(col);
        String defValue = col.getDefaultValue();
        if (defValue != null) {
            sql = sql + " DEFAULT " + defValue;
        }
        sql = sql + (col.isNullable() ? " NULL" : " NOT NULL");
        return sql;
    }

    public static String getDataType(ColumnInfo col) {
        SQLType name = col.getTypeName();
        if (SQLType.CHAR.equals((Object)name) || SQLType.VARCHAR.equals((Object)name) || SQLType.NCHAR.equals((Object)name) || SQLType.NVARCHAR.equals((Object)name) || SQLType.CLOB.equals((Object)name) || SQLType.BLOB.equals((Object)name) || SQLType.NCLOB.equals((Object)name) || SQLType.BINARY.equals((Object)name) || SQLType.VARBINARY.equals((Object)name)) {
            return name.getName() + "(" + col.getLength() + ")";
        }
        if (SQLType.NUMERIC.equals((Object)name)) {
            return "DECIMAL(" + col.getPrecision() + "," + col.getScale() + ")";
        }
        if (SQLType.INT.equals((Object)name) || SQLType.DATETIME.equals((Object)name)) {
            return name.getName();
        }
        LogTool.logError("invalid col DataType " + col.getTypeName().getName(), new Exception("invalid col DataType"));
        return name.getName();
    }

    public static ColumnInfo getColumnByName(AbstractTableInfo table, String name) {
        int s = table.getColumns().size();
        for (int i = 0; i < s; ++i) {
            ColumnInfo col = table.getColumns().get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    public static IndexInfo getIndexByName(AbstractTableInfo table, String name) {
        int s = table.getIndexes().size();
        for (int i = 0; i < s; ++i) {
            IndexInfo info = table.getIndexes().get(i);
            if (!info.getName().equalsIgnoreCase(name)) continue;
            return info;
        }
        return null;
    }

    public static void fillIndex(ResultSet rs, AbstractTableInfo table) throws SQLException {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null || table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = null;
            for (int i = 0; i < table.getIndexes().size(); ++i) {
                if (!table.getIndexes().get(i).getName().equals(indexName)) continue;
                index = table.getIndexes().get(i);
                break;
            }
            if (index == null) {
                index = new IndexInfo();
                index.setName(rs.getString("INDEX_NAME"));
                index.setUnique(!rs.getBoolean("NON_UNIQUE"));
                table.getIndexes().add(index);
            }
            IndexColumnInfo indexColumn = new IndexColumnInfo();
            indexColumn.setColumn(KDBUtils.getColumnByName(table, rs.getString("COLUMN_NAME")));
            indexColumn.setSortType(rs.getString("ASC_OR_DESC").equals("A") ? SortType.ASCEND : SortType.DESCEND);
            index.getIndexColumns().add(indexColumn);
        }
    }

    public static ForeignKeyCollection getRefFKList(Connection cn, String tableName) throws SQLException {
        ForeignKeyCollection fkList = new ForeignKeyCollection();
        ResultSet rs = cn.getMetaData().getExportedKeys(null, null, tableName);
        while (rs.next()) {
            String fkName = rs.getString("FK_NAME");
            ForeignKeyInfo fk = null;
            for (int i = 0; i < fkList.size(); ++i) {
                if (!fkList.get(i).getName().equals(fkName)) continue;
                fk = fkList.get(i);
                break;
            }
            if (fk == null) {
                fk = new ForeignKeyInfo();
                AbstractTableInfo refTable = new AbstractTableInfo();
                refTable.setName(rs.getString("FKTABLE_NAME"));
                fk.setRefTable(refTable);
                fk.setName(fkName);
                fkList.add(fk);
            }
            FKColumnPairInfo fkcol = new FKColumnPairInfo();
            ColumnInfo fkcolumn = new ColumnInfo();
            fkcolumn.setName(rs.getString("FKCOLUMN_NAME"));
            fkcol.setForeignKeyColumn(fkcolumn);
            ColumnInfo pkcolumn = new ColumnInfo();
            pkcolumn.setName(rs.getString("PKCOLUMN_NAME"));
            fkcol.setPrimaryKeyColumn(pkcolumn);
            fk.getFKColumnPairs().add(fkcol);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return fkList;
    }
}

