/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.filters;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class MetaDataTypeFilter
extends ViewerFilter {
    private static final String[] ALL_SUFFIXES = new String[]{"bizdatatype", "entity", "enum", "exception", "facade", "function", "log", "mdquery", "mutex", "package", "permission", "query", "relation", "resource", "rule", "solution", "table", "ui", "ruleset", "biztemplate", "bizunit", "webui", "wbpage", "imageresource"};
    public static final String[] PACKAGE_SUFFIXES = new String[]{"closed project", "bizdatatype", "entity", "enum", "exception", "facade", "function", "log", "mdquery", "mutex", "rule", "permission", "query", "relation", "resource", "table", "ui", "ruleset", "biztemplate", "bizunit", "webui", "imageresource", "jar"};
    private static final String[] ALL_WITHOUT_UI_SUFFIXES = new String[]{"bizdatatype", "entity", "enum", "exception", "facade", "function", "log", "mdquery", "mutex", "package", "permission", "query", "relation", "resource", "rule", "solution", "table", "ruleset", "biztemplate", "bizunit", "imageresource"};
    private Collection suffixes = new ArrayList();
    private boolean filterEmptyPackage = true;

    public MetaDataTypeFilter(String[] types) {
        this(types, true);
    }

    public MetaDataTypeFilter(String[] types, boolean filterEmptyPackage) {
        this.setSuffixes(types);
        this.filterEmptyPackage = filterEmptyPackage;
    }

    public void setSuffixes(String[] types) {
        this.suffixes.clear();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null) continue;
            this.suffixes.add(types[i]);
        }
    }

    public Collection getSuffixes() {
        return this.suffixes;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            return this.isValidFile(((IFile)element).getFileExtension());
        }
        if (element instanceof IMDFile) {
            return this.isValidFile(((IMDFile)element).getExtension());
        }
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            if (folder.getName().equalsIgnoreCase("CVS")) {
                return false;
            }
            if (this.filterEmptyPackage) {
                return !this.isEmptyFolder(folder);
            }
        } else if (element instanceof IMDFolder) {
            IMDFolder folder = (IMDFolder)element;
            if (folder.getName().equalsIgnoreCase("CVS")) {
                return false;
            }
            if (this.filterEmptyPackage) {
                return folder.listChildren().length == 0;
            }
        } else {
            if (element instanceof IProject) {
                return this.isValidProject((IProject)element);
            }
            if (element instanceof IMDProject) {
                return this.isValidProject(MDResourceUtil.toIProject((IMDProject)element));
            }
        }
        return true;
    }

    private boolean isEmptyFolder(IFolder folder) {
        boolean isEmpty = true;
        IWorkbenchAdapter adapter = this.getAdapter(folder);
        if (adapter != null) {
            Object[] children = adapter.getChildren((Object)folder);
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof IFile) {
                    if (!this.isValidFile(((IFile)children[i]).getFileExtension())) continue;
                    isEmpty = false;
                    break;
                }
                isEmpty = isEmpty && this.isEmptyFolder((IFolder)children[i]);
            }
        }
        return isEmpty;
    }

    private IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(IWorkbenchAdapter.class);
    }

    private boolean isValidFile(String fileExtension) {
        if (fileExtension != null) {
            fileExtension = fileExtension.toLowerCase();
        }
        return this.suffixes.contains(fileExtension);
    }

    private boolean isValidProject(IProject project) {
        if (project.isOpen()) {
            return true;
        }
        return this.suffixes.contains("closed project");
    }

    public static String[] getAllSuffixes() {
        return (String[])ALL_SUFFIXES.clone();
    }

    public static String[] getAllWithoutUISuffixes() {
        return (String[])ALL_WITHOUT_UI_SUFFIXES.clone();
    }
}

