/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.function;

import com.kingdee.bos.tool.function.Func1;
import com.kingdee.bos.tool.function.Func2;
import com.kingdee.bos.tool.function.Func2V;
import com.kingdee.bos.tool.function.Functions;
import com.kingdee.bos.tool.function.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Maps {
    public <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        return Functions.nullAsDefault(map.get(key), defaultValue);
    }

    public static <K, V> Map<K, V> foreach(Map<K, V> map, Func1<V, K> iterator) {
        Preconditions.checkNotNull(map, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "map");
        Preconditions.checkNotNull(iterator, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "iterator");
        HashMap<K, V> newMap = new HashMap<K, V>();
        for (K key : map.keySet()) {
            newMap.put(key, iterator.invoke(key));
        }
        return newMap;
    }

    public static <K, V> void foreach(Map<K, V> map, Func2V<K, V> iterator) {
        Preconditions.checkNotNull(map, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "map");
        Preconditions.checkNotNull(iterator, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "iterator");
        for (K key : map.keySet()) {
            iterator.invoke(key, map.get(key));
        }
    }

    public static <K, V> List<K> filterMap(Map<K, V> map, Func2<Boolean, K, V> filter) {
        ArrayList<K> list = new ArrayList<K>();
        for (K key : map.keySet()) {
            if (!filter.invoke(key, map.get(key)).booleanValue()) continue;
            list.add(key);
        }
        return list;
    }

    public static <K, V> Map<K, V> putMap(Map<K, V> map, K key, V value) {
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> newMap(K key, V value) {
        return Maps.putMap(new HashMap(), key, value);
    }

    public static <K, V> V getValueWithDefault(Map<K, V> map, K key, V defaultValue) {
        return map.get(key) == null ? defaultValue : map.get(key);
    }

    public static void main(String[] args) {
        final HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "cds");
        map.put("abc", "cds");
        map.put("b", "1234");
        Map<String, String> newmap = Maps.foreach(map, new Func1<String, String>(){

            @Override
            public String invoke(String key) {
                return (String)map.get(key) + "@@@";
            }
        });
        System.out.println(newmap);
        List<String> keys = Maps.filterMap(map, new Func2<Boolean, String, String>(){

            @Override
            public Boolean invoke(String key, String value) {
                return key.indexOf("a") != -1;
            }
        });
        System.out.println(keys);
    }
}

