/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import com.kingdee.bos.tool.multipageeditor.common.TableViewerImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class SnappyTableViewer
extends TableViewer {
    private TableViewerImpl fTableViewerImpl;
    private Table fTable;
    private TableEditor fTableEditor;

    public SnappyTableViewer(Composite composite) {
        this(composite, 2818);
    }

    public SnappyTableViewer(Composite composite, int i) {
        this(new Table(composite, i));
    }

    public SnappyTableViewer(Table table) {
        super(table);
        this.fTable = table;
        this.addKeyListener();
        this.hookControl((Control)table);
        this.fTableEditor = new TableEditor(table);
        this.initTableViewerImpl();
    }

    public void add(Object[] aobj) {
        Object[] aobj1 = this.filter(aobj);
        for (int i = 0; i < aobj1.length; ++i) {
            Object obj = aobj1[i];
            int j = this.indexForElement(obj);
            this.updateItem((Widget)new TableItem(this.getTable(), 0, j), obj);
        }
    }

    public void add(Object obj) {
        this.add(new Object[]{obj});
    }

    private void addKeyListener() {
        if (this.fTable != null && !this.fTable.isDisposed()) {
            this.fTable.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyevent) {
                    TableItem[] atableitem;
                    if ((keyevent.character == '\r' || keyevent.character == ' ') && (atableitem = SnappyTableViewer.this.fTable.getSelection()) != null && atableitem.length == 1) {
                        SnappyTableViewer.this.fTableViewerImpl.setTableItem((Item)atableitem[0]);
                        SnappyTableViewer.this.fTableViewerImpl.activateFirstCellEditor();
                    }
                }

                public void keyReleased(KeyEvent keyevent) {
                }
            });
        }
    }

    public void cancelEditing() {
        this.fTableViewerImpl.cancelEditing();
    }

    public void finishEditing() {
        this.fTableViewerImpl.applyEditorValue();
    }

    protected Widget doFindInputItem(Object obj) {
        if (obj.equals(this.getRoot())) {
            return this.getTable();
        }
        return null;
    }

    protected Widget doFindItem(Object obj) {
        TableItem[] atableitem = this.fTable.getItems();
        for (int i = 0; i < atableitem.length; ++i) {
            TableItem tableitem = atableitem[i];
            Object obj1 = tableitem.getData();
            if (obj1 == null || !obj1.equals(obj)) continue;
            return tableitem;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object obj, boolean flag) {
        if (widget instanceof TableItem) {
            TableItem tableitem = (TableItem)widget;
            if (flag) {
                this.associate(obj, (Item)tableitem);
            } else {
                tableitem.setData(obj);
                this.mapElement(obj, (Widget)tableitem);
            }
            IBaseLabelProvider ibaselabelprovider = this.getLabelProvider();
            ITableLabelProvider itablelabelprovider = null;
            ILabelProvider ilabelprovider = null;
            if (ibaselabelprovider instanceof ITableLabelProvider) {
                itablelabelprovider = (ITableLabelProvider)ibaselabelprovider;
            } else {
                ilabelprovider = (ILabelProvider)ibaselabelprovider;
            }
            int i = this.fTable.getColumnCount();
            for (int j = 0; j < i || j == 0; ++j) {
                TableItem tableitem1 = tableitem;
                String s = "";
                Image image = null;
                if (itablelabelprovider != null) {
                    s = itablelabelprovider.getColumnText(obj, j);
                    image = itablelabelprovider.getColumnImage(obj, j);
                } else if (j == 0) {
                    s = ilabelprovider.getText(obj);
                    image = ilabelprovider.getImage(obj);
                }
                if (s != null) {
                    tableitem1.setText(j, s);
                }
                if (tableitem1.getImage(j) == image) continue;
                tableitem1.setImage(j, image);
            }
        }
    }

    public void editElement(Object obj, int i) {
        this.fTableViewerImpl.editElement(obj, i);
    }

    public CellEditor[] getCellEditors() {
        return this.fTableViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.fTableViewerImpl.getCellModifier();
    }

    public Object[] getColumnProperties() {
        return this.fTableViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.fTable;
    }

    public Object getElementAt(int i) {
        TableItem tableitem;
        if (i >= 0 && i < this.fTable.getItemCount() && (tableitem = this.fTable.getItem(i)) != null) {
            return tableitem.getData();
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        TableItem[] atableitem = this.fTable.getSelection();
        ArrayList<Object> arraylist = new ArrayList<Object>(atableitem.length);
        for (int i = 0; i < atableitem.length; ++i) {
            TableItem tableitem = atableitem[i];
            Object obj = tableitem.getData();
            if (obj == null) continue;
            arraylist.add(obj);
        }
        return arraylist;
    }

    public Table getTable() {
        return this.fTable;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Table table = (Table)control;
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionevent) {
                SnappyTableViewer.this.handleSelect(selectionevent);
            }

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                SnappyTableViewer.this.handleDoubleSelect(selectionevent);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseevent) {
                SnappyTableViewer.this.fTableViewerImpl.handleMouseDown(mouseevent);
            }

            public void mouseDoubleClick(MouseEvent mouseevent) {
                SnappyTableViewer.this.fTableViewerImpl.handleMouseDoubleClick(mouseevent);
            }
        });
    }

    protected int indexForElement(Object obj) {
        ViewerSorter viewersorter = this.getSorter();
        if (viewersorter == null) {
            return this.fTable.getItemCount();
        }
        int i = this.fTable.getItemCount();
        int j = 0;
        int k = i - 1;
        while (j <= k) {
            int l = (j + k) / 2;
            Object obj1 = this.fTable.getItem(l).getData();
            int i1 = viewersorter.compare((Viewer)this, obj1, obj);
            if (i1 == 0) {
                while (i1 == 0 && ++l < i) {
                    Object obj2 = this.fTable.getItem(l).getData();
                    i1 = viewersorter.compare((Viewer)this, obj2, obj);
                }
                return l;
            }
            if (i1 < 0) {
                j = l + 1;
                continue;
            }
            k = l - 1;
        }
        return j;
    }

    private void initTableViewerImpl() {
        this.fTableViewerImpl = new TableViewerImpl(){

            @Override
            Rectangle getBounds(Item item, int i) {
                return ((TableItem)item).getBounds(i);
            }

            @Override
            int getColumnCount() {
                return SnappyTableViewer.this.getTable().getColumnCount();
            }

            @Override
            Item[] getSelection() {
                return SnappyTableViewer.this.getTable().getSelection();
            }

            @Override
            void setEditor(Control control, Item item, int i) {
                SnappyTableViewer.this.fTableEditor.setEditor(control, (TableItem)item, i);
            }

            @Override
            void setSelection(StructuredSelection structuredselection, boolean flag) {
                SnappyTableViewer.this.setSelection((ISelection)structuredselection, flag);
            }

            @Override
            void showSelection() {
                SnappyTableViewer.this.getTable().showSelection();
            }

            @Override
            void setLayoutData(CellEditor.LayoutData layoutdata) {
                ((SnappyTableViewer)SnappyTableViewer.this).fTableEditor.grabHorizontal = layoutdata.grabHorizontal;
                ((SnappyTableViewer)SnappyTableViewer.this).fTableEditor.horizontalAlignment = layoutdata.horizontalAlignment;
                ((SnappyTableViewer)SnappyTableViewer.this).fTableEditor.minimumWidth = layoutdata.minimumWidth;
            }
        };
    }

    protected void inputChanged(Object obj, Object obj1) {
        this.getControl().setRedraw(false);
        try {
            this.refresh();
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public void insert(Object obj, int i) {
        this.fTableViewerImpl.applyEditorValue();
        if (this.getSorter() != null || this.hasFilters()) {
            this.add(obj);
            return;
        }
        if (i == -1) {
            i = this.fTable.getItemCount();
        }
        this.updateItem((Widget)new TableItem(this.fTable, 0, i), obj);
    }

    protected void internalRefresh(Object obj) {
        this.internalRefresh(obj, true);
    }

    protected void internalRefresh(Object obj, boolean flag) {
        this.fTableViewerImpl.applyEditorValue();
        if (obj == null || obj.equals(this.getRoot())) {
            Object[] aobj = this.getSortedChildren(this.getRoot());
            TableItem[] atableitem = this.fTable.getItems();
            int i = Math.min(aobj.length, atableitem.length);
            for (int j = 0; j < i; ++j) {
                if (aobj[j] == null || atableitem[j] == null) continue;
                if (aobj[j].equals(atableitem[j].getData())) {
                    if (!flag) continue;
                    this.updateItem((Widget)atableitem[j], aobj[j]);
                    continue;
                }
                this.disassociate((Item)atableitem[j]);
            }
            if (i < atableitem.length) {
                int k = atableitem.length;
                while (--k >= i) {
                    this.disassociate((Item)atableitem[k]);
                }
                this.fTable.remove(i, atableitem.length - 1);
            }
            if (this.fTable.getItemCount() == 0) {
                this.fTable.removeAll();
            }
            for (int l = 0; l < i; ++l) {
                if (atableitem[l].getData() != null) continue;
                this.updateItem((Widget)atableitem[l], aobj[l]);
            }
            for (int i1 = i; i1 < aobj.length; ++i1) {
                this.updateItem((Widget)new TableItem(this.fTable, 0, i1), aobj[i1]);
            }
        } else {
            Widget widget = this.findItem(obj);
            if (widget != null) {
                this.updateItem(widget, obj);
            }
        }
    }

    private void internalRemove(Object[] aobj) {
        Object obj = this.getInput();
        for (int i = 0; i < aobj.length; ++i) {
            if (!aobj[i].equals(obj)) continue;
            this.setInput(null);
            return;
        }
        int[] ai = new int[aobj.length];
        int j = 0;
        for (int k = 0; k < aobj.length; ++k) {
            Widget widget = this.findItem(aobj[k]);
            if (!(widget instanceof TableItem)) continue;
            TableItem tableitem = (TableItem)widget;
            this.disassociate((Item)tableitem);
            ai[j++] = this.fTable.indexOf(tableitem);
        }
        if (j < ai.length) {
            int[] nArray = ai;
            ai = new int[j];
            System.arraycopy(nArray, 0, ai, 0, j);
        }
        this.fTable.remove(ai);
        if (this.fTable.getItemCount() == 0) {
            this.fTable.removeAll();
        }
    }

    public boolean isCellEditorActive() {
        return this.fTableViewerImpl.isCellEditorActive();
    }

    public void remove(final Object[] elements) {
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                SnappyTableViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object obj) {
        this.remove(new Object[]{obj});
    }

    public void reveal(Object obj) {
        Widget widget = this.findItem(obj);
        if (widget instanceof TableItem) {
            this.getTable().showItem((TableItem)widget);
        }
    }

    public void setCellEditors(CellEditor[] acelleditor) {
        this.fTableViewerImpl.setCellEditors(acelleditor);
    }

    public void setCellModifier(ICellModifier icellmodifier) {
        this.fTableViewerImpl.setCellModifier(icellmodifier);
    }

    public void setColumnProperties(String[] as) {
        this.fTableViewerImpl.setColumnProperties(as);
    }

    public void setLabelProvider(IBaseLabelProvider ibaselabelprovider) {
        Assert.isTrue((ibaselabelprovider instanceof ITableLabelProvider || ibaselabelprovider instanceof ILabelProvider ? 1 : 0) != 0);
        super.setLabelProvider(ibaselabelprovider);
    }

    protected void setSelectionToWidget(List list, boolean flag) {
        if (list == null) {
            this.fTable.deselectAll();
            return;
        }
        int i = list.size();
        TableItem[] atableitem = new TableItem[i];
        TableItem tableitem = null;
        int j = 0;
        for (int k = 0; k < i; ++k) {
            Object obj = list.get(k);
            Widget widget = this.findItem(obj);
            if (!(widget instanceof TableItem)) continue;
            TableItem tableitem1 = (TableItem)widget;
            atableitem[j++] = tableitem1;
            if (tableitem != null) continue;
            tableitem = tableitem1;
        }
        if (j < i) {
            TableItem[] tableItemArray = atableitem;
            atableitem = new TableItem[j];
            System.arraycopy(tableItemArray, 0, atableitem, 0, j);
        }
        this.fTable.setSelection(atableitem);
        if (flag && tableitem != null) {
            this.fTable.showItem(tableitem);
        }
    }

    public void setSingleClickCellSelect(boolean flag) {
        this.fTableViewerImpl.setSingleClickCellSelect(flag);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        super.addDoubleClickListener(listener);
    }
}

