/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import com.kingdee.bos.tool.multipageeditor.common.HyperlinkHandler;
import com.kingdee.bos.tool.multipageeditor.common.IHyperlinkListener;
import com.kingdee.bos.tool.multipageeditor.common.LinkLabel;
import com.kingdee.bos.tool.widgets.HrefText;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class WidgetFactory {
    public static final String DEFAULT_HEADER_COLOR = "__default__header__";
    public static final String COLOR_BACKGROUND = "__bg";
    public static final String COLOR_BORDER = "__border";
    public static final String COLOR_COMPOSITE_SEPARATOR = "__compSep";
    public static final String COLOR_HYPERLINK = "__hyperlink";
    public static final String COLOR_ACTIVE_HYPERLINK = "__active_hyperlink";
    public static final String COLOR_SEPARATOR = "__separatorColor";
    public static final String COLOR_WHITE = "__whiteColor";
    public static final String COLOR_BLACK = "__blackColor";
    public static final String COLOR_FLAT_LABEL = "__flatLabelColor";
    public static final int SEPARATOR_WIDTH = 4;
    private Hashtable fColorRegistry = new Hashtable();
    private Color fClientAreaColor;
    private Color fWidgetBackgroundColor;
    private KeyListener fDeleteListener;
    private Color fForegroundColor;
    private Color fReadOnlyColor;
    private Display fDisplay = Display.getDefault();
    public static final int BORDER_STYLE = 0;
    private BorderPainter fBorderPainter;
    private Color fBorderColor;
    private HyperlinkHandler fHyperlinkHandler;
    private Image fBanner;

    public WidgetFactory() {
        this.initialize();
    }

    public Color getReadOnlyColor() {
        return this.fReadOnlyColor;
    }

    public Button createButton(Composite composite, String text, int style) {
        int j = 0x800000;
        Button button = new Button(composite, style | j);
        button.setBackground(this.fClientAreaColor);
        button.setForeground(this.fForegroundColor);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public Button createCheckBox(Composite composite, String text) {
        int j = 0x800000;
        int i = 32;
        Button button = new Button(composite, i | j);
        button.setBackground(this.fClientAreaColor);
        button.setForeground(this.fForegroundColor);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public Composite createComposite(Composite composite) {
        return this.createComposite(composite, 0);
    }

    public CCombo createCCombo(Composite composite) {
        int i = 8;
        i = !SWT.getPlatform().equals("motif") ? (i |= 0x800000) : (i |= 0x800);
        return this.createCCombo(composite, i);
    }

    public CCombo createCCombo(Composite composite, int style) {
        CCombo ccombo = new CCombo(composite, style);
        ccombo.setBackground(this.fClientAreaColor);
        ccombo.setForeground(this.fForegroundColor);
        return ccombo;
    }

    public Composite createComposite(Composite composite, int style) {
        Composite composite1 = new Composite(composite, style);
        composite1.setBackground(this.fClientAreaColor);
        return composite1;
    }

    public Composite createCompositeSeparator(Composite composite) {
        Composite composite1 = new Composite(composite, 0);
        composite1.setBackground(this.getColor(COLOR_COMPOSITE_SEPARATOR));
        return composite1;
    }

    public Label[] createFlatHeaderComposite(Composite composite, String[] as) {
        Composite composite1 = this.createComposite(composite);
        GridData griddata = new GridData(272);
        composite1.setLayoutData((Object)griddata);
        GridLayout gridlayout = new GridLayout();
        int i = 1;
        if (as.length != 1) {
            i = as.length * 2 + 1;
        }
        gridlayout.numColumns = i;
        gridlayout.marginHeight = 0;
        gridlayout.marginWidth = 0;
        gridlayout.horizontalSpacing = 5;
        gridlayout.verticalSpacing = 0;
        composite1.setLayout((Layout)gridlayout);
        Color color = this.getColor(COLOR_SEPARATOR);
        Color color1 = this.getColor(COLOR_BORDER);
        Color color2 = this.getColor(COLOR_WHITE);
        composite.setBackground(color1);
        Label[] alabel = new Label[i];
        Composite[] acomposite = new Composite[i];
        if (i == 1) {
            composite1.setBackground(this.fWidgetBackgroundColor);
            acomposite[0] = this.createComposite(composite1);
            GridLayout gridlayout1 = new GridLayout();
            gridlayout1.marginHeight = 1;
            gridlayout1.marginWidth = 1;
            acomposite[0].setLayout((Layout)gridlayout1);
            acomposite[0].setLayoutData((Object)new GridData(272));
            acomposite[0].setBackground(this.fWidgetBackgroundColor);
            alabel[0] = this.createTableLabel(acomposite[0], as[0], this.fWidgetBackgroundColor);
            alabel[0].setLayoutData((Object)new GridData(272));
            alabel[0].setBackground(this.fWidgetBackgroundColor);
        } else {
            for (int j = 0; j < i; ++j) {
                acomposite[j] = this.createComposite(composite1);
                GridData griddata1 = new GridData(272);
                acomposite[j].setLayoutData((Object)griddata1);
                GridLayout gridlayout2 = new GridLayout();
                gridlayout2.marginHeight = 1;
                gridlayout2.marginWidth = 1;
                acomposite[j].setLayout((Layout)gridlayout2);
                acomposite[j].setBackground(color2);
                if (j % 2 != 0) {
                    alabel[j] = this.createTableLabel(acomposite[j], "", this.fWidgetBackgroundColor);
                    GridData griddata2 = new GridData(272);
                    griddata2.widthHint = 4;
                    alabel[j].setLayoutData((Object)griddata2);
                    alabel[j].setBackground(color);
                } else {
                    int k = 0;
                    if (j != 0) {
                        k = j / 2;
                    }
                    if (k < as.length) {
                        alabel[j] = this.createTableLabel(acomposite[j], as[k], this.fWidgetBackgroundColor);
                        alabel[j].setBackground(this.fWidgetBackgroundColor);
                    } else {
                        alabel[j] = this.createTableLabel(acomposite[j], "", this.fWidgetBackgroundColor);
                        alabel[j].setBackground(this.fWidgetBackgroundColor);
                    }
                    GridData griddata3 = new GridData(272);
                    alabel[j].setLayoutData((Object)griddata3);
                }
                acomposite[j].layout(true);
            }
        }
        return alabel;
    }

    public Group createGroup(Composite composite, String text) {
        Group group = new Group(composite, 32);
        group.setText(text);
        group.setBackground(this.fClientAreaColor);
        group.setForeground(this.fForegroundColor);
        return group;
    }

    public Label createHeadingLabel(Composite composite, String text, Color color) {
        return this.createHeadingLabel(composite, text, color, 0);
    }

    public Label createTableLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 0);
        label.setText(text);
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    public Label createHeadingLabel(Composite composite, String text, Color color, int style) {
        Label label = new Label(composite, style);
        label.setText(text);
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return label;
    }

    public Label createHyperlinkLabel(Composite composite, String text, IHyperlinkListener listener) {
        return this.createHyperlinkLabel(composite, text, listener, 0);
    }

    public Label createHyperlinkLabel(Composite composite, String text, IHyperlinkListener listener, int style) {
        Label label = this.createLabel(composite, text, style);
        this.turnIntoHyperlink((Control)label, listener);
        return label;
    }

    public Label createLabel(Composite composite, String text) {
        return this.createLabel(composite, text, 0);
    }

    public Label createLabel(Composite composite, String text, int style) {
        Label label = new Label(composite, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    public Label createSeparator(Composite composite, int style) {
        Label label = new Label(composite, 2 | style);
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fBorderColor);
        return label;
    }

    public ScrolledComposite createScrolledComposite(Composite composite) {
        ScrolledComposite scrolledcomposite = new ScrolledComposite(composite, 768);
        scrolledcomposite.setBackground(this.fClientAreaColor);
        scrolledcomposite.setForeground(this.fForegroundColor);
        return scrolledcomposite;
    }

    public LinkLabel createLinkLabel(Composite composite, String text) {
        return this.createLinkLabel(composite, text, 0);
    }

    public LinkLabel createLinkLabel(Composite composite, String text, int style) {
        LinkLabel linklabel = new LinkLabel(composite, style);
        if (text != null) {
            linklabel.setText(text);
        }
        linklabel.setBackground(this.fClientAreaColor);
        linklabel.setForeground(this.fForegroundColor);
        return linklabel;
    }

    public Table createTable(Composite composite, int style) {
        Table table = new Table(composite, 0 | style);
        table.setBackground(this.fClientAreaColor);
        table.setForeground(this.fForegroundColor);
        return table;
    }

    public Text createText(Composite composite, String text) {
        return this.createText(composite, text, 4);
    }

    public Text createText(Composite composite, String text, int style) {
        Text theText = new Text(composite, style);
        theText.setText(text);
        theText.setBackground(this.fClientAreaColor);
        theText.setForeground(this.fForegroundColor);
        if ((style & 8) != 0) {
            theText.setForeground(this.fReadOnlyColor);
        }
        return theText;
    }

    public HrefText createHrefText(Composite composite, String text) {
        return this.createHrefText(composite, text, 4);
    }

    public HrefText createHrefText(Composite composite, String text, int style) {
        HrefText theText = new HrefText(composite, style);
        theText.setText(text);
        theText.setBackground(this.fClientAreaColor);
        theText.setForeground(this.fForegroundColor);
        if ((style & 8) != 0) {
            theText.setForeground(this.fReadOnlyColor);
        }
        return theText;
    }

    public Text createTextArea(Composite composite, String text) {
        Text theText = new Text(composite, 834);
        theText.setText(text);
        theText.setBackground(this.fClientAreaColor);
        theText.setForeground(this.fForegroundColor);
        return theText;
    }

    public Tree createTree(Composite composite, int style) {
        Tree tree = new Tree(composite, 0 | style);
        tree.setBackground(this.fClientAreaColor);
        tree.setForeground(this.fForegroundColor);
        return tree;
    }

    public ViewForm createViewForm(Composite composite) {
        ViewForm viewform = new ViewForm(composite, 0);
        viewform.setBackground(this.fClientAreaColor);
        viewform.setForeground(this.fForegroundColor);
        return viewform;
    }

    public void dispose() {
        Enumeration enumeration = this.fColorRegistry.elements();
        while (enumeration.hasMoreElements()) {
            Color color = (Color)enumeration.nextElement();
            color.dispose();
        }
        this.fHyperlinkHandler.dispose();
        this.fColorRegistry = null;
        if (this.fBanner != null) {
            this.fBanner.dispose();
        }
    }

    public Color getBackgroundColor() {
        return this.fClientAreaColor;
    }

    public Color getWidgetBackgroundColor() {
        return this.fWidgetBackgroundColor;
    }

    public Image getBanner() {
        return this.fBanner;
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }

    public Cursor getBusyCursor() {
        return this.fHyperlinkHandler.getBusyCursor();
    }

    public Color getClientAreaColor() {
        return this.fClientAreaColor;
    }

    public Color getColor(String s) {
        return (Color)this.fColorRegistry.get(s);
    }

    public Color getForegroundColor() {
        return this.fForegroundColor;
    }

    public Color getHyperlinkColor() {
        return this.fHyperlinkHandler.getForeground();
    }

    public Cursor getHyperlinkCursor() {
        return this.fHyperlinkHandler.getHyperlinkCursor();
    }

    public Color getHyperlinkHoverColor() {
        return this.fHyperlinkHandler.getActiveForeground();
    }

    public int getHyperlinkUnderlineMode() {
        return this.fHyperlinkHandler.getHyperlinkUnderlineMode();
    }

    private void initialize() {
        this.fClientAreaColor = this.fDisplay.getSystemColor(25);
        this.fWidgetBackgroundColor = this.fDisplay.getSystemColor(22);
        this.fReadOnlyColor = this.fDisplay.getSystemColor(15);
        this.registerColor(COLOR_BACKGROUND, 255, 254, 249);
        this.registerColor(COLOR_BORDER, 195, 191, 179);
        this.registerColor(COLOR_COMPOSITE_SEPARATOR, 152, 170, 203);
        this.registerColor(DEFAULT_HEADER_COLOR, 72, 112, 152);
        this.registerColor(COLOR_SEPARATOR, 168, 168, 168);
        this.registerColor(COLOR_WHITE, 255, 255, 255);
        this.registerColor(COLOR_BLACK, 0, 0, 0);
        this.registerColor(COLOR_FLAT_LABEL, 214, 211, 206);
        this.fBorderColor = this.getColor(COLOR_BORDER);
        this.fForegroundColor = this.fDisplay.getSystemColor(24);
        this.fHyperlinkHandler = new HyperlinkHandler();
        this.fHyperlinkHandler.setForeground(this.registerColor(COLOR_HYPERLINK, 0, 0, 153));
        this.fHyperlinkHandler.setActiveForeground(this.registerColor(COLOR_ACTIVE_HYPERLINK, 255, 0, 0));
        this.fHyperlinkHandler.setBackground(this.fClientAreaColor);
    }

    public void paintBordersFor(Composite composite) {
        if (this.fBorderPainter == null) {
            this.fBorderPainter = new BorderPainter();
        }
        composite.addPaintListener((PaintListener)this.fBorderPainter);
    }

    public Color registerColor(String s, int i, int j, int k) {
        Color color = new Color((Device)this.fDisplay, i, j, k);
        this.fColorRegistry.put(s, color);
        return color;
    }

    private void registerColor(String s, Color color) {
        this.fColorRegistry.put(s, color);
    }

    public void setHyperlinkColor(Color color) {
        this.fHyperlinkHandler.setForeground(color);
    }

    public void setHyperlinkHoverColor(Color color) {
        this.fHyperlinkHandler.setActiveForeground(color);
    }

    public void setHyperlinkUnderlineMode(int i) {
        this.fHyperlinkHandler.setHyperlinkUnderlineMode(i);
    }

    public void turnIntoHyperlink(Control control, IHyperlinkListener listener) {
        this.fHyperlinkHandler.registerHyperlink(control, listener);
    }

    class BorderPainter
    implements PaintListener {
        public void paintControl(PaintEvent paintevent) {
            Composite composite = (Composite)paintevent.widget;
            Control[] acontrol = composite.getChildren();
            for (int i = 0; i < acontrol.length; ++i) {
                Control control = acontrol[i];
                if (control instanceof Text || control instanceof Canvas || control instanceof CCombo) {
                    Rectangle rectangle = control.getBounds();
                    GC gc = paintevent.gc;
                    gc.setForeground(control.getBackground());
                    gc.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                    gc.setForeground(WidgetFactory.this.fForegroundColor);
                    gc.drawRectangle(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
                    continue;
                }
                if (!(control instanceof Table) && !(control instanceof Tree) && !(control instanceof TableTree)) continue;
                Rectangle rectangle1 = control.getBounds();
                GC gc1 = paintevent.gc;
                gc1.setForeground(WidgetFactory.this.fBorderColor);
                gc1.drawRectangle(rectangle1.x - 1, rectangle1.y - 1, rectangle1.width + 2, rectangle1.height + 2);
            }
        }

        BorderPainter() {
        }
    }
}

