/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.properties;

import com.kingdee.bos.tool.properties.CellEditorMessages;
import java.text.MessageFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class BosDialogCellEditor
extends CellEditor {
    public static final String CELL_EDITOR_IMG_DOTS_BUTTON = "cell_editor_dots_button_image";
    private Composite editor;
    private Control contents;
    private Label defaultLabel;
    private Button button;
    private Button delBtn;
    private Object value = null;
    private static final int defaultStyle = 0;

    public BosDialogCellEditor() {
        this.setStyle(0);
    }

    protected BosDialogCellEditor(Composite parent) {
        this(parent, 0);
    }

    protected BosDialogCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.defaultLabel = new Label(cell, 16384);
        this.defaultLabel.setFont(cell.getFont());
        this.defaultLabel.setBackground(cell.getBackground());
        return this.defaultLabel;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.contents = this.createContents(this.editor);
        this.updateContents(this.value);
        this.delBtn = new Button(this.editor, 1024);
        this.delBtn.setText(CellEditorMessages.BosDialogCellEditor_QingKong);
        this.delBtn.setFont(font);
        this.delBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BosDialogCellEditor.this.deleteContents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    BosDialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object newValue = BosDialogCellEditor.this.openDialogBox((Control)BosDialogCellEditor.this.editor);
                if (newValue != null) {
                    boolean newValidState = BosDialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        BosDialogCellEditor.this.doSetValue(newValue);
                    } else {
                        BosDialogCellEditor.this.setErrorMessage(MessageFormat.format(BosDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                }
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        this.button.setFocus();
    }

    protected void doSetValue(Object value) {
        this.value = value;
        this.updateContents(value);
    }

    protected Label getDefaultLabel() {
        return this.defaultLabel;
    }

    protected abstract Object openDialogBox(Control var1);

    protected void updateContents(Object value) {
        if (this.defaultLabel == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.defaultLabel.setText(text);
    }

    protected void deleteContents() {
        if (this.defaultLabel == null) {
            return;
        }
        this.defaultLabel.setText("");
        this.value = null;
        this.setValue(null);
    }

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(CELL_EDITOR_IMG_DOTS_BUTTON, ImageDescriptor.createFromFile(DialogCellEditor.class, (String)"images/dots_button.gif"));
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            if (BosDialogCellEditor.this.delBtn != null) {
                BosDialogCellEditor.this.delBtn.setBounds(0, 0, 30, bounds.height);
            }
            Point size = BosDialogCellEditor.this.button.computeSize(-1, -1, force);
            if (BosDialogCellEditor.this.contents != null) {
                BosDialogCellEditor.this.contents.setBounds(30, 0, bounds.width - size.x - 30, bounds.height);
            }
            BosDialogCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = BosDialogCellEditor.this.contents.computeSize(-1, -1, force);
            Point buttonSize = BosDialogCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

