/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webframework.dynamic.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.DynamicMetadataFactory;
import com.kingdee.bos.config.IDynamicMetadata;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.webframework.dynamic.AbstractDynamicConfigureInfo;
import com.kingdee.bos.webframework.dynamic.AppSolutionFactory;
import com.kingdee.bos.webframework.dynamic.AppSolutionInfo;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureCollection;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureFactory;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureInfo;
import com.kingdee.bos.webframework.dynamic.IDynamicConfigure;
import com.kingdee.bos.webframework.dynamic.PageUserOrgUictFactory;
import com.kingdee.bos.webframework.dynamic.app.AbstractWebManagementFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASSysException;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class WebManagementFacadeControllerBean
extends AbstractWebManagementFacadeControllerBean {
    private static final long serialVersionUID = 2528152484073836675L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.webframework.dynamic.app.WebManagementFacadeControllerBean");

    @Override
    protected String _saveBizUnit(Context ctx, IObjectValue appInfo, IObjectValue cusUnitInfo) throws BOSException, EASSysException, EASBizException {
        String appId = null;
        String custId = null;
        IObjectPK objectPK = AppSolutionFactory.getLocalInstance(ctx).save((CoreBaseInfo)((AppSolutionInfo)appInfo));
        appId = objectPK.toString();
        ((AppSolutionInfo)appInfo).setId(BOSUuid.read((String)appId));
        if (cusUnitInfo != null) {
            ((CustomizedUnitInfo)cusUnitInfo).setAppSolutionID(appId);
            custId = this._saveCusUnit(ctx, cusUnitInfo);
        }
        String rt = "";
        if (appId != null) {
            rt = rt + "appId:'" + appId + "'";
        }
        if (custId != null) {
            rt = rt + ",custId:'" + custId + "'";
        }
        return "{" + rt + "}";
    }

    @Override
    protected String _saveCusUnit(Context ctx, IObjectValue cusUnitInfo) throws BOSException, EASSysException {
        IObjectPK objectPK = null;
        try {
            objectPK = CustomizedUnitFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)((CustomizedUnitInfo)cusUnitInfo));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
        return objectPK.toString();
    }

    @Override
    protected String _savePage(Context ctx, IObjectValue configureInfo, IObjectValue info) throws BOSException, EASBizException {
        CoreBaseCollection colls;
        DynamicConfigureInfo dynInfo = (DynamicConfigureInfo)configureInfo;
        IDynamicConfigure idyn = DynamicConfigureFactory.getLocalInstance(ctx);
        String appSolutionId = dynInfo.getAppSolution().getId().toString();
        String pageType = dynInfo.getPageType();
        if (dynInfo.isIsDefault() && (colls = DynamicConfigureFactory.getLocalInstance(ctx).getCollection(" where appsolution ='" + appSolutionId + "' and pageType='" + pageType + "' and isDefault='1'")).size() > 0) {
            for (int i = 0; i < colls.size(); ++i) {
                ((DynamicConfigureInfo)colls.get(i)).setIsDefault(false);
            }
            idyn.save(colls);
        }
        IObjectPK dynObjPK = idyn.save((CoreBaseInfo)dynInfo);
        String modelId = dynObjPK.toString();
        Project[] ps = null;
        if (dynInfo.getDependID() != null) {
            ps = this.getDependProjects(dynInfo.getLongNumber());
            logger.info((Object)("getDependProject memory:" + ps));
            if (ps == null) {
                logger.info((Object)("getDependProject db:" + dynInfo.getLongNumber()));
                ps = this.getDependProjects(ctx, modelId);
            }
        }
        if (ps != null && ps.length == 0) {
            ps = null;
        }
        IServerMetadataStore metadataStore = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
        WebPageObjectInfo webPageObjInfo = (WebPageObjectInfo)info;
        try {
            metadataStore.saveMetadata((AbstractMetaDataValue)webPageObjInfo, modelId, ps);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return modelId;
    }

    private Project[] getDependProjects(String longNumber) {
        if (StringUtils.isEmpty((String)longNumber)) {
            return null;
        }
        String[] strs = StringUtils.split((String)longNumber, (String)"|");
        ArrayList<Project> list = new ArrayList<Project>();
        for (int i = 0; i < strs.length; ++i) {
            String st = StringUtils.cnulls((String)strs[i]);
            if (st.length() <= 0) continue;
            list.add(new Project(st));
        }
        return list.toArray(new Project[list.size()]);
    }

    private Project[] getDependProjects(Context ctx, String modelID) {
        List<Project> list = new ArrayList<Project>();
        list = this.getDependProject(list, ctx, modelID);
        return list.toArray(new Project[list.size()]);
    }

    private List<Project> getDependProject(List<Project> list, Context ctx, String modelID) {
        DynamicConfigureInfo configureInfo = null;
        try {
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("dependID"));
            IDynamicConfigure iDynamicConfigure = DynamicConfigureFactory.getLocalInstance(ctx);
            configureInfo = iDynamicConfigure.getDynamicConfigureInfo((IObjectPK)new ObjectUuidPK(modelID), selectorItemCollection);
            String dependID = configureInfo.getDependID();
            if (!StringUtils.isEmpty((String)dependID)) {
                Project p = new Project(dependID);
                list.add(p);
                return this.getDependProject(list, ctx, dependID);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    protected String _delPage(Context ctx, String modelIds, String soluNums, String uipks) throws BOSException, EASBizException {
        int i;
        List<String> needDelIds = Arrays.asList(modelIds.split(","));
        List<String> solutionNumbers = Arrays.asList(soluNums.split(","));
        List<String> uipkList = Arrays.asList(uipks.split(","));
        ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
        IDynamicConfigure idyn = DynamicConfigureFactory.getLocalInstance(ctx);
        IDynamicMetadata imeta = DynamicMetadataFactory.getLocalInstance((Context)ctx);
        String deleteOql = " where  configure  in(";
        for (i = 0; i < needDelIds.size(); ++i) {
            pks.add(new ObjectUuidPK(needDelIds.get(i)));
            deleteOql = i == needDelIds.size() - 1 ? deleteOql + "'" + needDelIds.get(i) + "'" : deleteOql + "'" + needDelIds.get(i) + "',";
        }
        deleteOql = deleteOql + ")";
        idyn.deleteBatchData(pks.toArray(new IObjectPK[pks.size()]));
        if (needDelIds.size() > 0) {
            PageUserOrgUictFactory.getLocalInstance(ctx).delete(deleteOql);
        }
        for (i = 0; i < solutionNumbers.size(); ++i) {
            String number = solutionNumbers.get(i);
            DynamicConfigureCollection dynamicConfigureCollection = idyn.getDynamicConfigureCollection("select where solutionNumber = '" + number + "'");
            AbstractDynamicConfigureInfo parent = null;
            if (dynamicConfigureCollection != null && dynamicConfigureCollection.size() > 0) {
                for (int j = 0; j < dynamicConfigureCollection.size(); ++j) {
                    DynamicConfigureInfo inner = dynamicConfigureCollection.get(j);
                    if (!"0".equals(inner.getVersion())) continue;
                    parent = inner;
                }
            }
            if (dynamicConfigureCollection.size() != 1 || parent == null) continue;
            uipkList.add(parent.getWebUIObjectName());
            idyn.delete((IObjectPK)new ObjectUuidPK(parent.getId().toString()));
        }
        String metaOql = " where BOSType='wbpe' and PROJECTID in(";
        for (int i2 = 0; i2 < needDelIds.size(); ++i2) {
            pks.add(new ObjectUuidPK(needDelIds.get(i2)));
            metaOql = i2 == needDelIds.size() - 1 ? metaOql + "'" + needDelIds.get(i2) + "'" : metaOql + "'" + needDelIds.get(i2) + "',";
        }
        metaOql = metaOql + ")";
        imeta.delete(metaOql);
        return uipkList.toString().substring(1, uipkList.toString().length() - 1);
    }

    @Override
    protected String _delCusUnit(Context ctx, String custId) throws BOSException, EASBizException {
        logger.info((Object)"Into delCusUnit");
        ArrayList<String> uipks = new ArrayList<String>();
        StringBuffer str = null;
        DynamicConfigureCollection colls = DynamicConfigureFactory.getLocalInstance(ctx).getDynamicConfigureCollection("where customizedUnitID='" + custId + "' ");
        int j = colls.size();
        for (int i = 0; i < j; ++i) {
            DynamicConfigureInfo dynamicConfigureInfo = colls.get(i);
            uipks.add(dynamicConfigureInfo.getWebUIObjectName());
            if (str == null) {
                str = new StringBuffer();
            } else {
                str.append(",");
            }
            str.append("'");
            str.append(dynamicConfigureInfo.getId());
            str.append("'");
        }
        if (str != null) {
            logger.info((Object)"begin delete pageUserOrgUict in delCusUnit");
            PageUserOrgUictFactory.getLocalInstance(ctx).delete("where configure  in (" + str.toString() + ") ");
            logger.info((Object)"finish delete pageUserOrgUict in delCusUnit");
        }
        logger.info((Object)"begin delete pages in delCusUnit");
        if (DynamicConfigureFactory.getLocalInstance(ctx).exists("where customizedUnitID='" + custId + "' ")) {
            DynamicConfigureFactory.getLocalInstance(ctx).delete("where customizedUnitID='" + custId + "' ");
        }
        logger.info((Object)"finish delete pages in delCusUnit");
        ICustomizedUnit icust = CustomizedUnitFactory.getLocalInstance((Context)ctx);
        CustomizedUnitInfo cust = (CustomizedUnitInfo)icust.getValue((IObjectPK)new ObjectUuidPK(custId));
        String appId = cust.getAppSolutionID();
        logger.info((Object)"begin delete cusUnit in delCusUnit");
        CustomizedUnitFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(custId));
        logger.info((Object)"finish delete pages in delCusUnit");
        AppSolutionInfo appInfo = AppSolutionFactory.getLocalInstance(ctx).getAppSolutionInfo((IObjectPK)new ObjectUuidPK(appId));
        if ("cust!common".equals(appInfo.getMenuLongNumber())) {
            logger.info((Object)"begin delete app in delCusUnit");
            AppSolutionFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(appId));
            logger.info((Object)"finish delete app in delCusUnit");
        }
        return ((Object)uipks).toString().substring(1, ((Object)uipks).toString().length() - 1);
    }
}

