/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webframework.dynamic.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceI18nUtil {
    private static final String LANGS = "com.kingdee.bos.webframework.dynamic.app.dyn";
    private static Map<Locale, ResourceBundle> bundles = new HashMap<Locale, ResourceBundle>();

    private ResourceI18nUtil() {
    }

    public static String getString(String key) {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceI18nUtil.getString(key, locale);
    }

    public static String getString(String key, Locale locale) {
        if (bundles.get(locale) == null) {
            bundles.put(locale, ResourceBundle.getBundle(LANGS, locale));
        }
        String value = "ERROR:The key '" + key + "' is not found.";
        try {
            value = bundles.get(locale).getString(key);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getString(String key, Object[] args) {
        try {
            Locale locale = Locale.getDefault();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (bundles.get(locale) == null) {
                bundles.put(locale, ResourceBundle.getBundle(LANGS, locale));
            }
            ResourceBundle rb = bundles.get(locale);
            String temp = rb.getString(key);
            return MessageFormat.format(temp, args);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
            return "undefined";
        }
    }
}

