/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.workflow.cust.WFPersonRoleInfo;
import com.kingdee.bos.workflow.cust.WFRoleDataImport;
import com.kingdee.bos.workflow.cust.WFRoleInfo;
import com.kingdee.bos.workflow.cust.WFRoleType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Map;

public class WFRolePersonDataImport
extends WFRoleDataImport {
    @Override
    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.bos.workflow.cust.app.WFRolewithEntryQuery";
    }

    @Override
    protected String[] getExportFields() {
        String[] exportfields = new String[]{"personRole.Person.number", "personRole.Person.name", "personRole.AdminOrgUnit.number", "personRole.AdminOrgUnit.name", "personRole.DelePerson.number", "personRole.DelePerson.name"};
        return exportfields;
    }

    @Override
    public Map<String, String> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Map<String, String> result = super.exportTransmit(rs, ctx);
        this.putBoolean(rs, result, "personRole.IsInclude");
        return result;
    }

    @Override
    public CoreBaseInfo transmit(Hashtable chsData, Context ctx) throws TaskExternalException {
        CoreBaseInfo corebaseinfo = super.transmit(chsData, ctx);
        for (int t = 0; t < chsData.size(); ++t) {
            Hashtable hsData = (Hashtable)chsData.get(t);
            this.handlePersonRole(ctx, (WFRoleInfo)corebaseinfo, hsData);
        }
        return corebaseinfo;
    }

    @Override
    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("roleType", (Object)0);
        return filter;
    }

    private void handlePersonRole(Context ctx, WFRoleInfo info, Hashtable hsData) throws TaskExternalException {
        info.setRoleType(WFRoleType.PERSONROLE);
        WFPersonRoleInfo personRole = new WFPersonRoleInfo();
        personRole.setIsDele(false);
        personRole.setIsInclude(false);
        String personNumber = this.getStringTokenValue("personRole.Person.number", hsData);
        String orgNumber = this.getStringTokenValue("personRole.AdminOrgUnit.number", hsData);
        String delePersonNumber = this.getStringTokenValue("personRole.DelePerson.number", hsData);
        if (StringUtils.isEmpty((String)orgNumber)) {
            throw new TaskExternalException("\u5206\u5f55\u7ec4\u7ec7\u7f16\u7801\u5fc5\u5f55\u3002");
        }
        String isInclude = this.getStringTokenValue("personRole.IsInclude", hsData);
        if ("\u662f".equals(isInclude) || "true".equals(isInclude)) {
            personRole.setIsInclude(true);
        }
        try {
            PersonInfo pinfo = (PersonInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)PersonFactory.getLocalInstance((Context)ctx), personNumber);
            if (pinfo == null) {
                if (this.isScientificNotation(personNumber)) {
                    pinfo = (PersonInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)PersonFactory.getLocalInstance((Context)ctx), this.SNtoNormal(personNumber));
                }
                if (pinfo == null) {
                    throw new BOSException("\u804c\u5458\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u6b63\u786e\uff0c\u8bfb\u53d6\u5230\u7684\u804c\u5458\u7f16\u7801\u662f" + personNumber);
                }
            }
            personRole.setPersonID(pinfo);
            AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)AdminOrgUnitFactory.getLocalInstance((Context)ctx), orgNumber);
            if (orgInfo != null) {
                personRole.setOrgID(orgInfo);
            } else {
                if (this.isScientificNotation(orgNumber)) {
                    orgInfo = (AdminOrgUnitInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)AdminOrgUnitFactory.getLocalInstance((Context)ctx), this.SNtoNormal(orgNumber));
                }
                if (orgInfo == null) {
                    throw new TaskExternalException("\u5206\u5f55\u7ec4\u7ec7\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u8bfb\u53d6\u5230\u7684\u5206\u5f55\u7ec4\u7ec7\u7f16\u7801\u662f" + orgNumber);
                }
            }
            PersonInfo delpinfo = null;
            if (!StringUtils.isEmpty((String)delePersonNumber) && (delpinfo = (PersonInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)PersonFactory.getLocalInstance((Context)ctx), delePersonNumber)) != null) {
                personRole.setDelePersonID(delpinfo);
                personRole.setIsDele(true);
            }
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        info.getPersonEntrys().add(personRole);
    }
}

