/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.syn;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.metas.IInvokeMethodDelegate;
import com.kingdee.bos.workflow.metas.InvokeMethodDelegateFactory;
import com.kingdee.bos.workflow.metas.SARecordFactory;
import com.kingdee.bos.workflow.metas.SARecordInfo;
import com.kingdee.bos.workflow.statsa.util.SAUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SARecoredDeal {
    private static Logger log = Logger.getLogger(SARecoredDeal.class);

    public static String exceptionToString(Exception e) {
        StringBuffer sb = new StringBuffer("");
        try {
            if (e == null) {
                return "";
            }
            sb.append(e.toString()).append("\n");
            StackTraceElement[] stack = e.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                sb.append(stack[i].toString()).append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public void saveRecordInNewTransaction(Context ctx, boolean isSuccess, Timestamp synStartTime, boolean isReExtract, int days, int procinstCount, String errorStack) {
        try {
            IInvokeMethodDelegate delegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
            delegate.invokeRequiresNew("com.kingdee.bos.workflow.statsa.syn.SARecoredDeal", (Object)this, "addSARecord", new Class[]{Context.class, Boolean.TYPE, Timestamp.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, String.class}, new Object[]{ctx, isSuccess, synStartTime, isReExtract, days, procinstCount, errorStack});
        }
        catch (Throwable e) {
            log.error((Object)("saveRecordInNewTransaction catch ex:" + e));
        }
    }

    public void addSARecord(Context ctx, boolean isSuccess, Timestamp synStartTime, boolean isReExtract, int days, int procinstCount, String errorStack) {
        try {
            Timestamp synEndTime = SAUtil.getTime();
            long time = synEndTime.getTime() - synStartTime.getTime();
            BigDecimal executeTime = new BigDecimal(time / 1000L);
            executeTime.setScale(2, 4);
            SARecordInfo tSARecordInfo = new SARecordInfo();
            tSARecordInfo.setIsSuccess(isSuccess);
            tSARecordInfo.setSynStartTime(synStartTime);
            tSARecordInfo.setSynEndTime(synEndTime);
            tSARecordInfo.setExecuteTime(executeTime);
            tSARecordInfo.setIsReExtract(isReExtract);
            tSARecordInfo.setDays(days);
            tSARecordInfo.setProcinstCount(procinstCount);
            tSARecordInfo.setErrorStack(errorStack);
            SARecordFactory.getLocalInstance((Context)ctx).addnew(tSARecordInfo);
        }
        catch (Exception e) {
            log.error((Object)"\u4fdd\u5b58\u540c\u6b65\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
    }
}

