/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.DocumentProxyStateManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.PKIndexs;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.event.ParameterMappingInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.UIActionRefInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EventUtils {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.biz.EventUtils");
    private static volatile BizEventMap bizEventMap = null;
    private static final Map<String, BizEventMap> dynBizEventMap = new HashMap<String, BizEventMap>(4);

    public static synchronized void clearDynBizEventMap() {
        dynBizEventMap.clear();
    }

    private static FunctionObjectCollection loadFunctions(Context ctx, boolean isOnlyDynamic) {
        if (isOnlyDynamic) {
            return EventUtils.loadDynamicFunctions(ctx);
        }
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getFunctions();
    }

    private static FunctionObjectCollection loadDynamicFunctions(Context ctx) {
        FunctionObjectCollection col = new FunctionObjectCollection();
        PKIndexs pkIndexs = MDContextFactory.getSystemMDContext().pkIndexs;
        Map typeAndPK = pkIndexs.getMetaDataPKsFromDB(null);
        Set pks = (Set)typeAndPK.get(MetaDataTypeList.FUNCTION);
        if (pks != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            Iterator iterator = pks.iterator();
            while (iterator.hasNext()) {
                FunctionObjectInfo function = loader.getFunction((IMetaDataPK)iterator.next());
                col.add(function);
            }
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized BizEventMap initMetadataMapping(Context ctx, boolean isOnlyDynamic) {
        FunctionObjectCollection functions;
        long time = System.currentTimeMillis();
        BizEventMap bizEventMap = new BizEventMap(10);
        while (!DocumentProxyStateManager.isRepeatLog()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        WfEventListenerStateManager.getInstance().disableEventListener();
        try {
            functions = EventUtils.loadFunctions(ctx, isOnlyDynamic);
            if (functions == null) {
                BizEventMap bizEventMap2 = bizEventMap;
                return bizEventMap2;
            }
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
        OperationCollection operations = null;
        MethodInfo methodInfo = null;
        EventInfo event = null;
        boolean isDynamic = false;
        int size = functions.size();
        for (int i = 0; i < size; ++i) {
            FunctionObjectInfo functionInfo = functions.get(i);
            operations = functionInfo.getOperation();
            if (operations == null) {
                return bizEventMap;
            }
            for (int j = 0; j < operations.size(); ++j) {
                try {
                    OperationInfo operationInfo = operations.get(j);
                    methodInfo = operationInfo.getMethodRef();
                    event = operationInfo.getEventRef();
                    UIActionRefInfo uiActionRef = operationInfo.getUiActionRef();
                    if (uiActionRef == null) continue;
                    if (event == null || methodInfo == null) {
                        log.warn((Object)("EventUtils: get refrence " + (event == null ? (methodInfo == null ? "event and method" : "event") : "method") + " null. operation " + functionInfo.getFullName() + "." + operationInfo.getName()));
                        continue;
                    }
                    isDynamic = false;
                    BusinessObjectInfo bo = operationInfo.getBORef();
                    if (bo == null) continue;
                    String v1 = bo.getExtendedProperty("isDynamic");
                    String v2 = operationInfo.getExtendedProperty("configured");
                    isDynamic = Boolean.valueOf(v1) != false || Boolean.valueOf(v2) != false;
                    String boType = bo.getType().toString();
                    String methodId = methodInfo.getInnerID() + boType;
                    if (isOnlyDynamic) {
                        if (!isDynamic) continue;
                        bizEventMap.put(methodId, event, operationInfo.getName(), functionInfo.getFullName());
                        continue;
                    }
                    if (isDynamic) continue;
                    bizEventMap.put(methodId, event, operationInfo.getName(), functionInfo.getFullName());
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)("function " + functionInfo.getFullName() + ",operation " + operations.get(j).getName() + " has error"), t);
                }
            }
        }
        log.info((Object)("EventUtils.initMetadataMapping ais:" + ctx.getAIS() + " dyn:" + isOnlyDynamic + " cost:" + (System.currentTimeMillis() - time)));
        return bizEventMap;
    }

    public static BizEventMap getBizEventMap(Context ctx) {
        if (bizEventMap == null) {
            bizEventMap = EventUtils.initMetadataMapping(ctx, false);
        }
        return bizEventMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BizEventMap getDynBizEventMap(Context ctx) {
        String ais = null;
        if (ctx != null) {
            ais = ctx.getAIS();
        }
        if (ais == null) {
            return null;
        }
        BizEventMap eventMap = dynBizEventMap.get(ais);
        if (eventMap == null) {
            Map<String, BizEventMap> map = dynBizEventMap;
            synchronized (map) {
                eventMap = dynBizEventMap.get(ais);
                if (eventMap == null) {
                    eventMap = EventUtils.initMetadataMapping(ctx, true);
                    dynBizEventMap.put(ais, eventMap);
                }
            }
        }
        return eventMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BizEventMap.EventStructEntry[] getMatchedEventStructEntries(Context ctx, BOSObjectType boType, IMetaDataPK operationPK) {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(EventUtils.class.getName(), "getMatchedEventStructEntries", null);
        }
        if (operationPK == null || boType == null) {
            return new BizEventMap.EventStructEntry[0];
        }
        try {
            String methodID = operationPK.getName() + boType;
            BizEventMap.EventStructEntry[] eventStructEntryArray = EventUtils.getByMethod(ctx, methodID);
            return eventStructEntryArray;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public static ParameterMappingInfo getBoPKParamMapping(EventMethodInfo eventMethodInfo) {
        if (eventMethodInfo == null) {
            throw new IllegalArgumentException("eventMethodInfo null");
        }
        int length = eventMethodInfo.getParameterMappings().size();
        ParameterMappingInfo rtnValue = null;
        for (int i = 0; i < length; ++i) {
            ParameterMappingInfo paramMapping = eventMethodInfo.getParameterMappings().get(i);
            if (!paramMapping.isBOPK()) continue;
            rtnValue = paramMapping;
            break;
        }
        return rtnValue;
    }

    public static String getBoPK(EventMethodInfo eventMethod, Object[] args) {
        ParameterMappingInfo paramMap = EventUtils.getBoPKParamMapping(eventMethod);
        if (paramMap == null) {
            return "";
        }
        int paramIndex = paramMap.getActualParameterIndex() + 1;
        return EventUtils.convertPK(args[paramIndex]);
    }

    public static String convertPK(Object pk) {
        if (pk != null) {
            if (pk instanceof Object[]) {
                if (((Object[])pk).length > 0) {
                    if (!(((Object[])pk)[0] instanceof String || ((Object[])pk)[0] instanceof BOSUuid || ((Object[])pk)[0] instanceof IObjectPK)) {
                        return null;
                    }
                    pk = ((Object[])pk)[0].toString();
                } else {
                    pk = null;
                }
            }
            if (pk instanceof String) {
                return (String)pk;
            }
            if (pk instanceof BOSUuid) {
                return pk.toString();
            }
            if (pk instanceof IObjectPK) {
                return pk.toString();
            }
            if (pk instanceof IObjectValue) {
                String rtn = "";
                try {
                    IObjectValue objVal = (IObjectValue)pk;
                    String objValPkField = objVal.getPKField();
                    if (objValPkField == null || objValPkField.length() == 0) {
                        log.error((Object)("objectValue's PkField is null. class '" + objVal.getClass().getName() + "'"));
                        return "";
                    }
                    rtn = objVal.get(objValPkField) != null ? objVal.get(objValPkField).toString() : "";
                }
                catch (Throwable e) {
                    log.warn((Object)("Get pk error." + pk), e);
                }
                return rtn;
            }
        }
        return "";
    }

    public static boolean containsByEvent(Context ctx, String eventName) {
        return EventUtils.getByEvent(ctx, eventName) != null;
    }

    public static BizEventMap.EventStructEntry[] getByEvent(Context ctx, String eventName) {
        BizEventMap dynEventMap;
        BizEventMap.EventStructEntry[] entries = null;
        BizEventMap eventMap = EventUtils.getBizEventMap(ctx);
        if (eventMap != null) {
            entries = eventMap.getByEvent(eventName);
        }
        if ((entries == null || entries.length == 0) && (dynEventMap = EventUtils.getDynBizEventMap(ctx)) != null) {
            entries = dynEventMap.getByEvent(eventName);
        }
        return entries;
    }

    public static BizEventMap.EventStructEntry[] getByMethod(Context ctx, String methodId) {
        BizEventMap dynEventMap;
        BizEventMap.EventStructEntry[] entries = null;
        BizEventMap eventMap = EventUtils.getBizEventMap(ctx);
        if (eventMap != null) {
            entries = eventMap.getByMethod(methodId);
        }
        if ((entries == null || entries.length == 0) && (dynEventMap = EventUtils.getDynBizEventMap(ctx)) != null) {
            entries = dynEventMap.getByMethod(methodId);
        }
        return entries;
    }

    public static boolean containsByMethod(Context ctx, String methodId) {
        return EventUtils.getByMethod(ctx, methodId) != null;
    }
}

