/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.biz.BizUtils;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.metas.ITempBizProcRelation;
import com.kingdee.bos.workflow.metas.TempBizProcRelationFactory;
import com.kingdee.bos.workflow.metas.TempBizProcRelationInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfBizEventListenerHelper {
    public final IServiceContext serviceContext;
    private static final String TBPR_PROCDEFID = "TBPR_ProcDefID";
    private static final BOSObjectType MULTIAPPROVE_BOSTYPE = BOSObjectType.create((String)"63D30103");
    private static final Logger logger = Logger.getLogger(WfBizEventListenerHelper.class);

    private WfBizEventListenerHelper(IServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    private Context getContext() {
        return this.serviceContext.getContext();
    }

    public static WfBizEventListenerHelper getHelper(IServiceContext serviceContext) {
        return new WfBizEventListenerHelper(serviceContext);
    }

    public void handleTempBizProcRelation() throws BOSException {
        Object[] parameters = this.serviceContext.getOperationParameters();
        if (parameters != null) {
            int n = parameters.length;
            for (int i = 0; i < n; ++i) {
                Object objBizObjectID;
                IObjectValue objectValue;
                String procDefID;
                if (!(parameters[i] instanceof IObjectValue) || StringUtils.isEmpty((String)(procDefID = (objectValue = (IObjectValue)parameters[i]).getExtendedProperty(TBPR_PROCDEFID))) || (objBizObjectID = objectValue.get(objectValue.getPKField())) == null) continue;
                BOSUuid bizObjID = null;
                if (objBizObjectID instanceof BOSUuid) {
                    bizObjID = (BOSUuid)objBizObjectID;
                } else {
                    String strBizObjectID = objBizObjectID.toString();
                    if (BOSUuid.isValid((String)strBizObjectID, (boolean)false)) {
                        bizObjID = BOSUuid.read((String)strBizObjectID);
                    }
                }
                if (bizObjID == null) continue;
                BOSUuid uuidProcDefID = BOSUuid.read((String)procDefID);
                ITempBizProcRelation iTempBizProcRelation = TempBizProcRelationFactory.getLocalInstance((Context)this.getContext());
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("bizObjID", (Object)bizObjID));
                filterInfo.getFilterItems().add(new FilterItemInfo("procDefID", (Object)uuidProcDefID));
                if (iTempBizProcRelation.exists(filterInfo)) continue;
                TempBizProcRelationInfo tempBizProcRelationInfo = new TempBizProcRelationInfo();
                tempBizProcRelationInfo.setBizObjID(bizObjID);
                tempBizProcRelationInfo.setProcDefID(uuidProcDefID);
                tempBizProcRelationInfo.setCreator(BOSUuid.read((String)this.getContext().getCaller().toString()));
                tempBizProcRelationInfo.setCreatedTime(new Timestamp(System.currentTimeMillis()));
                iTempBizProcRelation.addnew(tempBizProcRelationInfo);
                return;
            }
        }
    }

    public void changeApproveAssignmentState(IObjectValue objectValue) throws BOSException {
        if (MULTIAPPROVE_BOSTYPE.equals((Object)objectValue.getBOSType())) {
            String assignmentID = objectValue.getExtendedProperty("assignmentID");
            this.changeAssignmentState(assignmentID);
        }
    }

    public void changeAssignmentState(String assignmentId) throws BOSException {
        if (!StringUtils.isEmpty((String)assignmentId)) {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.getContext());
            service.processingAssignment(assignmentId);
        }
    }

    public void checkIsInQueue(BizEventMap.EventStructEntry[] eventStructEntries, EventInfo eventInfo, String boId) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.getContext());
        service.checkIsInQueue(eventStructEntries, eventInfo, boId);
    }

    public WfBizEvent checkBizEvent(BizEventMap.EventStructEntry[] eventStructEntries, String boId) throws BOSException {
        return this.checkBizEvent(eventStructEntries, boId, null);
    }

    public WfBizEvent checkBizEvent(BizEventMap.EventStructEntry[] eventStructEntries, String boId, String userId) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.getContext());
        String caller = null;
        caller = !StringUtils.isEmpty((String)userId) ? userId : this.getContext().getCaller().toString();
        return service.checkBizEvent(this.serviceContext.getMethodReturnValue(), eventStructEntries, boId, caller);
    }

    public void processDesignateNextActivityPerformer(WfBizEvent wfBizEvent, IObjectValue bizObject) {
        wfBizEvent.putExtendProperty((Object)"CTRL_SHIFT_ALT", (Object)bizObject.getExtendedProperty("CTRL_SHIFT_ALT"));
        Map performers = BizUtils.getNextActivityPerformers((IObjectValue)bizObject);
        wfBizEvent.putExtendProperty((Object)"DesignateNextActivityPerformerWhenSubmit", (Object)performers);
    }

    public void checkAssignmentState(String assignmentID) throws BOSException {
        LowTimer lowTimer = new LowTimer();
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.getContext());
        AssignmentInfo assignmentInfo = service.getAssignmentById(assignmentID);
        if (assignmentInfo == null) {
            throw new WfException("WFE_RT_noAssignment", null, null);
        }
        if (!(WfAssignmentState.ACCEPTED.equals((Object)assignmentInfo.getState()) || WfAssignmentState.ASSIGNED.equals((Object)assignmentInfo.getState()) || WfAssignmentState.NOT_ASSIGNED.equals((Object)assignmentInfo.getState()))) {
            throw new AlreadyInProcessQueueException("Assignment[" + assignmentID + "] already put in eventQueue.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WfBizEventListener.checkAssignState cost:" + lowTimer.msValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEventQueue(WfBizEvent wfEvent) throws BOSException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "putEventQueue", null);
        }
        try {
            boolean isBindedProcessStartEvent;
            LowTimer timer = new LowTimer();
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.getContext());
            if (StringUtils.isEmpty((String)wfEvent.getAssignmentId()) && !(isBindedProcessStartEvent = service.isBindedProcessStartEvent(wfEvent.getFuncName(), wfEvent.getOperationName()))) {
                logger.warn((Object)("not bind process start event, will ignore. func:" + wfEvent.getFuncName() + " operation:" + wfEvent.getOperationName() + " boId:" + wfEvent.getBoId()));
                return;
            }
            service.putEventQueue(wfEvent);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("directPutEvent cost:" + timer.msValue()));
                timer.reset();
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }
}

