/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz.event;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.event.IEventExecutor;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.util.CommonEventUtils;
import org.apache.log4j.Logger;

public class ProcessEventExecutor
implements IEventExecutor {
    private static final Logger logger = Logger.getLogger(ProcessEventExecutor.class);

    @Override
    public boolean execute(ICommonEvent event, EventProcMetaInfo info, WfEngine wfEngine) throws WfException {
        if (event == null || info == null || wfEngine == null) {
            logger.warn((Object)("ProcessEventExecutor.execute args is null " + event + " || " + info + " || " + wfEngine));
            return false;
        }
        Person initiator = CommonEventUtils.getPersonFromEvent(event, wfEngine);
        WfProcessMgr wfProcessMgr = wfEngine.getProcessMgr(info.getProcDefId().toString());
        if (wfProcessMgr == null || wfProcessMgr.getData() == null) {
            logger.warn((Object)("ProcessEventExecutor.execute ProcessDef[" + info.getProcDefId() + "] is not exists "));
            return false;
        }
        if (!wfProcessMgr.getData().isEnable()) {
            logger.warn((Object)("ProcessEventExecutor.execute ProcessDef[" + wfProcessMgr.getData().getProcDefName(wfEngine.getLocale()) + "] is not enable "));
            return false;
        }
        WfProcess wfProcess = wfProcessMgr.createProcess(null, initiator);
        boolean b = wfProcess.startFromCommonEvent(event, initiator);
        wfProcessMgr.processProcessTopic(wfProcess);
        return b;
    }
}

