/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.Serialization;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.message.WfMessageSender;
import java.io.Serializable;
import java.util.Locale;

class ErrMessageSender {
    ErrMessageSender() {
    }

    static Message createWfMessage(WfEngine engine) {
        Message message = MessageFactory.newMessage();
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("priority", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setLocaleStringHeader("sender", "BOS_BPM", new Locale("l1"));
        message.setLocaleStringHeader("sender", "\u4e1a\u52a1\u6d41\u7a0b", new Locale("l2"));
        message.setLocaleStringHeader("sender", "\u4e1a\u52a1\u6d41\u7a0b", new Locale("l3"));
        Context ctx = engine.context();
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setBooleanHeader("isSendEmail", false);
        message.setBooleanHeader("isSendMobile", false);
        message.setBooleanHeader("isSendCommon", true);
        return message;
    }

    public static void send(WfEngine engine, String receiver, MessageContent[] content, Throwable e) {
        Message msg = ErrMessageSender.createWfMessage(engine);
        msg.setStringHeader("receiver", receiver);
        String errorStack = "";
        if (e != null) {
            errorStack = "\r\n\r\n" + Serialization.dump((Throwable)e);
        }
        for (int i = 0; i < content.length; ++i) {
            MessageContent t = content[i];
            msg.setLocaleStringHeader("title", t.title, t.locale);
            msg.setLocaleStringHeader("body", t.body + errorStack, t.locale);
        }
        WfMessageSender.sendMessageWithoutTransaction(engine.context(), msg);
    }

    public static class MessageContent
    implements Serializable {
        private static final long serialVersionUID = -1754581176558106817L;
        public Locale locale;
        public String title;
        public String body;

        public MessageContent(Locale locale, String title, String body) {
            this.locale = locale;
            this.title = title;
            this.body = body;
        }
    }
}

