/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.ExecutionMode;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.core.thread.FlowInitiator;
import com.kingdee.bos.workflow.exception.InvalidRequesterException;
import com.kingdee.bos.workflow.exception.NotEnabledException;
import com.kingdee.bos.workflow.exception.RequesterRequired;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.transaction.ActivityRunner;
import com.kingdee.bos.workflow.util.WfBizObjUtils;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.cbos.process.vm.runtime.Profile;
import com.kingdee.util.StringUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SubflowActivityRunner
implements ActivityRunner {
    private WfActivity innerActivityInst;
    private SubflowActivityDef innerActivityDef;

    public SubflowActivityRunner(WfActivity activityInst) {
        if (activityInst == null) {
            throw new IllegalArgumentException("activityInst");
        }
        this.innerActivityInst = activityInst;
        ActivityDef activityDef = this.innerActivityInst.getDefinition();
        if (!(activityDef instanceof SubflowActivityDef)) {
            throw new UnsupportedOperationException();
        }
        this.innerActivityDef = (SubflowActivityDef)activityDef;
    }

    @Override
    public void start() throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "start", null);
        }
        try {
            WfProcess parent = this.innerActivityInst.container();
            WfProcess subProcess = this.innerActivityInst.getSubProcessInstance();
            if (subProcess == null) {
                subProcess = this.innerCreateSubProcInst();
                this.innerActivityInst.setInited();
                this.initiateSubFlow(subProcess, parent);
            }
            FlowInitiator.enqueue(subProcess.getContext(), subProcess.getId(), parent.getId());
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private void initiateSubFlow(WfProcess subProcess, WfProcess parent) throws WfException {
        String hashCode = subProcess.getData().getProcDefHashValue();
        Flow flow = subProcess.getWfEngine().getFlow(hashCode);
        FlowContext runtime = flow.newInstance();
        runtime.setProfile(Profile.PERFORMANCE);
        if (!this.isAsync()) {
            Util.setSyncSubFlow(runtime);
        }
        this.innerActivityInst.innerSetState(WfState.RUNNING);
        subProcess.getProcessContext().setFlowContext(runtime);
        subProcess.innerStart();
    }

    private boolean isAsync() {
        return ExecutionMode.ASYNCHR.equals((Object)this.innerActivityDef.getSynchrMode());
    }

    public SubflowActivityDef getInnerActivityDef() {
        return this.innerActivityDef;
    }

    public WfProcess innerCreateSubProcInst() throws WfException, WfParticipantException, NotEnabledException, InvalidRequesterException, RequesterRequired {
        ParticipantCollection participants = this.innerActivityDef.getParticipants();
        if (participants.size() != 0) {
            throw new WfException("TODO");
        }
        String initiatorId = this.innerActivityInst.container().getData().getInitiatorId();
        WfEngine engine = this.innerActivityInst.getWfEngine();
        String subProcessDefId = this.innerActivityDef.getSubflowId();
        WfProcessMgr processMgr = null;
        try {
            processMgr = engine.getProcessMgr(subProcessDefId);
        }
        catch (WfException e) {
            throw new WfException("Get subflow process error.maybe subflow is not released.", (Throwable)e, true);
        }
        if (processMgr == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Process not founld.");
            buffer.append("ProcessDef Id is \"" + subProcessDefId + "\"");
            throw new WfException(buffer.toString());
        }
        IParticipantProvider participantProvider = engine.getPariticipantProvider();
        Person person = participantProvider.getPersonByUserId(engine.context(), initiatorId);
        WfProcess subProcess = processMgr.createProcess(this.innerActivityInst, person);
        this.innerActivityInst.setSubProcInst(subProcess.getId());
        ActualParameterCollection actualParameters = this.innerActivityDef.getActualParameters();
        FormalParameterCollection formalParameters = subProcess.getDefinition().getFormalParameters();
        ProcessContext context = this.innerActivityInst.container().getProcessContext();
        Map data = context.getDataCopy();
        Iterator iter = actualParameters.iterator();
        ProcessContext processContext = subProcess.getProcessContext();
        while (iter.hasNext()) {
            FormalParameterDef formalParameter;
            ActualParameterDef item;
            block12: {
                item = (ActualParameterDef)iter.next();
                if (item.getIndex() >= formalParameters.size()) continue;
                formalParameter = null;
                try {
                    if (StringUtils.isEmpty((String)item.getFormalDefId())) {
                        formalParameter = formalParameters.get(item.getIndex());
                        break block12;
                    }
                    formalParameter = formalParameters.get(item.getFormalDefId());
                    String orginName = formalParameter.getName();
                    if (!FormalParameterMode.OUT.equals((Object)formalParameter.getMode())) break block12;
                    for (int i = 0; i < formalParameters.size(); ++i) {
                        FormalParameterDef formalParameterTemp = formalParameters.get(i);
                        if (!FormalParameterMode.IN.equals((Object)formalParameterTemp.getMode()) || !orginName.equals(formalParameterTemp.getName())) continue;
                        formalParameter = formalParameterTemp;
                        break;
                    }
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (formalParameter.getMode().equals((Object)FormalParameterMode.OUT) || item == null || item.getDataField() == null) continue;
            String name = item.getDataField().getName();
            if (!StringUtils.isEmpty((String)item.getProp())) {
                name = name + "." + item.getProp();
            }
            if (formalParameter.getDataType().equals(BasicType.BIZOBJ)) {
                name = item.getDataField().getName() + ".id";
                Object value = WfBizObjUtils.getDataFieldValueInMap(data, name, processMgr.getWfEngine().context());
                if (value != null) {
                    String bizId = value.toString();
                    String key = "$" + formalParameter.getName() + " .bizId$";
                    processContext.putDataFieldValue(key, bizId);
                }
                processContext.putDataFieldValue(formalParameter.getName(), null);
                continue;
            }
            Object value = WfBizObjUtils.getDataFieldValueInMap(data, name, processMgr.getWfEngine().context());
            processContext.setDataFieldValue(formalParameter.getName(), value);
        }
        Map nextParticipantPersonData = this.getNextParticipantPersonData(data, subProcess.getDefinition());
        processContext.putDataFieldValues(nextParticipantPersonData);
        processContext.storeToDb();
        return subProcess;
    }

    private Map getNextParticipantPersonData(Map contextData, ProcessDef subProcessDef) {
        HashMap retVal = new HashMap();
        ActivityCollection manpowerActivityDefs = subProcessDef.getActivitys(ActivityType.MANPOWER);
        Set contextDataEntrySet = contextData.entrySet();
        for (Map.Entry entry : contextDataEntrySet) {
            Object objKey = entry.getKey();
            if (!(objKey instanceof String)) continue;
            String key = (String)objKey;
            if (!"DesignateNextActivityPerformerWhenSubmit".equals(objKey) && !key.startsWith("DP_")) continue;
            retVal.put(key, entry.getValue());
        }
        return retVal;
    }
}

