/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AcceptOption;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.AssignmentEvent;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.IWfActivity;
import com.kingdee.bos.workflow.enactment.IWfAssignment;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfExecutionObject;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.extend.jump.JumpController;
import com.kingdee.bos.workflow.engine.core.thread.FlowAbort;
import com.kingdee.bos.workflow.exception.ActivityIsNotRunningException;
import com.kingdee.bos.workflow.exception.AlreadySuspendedException;
import com.kingdee.bos.workflow.exception.CannotForwardException;
import com.kingdee.bos.workflow.exception.ForbidForwardException;
import com.kingdee.bos.workflow.exception.NotRunningException;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import com.kingdee.bos.workflow.transaction.SnapshotRecorder;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.WfMsgToOtherSys;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WfAssignment
extends WfExecutionObject
implements IWfAssignment {
    private static final Logger logger = Logger.getLogger(WfAssignment.class);
    private AssignmentInfo meta;
    private String procInstId;
    private String actInstId;
    private ManpowerActivityDef actDef;
    private transient WfActivity act;

    public WfAssignment() {
    }

    public WfAssignment(WfEngine engine, AssignmentInfo meta) throws WfException {
        super(engine, meta.getAssignmentId());
        this.actInstId = meta.getActInstId();
        this.procInstId = meta.getProcInstId();
        this.meta = meta;
    }

    public WfActivity getActInst() throws WfException {
        if (this.act == null) {
            this.act = this.getWfEngine().getActivityInst(this.actInstId);
        }
        return this.act;
    }

    private WfProcess getProcInst() throws WfException {
        return this.getActInst().container();
    }

    public String getActInstId() {
        return this.getMeta().getActInstId();
    }

    public String getProcInstId() {
        return this.getMeta().getProcInstId();
    }

    public AssignmentInfo getMeta() {
        return this.meta;
    }

    private ManpowerActivityDef getDefinition() throws WfException {
        if (this.actDef == null) {
            this.actDef = (ManpowerActivityDef)this.getActInst().getDefinition();
        }
        return this.actDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept() throws WfException {
        WfProcess wfProcess = this.getActInst().container();
        synchronized (wfProcess) {
            WfActivity wfActivity = this.getActInst();
            synchronized (wfActivity) {
                WfAssignment wfAssignment = this;
                synchronized (wfAssignment) {
                    if (!this.getActInst().state().startsWith(WfState.RUNNING.getValue()) && !this.getActInst().state().startsWith(WfState.NOT_STARTED.getValue())) {
                        if (this.getActInst().container().state().equalsIgnoreCase("open.not_running.suspended")) {
                            throw new AlreadySuspendedException("WFE_ASSIGN_accept_suspended").addArg(this.actInstId).addArg(this.procInstId);
                        }
                        throw new ActivityIsNotRunningException("WFE_ASSIGN_accept_notRun", null, null).addArg(this.actInstId).addArg(this.getActInst().state()).addArg(this.procInstId).addArg(this.getProcInst().state());
                    }
                    AcceptOption acceptOption = this.getDefinition().getAcceptOption();
                    WfActivity activityInst = this.getActInst();
                    if (activityInst.enableCountersign()) {
                        return;
                    }
                    int completedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.COMPLETED);
                    this.setState(WfAssignmentState.ACCEPTED);
                    if (acceptOption.equals((Object)AcceptOption.ONE)) {
                        if (completedCount > 0 && !this.isCountersign()) {
                            throw new WfException("error, can not accept, because only 1 person accept.");
                        }
                    } else if (acceptOption != AcceptOption.ALL) {
                        throw new WfException("Fatal Error.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject() throws WfException {
        WfProcess wfProcess = this.getActInst().container();
        synchronized (wfProcess) {
            WfActivity wfActivity = this.getActInst();
            synchronized (wfActivity) {
                WfAssignment wfAssignment = this;
                synchronized (wfAssignment) {
                    if (!this.state().equals((Object)WfAssignmentState.ACCEPTED) && !this.state().equals((Object)WfAssignmentState.ASSIGNED)) {
                        throw new WfException("WFE_ASSIGN_reject_state", null, null).addArg(this.getId()).addArg(this.state().toString());
                    }
                    if (!this.getDefinition().getAllowCancelSubmit()) {
                        throw new WfException("WFE_ASSIGN_reject_notAllow", null, null).addArg(this.getId()).addArg(this.getDefinition().getName());
                    }
                    AcceptOption acceptOption = this.getDefinition().getAcceptOption();
                    if (acceptOption == AcceptOption.ONE) {
                        this.setState(WfAssignmentState.REJECTED);
                        WfAssignment[] cancelAssignArray = this.getActInst().getAssignmentsInState(WfAssignmentState.CANCELED);
                        for (int i = 0; i < cancelAssignArray.length; ++i) {
                            cancelAssignArray[i].setState(WfAssignmentState.ASSIGNED);
                        }
                        int completedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.COMPLETED);
                        int assignedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.ASSIGNED);
                        int acceptedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.ACCEPTED);
                        int rejectedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.REJECTED);
                        if (completedCount > 0) {
                            throw new WfException("Fatal Error.");
                        }
                        if (rejectedCount < 1) {
                            throw new WfException("Fatal Error.");
                        }
                        if (assignedCount == 0 && acceptedCount == 0) {
                            this.setState(WfAssignmentState.REJECTED);
                            try {
                                Context cnt = this.getWfEngine().context();
                                Class<?> wfUtilClass = Class.forName("com.kingdee.bos.workflow.monitor.WfUtil");
                                Object util = wfUtilClass.getConstructor(Context.class).newInstance(cnt);
                                Method m = wfUtilClass.getMethod("suspend", String.class, String.class);
                                m.invoke(util, this.getProcInstId(), "assignment reject. assignemnt id '" + this.getId() + "'");
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage());
                                throw new WfException("\u62d2\u7edd\u5931\u8d25\uff01\u65e0\u6cd5\u6302\u8d77\u6d41\u7a0b");
                            }
                        }
                    } else if (acceptOption == AcceptOption.ALL) {
                        this.setState(WfAssignmentState.REJECTED);
                        try {
                            Context cnt = this.getWfEngine().context();
                            Class<?> wfUtilClass = Class.forName("com.kingdee.bos.workflow.monitor.WfUtil");
                            Object util = wfUtilClass.getConstructor(Context.class).newInstance(cnt);
                            Method m = wfUtilClass.getMethod("suspend", String.class, String.class);
                            m.invoke(util, this.getProcInstId(), "assignment reject. assignemnt id '" + this.getId() + "'");
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage());
                            throw new WfException("\u62d2\u7edd\u5931\u8d25\uff01\u65e0\u6cd5\u6302\u8d77\u6d41\u7a0b");
                        }
                    } else {
                        throw new WfException("Fatal Error.");
                    }
                }
            }
        }
    }

    public void cancel() throws WfException {
        this.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean checkAssignmentState) throws WfException {
        WfProcess wfProcess = this.getActInst().container();
        synchronized (wfProcess) {
            WfActivity wfActivity = this.getActInst();
            synchronized (wfActivity) {
                WfAssignment wfAssignment = this;
                synchronized (wfAssignment) {
                    if (this.getActInst().state().startsWith(WfState.CLOSED.getValue())) {
                        throw new NotRunningException();
                    }
                    if (checkAssignmentState && !this.state().equals((Object)WfAssignmentState.ACCEPTED) && !this.state().equals((Object)WfAssignmentState.ASSIGNED) && !this.state().equals((Object)WfAssignmentState.PROCESSING)) {
                        throw new WfException("WFE_ASSIGN_cancel_state", null, null).addArg(this.getId()).addArg(this.state().toString());
                    }
                    AcceptOption acceptOption = this.getDefinition().getAcceptOption();
                    this.setState(WfAssignmentState.CANCELED);
                    if (acceptOption == AcceptOption.ONE) {
                        int assignedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.ASSIGNED);
                        int acceptedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.ACCEPTED);
                        if (assignedCount == 0 && acceptedCount == 0) {
                            throw new WfException("\u6ca1\u6709\u5176\u4ed6\u4eba\u5904\u7406\u672c\u6d3b\u52a8\u4efb\u52a1\uff0c\u7981\u6b62\u53d6\u6d88");
                        }
                    } else if (acceptOption == AcceptOption.ALL) {
                        int completedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.COMPLETED);
                        int assignedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.ASSIGNED);
                        int acceptedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.ACCEPTED);
                        if (assignedCount == 0 && acceptedCount == 0) {
                            if (completedCount == 0) {
                                if (!this.getActInst().container().getProcessContext().isPvmMode()) {
                                    this.getActInst().terminate();
                                } else {
                                    FlowAbort.enqueue(this.getContext(), this.procInstId, this.actInstId);
                                }
                            } else {
                                this.getActInst().complete("");
                            }
                        }
                    } else {
                        throw new WfException("Fatal Error.");
                    }
                }
                this.setReadForUrgentMessage();
            }
        }
    }

    private void setReadForUrgentMessage() {
        try {
            String sql = "update t_bas_message set fstatus=10,fsourceStatus=4 where fbizType=40 and fsourceId=? ";
            DbUtil.execute((Context)this.getWfEngine().context(), (String)sql, (Object[])new Object[]{this.getId()});
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String devolve(Person newPerson, Map msgs) throws WfException {
        WfProcess wfProcess = this.getActInst().container();
        synchronized (wfProcess) {
            WfActivity wfActivity = this.getActInst();
            synchronized (wfActivity) {
                WfAssignment wfAssignment = this;
                synchronized (wfAssignment) {
                    if (this.getActInst().state().startsWith(WfState.CLOSED.getValue())) {
                        throw new WfException("WFE_ASSIGN_devolve_closed", null, null).addArg(this.getId()).addArg(this.getActInstId());
                    }
                    WorkItemStorer storer = this.getWfEngine().getStoreManager().getWorkItemStorer();
                    try {
                        AssignmentInfo newAssign = storer.createForwardWorkItem(this.getActInst(), this.getMeta(), newPerson, this.getActInst().isSendAssignmentMsg(), "devolve", msgs);
                        WfAssignment wfAssign = new WfAssignment(this.getWfEngine(), newAssign);
                        this.getWfEngine().eventService().raiseAssignmentEvent(AssignmentEvent.OnAssignmentCreated, wfAssign, null);
                        this.getActInst().fireAssignmentCreated(newAssign);
                        if (!this.getActInst().assignmentIds().contains(newAssign.getAssignmentId())) {
                            this.getActInst().assignmentIds().add(newAssign.getAssignmentId());
                        }
                        this.cancel(false);
                        return newAssign.getAssignmentId();
                    }
                    catch (SQLException ex) {
                        throw new WfException("can not get storer", (Throwable)ex);
                    }
                    catch (DataAccessException e) {
                        throw new WfException("DataAccessException", (Throwable)e);
                    }
                }
            }
        }
    }

    public String forward(Person newPerson) throws WfException {
        return this.forward(newPerson, null);
    }

    public String forward(Person newPerson, Map forwardMsg) throws WfException {
        return this.forward(newPerson, forwardMsg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssignmentInfo getForwardAssignmentInfo(WorkItemStorer storer, Person newPerson, Map forwardMsg, boolean checkConstraint) throws WfException {
        WfProcess wfProcess = this.getActInst().container();
        synchronized (wfProcess) {
            WfActivity wfActivity = this.getActInst();
            synchronized (wfActivity) {
                WfAssignment wfAssignment = this;
                synchronized (wfAssignment) {
                    if (this.getActInst().state().startsWith(WfState.CLOSED.getValue())) {
                        throw new CannotForwardException("WFE_ASSIGN_forward_closed", null, null).addArg(this.getActInst().state());
                    }
                    if (checkConstraint && !this.getDefinition().getAllowAssignNextPerformer()) {
                        throw new ForbidForwardException("WFE_ASSIGN_forward_notAllow", null, null).addArg(this.getId()).addArg(this.getDefinition().getName());
                    }
                    AssignmentInfo newAssign = storer.newForwardWorkItem(this.getActInst(), this.getMeta(), newPerson, true, "forward", forwardMsg);
                    return newAssign;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAfterBatchForward(AssignmentInfo newAssign) throws WfException {
        this.getActInst().fireAssignmentCreated(newAssign);
        WfActivity wfActivity = this.getActInst();
        synchronized (wfActivity) {
            String newAssignId = newAssign.getAssignmentId();
            if (!this.getActInst().assignmentIds().contains(newAssignId)) {
                this.getActInst().assignmentIds().add(newAssignId);
            }
        }
        this.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String forward(Person newPerson, Map forwardMsg, boolean checkConstraint) throws WfException {
        WfProcess wfProcess = this.getActInst().container();
        synchronized (wfProcess) {
            WfActivity wfActivity = this.getActInst();
            synchronized (wfActivity) {
                WfAssignment wfAssignment = this;
                synchronized (wfAssignment) {
                    if (this.getActInst().state().startsWith(WfState.CLOSED.getValue())) {
                        throw new CannotForwardException("WFE_ASSIGN_forward_closed", null, null).addArg(this.getActInst().state());
                    }
                    if (checkConstraint && !this.getDefinition().getAllowAssignNextPerformer()) {
                        throw new ForbidForwardException("WFE_ASSIGN_forward_notAllow", null, null).addArg(this.getId()).addArg(this.getDefinition().getName());
                    }
                    AssignmentInfo newAssignmentInfo = WorkItemStorer.newForwardWorkItem(this.getWfEngine().context(), this.getActInst(), this.getMeta(), newPerson, true, "forward", forwardMsg);
                    SnapshotRecorder recorder = SnapshotRecorder.create();
                    recorder.snapshoot((AbstractObjectValue)newAssignmentInfo.getAssignInfo());
                    WfAssignment wfAssign = new WfAssignment(this.getWfEngine(), newAssignmentInfo);
                    recorder.recordSnapshots();
                    this.getWfEngine().eventService().raiseAssignmentEvent(AssignmentEvent.OnAssignmentCreated, wfAssign, null);
                    this.getActInst().fireAssignmentCreated(newAssignmentInfo);
                    String newAssignId = newAssignmentInfo.getAssignmentId();
                    WfActivity wfActivity2 = this.getActInst();
                    synchronized (wfActivity2) {
                        if (!this.getActInst().assignmentIds().contains(newAssignId)) {
                            this.getActInst().assignmentIds().add(newAssignId);
                        }
                    }
                    this.getWfEngine().getCacheManager().addAssignment(wfAssign);
                    this.cancel(false);
                    return newAssignId;
                }
            }
        }
    }

    public void innerNotAssigned() throws WfException {
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)this.meta.getAssignInfo());
        this.meta.setState(WfAssignmentState.NOT_ASSIGNED);
        recorder.snapshoot((AbstractObjectValue)this.meta.getAssignInfo());
        recorder.recordSnapshots();
    }

    public void innerAssigned() throws WfException {
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)this.meta.getAssignInfo());
        try {
            if (this.meta.getAssignInfo().getActdefName() != null && this.meta.getAssignInfo().getActdefName().startsWith("[\u52a0\u7b7e]")) {
                String actinstid = this.meta.getActInstId();
                WfActivity activity = this.getWfEngine().getActivityInst(actinstid);
                if (activity != null) {
                    String parentactinstid = activity.getMeta().getParentActInstId();
                    AssignmentInfo[] assignment = this.getWfEngine().getAssignmentByActInstId(parentactinstid);
                    if (assignment != null && assignment.length > 0) {
                        for (int i = 0; i < assignment.length; ++i) {
                            if (assignment[i].getState() != WfAssignmentState.COMPLETED) continue;
                            String userid = assignment[i].getUserId();
                            this.meta.getAssignInfo().setPriorPerformerID(userid);
                            Locale[] lcla = ApplicationUtil.getContextLocales((Context)this.getWfEngine().getClonedContext());
                            if (lcla == null || lcla.length <= 0) continue;
                            for (int j = 0; j < lcla.length; ++j) {
                                String username = assignment[i].getUserName(lcla[j]);
                                this.meta.getAssignInfo().setPriorPerformName(username, lcla[j]);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception actinstid) {
            // empty catch block
        }
        this.meta.setState(WfAssignmentState.ASSIGNED);
        this.meta.setSendMsg(true);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.meta.setAcceptTime(now);
        this.meta.setCreatedTime(now);
        recorder.snapshoot((AbstractObjectValue)this.meta.getAssignInfo());
        recorder.recordSnapshots();
        ActInstInfo act = this.getActInst().getMeta().getActInstInfo();
        SnapshotRecorder r2 = SnapshotRecorder.create();
        r2.snapshoot((AbstractObjectValue)act);
        act.setCreatedTime(now);
        r2.snapshoot((AbstractObjectValue)act);
        r2.recordSnapshots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(WfAssignmentState state) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "setState", null);
        }
        try {
            WfProcess wfProcess = this.getActInst().container();
            synchronized (wfProcess) {
                WfActivity wfActivity = this.getActInst();
                synchronized (wfActivity) {
                    WfAssignment wfAssignment = this;
                    synchronized (wfAssignment) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("WfAssignment.setState [" + this.getId() + "][" + state.getName() + "]"));
                        }
                        LowTimer lowTimer = new LowTimer();
                        SnapshotRecorder recorder = SnapshotRecorder.create();
                        recorder.snapshoot((AbstractObjectValue)this.meta.getAssignInfo());
                        this.meta.setState(state);
                        Timestamp ts = new Timestamp(System.currentTimeMillis());
                        this.meta.setLastStateTime(ts);
                        if (WfAssignmentState.ACCEPTED.equals((Object)state)) {
                            this.meta.setAcceptTime(ts);
                        } else if (WfAssignmentState.COMPLETED.equals((Object)state) || WfAssignmentState.CANCELED.equals((Object)state) || WfAssignmentState.REJECTED.equals((Object)state)) {
                            this.meta.setEndTime(ts);
                            WfTxContext.current().getTxAssignmentMgr().addDumpAssignmentID(this.meta.getAssignmentId());
                        }
                        recorder.snapshoot((AbstractObjectValue)this.meta.getAssignInfo());
                        recorder.recordSnapshots();
                        this.raiseEvent(state);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("assignment[" + this.getId() + "] setState completed. cost: " + lowTimer.msValue()));
                        }
                    }
                }
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    void raiseEvent(WfAssignmentState state) {
        if (WfAssignmentState.PROCESSING.equals((Object)state)) {
            this.getWfEngine().eventService().raiseAssignmentEvent(AssignmentEvent.OnAssignmentSubmitted, this, null);
        } else if (WfAssignmentState.COMPLETED.equals((Object)state)) {
            this.getWfEngine().eventService().raiseAssignmentEvent(AssignmentEvent.OnAssignmentComplete, this, null);
            WfMsgToOtherSys.pushAssign4OtherSys(this.getContext(), this);
        } else if (WfAssignmentState.CANCELED.equals((Object)state)) {
            this.getWfEngine().eventService().raiseAssignmentEvent(AssignmentEvent.OnAssignmentAborted, this, null);
            WfMsgToOtherSys.pushAssign4OtherSys(this.getContext(), this);
        } else if (WfAssignmentState.REJECTED.equals((Object)state)) {
            this.getWfEngine().eventService().raiseAssignmentEvent(AssignmentEvent.OnAssignmentRejected, this, null);
        }
    }

    @Override
    public String getId() {
        return this.meta.getAssignmentId().toString();
    }

    public WfAssignmentState state() {
        return this.meta.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void complete() throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "complete", null);
        }
        try {
            LowTimer lowTimer = new LowTimer();
            WfActivity activityInst = this.getActInst();
            WfProcess processInst = activityInst.container();
            this.pvmSignalActivity(activityInst, processInst);
            WfProcess wfProcess = processInst;
            synchronized (wfProcess) {
                WfActivity wfActivity = activityInst;
                synchronized (wfActivity) {
                    WfAssignment wfAssignment = this;
                    synchronized (wfAssignment) {
                        ActivityDef targetAct;
                        if (!activityInst.state().startsWith(WfState.RUNNING.getValue()) && this.state() != WfAssignmentState.ACCEPTED && this.state() != WfAssignmentState.ASSIGNED && this.state() != WfAssignmentState.PROCESSING) {
                            WfException exception = new WfException("WFE_ASSIGN_complete_state", null, null).addArg(this.getId()).addArg(activityInst.getId()).addArg(processInst.getId()).addArg(processInst.getDefinition().getID()).addArg(activityInst.state()).addArg(this.state().toString());
                            WorkflowUtils.logProcessException(processInst.getId(), this.getWfEngine(), exception);
                            throw exception;
                        }
                        Object target = this.getProcInst().getProcessContext().getDataFieldValue(this.getId());
                        if (target != null && (targetAct = this.getProcInst().getDefinition().getActivityDef(target.toString())) != null) {
                            this.setState(WfAssignmentState.COMPLETED);
                            this.completeSamePersonAssignments();
                            FlowContext runtime = processInst.getProcessContext().getFlowContext();
                            Execution from = runtime.getExecution(activityInst.getId());
                            JumpController controller = JumpController.getService(this.getWfEngine().context());
                            controller.jump(targetAct.getID(), processInst, runtime, from, "");
                            return;
                        }
                        if (activityInst.enableCountersign()) {
                            this.setState(WfAssignmentState.COMPLETED);
                            this.completeSamePersonAssignments();
                            activityInst.processCountersign(this);
                        } else {
                            AcceptOption acceptOption = this.getDefinition().getAcceptOption();
                            if (acceptOption == AcceptOption.ONE) {
                                int i;
                                int completedCount = this.getActInst().getCountOfAssignment(WfAssignmentState.COMPLETED);
                                if (completedCount > 0) {
                                    throw new WfException("error, can not complete, because only 1 complete accept.");
                                }
                                this.setState(WfAssignmentState.COMPLETED);
                                WfAssignment[] assignArray = this.getActInst().getAssignmentsInState(WfAssignmentState.ASSIGNED);
                                for (i = 0; i < assignArray.length; ++i) {
                                    assignArray[i].setState(WfAssignmentState.CANCELED);
                                }
                                assignArray = this.getActInst().getAssignmentsInState(WfAssignmentState.ACCEPTED);
                                for (i = 0; i < assignArray.length; ++i) {
                                    assignArray[i].setState(WfAssignmentState.CANCELED);
                                }
                                assignArray = this.getActInst().getAssignmentsInState(WfAssignmentState.PROCESSING);
                                for (i = 0; i < assignArray.length; ++i) {
                                    assignArray[i].setState(WfAssignmentState.CANCELED);
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.info((Object)("cancel other assignment cost : " + lowTimer.msValue()));
                                    lowTimer.reset();
                                }
                                WfActivity act = this.getActInst();
                                act.innerComplete();
                                act.complete("");
                                if (logger.isDebugEnabled()) {
                                    logger.info((Object)("complete assignment's activity cost : " + lowTimer.msValue()));
                                }
                            } else {
                                if (acceptOption != AcceptOption.ALL) throw new WfException("Fatal Error.");
                                this.setState(WfAssignmentState.COMPLETED);
                                this.completeSamePersonAssignments();
                                List umcompletedPersons = this.getActInst().getPersonIdsOfUncompleteAssignments();
                                umcompletedPersons.remove(this.meta.getEmployeeId());
                                if (umcompletedPersons.size() == 0) {
                                    WfActivity act = this.getActInst();
                                    act.innerComplete();
                                    act.complete("");
                                }
                            }
                        }
                    }
                }
            }
            this.processVoteMode();
            return;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private void pvmSignalActivity(WfActivity activityInst, WfProcess processInst) throws WfException {
        if (processInst.getProcessContext().isPvmMode()) {
            processInst.getProcessContext().loadFlowContext();
            activityInst.innerParticalComplete();
        }
    }

    private void processVoteMode() throws WfException {
        boolean isVoteMode;
        WfActivity activityInst = this.getActInst();
        if ("closed.completed".equals(activityInst.state())) {
            return;
        }
        ActivityDef aDef = activityInst.getDefinition();
        if (aDef instanceof ApproveActivityDef && (isVoteMode = ((ApproveActivityDef)aDef).isVoteMode())) {
            String assignmentId = this.getMeta().getAssignmentId();
            try {
                String sql = "UPDATE T_BAS_MULTIAPPROVE SET FSTATUS=0 WHERE  fassignmentid='" + assignmentId + "'";
                SQL.executeUpdate((Context)this.getWfEngine().context(), (String)sql);
                sql = "update t_bas_option set ftype = 20 where ftype=9 and FASSIGNMENTID  = '" + assignmentId + "'";
                SQL.executeUpdate((Context)this.getWfEngine().context(), (String)sql);
            }
            catch (Exception e) {
                logger.warn((Object)("vote mode update multiapprove info state failed! assignmentid=" + assignmentId), (Throwable)e);
            }
        }
    }

    boolean isCountersign() throws WfException {
        ProcessContext processContext = this.getActInst().container().getProcessContext();
        Set countersignAssignments = (Set)processContext.getDataFieldValue("countersignAssignments");
        if (countersignAssignments == null) {
            return false;
        }
        return countersignAssignments.contains(this.getId());
    }

    boolean isInitiateCountersign() throws WfException {
        if (!this.isCountersign()) {
            return false;
        }
        ProcessContext processContext = this.getActInst().container().getProcessContext();
        Map initiateCountersignAssignments = (Map)processContext.getDataFieldValue("initiateCountersignAssignments");
        if (initiateCountersignAssignments == null) {
            return false;
        }
        if (initiateCountersignAssignments.containsKey(this.actInstId)) {
            String initiateCountersignAssignmentID = (String)initiateCountersignAssignments.get(this.actInstId);
            if (StringUtils.isEmpty((String)initiateCountersignAssignmentID)) {
                return false;
            }
            return initiateCountersignAssignmentID.equals(this.getId());
        }
        return false;
    }

    private void completeSamePersonAssignments() throws WfException {
        String personID = this.getMeta().getAssignInfo().getResponsibleEmpId();
        if (personID == null) {
            personID = this.getMeta().getEmployeeId();
        }
        if (personID == null) {
            return;
        }
        WfActivity activity = this.getActInst();
        for (WfAssignment assignment : activity.getAssignmentsInState(WfAssignmentState.ASSIGNED)) {
            String employeeId = assignment.getMeta().getAssignInfo().getResponsibleEmpId();
            if (employeeId == null) {
                employeeId = assignment.getMeta().getEmployeeId();
            }
            if (!personID.equals(employeeId)) continue;
            assignment.setState(WfAssignmentState.CANCELED);
        }
        for (WfAssignment assignment : activity.getAssignmentsInState(WfAssignmentState.ACCEPTED)) {
            String employeeId = assignment.getMeta().getAssignInfo().getResponsibleEmpId();
            if (employeeId == null) {
                employeeId = assignment.getMeta().getEmployeeId();
            }
            if (!personID.equals(employeeId)) continue;
            assignment.setState(WfAssignmentState.CANCELED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processing() throws WfException {
        WfProcess wfProcess = this.getActInst().container();
        synchronized (wfProcess) {
            WfActivity wfActivity = this.getActInst();
            synchronized (wfActivity) {
                WfAssignment wfAssignment = this;
                synchronized (wfAssignment) {
                    this.setState(WfAssignmentState.PROCESSING);
                }
            }
        }
    }

    public AssignmentInfo getAssignmentInfo() {
        return this.getMeta();
    }

    public Context getContext() {
        return this.getWfEngine().context();
    }

    public IWfActivity getActivity() throws WfException {
        return this.getActInst();
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.getWfEngine().getEngineKey());
        marshaller.writeObject((Object)this.getWfEngine().getInitContext());
        marshaller.writeObject((Object)this.actDef);
        marshaller.writeObject((Object)this.actInstId);
        marshaller.writeObject((Object)this.meta);
        marshaller.writeObject((Object)this.procInstId);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        String engineKey = (String)unmarshaller.readObject();
        Context engineContext = (Context)unmarshaller.readObject();
        WfEngine engine = null;
        try {
            engine = WfEngine.getEngine(engineKey, engineContext);
        }
        catch (Exception ex) {
            throw new RuntimeException("Get WfEngine[" + engineKey + "] error! context: " + engineContext);
        }
        this.setWfEngine(engine);
        this.actDef = (ManpowerActivityDef)unmarshaller.readObject();
        this.actInstId = (String)unmarshaller.readObject();
        this.meta = (AssignmentInfo)unmarshaller.readObject();
        this.procInstId = (String)unmarshaller.readObject();
        this.getInnerHashCode(true);
    }

    public String getInnerHashCode(boolean isRefresh) {
        String hashcode = super.getInnerHashCode();
        if (isRefresh || StringUtils.isEmpty((String)hashcode)) {
            int hc = 0;
            if (this.actInstId != null) {
                hc += this.actInstId.hashCode();
            }
            if (this.meta != null) {
                hc += this.meta.getInnerHashCode();
            }
            if (this.procInstId != null) {
                hc += this.procInstId.hashCode();
            }
            hashcode = hc == 0 ? null : String.valueOf(hc);
            this.setInnerHashCode(hashcode);
        }
        return hashcode;
    }
}

