/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ImportDef;
import com.kingdee.bos.workflow.define.ImportDefCollection;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfCorrelationMatchMgr;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessServiceMgr;
import com.kingdee.bos.workflow.metas.ProcImportDefInfo;
import com.kingdee.bos.workflow.metas.ProcImportObjInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.ProcImportDefStorer;
import com.kingdee.bos.workflow.store.ProcImportObjStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.wfdesigner.service.Webdesigner;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfDefinitionMgr {
    private static final Logger logger = Logger.getLogger(WfDefinitionMgr.class);
    private WfEngine engine;

    WfDefinitionMgr(WfEngine engine) {
        this.engine = engine;
    }

    public WfEngine getWfEngine() {
        return this.engine;
    }

    public ProcessDef getProcessDef(String procDefId) throws WfException {
        String kpdl = this.getWfEngine().getStoreManager().getProcessStorer().getKpdlById(procDefId);
        if (kpdl != null && kpdl.trim().length() > 0) {
            return KpdlParser.parseKpdl((String)kpdl, (boolean)true);
        }
        return null;
    }

    public ProcessDefInfo getProcessDefInfo(String procDefId) throws WfException {
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            return storer.getProcessDefInfoLastVersion(procDefId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public int getProcessDefLastVersionNumber(String procDefId) throws WfException {
        ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
        try {
            return storer.getProcessDefInfoLastVersionNumber(procDefId);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
    }

    public String getProcessDefLastVersionHash(String procDefId) throws WfException {
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            return storer.getProcessDefInfoLastVersionHash(procDefId);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
    }

    public ProcessDefInfo getProcessDefInfo(String procDefId, int innerVersion) throws WfException {
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            return storer.getProcessDefInfo(procDefId, innerVersion);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public ProcessDef getProcessDefByHash(String docHashValue) throws WfException {
        WfEngine engine = this.getWfEngine();
        return engine.getProcessDef(docHashValue);
    }

    public String getKpdlByHash(String hash) {
        ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
        return storer.getKpdlByHash(hash);
    }

    public ProcessDefInfo getProcessDefInfoByHash(String docHashValue) throws WfException {
        ProcessDefInfo procDefMeta;
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            procDefMeta = storer.getProcessDefInfoByHash(docHashValue);
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
        return procDefMeta;
    }

    public String updateDynamicFlowDef(String userId, String procInstId, String hashCode, ProcessDef newDef) throws WfException {
        ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
        String newHash = storer.updateDynamicFlowDef(userId, procInstId, hashCode, newDef);
        try {
            WfProcess procinst = this.getWfEngine().getProcessInst(procInstId);
            ProcessContext procContext = procinst.getProcessContext();
            Map oldProcContext = procContext.getDataCopy();
            Iterator iter = oldProcContext.keySet().iterator();
            boolean flag = false;
            while (iter.hasNext()) {
                String key;
                Object obj = iter.next();
                if (!(obj instanceof String) || !(key = (String)obj).startsWith("DP_") || key.indexOf("@") <= 0) continue;
                String str1 = key.substring(key.indexOf("@") + 1);
                procContext.putDataFieldValue("DP_" + newHash + "@" + str1, oldProcContext.get(key));
                flag = true;
            }
            if (flag) {
                procContext.storeToDb();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newHash;
    }

    public ProcessDefInfo loadXpdlDoc(String userId, String xmlString, boolean enable) throws WfException {
        ProcessDefInfo procDefMeta;
        ProcessStorer storer;
        ProcessDef procDef = KpdlParser.parseKpdl((String)xmlString);
        this.engine.getBizProcFinder().handlerProcDefReleaseEvent(procDef);
        try {
            storer = this.getWfEngine().getStoreManager().getProcessStorer();
            procDefMeta = storer.getProcessDefInfoLastVersion(procDef.getID());
        }
        catch (SQLException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
        int innverVersion = 0;
        if (procDefMeta == null) {
            this.saveToDb(xmlString, procDef, innverVersion, procDef.getHashValue(), enable);
            this.saveImportObj(procDef);
            try {
                procDefMeta = storer.getProcessDefInfoLastVersion(procDef.getID());
            }
            catch (SQLException ex) {
                throw new WfException("SQLException", (Throwable)ex);
            }
            catch (DataAccessException e) {
                throw new WfException("DataAccessException", (Throwable)e);
            }
            try {
                if (procDef.getExtendedAttributes().get("publish_by_webDesigner") == null) {
                    Webdesigner.insert(this.getWfEngine().getClonedContext(), procDefMeta, true);
                }
            }
            catch (Exception e) {}
        } else {
            if (procDefMeta.getMd5HashValue().equals(procDef.getHashValue())) {
                try {
                    IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)this.engine.context());
                    service.setProcessDefEnable(procDefMeta.getProcDefId(), true);
                }
                catch (BOSException e) {
                    throw new WfException((Throwable)e);
                }
            }
            innverVersion = procDefMeta.getInnerVersion() + 1;
            this.saveToDb(xmlString, procDef, innverVersion, procDef.getHashValue(), true);
            this.saveImportObj(procDef);
            try {
                procDefMeta = storer.getProcessDefInfoLastVersion(procDef.getID());
            }
            catch (SQLException ex) {
                throw new WfException("SQLException", (Throwable)ex);
            }
            catch (DataAccessException e) {
                throw new WfException("DataAccessException", (Throwable)e);
            }
            try {
                if (procDef.getExtendedAttributes().get("publish_by_webDesigner") == null) {
                    Webdesigner.update(this.engine.getClonedContext(), procDefMeta);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (enable) {
            this.scheduleProcess(procDef, null, true);
        }
        if (enable) {
            WfProcessServiceMgr serviceManager = new WfProcessServiceMgr(this.engine);
            serviceManager.publishService(procDef);
            WfCorrelationMatchMgr correlationMatchMgr = new WfCorrelationMatchMgr(this.engine);
            correlationMatchMgr.createProcessCorrelationMatches(procDef);
        }
        return procDefMeta;
    }

    private void saveImportObj(ProcessDef processDef) throws WfException {
        ImportDefCollection importDefs = processDef.getImports();
        ProcImportDefStorer importDefStorer = this.getWfEngine().getStoreManager().getProcImportDefStorer();
        ProcImportObjStorer importObjStorer = this.getWfEngine().getStoreManager().getProcImportObjStorer();
        importObjStorer.delete(processDef.getID());
        int size = importDefs.size();
        for (int i = 0; i < size; ++i) {
            ImportDef importDef = importDefs.getImportDef(i);
            String location = importDef.getLocation();
            int index = location.lastIndexOf("\\");
            String fileName = location.substring(index + 1);
            ProcImportDefInfo procImportDefInfo = importDefStorer.getProcImportDefInfo(processDef.getID(), fileName);
            ProcImportObjInfo procImportObjInfo = new ProcImportObjInfo();
            procImportObjInfo.setId(BOSUuid.create((BOSObjectType)WfBOSObjectTypeUtil.PROCIMPORTOBJ));
            procImportObjInfo.setNamespace(importDef.getNamespace());
            procImportObjInfo.setType(procImportDefInfo.getType());
            procImportObjInfo.setProcDefId(BOSUuid.read((String)processDef.getID()));
            procImportObjInfo.setContent(procImportDefInfo.getFileContent());
            importObjStorer.addNew(procImportObjInfo);
        }
    }

    public ProcessDefInfo[] getProcDefArrayDistinct() throws WfException {
        ProcessDefInfo[] rtnValue;
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            rtnValue = storer.getProcDefInfoArrayDistinct();
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
        return rtnValue;
    }

    public ProcessDefInfo[] getProcDefMetaArrayAll() throws WfException {
        ProcessDefInfo[] rtnValue;
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            rtnValue = storer.getProcDefInfoArrayAll();
        }
        catch (SQLException ex) {
            throw new WfException("SQLException", (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
        return rtnValue;
    }

    private void saveToDb(String originalString, ProcessDef procDef, int innerVersion, String hashValue, boolean enable) throws WfException {
        WfEngine.getFlowParser().parse(procDef);
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            storer.storeDef(procDef, innerVersion, originalString, hashValue, enable);
        }
        catch (SQLException sqle) {
            logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
            throw new WfException(sqle.getMessage(), (Throwable)sqle);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public void scheduleProcess(ProcessDef procDef, WfProcess procInst, boolean enable) {
        ProcessType processType = procDef.getType();
        if (!processType.equals((Object)ProcessType.BACKGROUNDJOB)) {
            return;
        }
        throw new RuntimeException("\u540e\u53f0\u4e8b\u52a1\u6d41\u7a0b\u5df2\u5e9f\u5f03\uff0c\u8bf7\u4f7f\u7528JobService.createJobInstance()\u65b9\u6cd5\u4ee3\u66ff\uff01" + procDef.getID());
    }
}

