/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.FunctionHelper;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.IApplicationActivity;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.app.AbstractApplicationManager;
import com.kingdee.bos.workflow.enactment.app.ApplicationMonitor;
import com.kingdee.bos.workflow.enactment.message.WfMessage;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.mdo.IFunctionObject;
import com.kingdee.bos.workflow.mdo.IMethodObject;
import com.kingdee.bos.workflow.mdo.IOperationObject;
import com.kingdee.bos.workflow.mdo.IParameterObject;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.EnactmentUtils;
import com.kingdee.bos.workflow.util.MDOHelper;
import com.kingdee.bos.workflow.util.MethodDesc;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.exception.FriendlyBOSException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManPowerAppManager
extends AbstractApplicationManager {
    private static Logger logger = Logger.getLogger(ManPowerAppManager.class);
    private static HashSet applicationMonitorSet = new HashSet();
    private AssignmentInfo assignment;

    public ManPowerAppManager(WfActivity activityInst, AssignmentInfo assignment) {
        super(activityInst);
        this.assignment = assignment;
    }

    public static synchronized void addApplicationMonitor(ApplicationMonitor monitor) {
        applicationMonitorSet.add(monitor);
    }

    public static synchronized void removeApplicationMonitor(ApplicationMonitor monitor) {
        applicationMonitorSet.remove(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeApplication(ApplicationDef application, ActualParameterCollection actualParameters) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "invokeApplication", null);
        }
        String operation = null;
        String proc_name = null;
        String instance_number = null;
        long startTime = System.currentTimeMillis();
        try {
            if (application == null) {
                return;
            }
            FunctionDef function = application.getFunction();
            if (function != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(function.getPackageName()).append('.').append(function.getName()).append('.').append(function.getOperation());
                operation = sb.toString();
            }
            if (this.activityInst != null && this.activityInst.container() != null && this.activityInst.container().manager() != null && this.activityInst.container().manager().getData() != null && this.activityInst.container().getData() != null) {
                proc_name = this.activityInst.container().manager().getData().getProcDefName(new Locale("l2"));
                instance_number = this.activityInst.container().getData().getCode();
            }
            if (operation != null && proc_name != null && instance_number != null) {
                for (ApplicationMonitor monitor : applicationMonitorSet) {
                    monitor.startApplication(operation);
                }
            }
            String text = proc_name + " - " + this.activityInst.getMeta().getActDefName(new Locale("l2"));
            boolean flag = false;
            ProcessContext context = this.getProcessContext();
            try {
                if (application.getType().equals((Object)ApplicationType.MANPOWER)) {
                    flag = true;
                    this.activityInst.getWfEngine().putApplicationRunMark(this.activityInst.getMeta().getActDefId(), text);
                    IFunctionObject functionObject = MDOHelper.getInstance().getFunctionObject((IMetaDataPK)new MetaDataPK(function.getPackageName(), function.getName()));
                    IOperationObject operationdef = null;
                    if (functionObject != null) {
                        operationdef = functionObject.getOperation(function.getOperation());
                    }
                    this.invokeTool(application, this.activityInst, context, actualParameters, operationdef);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("ApplicationType Error :");
                buffer.append(application.getType().getName());
                String message = buffer.toString();
                throw new WfException(message);
            }
            finally {
                try {
                    if (flag) {
                        this.activityInst.getWfEngine().removeApplicationRunMark(this.activityInst.getMeta().getActDefId());
                    }
                    long timespan = System.currentTimeMillis() - startTime;
                    if (operation != null && proc_name != null && instance_number != null) {
                        for (ApplicationMonitor monitor : applicationMonitorSet) {
                            monitor.endApplication(operation, timespan, proc_name, instance_number);
                        }
                    }
                }
                catch (Throwable t) {
                    throw new WfException(t);
                }
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public static Object transParameterData(WfActivity activity, ActualParameterDef item, FormalParameterDef formalParameter, Object formalParamData, IOperationObject operationdef) {
        String dataType;
        IMethodObject methodObject;
        List parameters;
        if (formalParameter.getDataType().equals(BasicType.PK)) {
            if (formalParamData != null) {
                String boId = formalParamData.toString();
                Object temp = formalParamData;
                try {
                    formalParamData = FunctionHelper.createPKbyBoId(boId);
                }
                catch (Exception e) {
                    log.info((Object)("transParameterData " + boId), (Throwable)e);
                    formalParamData = temp;
                }
            }
        } else if (formalParameter.getDataType().equals(BasicType.OBJECTVALUE)) {
            if (formalParamData != null) {
                String boId = formalParamData.toString();
                Object temp = formalParamData;
                try {
                    formalParamData = FunctionHelper.createObjectValueByBoId(boId, activity.getWfEngine().context());
                }
                catch (Exception e) {
                    log.info((Object)("transParameterData " + boId), (Throwable)e);
                    formalParamData = temp;
                }
            }
        } else if (formalParameter.getDataType().equals(BasicType.STRING)) {
            if (!BasicType.STRING.equals((Object)item.getDataField().getDataType()) && formalParamData != null) {
                if (ExternalType.ENUM.equals((Object)item.getDataField().getDataType())) {
                    if (formalParamData instanceof StringEnum) {
                        String value = ((StringEnum)formalParamData).getValue();
                        formalParamData = value;
                    }
                } else {
                    formalParamData = formalParamData.toString();
                }
            }
        } else if (formalParameter.getDataType().equals(BasicType.INTEGER)) {
            if (ExternalType.ENUM.equals((Object)item.getDataField().getDataType()) && formalParamData != null && formalParamData instanceof IntEnum) {
                int value = ((IntEnum)formalParamData).getValue();
                formalParamData = new Integer(value);
            }
        } else if (formalParameter.getDataType().equals(BasicType.FLOAT)) {
            if (ExternalType.ENUM.equals((Object)item.getDataField().getDataType()) && formalParamData != null && formalParamData instanceof FloatEnum) {
                float value = ((FloatEnum)formalParamData).getValue();
                formalParamData = new Float(value);
            }
        } else if (formalParameter.getDataType().equals(BasicType.BOID) && operationdef != null && (parameters = (methodObject = operationdef.getMethodObject()).getParameters()).size() == 1 && "ObjectValue".equals(dataType = ((IParameterObject)parameters.get(0)).getDataType()) && formalParamData != null) {
            String boId = formalParamData.toString();
            Object temp = formalParamData;
            try {
                formalParamData = FunctionHelper.createObjectValueByBoId(boId, activity.getWfEngine().context());
            }
            catch (Exception e) {
                log.info((Object)("transParameterData " + boId), (Throwable)e);
                formalParamData = temp;
            }
        }
        return formalParamData;
    }

    public static ArrayList getInvokeArgs(WfActivity activity, ActualParameterCollection actualParameters, FormalParameterCollection formalParameters, Map parameterMap, boolean isTransform, IOperationObject operationdef) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (int i = 0; i < actualParameters.size(); ++i) {
            FormalParameterDef formalParameter;
            ActualParameterDef item = actualParameters.get(i);
            if (item.getIndex() >= formalParameters.size() || (formalParameter = formalParameters.get(item.getIndex())).getMode().equals((Object)FormalParameterMode.OUT)) continue;
            Object formalParamData = parameterMap.get(formalParameter.getID());
            if (isTransform) {
                formalParamData = ManPowerAppManager.transParameterData(activity, item, formalParameter, formalParamData, operationdef);
            }
            try {
                if (formalParamData != null) {
                    logger.info((Object)"\u81ea\u52a8\u8282\u70b9\u8f93\u51fa\u53c2\u6570\u4fe1\u606f\uff1a");
                    logger.info((Object)("\u53c2\u6570\u540d\uff1a" + item.getExpr()));
                    logger.info((Object)("\u53c2\u6570\u503c\uff1a" + formalParamData.toString()));
                    logger.info((Object)("\u53c2\u6570\u7c7b\u578b\uff1a" + formalParamData.getClass().toString()));
                    logger.info((Object)("\u5bf9\u5e94\u7684\u5f62\u53c2\u540d\uff1a" + formalParameter.getName()));
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u81ea\u52a8\u8282\u70b9\u8f93\u51fa\u53c2\u6570\u65e5\u5fd7\u62a5\u9519\uff0c\u4e0d\u5f71\u54cd\u7a0b\u5e8f\u8fd0\u884c\uff1a" + e));
            }
            if (formalParamData == null && activity.getDefinition().getClass().toString().contains("com.kingdee.bos.workflow.define.ToolActivityDef")) {
                ToolActivityDef toolActivity = (ToolActivityDef)activity.getDefinition();
                String noTypeValue = (String)toolActivity.getToolActualsMap().get(formalParameter.getIndex());
                if (formalParameter.getDataType().equals(BasicType.INTEGER)) {
                    formalParamData = Integer.parseInt(noTypeValue);
                } else if (formalParameter.getDataType().equals(BasicType.STRING)) {
                    formalParamData = noTypeValue;
                } else if (formalParameter.getDataType().equals(BasicType.FLOAT)) {
                    formalParamData = Float.valueOf(Float.parseFloat(noTypeValue));
                } else if (formalParameter.getDataType().equals(BasicType.BOOLEAN)) {
                    formalParamData = Boolean.parseBoolean(noTypeValue);
                }
            }
            args.add(formalParamData);
        }
        return args;
    }

    public void setProcessContextForErrorMsg(WfActivity activity, ProcessContext context) {
        Object omsgKeyObject;
        Object onameKeyObject;
        Object msgKeyObject;
        String actDefId = activity.getDefinition().getID();
        String nameKey = actDefId + "_exceptionName";
        String msgKey = actDefId + "_exceptionMessage";
        String onameKey = "_exceptionName";
        String omsgKey = "_exceptionMessage";
        Object nameKeyObject = context.getDataFieldValue(nameKey);
        if (nameKeyObject != null) {
            context.setDataFieldValue(nameKey, null);
        }
        if ((msgKeyObject = context.getDataFieldValue(msgKey)) != null) {
            context.setDataFieldValue(msgKey, null);
        }
        if ((onameKeyObject = context.getDataFieldValue(onameKey)) != null) {
            context.setDataFieldValue(onameKey, null);
        }
        if ((omsgKeyObject = context.getDataFieldValue(omsgKey)) != null) {
            context.setDataFieldValue(omsgKey, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeTool(ApplicationDef application, WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters, IOperationObject operationdef) throws WfException {
        long time = System.currentTimeMillis();
        FormalParameterCollection formalParameters = application.getFormalParameters();
        Map parameterMap = ManPowerAppManager.getParameterMap(activity, context, actualParameters, formalParameters, true);
        FunctionDef functionDef = application.getFunction();
        ArrayList invokeArgs = ManPowerAppManager.getInvokeArgs(activity, actualParameters, formalParameters, parameterMap, true, operationdef);
        Context ctx = EnactmentUtils.getApplicationContext(activity);
        if (this.assignment != null && this.assignment.getUserId() != null) {
            ctx.setCaller((IObjectPK)new ObjectUuidPK(this.assignment.getUserId()));
        }
        String actInstId = activity.getId();
        String actDefName = activity.getName();
        String procInstId = activity.getProcInstId();
        String procDefName = activity.getProcess().getName();
        String bizPackage = functionDef.getPackageName();
        String function = functionDef.getName();
        String bizOperation = functionDef.getOperation();
        Object returnObject = null;
        try {
            String info = "Quick Test Invoking Manpower Function, procInstId=" + procInstId + ",actInstId=" + actInstId + "\nprocDefName=" + procDefName + ",actDefName=" + actDefName + "\nFunction:" + bizPackage + "." + function + ",Operation=" + bizOperation + "\nArguments:" + invokeArgs;
            log.info((Object)info);
            returnObject = this.needRollbackToolActivity(activity) ? FunctionHelper.invokeAutomatic(ctx, functionDef.getPackageName(), functionDef.getName(), functionDef.getOperation(), invokeArgs.toArray(), true) : this.invokeAutomaticRequiresNew(ctx, functionDef, invokeArgs);
            info = "Invoked Automatic Function, procInstId=" + procInstId + ",actInstId=" + actInstId + "\nReturn:" + returnObject;
            log.info((Object)info);
            this.setProcessContextForErrorMsg(activity, context);
            if (returnObject == null) return;
        }
        catch (Throwable e) {
            try {
                String info = "Invoked Automatic Function, procInstId=" + procInstId + ",actInstId=" + actInstId + "\nException:";
                log.error((Object)info, e);
                String paras = "parameters:{";
                if (invokeArgs != null) {
                    Object[] parameters = invokeArgs.toArray();
                    for (int i = 0; i < parameters.length; ++i) {
                        paras = paras + (i == 0 ? "" : ";");
                        paras = paras + parameters[i];
                    }
                }
                paras = paras + "}";
                String procDefId = activity.getDefinition().getContainer().getID();
                log.info((Object)("DefaultApplicationManager invokeTool error! PackageName:" + functionDef.getPackageName() + " FunctionName:" + functionDef.getName() + " Operation:" + functionDef.getOperation()));
                log.info((Object)("Datacenter:" + ctx.getAIS() + "; ProcessDef:" + procDefId + "; ActivityDef:" + activity.getDefinition().getID() + "; " + paras + "; Error Message:" + e.getMessage()), e);
                this.sendErrorMsg(application, activity, e);
                String actDefId = activity.getDefinition().getID();
                this.setInvokeExceptionToContext(e, context, actDefId);
                if (this.needRollbackToolActivity(activity)) {
                    InvocationTargetException ite;
                    IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
                    FunctionObjectInfo functionObjectInfo = loader.getFunction((IMetaDataPK)new MetaDataPK(functionDef.getPackageName(), functionDef.getName()));
                    if (e instanceof FriendlyBOSException) {
                        FriendlyBOSException friendlyBOSException = (FriendlyBOSException)e;
                        WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), friendlyBOSException);
                    } else if (e instanceof InvocationTargetException && (ite = (InvocationTargetException)e).getTargetException() != null && ite.getTargetException() instanceof FriendlyBOSException) {
                        FriendlyBOSException friendlyBOSException = (FriendlyBOSException)ite.getTargetException();
                        WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), friendlyBOSException);
                    }
                    if (functionObjectInfo != null && functionObjectInfo.getOperation() != null) {
                        OperationCollection operationCollection = functionObjectInfo.getOperation();
                        OperationInfo operationInfo = null;
                        int size = operationCollection.size();
                        for (int i = 0; i < size; ++i) {
                            OperationInfo temp = operationCollection.get(i);
                            if (!functionDef.getOperation().equals(temp.getName())) continue;
                            operationInfo = temp;
                            break;
                        }
                        if (operationInfo != null) {
                            WfException wfException = new WfException("WFE_TOOL_invoke", null, e);
                            wfException.addArg(activity.getMeta().getActInstInfo().getActDefName()).addArg(functionObjectInfo.getAlias()).addArg(functionObjectInfo.getFullName()).addArg(operationInfo.getAlias()).addArg(operationInfo.getName());
                            wfException.setIgnoreCurentStrack(true);
                            wfException.setExMessage(paras);
                            WorkflowUtils.logProcessException(activity.getProcInstId(), activity.getWfEngine(), wfException);
                            throw wfException;
                        }
                        this.executeToolExceptionLog(activity, functionDef, invokeArgs, e);
                        throw new WfException(e, true);
                    }
                    this.executeToolExceptionLog(activity, functionDef, invokeArgs, e);
                    throw new WfException(e, true);
                }
                this.executeToolExceptionLog(activity, functionDef, invokeArgs, e);
                throw new WfException(e, true);
            }
            catch (Throwable throwable) {
                if (returnObject == null) throw throwable;
                this.writeOutputToContext(returnObject, actualParameters, formalParameters, ApplicationType.TOOL);
                throw throwable;
            }
        }
        this.writeOutputToContext(returnObject, actualParameters, formalParameters, ApplicationType.TOOL);
        return;
    }

    private Object invokeAutomaticRequiresNew(Context ctx, FunctionDef functionDef, ArrayList invokeArgs) throws WfException {
        Class<FunctionHelper> classCaller = FunctionHelper.class;
        Object obj = null;
        String methodName = "invokeAutomatic";
        Class[] parameterTypes = new Class[]{Context.class, String.class, String.class, String.class, Object[].class, Boolean.TYPE};
        Object[] args = new Object[]{ctx, functionDef.getPackageName(), functionDef.getName(), functionDef.getOperation(), invokeArgs.toArray(), true};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        return WfTxHelper.invokeRequiresNew(ctx, invocationDesc);
    }

    private boolean isHandEvent(WfActivity activity) {
        ExtendedAttributeDef isHandEvent = activity.getDefinition().getActivityHeader().getExtendedAttributes().get("isHandEvent");
        return isHandEvent != null && isHandEvent.getValue().equalsIgnoreCase("true");
    }

    private boolean needRollbackToolActivity(WfActivity activity) {
        if (activity != null && activity.getDefinition() instanceof ToolActivityDef) {
            return ((ToolActivityDef)activity.getDefinition()).isDefaultRollback();
        }
        return false;
    }

    public static Map getParameterMap(WfActivity activity, ProcessContext context, ActualParameterCollection actualParameters, FormalParameterCollection formalParameters, boolean idKey) {
        Iterator iter = actualParameters.iterator();
        HashMap parameterMap = new HashMap();
        ApplicationDef appDef = null;
        String key = null;
        if (activity.getDefinition() != null) {
            appDef = ((IApplicationActivity)activity.getDefinition()).getRelatedApplication();
        }
        if (appDef != null && appDef.getType().equals((Object)ApplicationType.SCRIPT)) {
            parameterMap = (HashMap)context.getDataCopy();
        } else {
            while (iter.hasNext()) {
                ActualParameterDef item = (ActualParameterDef)iter.next();
                if (item.getIndex() >= formalParameters.size()) continue;
                FormalParameterDef formalParameter = formalParameters.get(item.getIndex());
                key = idKey ? formalParameter.getID() : formalParameter.getName();
                String name = item.getDataFieldName(activity.getDefinition());
                if (!StringUtils.isEmpty((String)item.getProp())) {
                    name = name + "." + item.getProp();
                }
                parameterMap.put(key, context.getDataFieldValue(name));
            }
        }
        return parameterMap;
    }

    private boolean isSendErrorMsg(WfActivity activity) {
        boolean result = false;
        ExtendedAttributeDef autoErrorSendTag = activity.getDefinition().getActivityHeader().getExtendedAttributes().get("autoErrorSend");
        if (autoErrorSendTag != null && autoErrorSendTag.getValue().equalsIgnoreCase("true")) {
            return true;
        }
        return result;
    }

    private String getMessageSubject(WfActivity activity, Locale local) throws WfException {
        StringBuffer titlebuffer = new StringBuffer();
        titlebuffer.append(activity.container().getData().getProcDefName(local)).append(" - ").append(activity.container().getData().getCode()).append(" - ").append(activity.getDefinition().getName(local)).append(" - ");
        titlebuffer.append("\u7684\u5f02\u5e38\u4fe1\u606f\uff01");
        return titlebuffer.toString();
    }

    private String getMessageBody(ApplicationDef application, WfActivity activity, Throwable e, Locale local) throws WfException {
        StringBuffer extendedDescription = new StringBuffer();
        FunctionDef functionDef = application.getFunction();
        if (functionDef == null) {
            extendedDescription.append("\u4efb\u52a1[").append(activity.getMeta().getActDefName(new Locale("L2"))).append("]\u6267\u884c\u4e2d\u53d1\u751f\u9519\u8bef").append('\n').append("\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a").append(e.getMessage());
        } else {
            extendedDescription.append("\u4efb\u52a1[").append(functionDef.getName()).append('-').append(functionDef.getOperation()).append("]\u6267\u884c\u4e2d\u53d1\u751f\u9519\u8bef").append('\n').append("\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a").append(e.getMessage());
        }
        return extendedDescription.toString();
    }

    private void sendErrorMsg(ApplicationDef application, WfActivity activity, Throwable e) throws WfException {
        if (this.isSendErrorMsg(activity)) {
            try {
                WfMessage message = new WfMessage();
                message.setActivity(activity);
                ProcessInstInfo processInstInfo = activity.container().getData();
                Locale[] locales = ApplicationUtil.getContextLocales((Context)activity.getWfEngine().context());
                for (int i = 0; i < locales.length; ++i) {
                    Locale locale = locales[i];
                    message.addSubject(this.getMessageSubject(activity, locale), locale);
                    message.addContent(this.getMessageBody(application, activity, e, locale), locale);
                    message.addInitiatorName(processInstInfo.getInitiatorName(locale), locale);
                }
                ProcessDef processDef = (ProcessDef)activity.getDefinition().getContainer();
                ResponsibleCollection responsibles = processDef.getProcessHeader().getResponsibles();
                String initiatorId = activity.container().getProcessMeta().getInitiatorId();
                for (int personIndex = 0; personIndex < responsibles.size(); ++personIndex) {
                    String personId = responsibles.get(personIndex).getID();
                    String userId = this.getUserIdByPersonId(personId, activity);
                    String receiver = this.wipeRepeatedUserId(userId + ";" + initiatorId);
                    message.sendNoTransaction(activity.getWfEngine().context(), receiver);
                }
            }
            catch (Throwable se) {
                log.warn((Object)"send error message error.", se);
            }
        }
    }

    private String wipeRepeatedUserId(String userId) {
        String[] userIds = userId.split(";");
        HashSet<String> set = new HashSet<String>();
        int n = userIds.length;
        for (int i = 0; i < n; ++i) {
            if (set.contains(userIds[i])) continue;
            set.add(userIds[i]);
        }
        StringBuffer receiver = new StringBuffer();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            receiver.append(i.next()).append(';');
        }
        return receiver.toString();
    }

    private String getUserIdByPersonId(String personId, WfActivity activity) throws WfException {
        StringBuffer userIdBuffer = new StringBuffer();
        IParticipantProvider IPersonProvider = activity.getWfEngine().getPariticipantProvider();
        Person[] persons = IPersonProvider.getPersonByEmployeeId(activity.getWfEngine().context(), personId);
        for (int i = 0; i < persons.length; ++i) {
            userIdBuffer.append(persons[i].getUserId());
            userIdBuffer.append(';');
        }
        userIdBuffer.delete(userIdBuffer.length() - 1, userIdBuffer.length());
        return userIdBuffer.toString();
    }

    private void executeToolExceptionLog(WfActivity activity, FunctionDef function, ArrayList invokeArgs, Throwable e) {
        try {
            WfLogger wfLogger = activity.getWfEngine().getWfLogger();
            StringBuffer buffer = new StringBuffer();
            buffer.append("Execute function error!\n");
            buffer.append("The detail is ");
            buffer.append("activityDefId=" + activity.getDefinition().getID());
            buffer.append(";functionName=");
            buffer.append(function.getName());
            buffer.append(";parameters:{");
            if (invokeArgs != null) {
                Object[] parameters = invokeArgs.toArray();
                for (int i = 0; i < parameters.length; ++i) {
                    buffer.append(i == 0 ? "" : ";");
                    buffer.append(parameters[i]);
                }
            }
            buffer.append('}');
            buffer.append(";statckTrace=");
            buffer.append(StringUtils.stackToString((Throwable)e));
            buffer.append('.');
            String message = buffer.toString();
            wfLogger.addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.RUNTOOLERROR, activity.container().getId(), message);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), e);
        }
    }

    private void setInvokeExceptionToContext(Throwable ex, ProcessContext context, String actDefId) {
        String nameKey = actDefId + "_exceptionName";
        String msgKey = actDefId + "_exceptionMessage";
        String onameKey = "_exceptionName";
        String omsgKey = "_exceptionMessage";
        if (ex.getCause() == null) {
            context.putDataFieldValue(nameKey, ex.getClass().getName());
            context.putDataFieldValue(msgKey, ex.getMessage());
            context.putDataFieldValue(onameKey, ex.getClass().getName());
            context.putDataFieldValue(omsgKey, ex.getMessage());
        } else if (ex.getCause().getCause() == null) {
            context.putDataFieldValue(nameKey, ex.getCause().getClass().getName());
            context.putDataFieldValue(msgKey, ex.getCause().getMessage());
            context.putDataFieldValue(onameKey, ex.getCause().getClass().getName());
            context.putDataFieldValue(omsgKey, ex.getCause().getMessage());
        } else if (ex.getCause().getCause().getCause() == null) {
            context.putDataFieldValue(nameKey, ex.getCause().getCause().getClass().getName());
            context.putDataFieldValue(msgKey, ex.getCause().getCause().getMessage());
            context.putDataFieldValue(onameKey, ex.getCause().getCause().getClass().getName());
            context.putDataFieldValue(omsgKey, ex.getCause().getCause().getMessage());
        } else {
            context.putDataFieldValue(nameKey, ex.getCause().getCause().getCause().getClass().getName());
            context.putDataFieldValue(msgKey, ex.getCause().getCause().getCause().getMessage());
            context.putDataFieldValue(onameKey, ex.getCause().getCause().getCause().getClass().getName());
            context.putDataFieldValue(omsgKey, ex.getCause().getCause().getCause().getMessage());
        }
    }
}

