/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.async;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    static SSL ssl = new SSL();
    private static final boolean HOSTNAME_VERIFY = true;

    private HttpUtil() {
    }

    public static String doGetRequest(String httpUrl, Map<String, String> header, String jsonStr) {
        return HttpUtil.request(httpUrl, header, jsonStr, true, false);
    }

    public static String jsonRequest(String httpUrl, String jsonStr) {
        return HttpUtil.request(httpUrl, null, jsonStr, false, true);
    }

    public static String doPostRequest(String httpUrl, Map<String, String> header, String jsonStr) {
        return HttpUtil.request(httpUrl, header, jsonStr, false, true);
    }

    private static String request(String httpUrl, Map<String, String> header, String httpArg, boolean isGet, boolean isContentTypeJSON) {
        String result = null;
        StringBuffer sbf = new StringBuffer();
        HttpURLConnection connection = null;
        FilterOutputStream out = null;
        BufferedReader reader = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            if (isGet) {
                connection.setRequestMethod("GET");
            } else {
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                if (isContentTypeJSON) {
                    connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
                }
                out = new DataOutputStream(connection.getOutputStream());
                ((DataOutputStream)out).writeBytes(httpArg);
                ((DataOutputStream)out).flush();
            }
            if (header != null && header.size() > 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String strRead = null;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
                sbf.append("\r\n");
            }
            result = sbf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("HTTP\u8fde\u63a5\u5931\u8d25", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetRequest(String urlStr, String accesstoken, String timestamp, String signature) throws IOException {
        StringBuilder result = new StringBuilder();
        HttpURLConnection connection = null;
        InputStream is = null;
        try {
            URL url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(30000);
            connection.setRequestProperty("accesstoken", accesstoken);
            connection.setRequestProperty("timestamp", timestamp);
            connection.setRequestProperty("signature", signature);
            connection.connect();
            is = connection.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            if (in != null) {
                String line = "";
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtil.close(null, is, connection);
            throw throwable;
        }
        HttpUtil.close(null, is, connection);
        return result.toString();
    }

    private static void close(OutputStream out, InputStream in, HttpURLConnection conn) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (conn != null) {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequestByParamsWithHeader(String signature, String timestamp, String accesstoken, String urlStr, Map<String, Object> params) throws IOException {
        StringBuffer result = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream iss = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Accept", "*/*");
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Accept-Charset", "utf-8");
            conn.setRequestProperty("signature", signature);
            conn.setRequestProperty("timestamp", timestamp);
            conn.setRequestProperty("accesstoken", accesstoken);
            out = conn.getOutputStream();
            String data = "";
            for (Map.Entry<String, Object> m : params.entrySet()) {
                if (data.length() == 0) {
                    data = m.getKey() + "=" + m.getValue();
                    continue;
                }
                data = data + "&" + m.getKey() + "=" + m.getValue();
            }
            out.write(data.getBytes());
            out.flush();
            conn.connect();
            iss = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(iss, "UTF-8"));
            if (in != null) {
                String line = "";
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtil.close(out, iss, conn);
            throw throwable;
        }
        HttpUtil.close(out, iss, conn);
        return result.toString();
    }

    private static boolean isHttps(String url) {
        return url.startsWith("https:");
    }

    public static class SSL {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        SSLContext context;

        SSL() {
            X509TrustManager x509 = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] ax509certificate, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] ax509certificate, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            try {
                this.context = SSLContext.getInstance("TLS");
                this.context.init(null, new TrustManager[]{x509}, new SecureRandom());
            }
            catch (Exception e) {
                logger.error(" \u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
    }
}

