/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.jcache.CacheLoader;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.trace.WfMonitor;
import com.kingdee.util.LowTimer;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class WfAssignmentCacheLoader
implements com.kingdee.bos.cache.CacheLoader,
CacheLoader {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.cache.WfAssignmentCacheLoader");
    private WfEngine engine;

    public WfAssignmentCacheLoader(WfEngine engine) {
        this.engine = engine;
    }

    public Object load(Object argument) throws CacheException {
        if (argument == null) {
            throw new IllegalArgumentException("argument");
        }
        try {
            return this.loadWfAssignment((String)argument);
        }
        catch (WfException ex) {
            log.warn((Object)("can not load assignment from cache. assignment's Id : '" + argument + "' at " + this.engine.context().getAIS()), (Throwable)ex);
            throw new CacheException("can not load assignment from cache. assignment's Id : '" + argument + "' at " + this.engine.context().getAIS(), (Throwable)ex);
        }
    }

    private WfAssignment loadWfAssignment(String assignmentId) throws WfException {
        AssignmentInfo meta;
        LowTimer lowTimer = new LowTimer();
        try {
            meta = this.engine.getStoreManager().getWorkItemStorer().getWorkItem(assignmentId);
        }
        catch (BOSException e) {
            throw new WfException(e.getMessage(), (Throwable)e, true);
        }
        catch (SQLException e) {
            throw new WfException(e.getMessage(), (Throwable)e, true);
        }
        if (meta == null) {
            throw new WfException("can not get data from db. assignmentId : " + assignmentId);
        }
        WfAssignment assignment = new WfAssignment(this.engine, meta);
        WfMonitor.trace(assignment);
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfAssignmentCacheLoader load " + assignmentId + "] cost: " + lowTimer.msValue()));
        }
        return assignment;
    }

    public void cleanUp() {
    }

    public Object load(ObjectRef ref) throws Exception {
        return this.load(ref.name());
    }

    public void unload(ObjectRef ref, Object value) {
        log.info((Object)("cache item " + ref + " unload value " + value));
    }
}

