/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.ext.app.Sql;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.cbos.process.vm.utils.XmlUtil;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlowContextBuilder {
    private static final Logger logger = Logger.getLogger(FlowContextBuilder.class);
    private static final String TRANSITION = "501010001";
    private static final String HALT_AFTER_TASK_STARTED = "2500000";
    private static final String HALT_BEFORE_PARTIAL_COMPLETED = "5190000";
    private static final String JOIN_BEFORE_READY = "995000";
    private static final String HALT_TOOL_TASK_STARTED = "2000000";
    private static final String NO_RECOVERY = "-1";
    private static final String WAITING_FOR_CHILDREN = "6000000";
    private static final String HALT_AFTER_SUSPENDED = "1301000000";
    private static final String ROOT_EXECUTION_ID = "1";
    private static final String EMPTY_RUNTIME = "<?xml version='1.0' encoding='UTF-8'?><context closed='false' counter='100' error='' execution-queue='' execution-stack='' last-execution='' profile='PERFORMANCE' running='false' started='true' timestamp=''><data-area crc='' flow='' host='' id='0'><values/><executions/></data-area></context>";

    public static Document build(WfProcess process) {
        try {
            ProcessDef procDef = process.getDefinition();
            Document doc = XmlUtil.parse((String)EMPTY_RUNTIME);
            Element da = FlowContextBuilder.setFlow(procDef, doc);
            Element container = XmlUtil.getChild((Element)da, (String)"executions");
            FlowContextBuilder.createRootExecution(process, doc, container);
            List acts = process.getActivities();
            StringBuffer queue = new StringBuffer();
            WfActivity start = null;
            WfEngine engine = process.getWfEngine();
            for (int i = 0; i < acts.size(); ++i) {
                String state;
                WfActivity src;
                String id;
                WfActivity act = (WfActivity)acts.get(i);
                String[] fromActs = act.getMeta().getFromActInstList();
                if (fromActs != null && fromActs.length == 1 && (id = fromActs[0]) != null && id.length() > 0 && (src = engine.getActivityInst(id)).getDefinition() instanceof StartActivityDef) {
                    start = act;
                }
                if ((state = act.state()).startsWith("open")) {
                    FlowContextBuilder.createNormalExecution(doc, container, act, state);
                    continue;
                }
                if (!state.equals("closed.completed")) continue;
                FlowContextBuilder.createTransExecution(act, doc, container, state, queue);
            }
            String parent = process.getInstanceInfo().getParentProcInstId();
            if (parent == null || parent.length() == 0) {
                Element properties = doc.createElement("properties");
                doc.getDocumentElement().appendChild(properties);
                Element item = doc.createElement("item");
                properties.appendChild(item);
                item.setAttribute("key", "$first_act_id");
                item.setAttribute("value", start.getDefinition().getID());
            }
            doc.getDocumentElement().setAttribute("execution-stack", queue.toString());
            logger.info((Object)("\u6d41\u7a0b{" + process.getId() + "}\u5347\u7ea7\u6d41\u7a0b\u8fd0\u884c\u671f\u73af\u5883\u6570\u636e\u6210\u529f\uff01"));
            return doc;
        }
        catch (Throwable e) {
            WfEngine engine = process.getWfEngine();
            WfException ex = new WfException("\u5347\u7ea7\u6d41\u7a0b\u8fd0\u884c\u671f\u73af\u5883\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u603b\u90e8\u652f\u6301\uff01", engine.getLocale().getLanguage(), e);
            WorkflowUtils.logProcessException(process.getId(), engine, ex);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void createTransExecution(WfActivity source, Document doc, Element container, String state, StringBuffer queue) throws WfException {
        ActivityDef actDef = source.getDefinition();
        if (actDef instanceof StartActivityDef) {
            return;
        }
        String[] postActs = source.getMeta().getPostActInstList();
        if (postActs == null || postActs.length == 0 || postActs.length == 1 && postActs[0].length() == 0) {
            if (!FlowContextBuilder.needsToRetry(source)) {
                return;
            }
            ActivityDef def = actDef;
            if (def instanceof EndActivityDef) {
                return;
            }
            Element e = doc.createElement("execution");
            container.appendChild(e);
            e.setAttribute("def", def.getID());
            e.setAttribute("id", source.getId());
            e.setAttribute("parent", ROOT_EXECUTION_ID);
            if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
                e.setAttribute("ip", HALT_AFTER_SUSPENDED);
                e.setAttribute("recovery", TRANSITION);
            } else {
                e.setAttribute("ip", TRANSITION);
                e.setAttribute("recovery", NO_RECOVERY);
            }
            if (queue.length() > 0) {
                queue.append(",");
            }
            queue.append(source.getId());
        }
    }

    private static boolean needsToRetry(WfActivity source) throws WfException {
        try {
            ActivityDef actDef = source.getDefinition();
            String sql = "select count(*) as c from T_WFR_ACTINST WHERE FPROCINSTID='" + source.getProcInstId() + "' AND FACTDEFID='" + actDef.getID() + "'";
            int count = ((Number)Sql.getObject((Context)source.getContext(), (String)sql)).intValue();
            TransitionCollection c = actDef.getOutgoingTransitions();
            boolean needsToRetry = false;
            for (int i = 0; i < c.size(); ++i) {
                ActivityDef to = c.get(i).getTo();
                JoinType type = to.getActivityHeader().getJoinType();
                if (!type.equals((Object)JoinType.AND)) continue;
                sql = "select count(*) as c from T_WFR_ACTINST WHERE FPROCINSTID='" + source.getProcInstId() + "' AND FACTDEFID='" + to.getID() + "'";
                int c2 = ((Number)Sql.getObject((Context)source.getContext(), (String)sql)).intValue();
                if (c2 >= count) continue;
                needsToRetry = true;
            }
            return needsToRetry;
        }
        catch (Exception e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
    }

    private static void createNormalExecution(Document doc, Element container, WfActivity act, String state) throws Exception {
        ActivityDef def = act.getDefinition();
        Element e = doc.createElement("execution");
        container.appendChild(e);
        e.setAttribute("def", def.getID());
        e.setAttribute("id", act.getId());
        e.setAttribute("parent", ROOT_EXECUTION_ID);
        String priorIds = act.getMeta().getActInstInfo().getPreActInstList();
        e.setAttribute("priorIds", priorIds);
        if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
            e.setAttribute("ip", HALT_AFTER_SUSPENDED);
            e.setAttribute("recovery", FlowContextBuilder.getIp(def));
        } else {
            e.setAttribute("ip", FlowContextBuilder.getIp(def));
            e.setAttribute("recovery", NO_RECOVERY);
            FlowContextBuilder.setProps4RouterJoin(doc, e, act);
        }
    }

    private static void setProps4RouterJoin(Document doc, Element e, WfActivity act) throws Exception {
        String priorIds;
        ActivityDef def = act.getDefinition();
        if (def instanceof RouterActivityDef && def.getActivityHeader().getJoinType() == JoinType.AND && (priorIds = act.getMeta().getActInstInfo().getPreActInstList()) != null) {
            String[] ids = priorIds.split(",");
            if (ids.length == 0) {
                return;
            }
            Element prop = doc.createElement("properties");
            Element item = doc.createElement("item");
            item.setAttribute("key", "EXECUTED_PRIORS");
            item.setAttribute("type", "collection");
            FlowContextBuilder.appendItemValue(doc, act, ids, item);
            prop.appendChild(item);
            e.appendChild(prop);
        }
    }

    private static void appendItemValue(Document doc, WfActivity act, String[] ids, Element item) throws Exception {
        for (String id : ids) {
            try {
                WfActivity from = act.getWfEngine().getActivityInst(id);
                if (from.getMeta().getState().startsWith("open")) continue;
                TransitionDef tran = act.container().getDefinition().getTransitionsByActivity(from.getDefinition().getID(), act.getDefinition().getID()).get(0);
                Element value = doc.createElement("value");
                value.setTextContent(tran.getID());
                item.appendChild(value);
            }
            catch (WfException e1) {
                throw new Exception(e1);
            }
        }
    }

    private static String getIp(ActivityDef def) {
        if (def instanceof ManpowerActivityDef) {
            return HALT_BEFORE_PARTIAL_COMPLETED;
        }
        if (def instanceof SubflowActivityDef) {
            return HALT_BEFORE_PARTIAL_COMPLETED;
        }
        if (def instanceof ToolActivityDef) {
            return HALT_TOOL_TASK_STARTED;
        }
        if (def instanceof RouterActivityDef) {
            return JOIN_BEFORE_READY;
        }
        return HALT_AFTER_TASK_STARTED;
    }

    private static void createRootExecution(WfProcess process, Document doc, Element container) {
        Element root = doc.createElement("execution");
        container.appendChild(root);
        root.setAttribute("def", "$");
        root.setAttribute("id", ROOT_EXECUTION_ID);
        if (process.state().equals("open.not_running.suspended") || process.state().equals("open.not_running.blocked")) {
            root.setAttribute("ip", HALT_AFTER_SUSPENDED);
            root.setAttribute("recovery", WAITING_FOR_CHILDREN);
        } else {
            root.setAttribute("ip", WAITING_FOR_CHILDREN);
            root.setAttribute("recovery", NO_RECOVERY);
        }
    }

    private static Element setFlow(ProcessDef procDef, Document doc) {
        Element da = XmlUtil.getChild((Element)doc.getDocumentElement(), (String)"data-area");
        da.setAttribute("flow", procDef.getHashValue());
        return da;
    }
}

