/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.workflow.biz.event.ActivityEventExecutor;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;

public class CommonEventReceiver
extends WfJobHandler {
    private static final long serialVersionUID = -3149519947280565253L;
    private ICommonEvent event;
    private EventProcMetaInfo info;

    public static void enqueue(Context ctx, ICommonEvent event, EventProcMetaInfo info) throws AlreadyInProcessQueueException {
        String procInstId = info.getProcInstId().toString();
        String jobId = Mutex.getMutex(ctx, procInstId);
        String title = "~" + procInstId + ":event:receiver";
        JobDispatcher.dispatch(jobId, ctx, title, new CommonEventReceiver(event, info, ctx.getCaller().toString()), false, WfPriority.MEDIUM);
    }

    private CommonEventReceiver(ICommonEvent event, EventProcMetaInfo info, String userId) {
        super(userId);
        this.event = event;
        this.info = info;
    }

    @Override
    protected boolean requiresTran() {
        return true;
    }

    @Override
    protected String getProcInstId() {
        return this.info.getProcInstId().toString();
    }

    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        ActivityEventExecutor.innerExecute(this.event, this.info, engine);
    }
}

