/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivitySuspendedException;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfRuntimeStat;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;

public class WfAssignEventHandler
extends WfJobHandler {
    private static final long serialVersionUID = -1824947496703012470L;
    private final WfBizEvent event;
    private String procInstId;

    public static void enqueue(Context ctx, WfBizEvent event) throws WfException {
        String title = WfAssignEventHandler.generateJobTitle(ctx, event);
        String jobId = Mutex.getMutex(ctx, event);
        JobDispatcher.dispatch(jobId, ctx, title, new WfAssignEventHandler(event, ctx.getCaller().toString()), false, WfPriority.MEDIUM);
    }

    private static String generateJobTitle(Context ctx, WfBizEvent event) throws WfException, ActivitySuspendedException {
        WfAssignment assign;
        String assignId = event.getAssignmentId();
        WfEngine engine = WfEngine.getEngine(ctx);
        WfActivity act = engine.getActivityInst((assign = engine.getAssignment(assignId)).getActInstId());
        if (act.state().equals("open.not_running.suspended") || act.state().equals("open.not_running.blocked")) {
            throw new ActivitySuspendedException();
        }
        String prefix = "~WFEvent(" + event.getId() + ") with assignment";
        String title = prefix + ",BoId:" + event.getBoId();
        title = title + ";assignId:" + event.getAssignmentId();
        return title;
    }

    private WfAssignEventHandler(WfBizEvent event, String userId) {
        super(userId);
        this.event = event;
    }

    @Override
    public void run(Context ctx) throws Exception {
        WfRuntimeStat.incEventCount();
        WfEngine engine = WfEngine.getEngine(ctx);
        this.setProcessInstId(engine);
        engine.acceptEventSupport(this.event);
    }

    private void setProcessInstId(WfEngine engine) throws WfException {
        String assignId = this.event.getAssignmentId();
        if (assignId != null) {
            this.procInstId = engine.getAssignment(assignId).getProcInstId();
        }
    }

    @Override
    protected String getProcInstId() {
        return this.procInstId;
    }

    @Override
    protected boolean requiresTran() {
        return true;
    }
}

