/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.ActivitySuspendedException;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfRuntimeStat;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;

public class WfBizEventHandler
extends WfJobHandler {
    private static final long serialVersionUID = -1824947496703012470L;
    private final WfBizEvent event;

    public static void enqueue(Context ctx, WfBizEvent event) throws WfException {
        if (event.getAssignmentId() != null) {
            throw new IllegalArgumentException("\u7ed1\u5b9a\u4e86\u4efb\u52a1\u7684\u4e8b\u4ef6\u5fc5\u987b\u901a\u8fc7WfAssignEventHandler\u5904\u7406\uff01");
        }
        String title = WfBizEventHandler.generateJobTitle(ctx, event);
        String jobId = event.getBoId();
        JobDispatcher.dispatch(jobId, ctx, title, new WfBizEventHandler(event, ctx.getCaller().toString()), true, WfPriority.HIGHEST);
    }

    private WfBizEventHandler(WfBizEvent event, String userId) {
        super(userId);
        this.event = event;
    }

    @Override
    public void run(Context ctx) throws Exception {
        WfRuntimeStat.incEventCount();
        WfEngine engine = WfEngine.getEngine(ctx);
        engine.acceptEventSupport(this.event);
    }

    @Override
    protected String getProcInstId() {
        return null;
    }

    @Override
    protected boolean requiresTran() {
        return true;
    }

    private static String generateJobTitle(Context ctx, WfBizEvent event) throws WfException, ActivitySuspendedException {
        String prefix = "~WFEvent(" + event.getId() + ") for create procinst";
        String title = prefix + ",BoId:" + event.getBoId();
        return title;
    }

    public static boolean existBizEventInJob(Context ctx, String bizEventId) throws WfException {
        String like = "~WFEvent(" + bizEventId + ")";
        String sql = "select 1 from T_JOB_INST where ftitle like '" + like + "%'";
        try {
            return SQL.executeQuery((Context)ctx, (String)sql).size() > 1;
        }
        catch (BOSException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
    }
}

