/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.event;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.message.WfMessage;
import com.kingdee.bos.workflow.event.WfEvent;
import com.kingdee.bos.workflow.event.WfEventAction;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfSendNotificationAction
implements WfEventAction {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.event.WfSendNotificationAction");
    private String type = "SendNotification";
    public static final String PARA_NAME_MESSAGE = "messgae";
    public static final String PARA_NAME_MESSAGEBODY = "body";
    public static final String PARA_NAME_AIS = "ais";
    public static final String PARA_NAME_SOLUTION = "solution";
    public static final String PARA_NAME_RECEIVER = "receiver";
    public static final String PARA_NAME_MESSAGETYPE = "messageType";

    @Override
    public void action(WfEvent event, Map parameters) {
        Map message = (Map)parameters.get(PARA_NAME_MESSAGE);
        Map bodies = (Map)parameters.get(PARA_NAME_MESSAGEBODY);
        String ais = (String)parameters.get(PARA_NAME_AIS);
        String solution = (String)parameters.get(PARA_NAME_SOLUTION);
        String recivers = (String)parameters.get(PARA_NAME_RECEIVER);
        int messageType = (Integer)parameters.get(PARA_NAME_MESSAGETYPE);
        WfActivity activity = (WfActivity)parameters.get("wfActivity");
        if (recivers != null) {
            this.sendMessageToPerson(message, bodies, recivers, ais, solution, messageType, activity);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send notification to (" + recivers + ")While Event: [" + event.getEventType().getName() + "] Message is "));
            log.debug((Object)message);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void sendMessageToPerson(Map titles, Map bodies, String userid, String ais, String solution, int messageType, WfActivity activity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"===============WfSendNotification start===============");
        }
        WfMessage message = new WfMessage();
        for (Map.Entry entry : titles.entrySet()) {
            Object body = bodies.get(entry.getKey());
            Locale locale = (Locale)entry.getKey();
            message.addSubject(entry.getValue().toString(), locale);
            message.addContent(body == null ? "" : body.toString(), locale);
        }
        message.setType(0);
        message.setBizType(0);
        message.setDatabaseCenter(ais);
        message.setSolution(solution);
        message.setContentType(messageType);
        try {
            message.setActivity(activity);
        }
        catch (WfException wfException) {
            // empty catch block
        }
        message.setPriority(10);
        message.send(userid);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" messageType:" + messageType + " userid:" + userid + " ais:" + ais + " solution:" + solution));
            log.debug((Object)"===============WfSendNotification end===============");
        }
    }
}

