/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.search;

import com.kingdee.bos.Context;
import com.kingdee.bos.search.lucene.IndexService;
import com.kingdee.bos.search.lucene.SolrSearchService;
import com.kingdee.bos.search.lucene.bean.FieldResultValue;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.search.lucene.bean.SearchResult;
import com.kingdee.bos.workflow.extscheme.search.SearchInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WFSearchAgent {
    private static final Logger logger = Logger.getLogger(WFSearchAgent.class);

    public static List<SearchResult> search(Context ctx, String searchVal, String userId, int assignState) throws Exception {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("f_u", WFSearchAgent.getHashCode(userId) + "_" + assignState);
        SearchParam param = new SearchParam(ctx.getAIS(), "WORKFLOW", null, searchVal, condition);
        return SolrSearchService.INS.search4BillInfo(param);
    }

    public static void buildIndex(Context ctx, Set assignIds) {
        try {
            if (assignIds.size() > 0) {
                String id = (String)assignIds.iterator().next();
                IndexService.INS.submit(ctx, "WORKFLOW", id);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"WFSearchAgent buildIndex error ", e);
        }
    }

    private static String getHashCode(String pid) {
        String hashCode = pid.hashCode() + "";
        if (hashCode.startsWith("-")) {
            hashCode = hashCode.substring(1);
        }
        return hashCode;
    }

    public static Map<String, ArrayList<SearchInfo>> searchBillByLucene(Context ctx, String searchVal, Integer assignState, String userId) throws Exception {
        HashMap<String, ArrayList<SearchInfo>> hashMap = new HashMap<String, ArrayList<SearchInfo>>();
        List<SearchResult> results = null;
        if (assignState == 0) {
            results = WFSearchAgent.search(ctx, searchVal, userId, 4);
            results.addAll(WFSearchAgent.search(ctx, searchVal, userId, 16));
        } else {
            results = WFSearchAgent.search(ctx, searchVal, userId, assignState);
        }
        String allMatch = "<Strong>" + searchVal + "</Strong>";
        for (SearchResult r : results) {
            String billId = r.getBillInfo().getOwnerId();
            List fieldResultValueList = r.getFieldValue();
            HashMap<String, SearchInfo> fieldMap = new HashMap<String, SearchInfo>();
            for (FieldResultValue fieldResultValue : fieldResultValueList) {
                SearchInfo info = new SearchInfo();
                String value = fieldResultValue.getHighlightFieldValue();
                info.setBillId(billId);
                info.setValue(value);
                info.setAllMatch(value.equals(allMatch));
                fieldMap.put(fieldResultValue.getFieldAlias(), info);
            }
            for (String field : fieldMap.keySet()) {
                if (hashMap.containsKey(field)) {
                    ((ArrayList)hashMap.get(field)).add(fieldMap.get(field));
                    continue;
                }
                ArrayList searchlist = new ArrayList();
                searchlist.add(fieldMap.get(field));
                hashMap.put(field, searchlist);
            }
        }
        return hashMap;
    }
}

