/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.core.thread.FlowAbort;
import com.kingdee.bos.workflow.engine.core.thread.FlowResume;
import com.kingdee.bos.workflow.engine.core.thread.FlowSignaler;
import com.kingdee.bos.workflow.engine.core.thread.FlowSuspend;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.CannotCompleteException;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.service.ActivityInfo;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IActivityControlService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.NotRollbackCause;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.cbos.process.vm.utils.graph.Activity;
import com.kingdee.cbos.process.vm.utils.graph.Diagram;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ActivityControlService
extends AbstractBOSObject
implements IActivityControlService {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.ActivityControlService");
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFACTCLS");

    public ActivityControlService(Context ctx) {
        super(ctx);
        this.registerInterface(IActivityControlService.class, (Object)this);
    }

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public static IActivityControlService getService(Context ctx) {
        return new ActivityControlService(ctx);
    }

    public ActivityInstInfo createActivityInst(String procInstId, String actDefId) throws WfException {
        WfEngine wfEngine;
        WfProcess procInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:createActivtyInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstId=\"");
                buffer.append(procInstId);
                buffer.append("\" actDefId=\"");
                buffer.append(actDefId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CREATE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if ((procInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getProcessInst(procInstId)).getProcessContext().isPvmMode()) {
            return this.innerCreateAct(procInstId, actDefId, procInst);
        }
        String actInstId = procInst.createActivityInst(actDefId, null, null, false);
        return wfEngine.getActivityInst(actInstId).getMeta();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityInstInfo innerCreateAct(String procInstId, String actDefId, WfProcess procInst) throws AlreadyInProcessQueueException, WfException {
        String mutex = Mutex.getMutex(this.getContext(), procInstId);
        Mutex.lock(this.getContext(), mutex);
        try {
            FlowContext runtime = procInst.getProcessContext().loadFlowContext();
            ActivityDef actDef = procInst.getDefinition().getActivityDef(actDefId);
            String parentId = runtime.getRootExecution().getId();
            Execution e = runtime.getService().append(parentId, new String[]{actDefId})[0];
            WfActivity act = procInst.innerCreateActivityInst(e.getId(), actDef, null, null);
            Util.setActivityIsCreated(e);
            procInst.getProcessContext().setFlowContext(runtime);
            ActivityInstInfo activityInstInfo = act.getInstanceInfo();
            return activityInstInfo;
        }
        finally {
            Mutex.unlock(this.getContext(), mutex);
        }
    }

    public void activateActivityInst(String activityInstId) throws WfException {
        WfEngine wfEngine;
        WfActivity actInst;
        WfProcess procInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:activateActivityInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: activityInstId=\"");
                buffer.append(activityInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!(procInst = (actInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getActivityInst(activityInstId)).container()).getProcessContext().isPvmMode()) {
            actInst.activate();
        } else {
            this.innerActivate(activityInstId, procInst);
        }
    }

    private void innerActivate(String activityInstId, WfProcess procInst) throws AlreadyInProcessQueueException, WfException {
        String procInstId = procInst.getId();
        Context ctx = this.getContext();
        FlowSignaler.enqueue(ctx, procInstId, activityInstId);
    }

    public void completeActivityInst(String activityInstId) throws WfException {
        WfEngine wfEngine;
        WfActivity actInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:completeActivityInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: activityInstId=\"");
                buffer.append(activityInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!(actInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getActivityInst(activityInstId)).isInited()) {
            throw new WfException("\u6d3b\u52a8\u672a\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u5f3a\u5236\u5b8c\u6210\uff01");
        }
        if (actInst.getDefinition() instanceof ManpowerActivityDef) {
            actInst.cancelUncompleteAssignments();
        }
        this.completeEnqueue(actInst);
    }

    public void resumeActInst(String actInstId) throws WfException {
        WfEngine wfEngine;
        WfActivity actInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:resumeActInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!(actInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getActivityInst(actInstId)).container().getProcessContext().isPvmMode()) {
            actInst.resume();
        } else {
            FlowResume.enqueue(this.getContext(), actInst.getProcInstId(), actInstId);
        }
    }

    public void suspendActInst(String actInstId) throws WfException {
        try {
            WfEngine wfEngine;
            WfActivity actInst;
            if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:suspendActInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            if (!(actInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getActivityInst(actInstId)).container().getProcessContext().isPvmMode()) {
                actInst.suspend("exec method 'EnactmentService.suspendActInst'.");
            } else {
                FlowSuspend.enqueue(this.getContext(), actInst.getProcInstId(), actInstId);
            }
        }
        catch (Exception e) {
            if (e instanceof WfException) {
                throw (WfException)((Object)e);
            }
            throw new WfException(e.getMessage(), (Throwable)e);
        }
    }

    public void abortActivityInst(String activityInstId) throws WfException {
        WfEngine wfEngine;
        WfActivity actInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:abortActivityInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(activityInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!(actInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getActivityInst(activityInstId)).container().getProcessContext().isPvmMode()) {
            actInst.abort("exec method 'EnactmentService.abortActivityInst'.");
        } else {
            if (!actInst.state().startsWith("open")) {
                return;
            }
            FlowAbort.enqueue(this.getContext(), actInst.getProcInstId(), activityInstId);
        }
    }

    public void terminateActivityInst(String activityInstId) throws WfException {
        WfEngine wfEngine;
        WfActivity actInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:terminateActivityInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(activityInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!(actInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getActivityInst(activityInstId)).container().getProcessContext().isPvmMode()) {
            actInst.terminate();
        } else {
            if (!actInst.state().startsWith("open")) {
                return;
            }
            FlowAbort.enqueue(this.getContext(), actInst.getProcInstId(), activityInstId);
        }
    }

    public ActivityInstInfo redoActInst(String actInstId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:redoActInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfActivity actInst = wfEngine.getActivityInst(actInstId);
        String newActInstId = actInst.redo();
        return wfEngine.getActivityInst(newActInstId).getMeta();
    }

    public ActivityInstInfo rollbackActInst(String actInstId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:rollbackActInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        Context ctx = this.getContext();
        WfEngine wfEngine = EngineUtil.getEngine(ctx);
        if (actInstId.endsWith("WFWKITEM")) {
            try {
                IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
                if (svc.createRollBackAssign(actInstId)) {
                    return null;
                }
                WfAssignment assign = wfEngine.getAssignment(actInstId);
                actInstId = assign.getActInst().getId();
            }
            catch (BOSException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
        }
        WfActivity actInst = wfEngine.getActivityInst(actInstId);
        ActivityInstInfo actInfo = null;
        WfProcess procInst = actInst.container();
        if (!procInst.getProcessContext().isPvmMode()) {
            String newActInstId = procInst.transBack(actInst);
            if (newActInstId == null || newActInstId.length() == 0) {
                return null;
            }
            actInfo = wfEngine.getActivityInst(newActInstId).getMeta();
        } else {
            actInfo = this.pvmRollback(wfEngine, actInst, procInst);
        }
        return actInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityInstInfo pvmRollback(WfEngine wfEngine, WfActivity actInst, WfProcess procInst) throws WfException, AlreadyInProcessQueueException {
        block8: {
            ArrayList targets = new ArrayList();
            boolean can = this.findActInst4Rollback(wfEngine, actInst, targets);
            if (!can) {
                throw new WfException("\u4e0d\u80fd\u56de\u9000");
            }
            String mutex = Mutex.getMutex(this.getContext(), procInst.getId());
            Mutex.lock(this.getContext(), mutex);
            FlowContext runtime = null;
            try {
                runtime = procInst.getProcessContext().loadFlowContext();
                Execution redo = runtime.getService().append(runtime.getRootExecution().getId(), new String[]{actInst.getDefinition().getID()})[0];
                redo.setProperty("$IsTransBack", "true");
                for (int i = 0; i < targets.size(); ++i) {
                    String actId = (String)targets.get(i);
                    Execution terminated = runtime.getExecution(actId);
                    if (terminated == null) continue;
                    terminated.terminate();
                    redo.setPrior(terminated.getId());
                    Util.setJumped(terminated);
                }
                runtime.resume();
                ActivityInstInfo i = Util.getWfActivity(redo).getMeta();
                return i;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                Object msg = procInst.getProcessContext().getDataFieldValue(actInst.getDefinition().getID() + "_exceptionMessage");
                if (msg != null) {
                    log.error((Object)msg.toString());
                    break block8;
                }
                throw new WfException(e.getMessage(), (Throwable)e);
            }
            finally {
                this.commitMgrAndRuntimeTx(procInst, runtime);
                Mutex.unlock(this.getContext(), mutex);
            }
        }
        return null;
    }

    public void commitMgrAndRuntime(WfProcess process, FlowContext runtime) throws WfException {
        process.getProcessContext().setFlowContext(runtime);
        WfTxContext.current().getLazyPersistentMgr().commit();
    }

    public void commitMgrAndRuntimeTx(WfProcess process, FlowContext runtime) throws WfException {
        Class<?> cls = ((Object)((Object)this)).getClass();
        Class[] ptypes = new Class[]{WfProcess.class, FlowContext.class};
        Object[] params = new Object[]{process, runtime};
        try {
            Method m = ObjectFactory.getMethod(cls, (String)"commitMgrAndRuntime", (Class[])ptypes);
            ObjectFactory.invokeRequired((Object)((Object)this), (Method)m, (Object[])params);
        }
        catch (Exception e) {
            throw new WfException("commitMgrAndRuntime failed", (Throwable)e);
        }
    }

    private boolean findActInst4Rollback(WfEngine engine, WfActivity rollbackActInst, List targets) throws WfException {
        if (!rollbackActInst.state().equals("closed.completed")) {
            return false;
        }
        String[] toActInstList = rollbackActInst.getMeta().getToActInstList();
        WfProcess process = (WfProcess)rollbackActInst.getProcess();
        ProcessContext procContext = process.getProcessContext();
        ArrayList<String> sets = new ArrayList<String>();
        while (true) {
            for (int i = 0; i < toActInstList.length; ++i) {
                ManpowerActivityDef activitydef;
                String id = toActInstList[i];
                targets.add(id);
                WfActivity toActInst = null;
                try {
                    toActInst = engine.getActivityInst(id);
                }
                catch (WfException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (toActInst == null) {
                    return false;
                }
                if (toActInst.getDefinition() instanceof ManpowerActivityDef ? !(activitydef = (ManpowerActivityDef)toActInst.getDefinition()).isRollback() : !toActInst.getDefinition().getActivityHeader().isRollback()) {
                    return false;
                }
                if (toActInst.getDefinition() instanceof ManpowerActivityDef) {
                    if (toActInst.state().equals("open.not_running.not_started")) continue;
                    String toActInstID = toActInst.getId();
                    String key = "OmitWhenHasNoAssigns" + toActInstID;
                    Object isSupportRollBack = procContext.getDataFieldValue(key);
                    if (isSupportRollBack != null && "true".equals(isSupportRollBack)) {
                        String[] postIds = toActInst.getMeta().getPostActInstList();
                        if (postIds == null) continue;
                        for (int k = 0; k < postIds.length; ++k) {
                            sets.add(postIds[k]);
                        }
                        continue;
                    }
                    return false;
                }
                String[] postIds = toActInst.getMeta().getPostActInstList();
                if (postIds == null) continue;
                for (int k = 0; k < postIds.length; ++k) {
                    sets.add(postIds[k]);
                }
            }
            if (sets.isEmpty()) break;
            toActInstList = sets.toArray(new String[sets.size()]);
            sets.clear();
        }
        return true;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Deprecated
    public boolean canRollbackActInst(String actInstId) throws WfException {
        WfEngine wfEngine;
        WfActivity actInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:canRollbackActInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if ((actInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getActivityInst(actInstId)).container().isClosed()) {
            return false;
        }
        if (actInst.getMeta().getParentActInstId() != null) {
            return false;
        }
        ArrayList targets = new ArrayList();
        return this.findActInst4Rollback(wfEngine, actInst, targets);
    }

    public NotRollbackCause canRollbackActInstNew(String actInstId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:canRollbackActInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        try {
            WfActivity actInst;
            WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
            String assignmentId = null;
            if (actInstId.endsWith("WFWKITEM")) {
                assignmentId = actInstId;
                WfAssignment assign = wfEngine.getAssignment(actInstId);
                actInstId = assign.getActInst().getId();
            }
            if ((actInst = wfEngine.getActivityInst(actInstId)).container().isClosed()) {
                return new NotRollbackCause("processClosed");
            }
            if ("open.not_running.suspended".equals(actInst.container().state())) {
                return new NotRollbackCause("processSuspend");
            }
            if (this.isAppendAct(actInst)) {
                return new NotRollbackCause("actInstIsAppend", actInst.getName());
            }
            if (this.isDynCountersign(actInst)) {
                return new NotRollbackCause("dynCountersign", actInst.getName());
            }
            if (!actInst.state().equals("closed.completed")) {
                if (actInst.state().equals("open.not_running.not_started") && actInst.enableCountersign() && !StringUtils.isEmpty((String)assignmentId)) {
                    WfAssignment assign = wfEngine.getAssignment(assignmentId);
                    if (WfAssignmentState.COMPLETED != assign.state()) {
                        return new NotRollbackCause("countersignNoRepeat");
                    }
                    if (this.hasRollBack(assignmentId)) {
                        return new NotRollbackCause("countersignNoRepeat");
                    }
                    return new NotRollbackCause("yes");
                }
                return new NotRollbackCause("actInstIsNotCompleted", actInst.getName());
            }
            return this.findActInst4RollbackNew(wfEngine, actInst);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new NotRollbackCause("processDataError");
        }
    }

    private boolean hasRollBack(String assignmentId) throws Exception {
        int count;
        boolean hasRollBack = false;
        String sql = "SELECT count(*) as count FROM T_bas_option where FTYPE = 10 and FASSIGNMENTID =?";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])new Object[]{assignmentId});
        if (rowSet.next() && (count = rowSet.getInt("count")) > 0) {
            hasRollBack = true;
        }
        return hasRollBack;
    }

    private boolean isDynCountersign(WfActivity actInst) throws Exception {
        String sql = "SELECT count(*) as count FROM t_bas_option where FTYPE=11 and FCURRENTACINSTID=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])new Object[]{actInst.getId()});
        return rowSet.next() && rowSet.getInt("count") > 0;
    }

    private boolean isAppendAct(WfActivity actInst) throws Exception {
        ActivityInstInfo actInstInfo = actInst.getMeta();
        if (actInstInfo.getParentActInstId() != null) {
            return true;
        }
        String sql = "SELECT count(*) as count FROM T_wfr_actinst where FPROCINSTID =? and FPARENTACTINSTID=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])new Object[]{actInstInfo.getProcInstId(), actInstInfo.getActInstId()});
        return rowSet.next() && rowSet.getInt("count") > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NotRollbackCause findActInst4RollbackNew(WfEngine engine, WfActivity rollbackActInst) throws WfException {
        String[] toActInstList = rollbackActInst.getMeta().getToActInstList();
        if (toActInstList == null) {
            return new NotRollbackCause("processDataError", rollbackActInst.getName());
        }
        WfProcess process = (WfProcess)rollbackActInst.getProcess();
        ProcessContext procContext = process.getProcessContext();
        ArrayList<String> sets = new ArrayList<String>();
        while (true) {
            for (int i = 0; i < toActInstList.length; ++i) {
                String[] postIds;
                String id = toActInstList[i];
                WfActivity toActInst = null;
                try {
                    toActInst = engine.getActivityInst(id);
                }
                catch (WfException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (toActInst == null) {
                    return new NotRollbackCause("targetActInstIsNull");
                }
                NotRollbackCause notAllowed = new NotRollbackCause("actDefIsNotAllowed", toActInst.getName());
                ActivityDef actDef = toActInst.getDefinition();
                if (actDef instanceof ManpowerActivityDef) {
                    ManpowerActivityDef activitydef = (ManpowerActivityDef)actDef;
                    if (!activitydef.isRollback()) {
                        return notAllowed;
                    }
                    if (!toActInst.state().equals("open.not_running.not_started")) {
                        String toActInstID = toActInst.getId();
                        String key = "OmitWhenHasNoAssigns" + toActInstID;
                        Object isSupportRollBack = procContext.getDataFieldValue(key);
                        if (isSupportRollBack == null || !"true".equals(isSupportRollBack)) return new NotRollbackCause("manpowerIsNotStarted", toActInst.getName());
                        String[] postIds2 = toActInst.getMeta().getPostActInstList();
                        if (postIds2 != null) {
                            for (int k = 0; k < postIds2.length; ++k) {
                                sets.add(postIds2[k]);
                            }
                        }
                    }
                } else {
                    if (actDef instanceof SubflowActivityDef) {
                        return new NotRollbackCause("notAllowCancelParent", actDef.getName());
                    }
                    if (!toActInst.getDefinition().getActivityHeader().isRollback()) {
                        return notAllowed;
                    }
                }
                if (actDef instanceof ManpowerActivityDef || (postIds = toActInst.getMeta().getPostActInstList()) == null) continue;
                for (int k = 0; k < postIds.length; ++k) {
                    sets.add(postIds[k]);
                }
            }
            if (sets.isEmpty()) return new NotRollbackCause("yes");
            toActInstList = sets.toArray(new String[sets.size()]);
            sets.clear();
        }
    }

    public ActivityInstInfo getActivityInstByActInstId(String actInstId) throws WfException {
        this.appendLog(actInstId);
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getActivityInst(actInstId).getMeta();
    }

    private void appendLog(String actInstId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ActivityControlService Method:getActivityInstByActInstId been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: actInstId=\"");
                buffer.append(actInstId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
    }

    public List<ActivityInstInfo> getActivityInstByActInstIds(String[] actInstIds) throws WfException {
        ArrayList<ActivityInstInfo> list = new ArrayList<ActivityInstInfo>();
        for (int i = 0; i < actInstIds.length; ++i) {
            String actInstId = actInstIds[i];
            this.appendLog(actInstId);
            WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
            ActivityInstInfo info = wfEngine.getActivityInst(actInstId).getMeta();
            list.add(info);
        }
        return list;
    }

    public void completeActivity(String activityInstId, Map invokeContext) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfActivity actInst = wfEngine.getActivityInst(activityInstId);
        ProcessContext processContext = this.completeEnqueue(actInst);
        processContext.putDataFieldValues(invokeContext);
        processContext.storeToDb();
    }

    private ProcessContext completeEnqueue(WfActivity actInst) throws WfException, CannotCompleteException, AlreadyInProcessQueueException {
        ProcessContext processContext = actInst.container().getProcessContext();
        if (!processContext.isPvmMode()) {
            actInst.complete("");
        } else {
            String procInstId = actInst.getProcInstId();
            Context ctx = this.getContext();
            FlowSignaler.enqueue(ctx, procInstId, actInst.getId());
        }
        return processContext;
    }

    public String getDiagramJson(String procInstId, String actDefId) throws Exception {
        WfEngine engine = WfEngine.getEngine(this.getContext());
        Map performers = this.getPerformers(procInstId, engine);
        Activity[] acts = this.getActivityInsts(procInstId, actDefId, engine, performers);
        Diagram diagram = new Diagram(acts);
        return diagram.toJson();
    }

    private ActivityInfo[] getActivityInsts(String procInstId, String actDefId, WfEngine engine, Map performers) throws WfException {
        ActivityInstInfo[] activities = engine.getActInstMetaByDefId(actDefId, procInstId, true);
        ActivityInfo[] acts = new ActivityInfo[activities.length];
        for (int i = 0; i < acts.length; ++i) {
            acts[i] = new ActivityInfo(activities[i]);
            String actDefName = activities[i].getActDefName(this.getContext().getLocale());
            StringBuffer names = (StringBuffer)performers.get(acts[i].getId());
            if (names != null) {
                actDefName = actDefName + "{" + names.toString() + "}";
            }
            acts[i].setUserNames(actDefName);
        }
        return acts;
    }

    private Map getPerformers(String procInstId, WfEngine engine) throws WfException {
        AssignmentInfo[] assignments = engine.getAssignmentAllByProcInstId(procInstId);
        Locale l2 = new Locale("l2");
        HashMap<String, StringBuffer> performers = new HashMap<String, StringBuffer>();
        for (int i = 0; i < assignments.length; ++i) {
            String actInstId = assignments[i].getActInstId();
            String name = assignments[i].getUserName(l2);
            StringBuffer userNames = (StringBuffer)performers.get(actInstId);
            if (userNames == null) {
                userNames = new StringBuffer();
                performers.put(actInstId, userNames);
            } else {
                if (userNames.indexOf(name) >= 0) continue;
                userNames.append(",");
            }
            userNames.append(name);
        }
        return performers;
    }
}

