/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.app.DefaultApplicationManager;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ServiceUtils {
    public static String getDecisionItems(Map assignmentInfoMap, WfEngine engine) throws WfException {
        return ServiceUtils.getDecisionItems(assignmentInfoMap, engine, null);
    }

    public static String getDecisionItems(Map assignmentInfoMap, WfEngine engine, Locale l) throws WfException {
        if (assignmentInfoMap == null || engine == null) {
            return "";
        }
        Iterator iterator = assignmentInfoMap.entrySet().iterator();
        String decisionItems = "";
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String assignmentID = (String)entry.getValue();
            String actInstId = engine.getAssignment(assignmentID).getActInstId();
            ActivityInstInfo actInstInfo = engine.getActInstMetaById(actInstId);
            ProcessDef processDef = engine.getProcessDef(actInstInfo.getProcDefHashValue());
            Locale defaultLocale = l != null ? l : engine.getLocale();
            ActivityDef actDef = processDef.getActivityDef(actInstInfo.getActDefId());
            if (actDef instanceof ApproveActivityDef) {
                decisionItems = ServiceUtils.getCustomDecisiones(actDef, "manualDecisionItems", defaultLocale);
            }
        }
        return decisionItems;
    }

    private static String getCustomDecisiones(ActivityDef actDef, String propertyKey, Locale defaultLocale) {
        ExtendedAttributeDef att;
        String propertyValue = "";
        ApproveActivityDef approveDef = (ApproveActivityDef)actDef;
        propertyValue = approveDef.getManualDecisionItems(defaultLocale);
        if (StringUtils.isEmpty((String)propertyValue)) {
            propertyValue = approveDef.getManualDecisionItems();
        }
        if (StringUtils.isEmpty((String)propertyValue) && (att = actDef.getActivityHeader().getExtendedAttributes().get(propertyKey)) != null) {
            propertyValue = att.getValue();
        }
        return propertyValue;
    }

    public static String getDefaultOpinion(Map assignmentInfoListMap, WfEngine engine) throws WfException {
        return ServiceUtils.getDefaultOpinion(assignmentInfoListMap, engine, null);
    }

    public static String getDefaultOpinion(Map assignmentInfoListMap, WfEngine engine, Locale l) throws WfException {
        String opinion = "";
        if (assignmentInfoListMap == null || engine == null) {
            return opinion;
        }
        if (assignmentInfoListMap.size() == 1) {
            String assignmentId = (String)assignmentInfoListMap.values().iterator().next();
            Map argument = DefaultApplicationManager.getAssignmentArguments(engine, assignmentId, true);
            opinion = (String)argument.get("defualtOpinion");
        }
        return opinion;
    }
}

