/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.service.IWFLogProcessor;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class WFLogProcessor
implements IWFLogProcessor {
    public static final String OPERATEOBJECT = "operateObject";
    public static final String OPERATE = "operate";
    public static final String FUNCTION = "function";
    protected Map<String, String> resultMap = new HashMap<String, String>();
    public Context ctx;
    protected WorkflowLogItem workflowLogItem;

    private WFLogProcessor() {
    }

    public WFLogProcessor(Context ctx, WorkflowLogItem workflowLogItem) {
        this.ctx = ctx;
        this.workflowLogItem = workflowLogItem;
        this.init();
    }

    public WFLogProcessor(Context ctx, WorkflowLogItem workflowLogItem, String OPERATEOBJECT) {
        this(ctx, workflowLogItem);
        this.resultMap.put(OPERATEOBJECT, OPERATEOBJECT);
    }

    private void init() {
        String function = this.workflowLogItem.getAlias() + this.workflowLogItem.getValue();
        this.resultMap.put(FUNCTION, function);
        StringBuffer operate = new StringBuffer();
        operate.append(this.workflowLogItem.getAlias()).append(this.workflowLogItem.getValue());
        this.resultMap.put(OPERATE, operate.toString());
        this.resultMap.put(OPERATEOBJECT, "");
    }

    public String getEASInstance() {
        String path = System.getProperty("EAS_INSTANCE_HOME");
        String easInstance = "";
        if (!StringUtils.isEmpty((String)path)) {
            easInstance = "(" + path.substring(path.lastIndexOf("/") + 1) + ")";
        }
        return easInstance;
    }

    public String getFunction() {
        return this.resultMap.get(FUNCTION);
    }

    public String getOperate() {
        return this.resultMap.get(OPERATE);
    }

    public String getOperateObject() {
        return this.resultMap.get(OPERATEOBJECT);
    }

    public boolean process() throws Exception {
        return true;
    }

    public void setFunction(String function) {
        this.resultMap.put(FUNCTION, function);
    }

    public void setOperate(String operate, boolean isAppendInstance) {
        if (isAppendInstance) {
            operate = operate + this.getEASInstance();
        }
        this.resultMap.put(OPERATE, operate);
    }

    public void setOperate(String operate) {
        this.setOperate(operate, true);
    }

    public void setOperateObject(String operateObject) {
        this.resultMap.put(OPERATEOBJECT, operateObject);
    }
}

