/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.EASWfServiceData;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.enhanced.EMessage;
import com.kingdee.bos.workflow.define.enhanced.IEMessageActivity;
import com.kingdee.bos.workflow.define.enhanced.IMessageActivity;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.enactment.WfDefinitionMgr;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.security.IPermissionProvider;
import com.kingdee.bos.workflow.service.ActivityControlService;
import com.kingdee.bos.workflow.service.AssignmentMonitorService;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IActivityControlService;
import com.kingdee.bos.workflow.service.IAssignmentMonitorService;
import com.kingdee.bos.workflow.service.IProcessMonitorService;
import com.kingdee.bos.workflow.service.IWfApplictionService;
import com.kingdee.bos.workflow.service.IWfDefineService;
import com.kingdee.bos.workflow.service.ProcessMonitorService;
import com.kingdee.bos.workflow.service.WfDefineService;
import com.kingdee.bos.workflow.util.PermissionUtil;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.util.SortedStringObjectMap;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfApplictionService
extends AbstractBOSObject
implements IWfApplictionService {
    private static Logger log = Logger.getLogger((String)WfApplictionService.class.getName());
    private static final String MULTIAPPROVE_MANUALDECISION_ITEMS = "manualDecisionItems";
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFAPPS");

    public WfApplictionService(Context ctx) {
        super(ctx);
        this.registerInterface(IWfApplictionService.class, (Object)this);
    }

    public static IWfApplictionService getService(Context ctx) {
        return new WfApplictionService(ctx);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public ActivityDef getActDefByActInstInfo(ActivityInstInfo actInstInfo) throws WfKpdlParseException, WfException {
        ProcessInstInfo procInstInfo;
        ActivityDef actDef = null;
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        WfDefinitionMgr defMgr = wfEngine.getDefinitionMgr();
        ProcessDef procDef = defMgr.getProcessDefByHash((procInstInfo = wfEngine.getProcessInstMeta(actInstInfo.getProcInstId())).getProcDefHashValue());
        if (procDef != null) {
            actDef = procDef.getActivityDef(actInstInfo.getActDefId());
        }
        return actDef;
    }

    public boolean checkPermission(String userId, String packageName, String functionName, String operationName) throws WfException {
        IPermissionProvider easPermissionProvider = WfEngine.getEngine(this.getContext()).getPermissionProvider();
        boolean result = false;
        Context ctx = this.getContext();
        try {
            PermissionItemCollection permItems = PermissionUtil.getPermissionItemCollection(ctx, packageName, functionName, operationName);
            result = easPermissionProvider.checkPermission(ctx, userId, 0, null, permItems);
        }
        catch (BOSException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public EASWfServiceData getEASWfServiceData(String[] assignmentIds, boolean isPerm) throws WfException {
        String key;
        WfEngine engine;
        FlowContext runtime;
        String targetActDefId;
        EASWfServiceData data = new EASWfServiceData();
        if (assignmentIds == null || assignmentIds.length == 0) {
            return data;
        }
        IActivityControlService activityCtrlService = ActivityControlService.getService(this.getContext());
        IAssignmentMonitorService assignMonSerivce = AssignmentMonitorService.getService(this.getContext());
        AssignmentInfo assInfo = null;
        if (assignmentIds.length > 1) {
            AssignmentInfo[] assignmentInfos = assignMonSerivce.getAssignmentById(assignmentIds, DataTypeEnum.getEnum((int)0));
            if (assignmentInfos.length > 0) {
                assInfo = assignmentInfos[0];
                data.setAssignmentInfos(assignmentInfos);
            }
        } else {
            assInfo = assignMonSerivce.getAssignmentById(assignmentIds[0]);
        }
        if (assInfo == null) {
            return data;
        }
        String actInstId = assInfo.getActInstId();
        ActivityInstInfo actInstInfo = activityCtrlService.getActivityInstByActInstId(actInstId);
        if (actInstInfo == null) {
            return data;
        }
        ActivityDef actDef = this.getActDefByActInstInfo(actInstInfo);
        if (actDef == null) {
            return data;
        }
        Map args = assignMonSerivce.getAssignmentArgument(assInfo.getAssignmentId(), true);
        data.setAssignmentInfo(assInfo);
        Map extAttr = this.getExtendedAttributeFromActDef(actDef);
        if (actInstInfo.getParentActInstId() != null) {
            String procInstId = assInfo.getProcInstId();
            Map dynamicProperties = this.getDynamicExendedProperties(actInstId, procInstId);
            extAttr.putAll(dynamicProperties);
        }
        if (!StringUtils.isEmpty((String)(targetActDefId = (String)(runtime = (engine = WfEngine.getEngine(this.getContext())).getProcessInst(actInstInfo.getProcInstId()).getProcessContext().getFlowContext()).getProperty(key = actDef.getID() + "#RETURN_TARGET")))) {
            extAttr.put("appendActivity", "false");
        }
        data.setExtendedAttribute(extAttr);
        this.setNotifyNextPerformer(assInfo, data);
        data.setActInstInfo(actInstInfo);
        data.setAssignmentArgs(args);
        if (isPerm) {
            String userID = assInfo.getUserId();
            String bizPackgeName = assInfo.getBizPackage();
            String bizFunName = assInfo.getBizFunction();
            String bizOperation = assInfo.getBizOperation();
            boolean permission = this.checkPermission(userID, bizPackgeName, bizFunName, bizOperation);
            data.setPermission(permission);
        }
        return data;
    }

    public Map getDynamicExendedProperties(String actInstId, String procInstId) throws WfException {
        WfEngine engine = WfEngine.getEngine(this.getContext());
        FlowContext runtime = engine.getProcessInst(procInstId).getProcessContext().getFlowContext();
        Execution e = runtime.getExecution(actInstId);
        Map dynamicProperties = e.getProperties();
        return dynamicProperties;
    }

    private void setNotifyNextPerformer(AssignmentInfo assInfo, EASWfServiceData data) throws WfException {
        ActivityDef targetAct;
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(assInfo.getProcInstId());
        Object target = procInst.getProcessContext().getDataFieldValue(assInfo.getAssignmentId());
        if (target != null && (targetAct = procInst.getDefinition().getActivityDef(target.toString())) != null && targetAct instanceof ManpowerActivityDef) {
            ManpowerActivityDef manpowerDef = (ManpowerActivityDef)targetAct;
            boolean isSendMail = manpowerDef.getMessage().isSendMail();
            boolean isSendSMS = manpowerDef.getEMessage() != null ? manpowerDef.getEMessage().isEnable() : false;
            data.getExtendedAttribute().put("isSendMail", String.valueOf(isSendMail));
            data.getExtendedAttribute().put("isSendSMS", String.valueOf(isSendSMS));
        }
    }

    public Map getSendProperty(String actInstId, boolean isMultiMessage) throws BOSException {
        HashMap<String, Boolean> propertyMap = new HashMap<String, Boolean>();
        boolean isSendMail = this._getSendProperty(actInstId, "isSendMail", isMultiMessage);
        boolean isSendMobile = this._getSendProperty(actInstId, "isSendMobileMsg", isMultiMessage);
        propertyMap.put("isSendMail", isSendMail);
        propertyMap.put("isSendMobileMsg", isSendMobile);
        return propertyMap;
    }

    private boolean _getSendProperty(String actInstId, String type, boolean isMultiMessage) throws BOSException {
        IActivityControlService activityCtrlService = ActivityControlService.getService(this.getContext());
        IProcessMonitorService proMonSerivce = ProcessMonitorService.getService(this.getContext());
        ActivityInstInfo actInstInfo = activityCtrlService.getActivityInstByActInstId(actInstId);
        ProcessInstInfo procInstInfo = proMonSerivce.getProcessInstInfo(actInstInfo.getProcInstId());
        if (isMultiMessage) {
            if (this.innerMutilApproveProperty(procInstInfo.getProcDefHashValue(), type)) {
                return true;
            }
        } else {
            boolean isSendMobileMsg;
            boolean isSendMail = "isSendMail".equals(type) && procInstInfo.isSendMail();
            boolean bl = isSendMobileMsg = "isSendMobileMsg".equals(type) && procInstInfo.isSendMobileMsg();
            if (isSendMail || isSendMobileMsg) {
                return true;
            }
        }
        if (procInstInfo.getParentActInstId() != null) {
            return this._getSendProperty(procInstInfo.getParentActInstId(), type, isMultiMessage);
        }
        return false;
    }

    private boolean innerMutilApproveProperty(String procDefHashValue, String type) throws BOSException {
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        ProcessDef procDef = wfEngine.getProcessDef(procDefHashValue);
        if (procDef instanceof IMessageActivity) {
            if ("isSendMail".equals(type)) {
                AssignmentMessage msg = ((IMessageActivity)procDef).getMessage();
                return msg != null && msg.isSendMail();
            }
            if ("isSendMobileMsg".equals(type)) {
                EMessage emsg = ((IEMessageActivity)procDef).getEMessage();
                return emsg != null && emsg.isEnable();
            }
        }
        return false;
    }

    public Map getExtendedAttributeFromActDef(ActivityDef actDef) throws WfException {
        SortedStringObjectMap extendedAttrMap = new SortedStringObjectMap();
        ExtendedAttributeCollection attrCol = actDef.getActivityHeader().getExtendedAttributes();
        for (ExtendedAttributeDef attrDef : attrCol) {
            extendedAttrMap.put(attrDef.getName(), attrDef.getValue());
        }
        if (actDef instanceof ManpowerActivityDef) {
            ExtendedAttributeDef def;
            extendedAttrMap.put("isAllowForward", String.valueOf(((ManpowerActivityDef)actDef).getAllowAssignNextPerformer()));
            ApplicationDef applicationDef = ((ManpowerActivityDef)actDef).getRelatedApplication();
            ExtendedAttributeCollection collection = applicationDef.getExtendedAttributes();
            if (collection != null && collection.get("UIConfSolutionID") != null && !StringUtils.isEmpty((String)(def = collection.get("UIConfSolutionID")).getValue())) {
                extendedAttrMap.put("UIConfSolutionID", def.getValue());
            }
        }
        if (actDef instanceof ManualDecisionActivityDef) {
            extendedAttrMap.put("isManualDecisionNode", "true");
        }
        if (actDef instanceof ManpowerActivityDef) {
            Map postActivities = this.getDirectPostManpowerActivities(actDef);
            for (Object o : postActivities.values()) {
                boolean sendSMS;
                if (!(o instanceof ManpowerActivityDef)) continue;
                AssignmentMessage msg = ((IMessageActivity)o).getMessage();
                boolean sendMail = msg != null && msg.isSendMail();
                EMessage emsg = ((IEMessageActivity)o).getEMessage();
                boolean bl = sendSMS = emsg != null && emsg.isEnable();
                if (sendMail) {
                    extendedAttrMap.put("isSendMail", String.valueOf(sendMail));
                }
                if (!sendSMS) continue;
                extendedAttrMap.put("isSendSMS", String.valueOf(sendSMS));
            }
        }
        if (actDef instanceof ApproveActivityDef) {
            ApproveActivityDef approveDef = (ApproveActivityDef)actDef;
            extendedAttrMap.put("manualDecisionItems_l1", approveDef.getManualDecisionItems(new Locale("l1")));
            extendedAttrMap.put("manualDecisionItems_l2", approveDef.getManualDecisionItems(new Locale("l2")));
            extendedAttrMap.put("manualDecisionItems_l3", approveDef.getManualDecisionItems(new Locale("l3")));
        }
        return extendedAttrMap;
    }

    public Map getDirectPostManpowerActivities(ActivityDef actDef) throws WfException {
        HashMap activities = new HashMap();
        HashSet visited = new HashSet();
        ActivityCollection coll = actDef.getPostActivities();
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                this.findPostManpowerActivities(coll.get(i), activities, visited);
            }
        }
        return activities;
    }

    private boolean findPostManpowerActivities(ActivityDef actDef, Map activities, HashSet visited) throws WfException {
        String id = actDef.getID();
        if (visited.contains(id)) {
            return false;
        }
        visited.add(id);
        if (actDef instanceof ManpowerActivityDef) {
            String key = actDef.getContainer().getID() + "@" + actDef.getID();
            activities.put(key, actDef);
            return true;
        }
        if (actDef instanceof SubflowActivityDef && this.findPostManpowerActivitiesInSubFlow((SubflowActivityDef)actDef, activities, visited)) {
            return true;
        }
        ActivityCollection coll = actDef.getPostActivities();
        if (coll == null) {
            return false;
        }
        boolean b = false;
        for (int i = 0; i < coll.size(); ++i) {
            ActivityDef act = coll.get(i);
            if (!this.findPostManpowerActivities(act, activities, visited)) continue;
            b = true;
        }
        return b;
    }

    private boolean findPostManpowerActivitiesInSubFlow(SubflowActivityDef subFlowactDef, Map activities, HashSet visited) throws WfException {
        String subProcessDefID = subFlowactDef.getSubflowId();
        IWfDefineService wfDefineService = WfDefineService.getService(this.getContext());
        ProcessDefInfo subProcessDefInfo = wfDefineService.getProcessDefInfo(subProcessDefID);
        ProcessDef subProcessDef = wfDefineService.getProcessDefByDefineHashValue(subProcessDefInfo.getMd5HashValue());
        ActivityCollection startupActivities = subProcessDef.getStartupActivities();
        boolean b = false;
        for (int i = 0; i < startupActivities.size(); ++i) {
            if (!this.findPostManpowerActivities(startupActivities.get(i), activities, visited)) continue;
            b = true;
        }
        return b;
    }
}

