/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.function.FunctionInvoke;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.biz.BizProcInfo;
import com.kingdee.bos.workflow.biz.EventUtils;
import com.kingdee.bos.workflow.biz.IBizProcFinder;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.biz.trans.ActivityDefPartialInfo;
import com.kingdee.bos.workflow.biz.trans.AssignatePersonsInfo;
import com.kingdee.bos.workflow.biz.trans.BillActivityPersonsData;
import com.kingdee.bos.workflow.biz.trans.BillApproveResultInfo;
import com.kingdee.bos.workflow.biz.trans.DesignatePerformerData;
import com.kingdee.bos.workflow.biz.trans.WfSendingMsgBundle;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.enactment.ParticipantHelper;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfDefinitionMgr;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfExecutionObject;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.participant.ActivityPersonsInfo;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.ParticipantBlock;
import com.kingdee.bos.workflow.participant.ParticipantCase;
import com.kingdee.bos.workflow.participant.ParticipantUnit;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.PerformerType;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ActiviyMonitorService;
import com.kingdee.bos.workflow.service.CheckShareAssign;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IWfBizService;
import com.kingdee.bos.workflow.service.IWfDefineService;
import com.kingdee.bos.workflow.service.ProcessMonitorService;
import com.kingdee.bos.workflow.service.ServiceUtils;
import com.kingdee.bos.workflow.service.WfDefineService;
import com.kingdee.bos.workflow.util.EnactmentUtils;
import com.kingdee.bos.workflow.util.ProcessParamUtils;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WfBizService
extends AbstractBOSObject
implements IWfBizService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WBZS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.WfBizService");

    public static IWfBizService getService(Context ctx) {
        return new WfBizService(ctx);
    }

    public WfBizService() {
        this.registerInterface(IWfBizService.class, (Object)this);
    }

    public WfBizService(Context ctx) {
        super(ctx);
        this.registerInterface(IWfBizService.class, (Object)this);
    }

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public AssignmentInfo checkAssignmentInfo(String businessObjId, String userId, String packageName, String functionName, String operation) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:checkAssignmentInfo been called.");
                String desc = buffer.toString();
                buffer.append("parameter: businessObjId=\"");
                buffer.append(businessObjId);
                buffer.append('\"');
                buffer.append(" userId=\"");
                buffer.append(userId);
                buffer.append('\"');
                buffer.append(" packageName=\"");
                buffer.append(packageName);
                buffer.append('\"');
                buffer.append(" functionName=\"");
                buffer.append(functionName);
                buffer.append('\"');
                buffer.append(" operation=\"");
                buffer.append(operation);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.checkAssignmentInfo(businessObjId, userId, packageName, functionName, operation, null);
    }

    public AssignmentInfo checkAssignmentInfo(String businessObjId, String userId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:checkAssignmentInfo been called.");
                String desc = buffer.toString();
                buffer.append("parameter: businessObjId=\"");
                buffer.append(businessObjId);
                buffer.append('\"');
                buffer.append(" userId=\"");
                buffer.append(userId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.checkAssignmentInfo(businessObjId, userId);
    }

    public AssignmentInfo[] checkAssignmentInfo(String businessObjId, String userId, IMetaDataPK uiObjPK, String action) throws WfException {
        ProcessInstInfo[] procInstInfos;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:checkAssignmentInfo been called.");
                String desc = buffer.toString();
                buffer.append("parameter: businessObjId=\"");
                buffer.append(businessObjId);
                buffer.append('\"');
                buffer.append(" userId=\"");
                buffer.append(userId);
                buffer.append('\"');
                buffer.append(" uiObjPK=\"");
                buffer.append(uiObjPK);
                buffer.append('\"');
                buffer.append(" action=\"");
                buffer.append(action);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        Map operations = null;
        try {
            operations = this.getRemoteOperation(uiObjPK, action);
        }
        catch (BOSException ex) {
            log.warn((Object)"cannot found operation infomation about the UI Object", (Throwable)ex);
            return new AssignmentInfo[0];
        }
        String packageName = "";
        String functionName = "";
        String operation = "";
        if (operations == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"cannot find any operation info about this UI Object!");
            }
            return new AssignmentInfo[0];
        }
        if (operations.size() > 0 && log.isDebugEnabled()) {
            log.debug((Object)("warning: found more than 1 operation. UIPK:" + uiObjPK + "user:" + userId));
        }
        Iterator entrys = operations.entrySet().iterator();
        int count = 0;
        ArrayList<AssignmentInfo> assignList = new ArrayList<AssignmentInfo>();
        while (entrys.hasNext()) {
            AssignmentInfo assignment;
            Map.Entry entry = entrys.next();
            String key = (String)entry.getKey();
            OperationInfo operationInfo = (OperationInfo)entry.getValue();
            if (key.indexOf("-") != -1) {
                key = key.substring(0, key.lastIndexOf("-"));
            }
            if ((assignment = this.checkAssignmentInfo(businessObjId, userId, packageName = MetaDataUtils.getPackageName((String)key), functionName = MetaDataUtils.getClassName((String)key), operation = operationInfo.getName())) == null) continue;
            assignList.add(assignment);
            ++count;
        }
        if (assignList.size() == 0 && businessObjId != null && businessObjId.length() > 0 && (procInstInfos = new ProcessMonitorService(this.getContext()).getProcessInstanceByHoldedObjectId(businessObjId)) != null) {
            int n = procInstInfos.length;
            for (int i = 0; i < n; ++i) {
                if (!procInstInfos[i].getState().startsWith(WfState.OPEN.getValue())) continue;
                throw new MatchAssignmentException("Object has assignment.but current operation not match./n uipk:" + uiObjPK + " action:" + action);
            }
        }
        if (count == 0) {
            return new AssignmentInfo[0];
        }
        AssignmentInfo[] assignments = new AssignmentInfo[assignList.size()];
        assignList.toArray(assignments);
        return assignments;
    }

    public AssignmentInfo[] checkAssignmentInfos(String businessObjId, String userId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:checkAssignmentInfos been called.");
                String desc = buffer.toString();
                buffer.append("parameter: businessObjId=\"");
                buffer.append(businessObjId);
                buffer.append('\"');
                buffer.append(" userId=\"");
                buffer.append(userId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.checkAssignmentInfos(businessObjId, userId);
    }

    public AssignmentInfo[] checkAssignmentInfos(String userId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:checkAssignmentInfos been called.");
                String desc = buffer.toString();
                buffer.append("parameter: businessObjId=\"");
                buffer.append('\"');
                buffer.append(" userId=\"");
                buffer.append(userId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.checkAssignmentInfos(userId);
    }

    public SubmitAssignResult virtualSubmitAssignment(String assignmentID) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfBizService Method:virtualSubmitAssignment been called.");
            String desc = buffer.toString();
            buffer.append("parameter: assignmentID=\"");
            buffer.append(assignmentID);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.virtualSubmitAssignment(assignmentID);
    }

    public BizProcInfo[] findProcDef(String performerId, PerformerType performerType, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:findProcDef been called.");
                String desc = buffer.toString();
                buffer.append("parameter: performerId=\"");
                buffer.append(performerId);
                buffer.append('\"');
                buffer.append(" performerType=");
                buffer.append(performerType.getValue());
                buffer.append(" bizFunc=\"");
                buffer.append(bizFunc);
                buffer.append('\"');
                buffer.append(" bizPackage=\"");
                buffer.append(bizPackage);
                buffer.append('\"');
                buffer.append(" bizOperation=\"");
                buffer.append(bizOperation);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getBizProcFinder().findProcDef(performerId, performerType, bizFunc, bizPackage, bizOperation);
    }

    public void setBizProcRelation(BizProcInfo bizProcInfo) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:setBizProcRelation been called.");
                String desc = buffer.toString();
                buffer.append("parameter: bizProcInfo=");
                buffer.append(bizProcInfo);
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        wfEngine.getBizProcFinder().setBizProcRelation(bizProcInfo);
    }

    public void unregistProcessBizObj(String bizObjId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:unregistProcessBizObj been called.");
                String desc = buffer.toString();
                buffer.append("parameter: bizObjId=\"");
                buffer.append(bizObjId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        EngineUtil.getEngine(this.getContext()).unregistProcessBizObj(bizObjId);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public Map getRemoteOperation(IMetaDataPK uiPK, String actionName) throws BOSException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:getRemoteOperation been called.");
                String desc = buffer.toString();
                buffer.append("parameter: uiPK=\"");
                buffer.append(uiPK);
                buffer.append('\"');
                buffer.append(" actionName=\"");
                buffer.append(actionName);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        return FunctionInvoke.getOperation((Context)this.getContext(), (IMetaDataPK)uiPK, (String)actionName);
    }

    public Map checkAssignmentInfo(String[] boIds, IMetaDataPK uiObjPK, String action, String userId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:checkAssignmentInfo been called.");
                String desc = buffer.toString();
                buffer.append("parameter: boIds=\"");
                buffer.append(StringUtils.arrayToString((Object[])boIds, (String)","));
                buffer.append('\"');
                buffer.append(" uiObjPK=\"");
                buffer.append(uiObjPK);
                buffer.append('\"');
                buffer.append(" action=\"");
                buffer.append(action);
                buffer.append('\"');
                buffer.append(" userId=\"");
                buffer.append(userId);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        HashMap assignments = new HashMap();
        Map operations = null;
        try {
            operations = this.getRemoteOperation(uiObjPK, action);
        }
        catch (BOSException ex) {
            log.debug((Object)"cannot found operation infomation about the UI Object", (Throwable)ex);
        }
        String packageName = "";
        String functionName = "";
        String operation = "";
        OperationInfo operationInfo = null;
        if (operations == null) {
            for (int i = 0; i < boIds.length; ++i) {
                ProcessInstInfo[] procInstInfos = ProcessMonitorService.getService(this.getContext()).getProcessInstanceByHoldedObjectId(boIds[i]);
                if (procInstInfos != null) {
                    boolean isRunning = false;
                    int m = procInstInfos.length;
                    for (int j = 0; j < m; ++j) {
                        if (!procInstInfos[j].getState().startsWith(WfState.OPEN.getValue())) continue;
                        isRunning = true;
                        break;
                    }
                    if (isRunning) continue;
                }
                assignments.put(boIds[i], null);
            }
            return assignments;
        }
        if (operations.size() > 0 && log.isDebugEnabled()) {
            log.debug((Object)("warning: found more than 1 operation. UIPK:" + uiObjPK + "user:" + userId));
        }
        for (Map.Entry entry : operations.entrySet()) {
            String key = (String)entry.getKey();
            operationInfo = (OperationInfo)entry.getValue();
            if (key.indexOf("-") != -1) {
                key = key.substring(0, key.lastIndexOf("-"));
            }
            packageName = MetaDataUtils.getPackageName((String)key);
            functionName = MetaDataUtils.getClassName((String)key);
            operation = operationInfo.getName();
        }
        AssignmentInfo assignment = null;
        int n = boIds.length;
        for (int i = 0; i < n; ++i) {
            assignment = this.checkAssignmentInfo(boIds[i], userId, packageName, functionName, operation);
            if (assignment == null) {
                ProcessInstInfo[] procInstInfos = ProcessMonitorService.getService(this.getContext()).getProcessInstanceByHoldedObjectId(boIds[i]);
                if (procInstInfos != null) {
                    boolean isRunning = false;
                    int m = procInstInfos.length;
                    for (int j = 0; j < m; ++j) {
                        if (!procInstInfos[j].getState().startsWith(WfState.OPEN.getValue())) continue;
                        isRunning = true;
                        break;
                    }
                    if (isRunning) continue;
                }
                assignments.put(boIds[i], null);
            }
            List<Object> assigns = null;
            if (!this.checkAssignmentInfo(assignment, operationInfo, action)) continue;
            assigns = assignments.containsKey(boIds[i]) ? (List)assignments.get(boIds[i]) : new ArrayList<AssignmentInfo>(10);
            assigns.add(assignment);
            assignments.put(boIds[i], assigns);
        }
        return assignments;
    }

    public Map checkAssignmentInfo(Context ctx, String[] boIds, IMetaDataPK entityPk, String eventName) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:checkAssignmentInfo been called.");
                String desc = buffer.toString();
                buffer.append("parameter: ctx=");
                buffer.append(ctx);
                buffer.append(" boIds=\"");
                buffer.append(StringUtils.arrayToString((Object[])boIds, (String)","));
                buffer.append('\"');
                buffer.append(" entityPk=\"");
                buffer.append(entityPk);
                buffer.append('\"');
                buffer.append(" eventName=\"");
                buffer.append(eventName);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        HashMap<String, AssignmentInfo> assignments = new HashMap<String, AssignmentInfo>();
        EntityObjectInfo entityInfo = (EntityObjectInfo)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getBusinessObject(entityPk);
        EventInfo event = null;
        if (entityInfo != null && entityInfo.getEvents() != null && entityInfo.getEvents().getObject((Object)eventName) != null) {
            event = (EventInfo)entityInfo.getEvents().getObject((Object)eventName);
        }
        BizEventMap.EventStructEntry[] eventEntries = EventUtils.getByEvent(ctx, eventName);
        String userId = ctx.getCaller().toString();
        if (event == null || eventEntries == null || eventEntries.length == 0) {
            for (int i = 0; i < boIds.length; ++i) {
                ProcessInstInfo[] procInstInfos = ProcessMonitorService.getService(this.getContext()).getProcessInstanceByHoldedObjectId(boIds[i]);
                if (procInstInfos != null) {
                    boolean isRunning = false;
                    int m = procInstInfos.length;
                    for (int j = 0; j < m; ++j) {
                        if (!procInstInfos[j].getState().startsWith(WfState.OPEN.getValue())) continue;
                        isRunning = true;
                        break;
                    }
                    if (isRunning) continue;
                }
                assignments.put(boIds[i], null);
            }
            return assignments;
        }
        AssignmentInfo[] existAssigns = null;
        int n = boIds.length;
        for (int i = 0; i < n; ++i) {
            existAssigns = this.checkAssignmentInfos(boIds[i], userId);
            if (existAssigns == null || existAssigns.length == 0) {
                ProcessInstInfo[] procInstInfos = ProcessMonitorService.getService(this.getContext()).getProcessInstanceByHoldedObjectId(boIds[i]);
                if (procInstInfos != null) {
                    boolean isRunning = false;
                    int m = procInstInfos.length;
                    for (int j = 0; j < m; ++j) {
                        if (!procInstInfos[j].getState().startsWith(WfState.OPEN.getValue())) continue;
                        isRunning = true;
                        break;
                    }
                    if (isRunning) continue;
                }
                assignments.put(boIds[i], null);
            }
            BizEventMap.EventStructEntry entry = null;
            for (int x = 0; x < existAssigns.length; ++x) {
                for (int y = 0; y < eventEntries.length; ++y) {
                    entry = eventEntries[y];
                    if (!entry.getFunction().equalsIgnoreCase(existAssigns[x].getBizFunction()) || !entry.getOperation().equalsIgnoreCase(existAssigns[x].getBizOperation())) continue;
                    assignments.put(boIds[i], existAssigns[x]);
                }
            }
        }
        return assignments;
    }

    private boolean checkAssignmentInfo(AssignmentInfo assignment, OperationInfo operation, String action) {
        try {
            if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:checkAssignmentInfo been called.");
                String desc = buffer.toString();
                buffer.append("parameter: assignment=");
                buffer.append(assignment);
                buffer.append(" operation=\"");
                buffer.append(operation);
                buffer.append('\"');
                buffer.append(" action=\"");
                buffer.append(action);
                buffer.append('\"');
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
        }
        catch (WfException e) {
            log.warn((Object)"error", (Throwable)e);
        }
        return assignment != null && assignment.isValid() && assignment.getBizOperation() != null && operation != null && action.equals(operation.getUiActionRef().getActionRefName());
    }

    public SubmitAssignResult submitAssignment(Map boMap, String userId, String packageName, String functionName, String operation, AssignmentInfo assignment, BizProcInfo bizProcInfo) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.submitAssignment(boMap, userId, packageName, functionName, operation, assignment, bizProcInfo);
    }

    public SubmitAssignResult submitAssignment(Map businessObjects, String userId, AssignmentInfo assignment) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.submitAssignment(businessObjects, userId, assignment.getBizPackage(), assignment.getBizFunction(), assignment.getBizOperation(), assignment, null);
    }

    public SubmitAssignResult[] submitAssignment(Map assignments, String userId) throws WfException {
        return EngineUtil.getEngine(this.getContext()).submitAssignment(assignments, userId);
    }

    public String[] getUIBindingBOTypes(IMetaDataPK uiPK) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:getUIBindingBOTypes been called.");
                String desc = buffer.toString();
                buffer.append("parameter: uiPK=");
                buffer.append(uiPK);
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (WfException e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        String[] rtnValue = new String[]{};
        if (uiPK == null) {
            throw new IllegalArgumentException();
        }
        UIObjectInfo uiInfo = (UIObjectInfo)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext()).get(MetaDataTypeList.UIOBJECT, uiPK);
        UIObjectInfo fullUIInfo = UIObjectAssembler.assembleUI((Context)this.getContext(), (UIObjectInfo)uiInfo);
        DataObjectCollection dataObjectCol = fullUIInfo.getDataObjects();
        int n = dataObjectCol.size();
        for (int i = 0; i < n; ++i) {
            if (!StringUtils.equalsIgnoreCase((String)dataObjectCol.get(i).getObjectType(), (String)"enty")) continue;
            rtnValue = StringUtils.stringArrayAppend((String[])rtnValue, (String)dataObjectCol.get(i).getType());
        }
        return rtnValue;
    }

    public boolean enableNextPerson(String actInstId) throws WfException {
        ActivityDef currentActDef = this.getActivityDefByActInstId(actInstId);
        if (currentActDef instanceof ManpowerActivityDef) {
            return ((ManpowerActivityDef)currentActDef).canSpecifyNextActivityPerformer();
        }
        return false;
    }

    private ActivityDef getActivityDefByActInstId(String actInstId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:WfBizService Method:getActivityDefByActInstId been called.");
                String desc = buffer.toString();
                buffer.append("parameter: actInstId=");
                buffer.append(actInstId);
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (WfException e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfActivity actInst = wfEngine.getActivityInst(actInstId);
        ActivityDef actDef = actInst.getDefinition();
        return actDef;
    }

    public AssignmentInfo checkAssignmentInfo(String businessObjId, String userId, String packageName, String functionName, String operation, String[] selectors) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.checkAssignmentInfo(businessObjId, userId, packageName, functionName, operation, selectors);
    }

    public AssignmentInfo[] checkAssignmentInfo(String businessObjId, String userId, IMetaDataPK uiObjPK, String action, String[] selectors) throws WfException {
        ProcessInstInfo[] procInstInfos;
        Map operations = null;
        try {
            operations = this.getRemoteOperation(uiObjPK, action);
        }
        catch (BOSException ex) {
            log.warn((Object)"cannot found operation infomation about the UI Object", (Throwable)ex);
            return new AssignmentInfo[0];
        }
        String packageName = "";
        String functionName = "";
        String operation = "";
        if (operations == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"cannot find any operation info about this UI Object!");
            }
            return new AssignmentInfo[0];
        }
        if (operations.size() > 0 && log.isDebugEnabled()) {
            log.debug((Object)("warning: found more than 1 operation. UIPK:" + uiObjPK + "user:" + userId));
        }
        Iterator entrys = operations.entrySet().iterator();
        int count = 0;
        ArrayList<AssignmentInfo> assignList = new ArrayList<AssignmentInfo>();
        while (entrys.hasNext()) {
            AssignmentInfo assignment;
            Map.Entry entry = entrys.next();
            String key = (String)entry.getKey();
            OperationInfo operationInfo = (OperationInfo)entry.getValue();
            if (key.indexOf("-") != -1) {
                key = key.substring(0, key.lastIndexOf("-"));
            }
            if ((assignment = this.checkAssignmentInfo(businessObjId, userId, packageName = MetaDataUtils.getPackageName((String)key), functionName = MetaDataUtils.getClassName((String)key), operation = operationInfo.getName(), selectors)) == null) continue;
            assignList.add(assignment);
            ++count;
        }
        if (assignList.size() == 0 && businessObjId != null && businessObjId.length() > 0 && (procInstInfos = new ProcessMonitorService(this.getContext()).getProcessInstanceByHoldedObjectId(businessObjId)) != null) {
            int n = procInstInfos.length;
            for (int i = 0; i < n; ++i) {
                if (!procInstInfos[i].getState().startsWith(WfState.OPEN.getValue())) continue;
                throw new MatchAssignmentException("Object has assignment.but current operation not match./n uipk:" + uiObjPK + " action:" + action);
            }
        }
        if (count == 0) {
            return new AssignmentInfo[0];
        }
        AssignmentInfo[] assignments = new AssignmentInfo[assignList.size()];
        assignList.toArray(assignments);
        return assignments;
    }

    public AssignmentInfo[] checkAssignmentInfos(String businessObjId, String userId, String[] selectors) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.checkAssignmentInfos(businessObjId, userId, selectors);
    }

    public void putEventQueue(WfBizEvent event) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        wfEngine.putEventQueue(event);
    }

    public boolean isAssignmentInQueue(String assignId) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.isAssignmentInQueue(assignId);
    }

    public String getStartupActivityUIClass(String procDefId, String startupActDefId) throws WfException {
        OperationInfo operInfo = this.getActivityUIRef(procDefId, startupActDefId);
        UIObjectInfo uiInfo = operInfo.getUiActionRef().getUIObjectRef();
        if (uiInfo == null) {
            throw new WfException("ui is null");
        }
        String uiClass = uiInfo.getReleasePackage() + "." + uiInfo.getReleaseClass();
        return uiClass;
    }

    public String getStartupActivityBindBo(String procDefId, String startupActDefId) throws WfException {
        OperationInfo operInfo = this.getActivityUIRef(procDefId, startupActDefId);
        if (operInfo.getEntityObjectRef() == null) {
            throw new WfException("operation is bad");
        }
        EntityObjectInfo entityInfo = operInfo.getEntityObjectRef();
        return entityInfo.getPackage() + "." + entityInfo.getName();
    }

    public String getStartupActivityUIStatus(String procDefId, String startupActDefId) throws WfException {
        OperationInfo operInfo = this.getActivityUIRef(procDefId, startupActDefId);
        return operInfo.getUiActionRef().getUIStatus();
    }

    public Map getStartupActivityOperation(String procDefId) throws WfException {
        if (StringUtils.isEmpty((String)procDefId)) {
            throw new WfException("parameter is null");
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfDefinitionMgr defMgr = wfEngine.getDefinitionMgr();
        ProcessDefInfo procDefInfo = defMgr.getProcessDefInfo(procDefId);
        if (procDefInfo == null) {
            throw new WfException("can not load processDefInfo by procDefId:" + procDefId);
        }
        ProcessDef procDef = defMgr.getProcessDefByHash(procDefInfo.getMd5HashValue());
        if (procDef == null) {
            throw new WfException("can not load processDef by procDefHashValue:" + procDefInfo.getMd5HashValue());
        }
        ActivityCollection actDefCol = procDef.getStartupActivities();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        int n = actDefCol.size();
        for (int i = 0; i < n; ++i) {
            ActivityDef actDef = actDefCol.get(i);
            if (actDef instanceof WebBillManpowerActivityDef) {
                WebBillManpowerActivityDef webBillManpowerActivityDef = (WebBillManpowerActivityDef)actDef;
                String[] rtnValue = new String[]{webBillManpowerActivityDef.getUrl()};
                rtnValue[0] = rtnValue[0] == null ? "" : rtnValue[0].trim();
                if (rtnValue[0].charAt(0) != '/') {
                    rtnValue[0] = "/" + rtnValue[0];
                }
                if (rtnValue[0].startsWith("/servlet/BillServlet")) {
                    rtnValue[0] = "/easweb" + rtnValue[0];
                }
                map.put(actDef.getID(), rtnValue);
                continue;
            }
            if (actDef instanceof EventActivityDef) continue;
            if (!(actDef instanceof ManpowerActivityDef)) {
                throw new WfException("not support");
            }
            ManpowerActivityDef manpowerActDef = (ManpowerActivityDef)actDef;
            ApplicationDef appDef = manpowerActDef.getRelatedApplication();
            if (appDef == null) {
                throw new WfException("actDef error,app def is null");
            }
            FunctionDef funcDef = appDef.getFunction();
            if (funcDef == null) {
                throw new WfException("actDef error,func def is null");
            }
            String bizPack = funcDef.getPackageName();
            String bizFunc = funcDef.getName();
            String bizOpetaion = funcDef.getOperation();
            if (StringUtils.isEmpty((String)bizPack) || StringUtils.isEmpty((String)bizFunc) || StringUtils.isEmpty((String)bizOpetaion)) {
                throw new WfException("actDef error,func def error");
            }
            FunctionObjectInfo funcInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext()).getFunction((IMetaDataPK)new MetaDataPK(bizPack, bizFunc));
            if (funcInfo == null) {
                throw new WfException("can not load function:" + bizPack + "." + bizFunc);
            }
            OperationCollection operCol = funcInfo.getOperation();
            if (operCol == null) {
                log.error((Object)("Function:" + funcInfo.getPackage() + "." + funcInfo.getName() + " has no operactions"));
                throw new WfException("Function:" + funcInfo.getPackage() + "." + funcInfo.getName() + " has no operactions");
            }
            OperationInfo operInfo = null;
            int m = operCol.size();
            for (int j = 0; j < m; ++j) {
                if (!operCol.get(j).getName().equals(bizOpetaion)) continue;
                operInfo = operCol.get(j);
                break;
            }
            if (operInfo == null) {
                throw new WfException("can not load operation:" + bizPack + "." + bizFunc + "-" + bizOpetaion);
            }
            String[] rtnValue = new String[]{funcInfo.getPackage(), funcInfo.getName(), operInfo.getName()};
            map.put(actDef.getID(), rtnValue);
        }
        return map;
    }

    private OperationInfo getActivityUIRef(String procDefId, String startupActDefId) throws WfException {
        if (StringUtils.isEmpty((String)procDefId) || StringUtils.isEmpty((String)startupActDefId)) {
            throw new WfException("parameter is null");
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfDefinitionMgr defMgr = wfEngine.getDefinitionMgr();
        ProcessDefInfo procDefInfo = defMgr.getProcessDefInfo(procDefId);
        if (procDefInfo == null) {
            throw new WfException("can not load processDefInfo by procDefId:" + procDefId);
        }
        ProcessDef procDef = defMgr.getProcessDefByHash(procDefInfo.getMd5HashValue());
        if (procDef == null) {
            throw new WfException("can not load processDef by procDefHashValue:" + procDefInfo.getMd5HashValue());
        }
        ActivityDef actDef = procDef.getActivityDef(startupActDefId);
        if (actDef == null) {
            throw new WfException("can not load ActivityDef procDefHashValue:" + procDefInfo.getMd5HashValue() + ",actDefId:" + startupActDefId);
        }
        if (!(actDef instanceof ManpowerActivityDef)) {
            throw new WfException("not support");
        }
        ManpowerActivityDef manpowerActDef = (ManpowerActivityDef)actDef;
        ApplicationDef appDef = manpowerActDef.getRelatedApplication();
        if (appDef == null) {
            throw new WfException("actDef error,app def is null");
        }
        FunctionDef funcDef = appDef.getFunction();
        if (funcDef == null) {
            throw new WfException("actDef error,func def is null");
        }
        String bizPack = funcDef.getPackageName();
        String bizFunc = funcDef.getName();
        String bizOpetaion = funcDef.getOperation();
        if (StringUtils.isEmpty((String)bizPack) || StringUtils.isEmpty((String)bizFunc) || StringUtils.isEmpty((String)bizOpetaion)) {
            throw new WfException("actDef error,func def error");
        }
        FunctionObjectInfo funcInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext()).getFunction((IMetaDataPK)new MetaDataPK(bizPack, bizFunc));
        if (funcInfo == null) {
            throw new WfException("can not load function:" + bizPack + "." + bizFunc);
        }
        OperationCollection operCol = funcInfo.getOperation();
        if (operCol == null) {
            log.error((Object)("Function:" + funcInfo.getPackage() + "." + funcInfo.getName() + " has no operactions"));
            throw new WfException("Function:" + funcInfo.getPackage() + "." + funcInfo.getName() + " has no operactions");
        }
        OperationInfo operInfo = null;
        int n = operCol.size();
        for (int i = 0; i < n; ++i) {
            if (!operCol.get(i).getName().equals(bizOpetaion)) continue;
            operInfo = operCol.get(i);
            break;
        }
        if (operInfo == null) {
            throw new WfException("can not load operation:" + bizPack + "." + bizFunc + "-" + bizOpetaion);
        }
        if (operInfo.getUiActionRef() == null || operInfo.getUiActionRef().getUIObjectRef() == null) {
            throw new WfException("ui is null");
        }
        return operInfo;
    }

    public boolean canStartProcess(String userID, String procDefID) throws WfException {
        Context ctx = this.getContext();
        WfEngine wfEngine = WfEngine.getEngine(ctx);
        Person person = wfEngine.getPariticipantProvider().getPersonByUserId(ctx, userID);
        if (person == null) {
            return false;
        }
        Map map = WfBizService.getService(ctx).getStartupActivityOperation(procDefID);
        Collection collection = map.values();
        IBizProcFinder finder = wfEngine.getBizProcFinder();
        for (String[] infos : collection) {
            if (infos == null || infos.length == 1) {
                if (!wfEngine.getProcessMgr(procDefID).getData().isEnable()) continue;
                return true;
            }
            BizProcInfo[] bizProcInfos = finder.findProcDef(person, PerformerType.EMPLOYEE, infos[1], infos[0], infos[2]);
            int size = bizProcInfos.length;
            for (int i = 0; i < size; ++i) {
                if (!procDefID.equals(bizProcInfos[i].getProcDefId()) || !wfEngine.getProcessMgr(procDefID).getData().isEnable()) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getCurrentActivityParticipantPersonIDs(String procInstID, String activityDefID) throws WfException {
        ParticipantCase pCase;
        int i;
        WfProcess wfProcess;
        String procDefHashValue;
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        ProcessDef processDef = wfEngine.getProcessDef(procDefHashValue = (wfProcess = wfEngine.getProcessInst(procInstID)).getProcessMeta().getProcDefHashValue());
        ActivityDef activityDef = processDef.getActivityDef(activityDefID);
        if (activityDef == null) {
            return null;
        }
        ParticipantCollection includeCol = new ParticipantCollection();
        ParticipantCollection excludeCol = new ParticipantCollection();
        ParticipantBlock block = new ParticipantBlock(activityDef);
        ArrayList<ParticipantCase> executeCaseList = new ArrayList<ParticipantCase>();
        List caseList = block.getChildren();
        int n = caseList.size();
        for (i = 0; i < n; ++i) {
            String script;
            pCase = (ParticipantCase)caseList.get(i);
            if (pCase.isDefault() || !ScriptUtil.evalCondition(script = pCase.getCondition().getScriptDefWrapper().getScriptDef().getScriptContent(), wfProcess.getProcessContext(), processDef)) continue;
            executeCaseList.add(pCase);
        }
        if (executeCaseList.size() == 0) {
            executeCaseList.add(block.getDefaultCase());
        }
        n = executeCaseList.size();
        for (i = 0; i < n; ++i) {
            pCase = (ParticipantCase)executeCaseList.get(i);
            List unitList = pCase.getChildren();
            int m = unitList.size();
            for (int j = 0; j < m; ++j) {
                ParticipantUnit pUnit = (ParticipantUnit)unitList.get(j);
                ParticipantDef def = pUnit.getIncludeParticpant().getParticpantDefWrapper().getParticipantDef();
                includeCol.addObject(def.getID(), (Object)def);
                if (pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef() == null) continue;
                excludeCol.addObject(def.getID(), (Object)pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef());
            }
        }
        HashSet<String> personIDs = new HashSet<String>();
        if (includeCol.size() > 0) {
            List includePersons = ParticipantHelper.getPersonsByParticipants(wfProcess, includeCol);
            int size = includePersons.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Person person = (Person)includePersons.get(i2);
                personIDs.add(person.getEmployeeId());
            }
        }
        if (excludeCol.size() > 0) {
            List excludePersons = ParticipantHelper.getPersonsByParticipants(wfProcess, excludeCol);
            int size = excludePersons.size();
            for (int i3 = 0; i3 < size; ++i3) {
                Person person = (Person)excludePersons.get(i3);
                personIDs.remove(person.getEmployeeId());
            }
        }
        return personIDs.toArray(new String[personIDs.size()]);
    }

    public List getPersonsByDefParticipants(String procDefHash, String activityDefId, List participantIdList) throws WfException {
        WfEngine eninge = WfEngine.getEngine(this.getContext());
        ProcessDef procDef = eninge.getProcessDef(procDefHash);
        if (procDef == null) {
            throw new WfException("Can not find the ProcessDef in workflow engine, the process definition hash value is:" + procDefHash);
        }
        ActivityDef actDef = procDef.getActivityDef(activityDefId);
        if (!(actDef instanceof ManpowerActivityDef)) {
            throw new WfException("Activity is not a ManpowerActivity, activity definition id: " + activityDefId);
        }
        ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)actDef;
        ParticipantCollection participantCollection = new ParticipantCollection();
        Iterator iterator = participantIdList.iterator();
        ArrayList<ParticipantDef> permTypeList = new ArrayList<ParticipantDef>();
        while (iterator.hasNext()) {
            String participantId = (String)iterator.next();
            ParticipantDef participantDef = manpowerActivityDef.getParticipants().get(participantId);
            if (participantDef == null) continue;
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                permTypeList.add(participantDef);
                continue;
            }
            participantCollection.add(participantDef.getID(), participantDef);
        }
        ArrayList list = ParticipantHelper.getPersonsByParticipants(eninge, procDefHash, activityDefId, participantCollection);
        if (list == null) {
            list = new ArrayList();
        }
        int n = permTypeList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantDef def = (ParticipantDef)permTypeList.get(i);
            if (ParticipantHelper.isOrgVariable(def.getParticipantValue())) continue;
            ParticipantHelper.getPersonByOrgPermissionOwner(eninge, list, def, (ActivityDef)manpowerActivityDef, def.getParticipantValue());
        }
        return list;
    }

    public List getPersonsByDefParticipants(String procDefHash, String activityDefId, List participantIdList, String currentUserId, IObjectValue bizBillObject) throws WfException {
        WfEngine eninge = WfEngine.getEngine(this.getContext());
        List list1 = ParticipantHelper.getPersonsByParticipant(eninge, procDefHash, activityDefId, currentUserId, true);
        ProcessDef procDef = eninge.getProcessDef(procDefHash);
        if (procDef == null) {
            throw new WfException("Can not find the ProcessDef in workflow engine, the process definition hash value is:" + procDefHash);
        }
        ActivityDef actDef = procDef.getActivityDef(activityDefId);
        if (!(actDef instanceof ManpowerActivityDef)) {
            throw new WfException("Activity is not a ManpowerActivity, activity definition id: " + activityDefId);
        }
        ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)actDef;
        ParticipantCollection participantCollection = new ParticipantCollection();
        Iterator iterator = participantIdList.iterator();
        ArrayList<ParticipantDef> permTypeList = new ArrayList<ParticipantDef>();
        while (iterator.hasNext()) {
            String participantId = (String)iterator.next();
            ParticipantDef participantDef = manpowerActivityDef.getParticipants().get(participantId);
            if (participantDef == null) continue;
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                permTypeList.add(participantDef);
                continue;
            }
            participantCollection.add(participantDef.getID(), participantDef);
        }
        ArrayList list = ParticipantHelper.getPersonsByParticipants(eninge, procDefHash, activityDefId, participantCollection, currentUserId, bizBillObject);
        if (list == null) {
            list = new ArrayList();
        }
        int n = permTypeList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantDef def = (ParticipantDef)permTypeList.get(i);
            if (ParticipantHelper.isOrgVariable(def.getParticipantValue())) continue;
            ParticipantHelper.getPersonByOrgPermissionOwner(eninge, list, def, (ActivityDef)manpowerActivityDef, def.getParticipantValue());
        }
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            Person person = (Person)list.get(i);
            if (!list1.contains(person)) continue;
            list.remove(person);
        }
        return list;
    }

    public List getPersonsByParticipants(String processInstId, ActivityDef actDef, List participantIdList) throws WfException {
        WfEngine eninge = WfEngine.getEngine(this.getContext());
        WfProcess processInst = eninge.getProcessInst(processInstId);
        List list1 = ParticipantHelper.getPersonsByParticipant(processInst, actDef, processInstId);
        ParticipantCollection participantCollection = new ParticipantCollection();
        Iterator iterator = participantIdList.iterator();
        ArrayList<ParticipantDef> permTypeList = new ArrayList<ParticipantDef>();
        while (iterator.hasNext()) {
            String participantId = (String)iterator.next();
            ParticipantDef participantDef = actDef instanceof ManpowerActivityDef ? ((ManpowerActivityDef)actDef).getParticipants().get(participantId) : ((MessageActivityDef)actDef).getReceivers().get(participantId);
            if (participantDef == null) continue;
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                permTypeList.add(participantDef);
                continue;
            }
            participantCollection.add(participantDef.getID(), participantDef);
        }
        List list = ParticipantHelper.getPersonsByParticipants(processInst, participantCollection);
        int n = permTypeList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantDef def = (ParticipantDef)permTypeList.get(i);
            ParticipantHelper.getPersonByOrgPermissionOwner(processInst, list, def, actDef);
        }
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            Person person = (Person)list.get(i);
            if (!list1.contains(person)) continue;
            list.remove(person);
        }
        return list;
    }

    public List getPersonsByParticipants(String processInstId, String activityDefId, List participantIdList) throws WfException {
        WfEngine eninge = WfEngine.getEngine(this.getContext());
        if (StringUtils.isEmpty((String)processInstId)) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)activityDefId)) {
            throw new IllegalArgumentException();
        }
        WfProcess processInst = eninge.getProcessInst(processInstId);
        ActivityDef activityDef = processInst.getDefinition().getActivityDef(activityDefId);
        if (activityDef == null) {
            return null;
        }
        return this.getPersonsByParticipants(processInstId, activityDef, participantIdList);
    }

    public List getPersonsByParticipants(String processInstId, ManpowerActivityDef actDef, List participantIdList, String currentUserId) throws WfException {
        WfEngine eninge = WfEngine.getEngine(this.getContext());
        WfProcess processInst = eninge.getProcessInst(processInstId);
        ParticipantCollection participantCollection = new ParticipantCollection();
        Iterator iterator = participantIdList.iterator();
        ArrayList<ParticipantDef> permTypeList = new ArrayList<ParticipantDef>();
        while (iterator.hasNext()) {
            String participantId = (String)iterator.next();
            ParticipantDef participantDef = actDef.getParticipants().get(participantId);
            if (participantDef == null) continue;
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                permTypeList.add(participantDef);
                continue;
            }
            participantCollection.add(participantDef.getID(), participantDef);
        }
        List list = ParticipantHelper.getPersonsByParticipants((WfExecutionObject)processInst, participantCollection, currentUserId);
        int n = permTypeList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantDef def = (ParticipantDef)permTypeList.get(i);
            ParticipantHelper.getPersonByOrgPermissionOwner(processInst, list, def, (ActivityDef)actDef);
        }
        return list;
    }

    public ActivityPersonsInfo[] getPostActivitysPersonsByActInstID(String actInstId, String currentUserId, boolean needCheck) throws WfException {
        return this.getPostActivitysPersonsByActInstID(actInstId, currentUserId, needCheck, null);
    }

    public ActivityPersonsInfo[] getPostActivitysPersonsByActInstID(String actInstId, String currentUserId, boolean needCheck, String associationLine) throws WfException {
        if (StringUtils.isEmpty((String)actInstId)) {
            throw new IllegalArgumentException("EnactmentService.getPostActivitysPersonsByActDef args actInstId is null");
        }
        WfEngine engine = WfEngine.getEngine(this.getContext());
        WfActivity wfActivity = engine.getActivityInst(actInstId);
        ActivityInstInfo actInfo = wfActivity.getMeta();
        ActivityDef actDef = wfActivity.getDefinition();
        ExtendedAttributeDef eDef = actDef.getActivityHeader().getExtendedAttributes().get("nextPerson");
        if (needCheck && (eDef == null || !"true".equalsIgnoreCase(eDef.getValue()))) {
            return new ActivityPersonsInfo[0];
        }
        ProcessDef procDef = (ProcessDef)actDef.getContainer();
        Map postActs = null;
        boolean notCheckPostActivitys = ProcessParamUtils.isSatisfyThisParam((Context)this.getContext(), (String)procDef.getID(), (String)"notCheckPostActivitys");
        if (notCheckPostActivitys) {
            postActs = this.getDirectPostManpowerActivities(actDef, associationLine);
        } else {
            ManpowerActivityDef activitydef = (ManpowerActivityDef)procDef.getActivityDef(actDef.getID());
            boolean checkAll = activitydef.isShowAllManpowerActivities() || activitydef.isShowAllEmptyManpowerActivites();
            postActs = checkAll ? this.gePostManpowerActivitiesBytAssociationLine(actDef, associationLine) : this.getDirectPostManpowerActivities(actDef, associationLine);
        }
        ArrayList postActivities = new ArrayList();
        postActivities.addAll(postActs.values());
        return this.getActivitiesAndPersons(actInfo, postActivities, currentUserId, needCheck);
    }

    private Map gePostManpowerActivitiesBytAssociationLine(ActivityDef actDef, String associationLine) throws WfException {
        Map postActs = new HashMap();
        HashMap activities = new HashMap();
        HashSet visited = new HashSet();
        boolean isgetActivity = false;
        ActivityCollection coll = actDef.getPostActivities();
        if (coll != null) {
            TransitionDef tran;
            if (associationLine != null && (tran = actDef.getOutgoingTransitions().get(associationLine)) != null) {
                this.findPostManpowerActivities(tran.getTo(), activities, visited);
                isgetActivity = true;
            }
            if (!isgetActivity) {
                postActs = this.getPostManpowerActivities(actDef);
                return postActs;
            }
            for (Map.Entry entry : activities.entrySet()) {
                ActivityDef postActDef = (ActivityDef)entry.getValue();
                postActs = this.getPostManpowerActivities(actDef);
            }
            postActs.putAll(activities);
        }
        return postActs;
    }

    private ActivityPersonsInfo[] getActivitiesAndPersons(ActivityInstInfo actInfo, List postActivities, String currentUserId, boolean needCheck) throws WfException {
        ArrayList<ActivityPersonsInfo> actPersons = new ArrayList<ActivityPersonsInfo>();
        WfEngine engine = WfEngine.getEngine(this.getContext());
        WfProcess procInst = engine.getProcessInst(actInfo.getProcInstId().toString());
        ProcessContext processContext = procInst.getProcessContext();
        for (int i = 0; i < postActivities.size(); ++i) {
            List<Person> result;
            ActivityDef postAct = (ActivityDef)postActivities.get(i);
            if (!(postAct instanceof ManpowerActivityDef)) continue;
            ManpowerActivityDef manAct = (ManpowerActivityDef)postAct;
            if (needCheck && this.isProcessInitiator((ManpowerActivityDef)postAct)) continue;
            String dataFieldName = ParticipantUtils.createDesignatePerformerKey((ActivityDef)postAct);
            Object dataFieldValue = processContext.getDataFieldValue(dataFieldName);
            if (dataFieldValue != null && dataFieldValue instanceof List && ((List)dataFieldValue).size() > 0) {
                List dpl = (List)dataFieldValue;
                IParticipantProvider provider = engine.getPariticipantProvider();
                result = new ArrayList();
                for (String personId : dpl) {
                    Person[] persons = provider.getPersonByEmployeeId(this.getContext(), personId);
                    if (persons == null || persons.length <= 0) {
                        persons = new Person[]{provider.getPersonByUserId(this.getContext(), personId)};
                    }
                    for (int j = 0; j <= persons.length - 1; ++j) {
                        result.add(persons[j]);
                    }
                }
                actPersons.add(this.constructActivityPersonsInfo(manAct, result, false));
                continue;
            }
            ParticipantCollection pcol = manAct.getParticipants();
            ArrayList<String> participantIdList = new ArrayList<String>();
            for (int j = 0; j < pcol.size(); ++j) {
                ParticipantDef pdef = pcol.get(j);
                if (StringUtils.isEmpty((String)pdef.getScriptRef())) {
                    participantIdList.add(pdef.getID());
                    continue;
                }
                try {
                    ScriptDef scriptdef = procInst.getDefinition().getScripts().get(pdef.getScriptRef());
                    boolean flag = ScriptUtil.evalCondition(scriptdef.getScriptContent(), processContext, procInst.getDefinition());
                    if (!flag) continue;
                    participantIdList.add(pdef.getID());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result = null;
            result = this.isSetCurrentUserAsPerformer((ActivityDef)manAct, actInfo) ? this.getPersonsByParticipants(actInfo.getProcInstId(), manAct, participantIdList, currentUserId) : this.getPersonsByParticipants(actInfo.getProcInstId(), (ActivityDef)manAct, participantIdList);
            if (result == null) {
                String defHashValue = ((ProcessDef)manAct.getContainer()).getHashValue();
                result = this.getPersonsByDefParticipants(defHashValue, manAct.getID(), participantIdList);
            }
            actPersons.add(this.constructActivityPersonsInfo(manAct, result, true));
        }
        return actPersons.toArray(new ActivityPersonsInfo[0]);
    }

    private ActivityPersonsInfo constructActivityPersonsInfo(ManpowerActivityDef actDef, List persons, boolean isFromFlowDefine) {
        ActivityPersonsInfo actPersonInfo = new ActivityPersonsInfo(isFromFlowDefine);
        ProcessDef procdef = (ProcessDef)actDef.getContainer();
        actPersonInfo.setPersons(persons.toArray(new Person[0]));
        actPersonInfo.setActDefID(actDef.getID());
        actPersonInfo.setCanSpecifyNextActivityPerformer(actDef.canSpecifyNextActivityPerformer());
        actPersonInfo.setActDefName(actDef.getName(this.getContext().getLocale()));
        actPersonInfo.setProcDefName(procdef.getName(this.getContext().getLocale()));
        actPersonInfo.setProcDefHashValue(procdef.getHashValue());
        return actPersonInfo;
    }

    private boolean isProcessInitiator(ManpowerActivityDef act) {
        boolean isProcessInitiator = false;
        ParticipantCollection participantCollection = act.getParticipants();
        for (ParticipantDef participantDef : participantCollection) {
            if (participantDef.getReferenceHumanType() == null || !participantDef.getReferenceHumanType().equals((Object)ReferenceHumanType.PROCESS_INITIATOR)) continue;
            isProcessInitiator = true;
            break;
        }
        return isProcessInitiator;
    }

    private boolean isSetCurrentUserAsPerformer(ActivityDef nextActDef, ActivityInstInfo actInfo) throws WfException {
        if (!(nextActDef instanceof ManpowerActivityDef)) {
            return false;
        }
        WfEngine engine = WfEngine.getEngine(this.getContext());
        AssignmentInfo[] assignmentInfos = engine.getAssignmentByActInstId(actInfo.getActInstId());
        for (int i = 0; i < assignmentInfos.length; ++i) {
            AssignmentInfo assignmentInfo = assignmentInfos[i];
            if (!assignmentInfo.getState().equals((Object)WfAssignmentState.COMPLETED)) continue;
            return false;
        }
        ParticipantCollection participantCollection = ((ManpowerActivityDef)nextActDef).getParticipants();
        for (int j = 0; j < participantCollection.size(); ++j) {
            ParticipantDef pdef = participantCollection.get(j);
            if (pdef.getParticipantType() != ParticipantType.RELATION) continue;
            String refObjId = pdef.getReferenceHumanId();
            ReferenceHumanType refObjType = pdef.getReferenceHumanType();
            if (!refObjType.equals((Object)ReferenceHumanType.ACTIVITY_PERFORMER) || !refObjId.equals(actInfo.getActDefId())) continue;
            return true;
        }
        return false;
    }

    private Map getPostManpowerActivities(ActivityDef actDef) throws WfException {
        if (actDef == null || actDef.getPostActivities() == null || actDef.getPostActivities().size() == 0) {
            throw new IllegalArgumentException();
        }
        return this.filterManpowerActivityDef(this.getPostActivities(actDef));
    }

    private Map getPostActivities(ActivityDef actDef) throws WfException {
        if (actDef == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, ActivityDef> result = new HashMap<String, ActivityDef>();
        ProcessDef procDef = (ProcessDef)actDef.getContainer();
        ActivityCollection activities = this.getAllPostActivitiesNoBack(actDef, procDef);
        if (activities == null || activities.size() == 0) {
            return result;
        }
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDef postActDef = activities.get(i);
            String key = procDef.getID() + "@" + postActDef.getID();
            if (result.get(key) != null) continue;
            result.put(key, postActDef);
            if (!(postActDef instanceof SubflowActivityDef)) continue;
            this.getSubflowPostActivities((SubflowActivityDef)postActDef, result);
        }
        return result;
    }

    private ActivityCollection getAllPostActivitiesNoBack(ActivityDef actDef, ProcessDef procDef) throws WfException {
        ActivityCollection activities = new ActivityCollection((AbstractKpdlElement)procDef);
        WfEngine engine = WfEngine.getEngine(this.getContext());
        Flow flow = engine.getFlow(procDef.getHashValue());
        Set backTranSet = flow.getGraph().getBackwardEdges();
        this.getPostActivitiesNoBack(backTranSet, activities, actDef);
        return activities;
    }

    private void getPostActivitiesNoBack(Set backTranSet, ActivityCollection activities, ActivityDef actDef) throws WfException {
        TransitionCollection inTrans;
        if (!(actDef instanceof EndActivityDef) && (inTrans = actDef.getOutgoingTransitions()) != null) {
            for (int index = 0; index < inTrans.size(); ++index) {
                TransitionDef tranDef = inTrans.get(index);
                if (tranDef.getFrom() == null || tranDef.getTo() == null || WfBizService.isBackTransition(backTranSet, tranDef)) continue;
                ActivityDef nextDef = tranDef.getTo();
                if (actDef.getID().equals(nextDef.getID())) continue;
                activities.add(nextDef);
                this.getPostActivitiesNoBack(backTranSet, activities, nextDef);
            }
        }
    }

    public static boolean isBackTransition(Set backTranSet, TransitionDef transitionDef) {
        String transitionPach = transitionDef.getFrom().getID() + "->" + transitionDef.getTo().getID();
        return backTranSet.contains(transitionPach);
    }

    private void getSubflowPostActivities(SubflowActivityDef subflowActivityDef, Map result) throws WfException {
        String subProcessDefID = subflowActivityDef.getSubflowId();
        IWfDefineService wfDefineService = WfDefineService.getService(this.getContext());
        ProcessDefInfo subProcessDefInfo = wfDefineService.getProcessDefInfo(subProcessDefID);
        ProcessDef subProcessDef = wfDefineService.getProcessDefByDefineHashValue(subProcessDefInfo.getMd5HashValue());
        ActivityCollection startupActivities = subProcessDef.getStartupActivities();
        int size = startupActivities.size();
        for (int i = 0; i < size; ++i) {
            ActivityDef actDef = startupActivities.get(i);
            if (actDef instanceof ManpowerActivityDef) {
                result.put(subProcessDef.getID() + "@" + actDef.getID(), actDef);
            }
            result.putAll(this.getPostActivities(actDef));
        }
    }

    private Map filterManpowerActivityDef(Map map) {
        HashMap retvalue = new HashMap();
        if (map == null || map.size() < 1) {
            return retvalue;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            ActivityDef actDef = (ActivityDef)entry.getValue();
            if (!(actDef instanceof ManpowerActivityDef)) continue;
            retvalue.put(key, actDef);
        }
        return retvalue;
    }

    private ActivityPersonsInfo[] getPostActivitysPersonsByActDef(ActivityDef actDef, String currentUserID) throws WfException {
        if (actDef == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ActivityPersonsInfo> actPersons = new ArrayList<ActivityPersonsInfo>();
        Map postActs = this.getDirectPostManpowerActivities(actDef, null);
        ArrayList postActivities = new ArrayList();
        postActivities.addAll(postActs.values());
        for (int i = 0; i < postActivities.size(); ++i) {
            ActivityDef postAct = (ActivityDef)postActivities.get(i);
            ManpowerActivityDef manAct = (ManpowerActivityDef)postAct;
            ExtendedAttributeDef ead = manAct.getActivityHeader().getExtendedAttributes().get("notAllowChangePerformers");
            if (ead != null && "true".equals(ead.getValue())) continue;
            ParticipantCollection pcol = manAct.getParticipants();
            ArrayList<String> participantIdList = new ArrayList<String>();
            for (int j = 0; j < pcol.size(); ++j) {
                ParticipantDef pdef = pcol.get(j);
                if (!StringUtils.isEmpty((String)pdef.getScriptRef())) continue;
                participantIdList.add(pdef.getID());
            }
            List result = this.getPersonsByDefParticipants(manAct, participantIdList, currentUserID);
            actPersons.add(this.constructActivityPersonsInfo(manAct, result, true));
        }
        return actPersons.toArray(new ActivityPersonsInfo[0]);
    }

    private List getPersonsByDefParticipants(ManpowerActivityDef actDef, List participantIdList, String currentUserID) throws WfException {
        WfEngine engine = WfEngine.getEngine(this.getContext());
        ProcessDef procDef = (ProcessDef)actDef.getContainer();
        ManpowerActivityDef manpowerActivityDef = actDef;
        ParticipantCollection participantCollection = new ParticipantCollection();
        Iterator iterator = participantIdList.iterator();
        ArrayList<ParticipantDef> permTypeList = new ArrayList<ParticipantDef>();
        while (iterator.hasNext()) {
            String participantId = (String)iterator.next();
            ParticipantDef participantDef = manpowerActivityDef.getParticipants().get(participantId);
            if (participantDef == null) continue;
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                permTypeList.add(participantDef);
                continue;
            }
            participantCollection.add(participantDef.getID(), participantDef);
        }
        ArrayList list = ParticipantHelper.getPersonsByParticipants(engine, procDef.getHashValue(), actDef.getID(), participantCollection, currentUserID);
        if (list == null) {
            list = new ArrayList();
        }
        int n = permTypeList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantDef def = (ParticipantDef)permTypeList.get(i);
            if (ParticipantHelper.isOrgVariable(def.getParticipantValue())) continue;
            ParticipantHelper.getPersonByOrgPermissionOwner(engine, list, def, (ActivityDef)manpowerActivityDef, def.getParticipantValue());
        }
        return list;
    }

    public BillActivityPersonsData[] getPostActivitysPersonsByAssignIDs(String[] assignIds, String[] billIds, String currentUserId) throws WfException {
        if (assignIds == null || billIds == null || assignIds.length <= 0 || billIds.length <= 0 || assignIds.length != billIds.length) {
            throw new IllegalArgumentException("EnactmentService.getPostActivitysPersonsByAssignIDs args error");
        }
        ArrayList<BillActivityPersonsData> result = new ArrayList<BillActivityPersonsData>();
        WfEngine engine = WfEngine.getEngine(this.getContext());
        for (int i = 0; i < assignIds.length; ++i) {
            WfAssignment wfAssignment = engine.getAssignment(assignIds[i]);
            ActivityInstInfo activityInstInfo = wfAssignment.getActInst().getMeta();
            ActivityPersonsInfo[] ap = this.getPostActivitysPersonsByActInstID(activityInstInfo.getActInstId(), currentUserId, true);
            result.add(new BillActivityPersonsData(billIds[i], ap));
        }
        return result.toArray(new BillActivityPersonsData[0]);
    }

    public AssignatePersonsInfo checkPostActivitiesPersonsResult(IObjectValue editData, String userID, String boId, String functionName, String operationName) throws WfException {
        WfEngine engine = WfEngine.getEngine(this.getContext());
        ProcessInstInfo[] procInsts = engine.getProcessInstanceByHoldedObjectId(boId);
        ProcessDef procDef = null;
        if (procInsts != null && procInsts.length != 0 && procInsts[0] != null) {
            ProcessInstInfo procInstInfo = procInsts[0];
            procDef = engine.getProcessDef(procInstInfo.getProcDefHashValue());
            ActivityInstInfo[] acts = engine.getActInstMetaArrayByProcInstIdAndActInstState(procInstInfo.getProcInstId(), "open.not_running.not_started");
            if (acts != null) {
                boolean isFirst = false;
                for (int i = 0; i < acts.length; ++i) {
                    TransitionCollection tc;
                    ActivityDef actDef = procDef.getActivityDef(acts[i].getActDefId());
                    if (actDef == null || (tc = actDef.getIncomingTransitions()) == null) continue;
                    for (int j = 0; j < tc.size(); ++j) {
                        if (!(tc.get(j).getFrom() instanceof StartActivityDef)) continue;
                        isFirst = true;
                    }
                }
                if (!isFirst) {
                    return null;
                }
            }
        }
        if (procDef == null) {
            IWfDefineService defineService = WfDefineService.getService(this.getContext());
            String procDefId = defineService.findSubmitProcDef(userID, editData, functionName, operationName);
            return this.checkPostActivitiesPersonsResult(procDefId, userID);
        }
        return this.checkPostActivitiesPersonsResult(procDef, userID);
    }

    public AssignatePersonsInfo checkPostActivitiesPersonsResult(String procDefId, String userID) throws WfException {
        WfEngine engine = WfEngine.getEngine(this.getContext());
        IWfDefineService defineService = WfDefineService.getService(this.getContext());
        if (procDefId == null) {
            return null;
        }
        ProcessDef procDef = engine.getProcessDef(defineService.getProcessDefInfo(procDefId).getMd5HashValue());
        if (procDef == null) {
            return null;
        }
        return this.checkPostActivitiesPersonsResult(procDef, userID);
    }

    public AssignatePersonsInfo checkPostActivitiesPersonsResult(ProcessDef procDef, String userID) throws WfException {
        ActivityPersonsInfo[] result = null;
        ActivityDefPartialInfo[] unitScopeActDefs = null;
        AssignatePersonsInfo apInfo = new AssignatePersonsInfo();
        ActivityCollection actCol = procDef.getStartupActivities();
        apInfo.setSetNextPersonBeforeSubmit(procDef.getProcessHeader().isSetPostActivitiesPerson());
        boolean b = false;
        boolean canSetPostActivitiesPerson = false;
        for (int i = 0; i < actCol.size(); ++i) {
            ActivityDef actDef = actCol.get(i);
            if (!(actDef instanceof ManpowerActivityDef)) continue;
            if (((ManpowerActivityDef)actDef).isMustShowParticipantsCheckList()) {
                b = true;
            }
            if (!((ManpowerActivityDef)actDef).canSpecifyNextActivityPerformer()) continue;
            canSetPostActivitiesPerson = true;
        }
        if (!canSetPostActivitiesPerson) {
            apInfo.setSetNextPersonBeforeSubmit(false);
        }
        apInfo.setMustShowParticipantsCheckList(b);
        if (!b && procDef.getProcessHeader().isCheckPostActivitiesPerson()) {
            ActivityDef actDef = procDef.getStartupActivities().get(0);
            result = this.getPostActivitysPersonsByActDef(actDef, userID);
            unitScopeActDefs = EnactmentUtils.getUnitScopeActDefsByProcDef(procDef, this.getContext().getLocale());
        }
        apInfo.setProcDefHashValue(procDef.getHashValue());
        apInfo.setProcDefId(procDef.getID());
        apInfo.setActivityPersons(result);
        apInfo.setUnitScopeActDefCol(unitScopeActDefs);
        return apInfo;
    }

    public String[] checkBizObjInWfProcess(String[] bizObjIds) throws WfException {
        assert (bizObjIds != null);
        if (bizObjIds.length == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int execCount = 0;
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            int tCount;
            for (int count = bizObjIds.length; count > 0; count -= tCount) {
                tCount = 500;
                if (count < 500) {
                    tCount = count;
                }
                StringBuffer idsb = new StringBuffer();
                for (int i = 0; i < tCount; ++i) {
                    idsb.append(",'").append(bizObjIds[execCount + i]).append("'");
                }
                String ids = idsb.substring(1);
                connection = WfDbUtil.getConnection((Context)this.getContext());
                String sql = null;
                sql = "select fbizObjId from T_WFR_ProcInstBizObj where fbizObjId in (" + ids + ") union select fbizObjId from T_WFR_Assign where fbizObjId in (" + ids + ") and (fstate = 0 or fstate = 1 or fstate = 2 or fstate = 32) ";
                stmt = connection.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                execCount += tCount;
            }
        }
        catch (Exception ex) {
            throw new WfException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, connection);
        }
        return list.toArray(new String[0]);
    }

    public String getMessageBillId(String actInstId) throws WfException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection connection;
        block7: {
            String string;
            assert (actInstId != null);
            WfEngine wfEngine = WfEngine.getEngine(this.getContext());
            WfActivity activity = wfEngine.getActivityInst(actInstId);
            if (!(activity.getDefinition() instanceof MessageActivityDef)) {
                return null;
            }
            MessageActivityDef def = (MessageActivityDef)activity.getDefinition();
            String billIdKey = def.getBillIdKey();
            WfProcess procInst = wfEngine.getProcessInst(activity.getProcInstId());
            if (billIdKey != null) {
                Object id = procInst.getProcessContext().getDataFieldValue(billIdKey);
                return id.toString();
            }
            connection = null;
            pstmt = null;
            rs = null;
            try {
                connection = WfDbUtil.getConnection((Context)wfEngine.context());
                String sql = null;
                sql = "select top 1 fbizObjId from T_WFR_ProcInstBizObj where FProcInstId = ?";
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, procInst.getId());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block7;
                string = rs.getString(1);
            }
            catch (Exception ex) {
                try {
                    throw new WfException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)connection);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)connection);
        return null;
    }

    public DesignatePerformerData getManpowerActDefByActInstIds(List ActInstIds) throws WfException {
        if (ActInstIds == null) {
            throw new WfException("getManpowerActDefByActInstIds,args can't be null");
        }
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        DesignatePerformerData data = new DesignatePerformerData();
        Iterator it = ActInstIds.iterator();
        ArrayList<ActivityDef> submitActDefs = new ArrayList<ActivityDef>();
        String baseActInstId = null;
        String procInstId = null;
        while (it.hasNext()) {
            baseActInstId = (String)it.next();
            WfActivity wfActivity = wfEngine.getActivityInst(baseActInstId);
            procInstId = wfActivity.getProcInstId();
            ActivityDef def = wfActivity.getDefinition();
            if (!(def instanceof ManpowerActivityDef)) continue;
            submitActDefs.add(def);
        }
        data.setManpowerActDefs(submitActDefs);
        data.setProcessInsId(procInstId);
        return data;
    }

    public ActivityPersonsInfo[] getPostActivitysPersonsByAssociationLine(String actInstId, String currentUserId, String[] associationTransitionIds, boolean onlyFirst) throws WfException {
        if (associationTransitionIds == null || associationTransitionIds.length <= 0) {
            return this.getPostActivitysPersonsByActInstID(actInstId, currentUserId, false);
        }
        ArrayList postActivities = new ArrayList();
        Map postAcitivitiesMap = new HashMap();
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        WfActivity wfActivity = wfEngine.getActivityInst(actInstId);
        ActivityInstInfo actInfo = wfActivity.getMeta();
        ActivityDef actDef = wfActivity.getDefinition();
        ProcessDef procDef = (ProcessDef)actDef.getContainer();
        postAcitivitiesMap = onlyFirst ? this.getAssociationLineDirectPostManActivitys(procDef, associationTransitionIds) : this.getAssociationLineAllPostManActivitys(procDef, associationTransitionIds);
        postActivities.addAll(postAcitivitiesMap.values());
        return this.getActivitiesAndPersons(actInfo, postActivities, currentUserId, false);
    }

    private Map getAssociationLineAllPostManActivitys(ProcessDef procDef, String[] associationTransitionIds) throws WfException {
        HashMap result = new HashMap();
        for (int i = 0; i < associationTransitionIds.length; ++i) {
            TransitionDef transitionDef = procDef.getTransitionDef(associationTransitionIds[i]);
            ActivityDef postActDef = transitionDef.getTo();
            result.putAll(this.getPostManpowerActivities(postActDef));
        }
        return result;
    }

    private Map getAssociationLineDirectPostManActivitys(ProcessDef procDef, String[] associationTransitionIds) throws WfException {
        HashMap<String, ActivityDef> result = new HashMap<String, ActivityDef>();
        for (int i = 0; i < associationTransitionIds.length; ++i) {
            TransitionDef transitionDef = procDef.getTransitionDef(associationTransitionIds[i]);
            ActivityDef postActDef = transitionDef.getTo();
            if (postActDef instanceof ManpowerActivityDef) {
                String key = procDef.getID() + "@" + postActDef.getID();
                if (result.get(key) != null) continue;
                result.put(key, postActDef);
                continue;
            }
            if (postActDef instanceof SubflowActivityDef) {
                this.getSubflowDirectPostManActivitys((SubflowActivityDef)postActDef, result);
                continue;
            }
            TransitionCollection transitionCollection = postActDef.getOutgoingTransitions();
            String[] transitionIds = EnactmentUtils.getTransitionIds(transitionCollection);
            result.putAll(this.getAssociationLineDirectPostManActivitys(procDef, transitionIds));
        }
        return result;
    }

    private void getSubflowDirectPostManActivitys(SubflowActivityDef subflowActivityDef, Map result) throws WfException {
        TransitionCollection transitionCollection;
        String[] transitionIds;
        ProcessDefInfo subProcessDefInfo;
        String subProcessDefID = subflowActivityDef.getSubflowId();
        IWfDefineService defineService = WfDefineService.getService(this.getContext());
        ProcessDef subProcessDef = defineService.getProcessDefByDefineHashValue((subProcessDefInfo = defineService.getProcessDefInfo(subProcessDefID)).getMd5HashValue());
        Map subflowActs = this.getAssociationLineDirectPostManActivitys(subProcessDef, transitionIds = EnactmentUtils.getTransitionIds(transitionCollection = subProcessDef.getStartActivity().getOutgoingTransitions()));
        if (subflowActs.size() > 0) {
            result.putAll(subflowActs);
        } else {
            ProcessDef procDef = (ProcessDef)subflowActivityDef.getContainer();
            result.putAll(this.getAssociationLineDirectPostManActivitys(procDef, EnactmentUtils.getTransitionIds(subflowActivityDef.getOutgoingTransitions())));
        }
    }

    public List getPersonsByDefParticipants(String procDefHash, String activityDefId, List participantIdList, String currentUserId) throws WfException {
        WfEngine eninge = WfEngine.getEngine(this.getContext());
        List list1 = ParticipantHelper.getPersonsByParticipant(eninge, procDefHash, activityDefId, currentUserId, true);
        ProcessDef procDef = eninge.getProcessDef(procDefHash);
        if (procDef == null) {
            throw new WfException("Can not find the ProcessDef in workflow engine, the process definition hash value is:" + procDefHash);
        }
        ActivityDef actDef = procDef.getActivityDef(activityDefId);
        if (!(actDef instanceof ManpowerActivityDef) && !(actDef instanceof MessageActivityDef)) {
            throw new WfException("Activity is not a ManpowerActivity or MessageActivity,, activity definition id: " + activityDefId);
        }
        ParticipantCollection participantCollection = new ParticipantCollection();
        Iterator iterator = participantIdList.iterator();
        ArrayList<ParticipantDef> permTypeList = new ArrayList<ParticipantDef>();
        while (iterator.hasNext()) {
            String participantId = (String)iterator.next();
            ParticipantDef participantDef = actDef instanceof ManpowerActivityDef ? ((ManpowerActivityDef)actDef).getParticipants().get(participantId) : ((MessageActivityDef)actDef).getReceivers().get(participantId);
            if (participantDef == null) continue;
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                permTypeList.add(participantDef);
                continue;
            }
            participantCollection.add(participantDef.getID(), participantDef);
        }
        ArrayList list = ParticipantHelper.getPersonsByParticipants(eninge, procDefHash, activityDefId, participantCollection, currentUserId);
        if (list == null) {
            list = new ArrayList();
        }
        int n = permTypeList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantDef def = (ParticipantDef)permTypeList.get(i);
            if (ParticipantHelper.isOrgVariable(def.getParticipantValue())) continue;
            ParticipantHelper.getPersonByOrgPermissionOwner(eninge, list, def, actDef, def.getParticipantValue());
        }
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            Person person = (Person)list.get(i);
            if (!list1.contains(person)) continue;
            list.remove(person);
        }
        return list;
    }

    private Map getDirectPostManpowerActivities(ActivityDef actDef, String associationLine) throws WfException {
        HashMap activities = new HashMap();
        HashSet visited = new HashSet();
        ActivityCollection coll = actDef.getPostActivities();
        if (coll != null) {
            TransitionDef tran;
            if (associationLine != null && (tran = actDef.getOutgoingTransitions().get(associationLine)) != null) {
                this.findPostManpowerActivities(tran.getTo(), activities, visited);
                return activities;
            }
            for (int i = 0; i < coll.size(); ++i) {
                this.findPostManpowerActivities(coll.get(i), activities, visited);
            }
        }
        return activities;
    }

    private boolean findPostManpowerActivities(ActivityDef actDef, Map activities, HashSet visited) throws WfException {
        String id = actDef.getID();
        if (visited.contains(id)) {
            return false;
        }
        visited.add(id);
        if (actDef instanceof ManpowerActivityDef) {
            String key = actDef.getContainer().getID() + "@" + actDef.getID();
            activities.put(key, actDef);
            return true;
        }
        if (actDef instanceof SubflowActivityDef && this.findPostManpowerActivitiesInSubFlow((SubflowActivityDef)actDef, activities, visited)) {
            return true;
        }
        ActivityCollection coll = actDef.getPostActivities();
        if (coll == null || coll.size() <= 0) {
            return false;
        }
        boolean b = false;
        for (int i = 0; i < coll.size(); ++i) {
            ActivityDef act = coll.get(i);
            if (!this.findPostManpowerActivities(act, activities, visited)) continue;
            b = true;
        }
        return b;
    }

    private boolean findPostManpowerActivitiesInSubFlow(SubflowActivityDef subFlowactDef, Map activities, HashSet visited) throws WfException {
        String subProcessDefID = subFlowactDef.getSubflowId();
        IWfDefineService wfDefineService = WfDefineService.getService(this.getContext());
        ProcessDefInfo subProcessDefInfo = wfDefineService.getProcessDefInfo(subProcessDefID);
        ProcessDef subProcessDef = wfDefineService.getProcessDefByDefineHashValue(subProcessDefInfo.getMd5HashValue());
        ActivityCollection startupActivities = subProcessDef.getStartupActivities();
        boolean b = false;
        for (int i = 0; i < startupActivities.size(); ++i) {
            if (!this.findPostManpowerActivities(startupActivities.get(i), activities, visited)) continue;
            b = true;
        }
        return b;
    }

    public BillApproveResultInfo getBillApproveResultInfo(String[] billIdArray, IMetaDataPK uiObjPK, String action, String userId) throws WfException {
        BillApproveResultInfo info = new BillApproveResultInfo();
        Map assignmentInfoListMap = this.checkAssignmentInfo(billIdArray, uiObjPK, action, userId);
        HashMap assignmentInfoMap = new HashMap();
        block2: for (Map.Entry entry : assignmentInfoListMap.entrySet()) {
            Object key = entry.getKey();
            List value = (List)entry.getValue();
            if (value == null || value.size() <= 0) continue;
            for (int i = 0; i <= value.size() - 1; ++i) {
                AssignmentInfo assignmentInfo = (AssignmentInfo)value.get(i);
                WfAssignmentState assignmentState = assignmentInfo.getState();
                boolean isSendMsg = assignmentInfo.isSendMsg();
                if (!isSendMsg) {
                    try {
                        if (CheckShareAssign.isShareCenterAssign(assignmentInfo.getProcInstId(), this.getContext())) {
                            continue;
                        }
                    }
                    catch (BOSException bOSException) {
                        // empty catch block
                    }
                }
                if (!WfAssignmentState.ASSIGNED.equals((Object)assignmentState) && !WfAssignmentState.ACCEPTED.equals((Object)assignmentState)) continue;
                assignmentInfoMap.put(key, assignmentInfo.getAssignmentId().toString());
                continue block2;
            }
        }
        WfEngine engine = WfEngine.getEngine(this.getContext());
        info.setAssignmentInfoMap(assignmentInfoMap);
        info.setDecisionItemsString(ServiceUtils.getDecisionItems(assignmentInfoMap, engine));
        info.setDefaultOpinion(ServiceUtils.getDefaultOpinion(assignmentInfoMap, engine));
        return info;
    }

    public Set getWfSendingMsgBundle(String billId, Locale currentLocale) throws WfException {
        HashSet<WfSendingMsgBundle> result = new HashSet<WfSendingMsgBundle>();
        HashSet<String> states = new HashSet<String>();
        states.add("open.running");
        states.add("open.not_running.not_started");
        WfEngine engine = WfEngine.getEngine(this.getContext());
        ProcessInstInfo[] procInsts = engine.getProcessInstanceByHoldedObjectId(billId);
        if (procInsts == null || procInsts.length <= 0 || procInsts[0] == null) {
            return result;
        }
        List actInstInfos = ActiviyMonitorService.getService(this.getContext()).getRelatedActInstsByProcInstID(procInsts[0].getProcInstId(), states);
        for (ActivityInstInfo activityInstInfo : actInstInfos) {
            StringBuffer receviers = new StringBuffer("");
            StringBuffer content = new StringBuffer("");
            String name = activityInstInfo.getActDefName(currentLocale);
            boolean isApproved = false;
            String processInstId = activityInstInfo.getProcDefId();
            String actvityInstId = activityInstInfo.getActInstId();
            ActivityDef actDef = WfDefineService.getService(this.getContext()).getActDefByActInstInfo(activityInstInfo);
            if (actDef instanceof ApproveActivityDef) {
                isApproved = true;
            }
            AssignmentInfo[] assignInfoArray = engine.getAssignmentByActInstId(activityInstInfo.getActInstId());
            int length = assignInfoArray.length;
            for (int j = 0; j < length; ++j) {
                String userName = assignInfoArray[j].getUserName(currentLocale);
                String workContent = assignInfoArray[j].getBody(currentLocale);
                if (userName == null || receviers.indexOf(userName) != -1) continue;
                if (receviers.toString().trim().length() != 0) {
                    receviers.append(',');
                    content.append(',');
                }
                receviers.append(userName);
                if (workContent == null || content.indexOf(workContent) != -1) continue;
                content.append(workContent);
            }
            if (content == null || ",".equals(content.toString())) {
                content = new StringBuffer("");
            }
            WfSendingMsgBundle MsgBundle = new WfSendingMsgBundle(name, receviers.toString(), content.toString(), isApproved, processInstId, actvityInstId);
            result.add(MsgBundle);
        }
        return result;
    }

    public boolean isShareCenterAssign(String procinstId) throws BOSException {
        boolean isShareCenter = false;
        isShareCenter = CheckShareAssign.isShareCenterAssign(procinstId, this.getContext());
        return isShareCenter;
    }

    public List getPersonsByParticipantsNew(String processInstId, ActivityDef actDef, List participantIdList) throws WfException {
        WfEngine eninge = WfEngine.getEngine(this.getContext());
        WfProcess processInst = eninge.getProcessInst(processInstId);
        List list = ParticipantHelper.getPersonsByParticipants((WfExecutionObject)processInst, actDef, processInstId);
        return list;
    }

    public Map getUndisposRow(String userId) {
        int count = 0;
        StringBuffer undisposSql = new StringBuffer();
        Object[] undisposeParams = null;
        Context ctx = this.getContext();
        undisposSql.append("SELECT COUNT(a.FASSIGNID) AS COUNT from T_WFR_Assign a  ,T_BAS_AssignRead b where a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 and a.FPERSONUSERID = ? ");
        undisposeParams = new Object[]{userId};
        try {
            IRowSet undisposeTaskRowSet = DbUtil.executeQuery((Context)ctx, (String)undisposSql.toString(), (Object[])undisposeParams);
            if (undisposeTaskRowSet.next()) {
                count = undisposeTaskRowSet.getInt("COUNT");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("count", count);
        return map;
    }
}

