/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.shell.trace.KSqlMonitor;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.security.IPermissionProvider;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IWfTestService;
import com.kingdee.cbos.process.vm.runtime.FlowContext;

public class WfTestService
extends AbstractBOSObject
implements IWfTestService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WINS");

    public static IWfTestService getService(Context ctx) {
        return new WfTestService(ctx);
    }

    public WfTestService(Context ctx) {
        super(ctx);
        this.registerInterface(IWfTestService.class, (Object)this);
    }

    public void initActivityInst(String activityInstId) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfActivity actInst = wfEngine.getActivityInst(activityInstId);
        WfProcess procInst = actInst.container();
        if (!procInst.getProcessContext().isPvmMode()) {
            actInst.init();
        } else {
            this.innerInit(procInst);
        }
    }

    private void innerInit(WfProcess procInst) throws AlreadyInProcessQueueException, WfException {
        String mutex = Mutex.getMutex(this.getContext(), procInst.getId());
        Mutex.lock(this.getContext(), mutex);
        try {
            FlowContext runtime = procInst.getProcessContext().loadFlowContext();
            runtime.resume();
            procInst.getProcessContext().setFlowContext(runtime);
        }
        catch (Exception e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        finally {
            Mutex.unlock(this.getContext(), mutex);
        }
    }

    public void setEngineThreadLookupBlockSize(int engineThreadLookupBlockSize) throws WfException {
    }

    public String getActivateConnectionInfo() throws WfException {
        return KSqlMonitor.getActivateConnectionInfoReport();
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public IParticipantProvider getParticipantProvider() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getPariticipantProvider();
    }

    public IPermissionProvider getPermissionProvider() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getPermissionProvider();
    }

    public int getEngineThreadLookupBlockSize() throws WfException {
        return 0;
    }

    public String getProcInstIdByCreateQuequeEntryId(String transQItemId) throws WfException {
        throw new UnsupportedOperationException();
    }
}

