/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.ProcInstDataCollection;
import com.kingdee.bos.workflow.metas.ProcInstDataHstCollection;
import com.kingdee.bos.workflow.metas.ProcInstDataHstInfo;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.store.AbstractBaseStorer;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.store.util.RelevantDatas;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ConvertUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DataFieldStorer
extends AbstractBaseStorer {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.store.DataFieldStorer");

    DataFieldStorer(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcInstDataCollection getProcInstDataInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            ProcInstDataCollection pidic;
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCINSTDATABOT, cn);
            IObjectCollection oc = oql == null || oql.length() == 0 ? ormdao.getCollection() : ormdao.getCollection(oql);
            ProcInstDataCollection procInstDataCollection = pidic = (ProcInstDataCollection)oc;
            return procInstDataCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private ProcInstDataInfo getProcInstDataInfo(String oql) throws SQLException, DataAccessException {
        ProcInstDataCollection pidic = this.getProcInstDataInfoCollection(oql);
        if (pidic != null && pidic.size() > 0) {
            return pidic.get(0);
        }
        return null;
    }

    public void clearTempProcInstData(String procInstId) throws WfException {
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql1 = "DELETE t_wfr_procInstData where FProcInstId = ? and FIsCurrent = 0";
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql1);
            stmt.setString(1, procInstId);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new WfException("clearTempProcInstData meet SQLException", (Throwable)ex);
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(null, stmt, conn);
                throw throwable;
            }
        }
        StoreManager.cleanup(null, stmt, conn);
        this.notifyDataChangedByProcInstId(procInstId, "clearTempProcInstData", new Class[]{String.class}, new Object[]{procInstId});
    }

    public void addNewProcInstData(ProcInstDataInfo procInstDataInfo) throws WfException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCINSTDATABOT, cn);
            ormdao.addnew((IObjectValue)procInstDataInfo);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (DataAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        this.notifyDataChangedByProcDefId(procInstDataInfo.getProcDefID() != null ? procInstDataInfo.getProcDefID().toString() : "", "addNewProcInstData", new Class[]{ProcInstDataInfo.class}, new Object[]{procInstDataInfo});
    }

    public static ProcInstDataInfo buildNewProcInstDataInfo(Context ctx, WfProcessMgr processMgr, String procInstId, String data, boolean bRollback) {
        Locale[] lcla = ApplicationUtil.getContextLocales((Context)ctx);
        Timestamp cts = new Timestamp(System.currentTimeMillis());
        ProcessDef pdef = processMgr.getProcessDef();
        ProcInstDataInfo pidi = new ProcInstDataInfo();
        for (int i = 0; i <= lcla.length - 1; ++i) {
            Locale lcl = lcla[i];
            pidi.setProcDefName(pdef.getName(lcl), lcl);
        }
        pidi.setProcInstID(BOSUuid.read((String)procInstId));
        pidi.setTime(cts);
        pidi.setProcDefID(BOSUuid.read((String)pdef.getID()));
        pidi.setProcDefHash(pdef.getDocHash());
        pidi.setProcDefVer(processMgr.getInnverVersion());
        pidi.setDataValue(data);
        pidi.setIsCurrent(1);
        pidi.setIsRollback(ConvertUtils.toInt((boolean)bRollback));
        return pidi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcInstDataHstCollection getProcInstDataHstInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            ProcInstDataHstCollection pidic;
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCINSTDATAHSTBOT, cn);
            IObjectCollection oc = oql == null || oql.length() == 0 ? ormdao.getCollection() : ormdao.getCollection(oql);
            ProcInstDataHstCollection procInstDataHstCollection = pidic = (ProcInstDataHstCollection)oc;
            return procInstDataHstCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private ProcInstDataInfo getProcInstDataInfo_Hst(String oql) throws SQLException, DataAccessException {
        ProcInstDataHstCollection pidic = this.getProcInstDataHstInfoCollection(oql);
        if (pidic != null && pidic.size() > 0) {
            ProcInstDataHstInfo pidhi = pidic.get(0);
            ProcInstDataInfo pidi = new ProcInstDataInfo(pidhi.getValues());
            return pidi;
        }
        return null;
    }

    private HashMap getCurrentValue(String processInstId, HashMap data, DataTypeEnum dataType) throws WfException {
        if (processInstId == null || processInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            ProcInstDataInfo procInstDataInfo;
            String cndtn0 = "(procInstID = '" + processInstId + "')";
            String cndtn1 = "(isCurrent = 1)";
            String cndtn = cndtn0 + " and " + cndtn1;
            String oql = "where " + cndtn;
            HashMap returnValue = null;
            if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
                procInstDataInfo = this.getProcInstDataInfo_Hst(oql);
            } else if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
                procInstDataInfo = this.getProcInstDataInfo(oql);
            } else {
                throw new IllegalArgumentException();
            }
            if (procInstDataInfo != null) {
                String relevantDatasString = procInstDataInfo.getDataValue();
                RelevantDatas relevantDatas = new RelevantDatas();
                relevantDatas.initial(relevantDatasString);
                returnValue = relevantDatas.readValue();
                data.putAll(returnValue);
            }
            return returnValue;
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
        catch (SQLException e) {
            throw new WfException("SQLException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ProcInstDataInfo procInstDataInfo) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "storeValue", null);
        }
        try {
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                conn = this.getConnection();
                String sql = "UPDATE T_WFR_ProcInstData SET FDATAVALUE = ? , FISCURRENT = 1 WHERE FPROCINSTID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, procInstDataInfo.getDataValue());
                stmt.setString(2, procInstDataInfo.getProcInstID().toString());
                stmt.execute();
            }
            catch (SQLException e) {
                try {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new WfException((Throwable)e);
                }
                catch (Throwable throwable) {
                    StoreManager.cleanup(stmt, conn);
                    throw throwable;
                }
            }
            StoreManager.cleanup(stmt, conn);
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public HashMap getCurrentValue(String processInstId, HashMap data) throws WfException {
        if (processInstId == null || processInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        HashMap result = this.getCurrentValue(processInstId, data, DataTypeEnum.RUNTIME);
        if (result == null || result.size() == 0) {
            result = this.getCurrentValue(processInstId, data, DataTypeEnum.HISTORY);
        }
        return result;
    }

    public HashMap getCurrentValue(String processInstId, HashMap data, boolean queryHistory) throws WfException {
        if (processInstId == null || processInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        HashMap returnValue = this.getCurrentValue(processInstId, data);
        if (queryHistory && returnValue == null) {
            returnValue = this.getCurrentValue(processInstId, data, DataTypeEnum.HISTORY);
        }
        return returnValue;
    }

    public ProcInstDataInfo getProcInstDataInfo(BOSUuid procInstDataID) throws WfException {
        ProcInstDataInfo procInstDataInfo = null;
        try {
            String oql = "WHERE procInstID = '" + procInstDataID.toString() + "' ";
            procInstDataInfo = this.getProcInstDataInfo(oql);
            if (procInstDataInfo == null) {
                procInstDataInfo = this.getProcInstDataInfo_Hst(oql);
            }
        }
        catch (DataAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        return procInstDataInfo;
    }
}

