/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.listener;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.store.listener.DefaultDataFilter;
import com.kingdee.bos.workflow.store.listener.IDataChangedListener;
import com.kingdee.bos.workflow.store.listener.IDataProvider;
import com.kingdee.bos.workflow.store.util.StoreUtil;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.WfDbUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class AbstractDataProvider
implements IDataProvider {
    private Vector listeners;
    private boolean changed = false;
    private boolean enableListen = false;
    private EngineConfig config;
    protected Context innerContext;
    private static IDataChangedListener eaiAdapter = AbstractDataProvider.initEAIAdapterListener();

    public AbstractDataProvider(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context can not be null!");
        }
        this.innerContext = context;
        this.config = EngineConfig.getInstance();
        this.enableListen = this.config.isEnableWorkflowDataListen();
        this.listeners = new Vector();
        this.registerListener(eaiAdapter);
    }

    @Override
    public synchronized void registerListener(IDataChangedListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public synchronized void removeListener(IDataChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyObservers(IObjectValue object) {
        if (this.isEnableListen() && this.fillFilter(object)) {
            Object[] listenersLocal;
            AbstractDataProvider abstractDataProvider = this;
            synchronized (abstractDataProvider) {
                if (!this.changed) {
                    return;
                }
                listenersLocal = this.listeners.toArray();
                this.clearChanged();
            }
            for (int i = listenersLocal.length - 1; i >= 0; --i) {
                ((IDataChangedListener)listenersLocal[i]).dataChanged(object);
            }
        }
    }

    private boolean fillFilter(IObjectValue object) {
        DefaultDataFilter filter = new DefaultDataFilter(this.config);
        return filter.filter(object);
    }

    public synchronized void deleteObservers() {
        this.listeners.removeAllElements();
    }

    protected synchronized void setDataChanged(IObjectValue object) {
        this.changed = true;
        this.notifyObservers(object);
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countObservers() {
        return this.listeners.size();
    }

    public boolean isEnableListen() {
        return this.enableListen && this.getContext().get((Object)"eaiInvoke") == null;
    }

    private static IDataChangedListener initEAIAdapterListener() {
        IDataChangedListener eaiListener = null;
        return eaiListener;
    }

    protected void notifyDataChangedByProcInstId(String procInstId, String methodName, Class[] paramTypes, Object[] params) {
        if (this.isEnableListen()) {
            ProcessDef def = StoreUtil.getProcessDefByProcInstId(procInstId, this.getContext());
            this.setDataChanged(StoreUtil.generateTransDataByProcessDef(this, this.getContext(), methodName, paramTypes, params, def));
        }
    }

    protected void notifyDataChangeByProcInstIdAndBOSType(String procInstId, String methodName, Class[] paramTypes, Object[] params, BOSObjectType type) {
        if (this.isEnableListen()) {
            ProcessDef def = StoreUtil.getProcessDefByProcInstId(procInstId, this.getContext());
            this.setDataChanged(StoreUtil.generateTransDataByProcessDefAndBOSType(this, this.getContext(), methodName, paramTypes, params, def, type));
        }
    }

    protected void notifyDataChangedByProcDefId(String procDefId, String methodName, Class[] paramTypes, Object[] params) {
        if (this.isEnableListen()) {
            ProcessDefInfo def = StoreUtil.getProcessDefInfoByID(procDefId, this.getContext());
            this.setDataChanged(StoreUtil.generateTransDataByProcessDefInfo(this, this.getContext(), methodName, paramTypes, params, def));
        }
    }

    protected void notifyDataChangedByProcDefIdByDao(String procDefId, String methodName, BOSObjectType daoType, Object[] params) {
        if (this.isEnableListen()) {
            ProcessDefInfo def = StoreUtil.getProcessDefInfoByID(procDefId, this.getContext());
            this.setDataChanged(StoreUtil.generateDaoDataByProcDef(this, this.getContext(), methodName, daoType, params, def));
        }
    }

    public Context getContext() {
        return this.innerContext;
    }

    public void setContext(Context ctx) {
        this.innerContext = ctx;
    }

    public Connection getConnection() throws SQLException {
        return WfDbUtil.getConnection((Context)this.innerContext);
    }
}

