/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.enactment.queue.impl.WfTransQueueEntry;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.transaction.IWfMutexPolicy;
import com.kingdee.bos.workflow.transaction.WfMutexInfo;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.WorkflowClusterConfig;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WfProcessMutexAcquirePolicy
implements IWfMutexPolicy {
    private final WfTxContext wfContext;
    private final WfTxInvocationDesc invocationDesc;

    public WfProcessMutexAcquirePolicy(WfTxInvocationDesc invocationDesc, WfTxContext wfContext) {
        this.invocationDesc = invocationDesc;
        this.wfContext = wfContext;
    }

    @Override
    public void execute() throws WfException {
        List list;
        if (WorkflowClusterConfig.getInstance().isGroupType() && (list = this.invocationDesc.getMutexObjects()) != null && !list.isEmpty()) {
            String[] mutexProcessIDs = this.getProcessIDs(list);
            WfMutexInfo[] wfMutexInfos = this.tryAcquireMutexes(mutexProcessIDs);
            if (this.wfContext.isTopTx()) {
                this.unloadCache(wfMutexInfos);
            }
        }
    }

    private String[] getProcessIDs(List listMutexObjects) throws WfException {
        WfEngine engine = WfEngine.getEngine(this.wfContext.getContext());
        ArrayList<String> retValue = new ArrayList<String>();
        int size = listMutexObjects.size();
        for (int i = 0; i < size; ++i) {
            Object object = listMutexObjects.get(i);
            String objectID = null;
            if (object instanceof WfBizEvent) {
                WfBizEvent bizEvent = (WfBizEvent)object;
                if (!StringUtils.isEmpty((String)bizEvent.getAssignmentId())) {
                    objectID = bizEvent.getAssignmentId();
                }
            } else if (object instanceof WfTransQueueEntry) {
                WfTransQueueEntry entry = (WfTransQueueEntry)object;
                objectID = entry.getProcInstId();
            } else if (object instanceof String) {
                objectID = (String)object;
            }
            if (StringUtils.isEmpty(objectID) || !BOSUuid.isValid((String)objectID, (boolean)false)) continue;
            BOSObjectType type = BOSUuid.read((String)objectID).getType();
            if (this.isAssignmentType(type)) {
                WfAssignment assignment = engine.getAssignment(objectID);
                retValue.add(assignment.getProcInstId());
                continue;
            }
            if (this.isActivityType(type)) {
                WfActivity activity = engine.getActivityInst(objectID);
                retValue.add(activity.getProcInstId());
                continue;
            }
            if (!this.isProcessType(type)) continue;
            retValue.add(objectID);
        }
        return retValue.toArray(new String[retValue.size()]);
    }

    private void unloadCache(WfMutexInfo[] wfMutexInfos) throws WfException {
        HashSet<String> mutexProcessIDs = new HashSet<String>();
        int size = wfMutexInfos.length;
        for (int i = 0; i < size; ++i) {
            WfMutexInfo mutexInfo = wfMutexInfos[i];
            if (!mutexInfo.getServerKey().equals(mutexInfo.getLastServerKey())) continue;
            mutexProcessIDs.add(wfMutexInfos[i].getObjectID());
        }
        if (!mutexProcessIDs.isEmpty()) {
            Set transactionProcesses;
            Set transactionActivitys;
            WfEngine engine = WfEngine.getEngine(this.wfContext.getContext());
            IWfCacheManager cacheManager = engine.getCacheManager();
            Set assignmentIds = this.wfContext.getTxAssignmentMgr().getTxAssignmentIDs();
            if (assignmentIds != null && assignmentIds.size() > 0) {
                for (String assignmentId : assignmentIds) {
                    WfAssignment wfAssignment;
                    if (StringUtils.isEmpty((String)assignmentId) || !mutexProcessIDs.contains((wfAssignment = engine.getAssignment(assignmentId)).getProcInstId())) continue;
                    cacheManager.removeAssignment(assignmentId);
                }
            }
            if ((transactionActivitys = this.wfContext.getTxActivityMgr().getTxActivityIDs()) != null && transactionActivitys.size() > 0) {
                for (String transactionActivityId : transactionActivitys) {
                    WfActivity wfActivity;
                    if (StringUtils.isEmpty((String)transactionActivityId) || !mutexProcessIDs.contains((wfActivity = engine.getActivityInst(transactionActivityId)).getProcInstId())) continue;
                    cacheManager.removeAssignment(transactionActivityId);
                }
            }
            if ((transactionProcesses = this.wfContext.getTxProcessMgr().getTxProcessIDs()) != null && transactionProcesses.size() > 0) {
                for (String procInstId : transactionProcesses) {
                    if (!mutexProcessIDs.contains(procInstId)) continue;
                    cacheManager.removeProcessInst(procInstId);
                }
            }
        }
    }

    private boolean isAssignmentType(BOSObjectType type) {
        return WfBOSObjectTypeUtil.ASSIGNMENTBOT.equals((Object)type);
    }

    private boolean isActivityType(BOSObjectType type) {
        return WfBOSObjectTypeUtil.ACTIVITYINSTBOT.equals((Object)type);
    }

    private boolean isProcessType(BOSObjectType type) {
        return WfBOSObjectTypeUtil.PROCESSINSTBOT.equals((Object)type);
    }

    private WfMutexInfo[] tryAcquireMutexes(String[] mutexProcessIDs) throws WfException {
        return this.wfContext.getMutexManager().tryAcquireMutexes(mutexProcessIDs);
    }
}

