/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.security.IPermissionProvider;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.wfdesigner.service.IPermissionHelper;
import org.apache.log4j.Logger;

public class PermissionHelper
extends AbstractBOSObject
implements IPermissionHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.wfdesigner.service.PermissionHelper");
    IPermissionProvider _provider = this.loadPermissionProvider();

    public PermissionHelper() {
        super.registerInterface(IPermissionHelper.class, (Object)this);
    }

    public PermissionHelper(Context context) {
        super.registerInterface(IPermissionHelper.class, (Object)this);
    }

    private IPermissionProvider loadPermissionProvider() {
        String sPermissionProviderClassName = EngineConfig.getInstance().getPermissionProvider();
        if (sPermissionProviderClassName != null) {
            try {
                Class<?> sPermissionProviderClass = Class.forName(sPermissionProviderClassName);
                IPermissionProvider myPermissionProvider = (IPermissionProvider)sPermissionProviderClass.newInstance();
                return myPermissionProvider;
            }
            catch (IllegalAccessException ex1) {
                logger.error((Object)"PermissionProvider init error", (Throwable)ex1);
                return null;
            }
            catch (InstantiationException ex1) {
                logger.error((Object)"PermissionProvider init error", (Throwable)ex1);
                return null;
            }
            catch (ClassNotFoundException ex1) {
                logger.error((Object)"PermissionProvider init error", (Throwable)ex1);
                return null;
            }
        }
        return null;
    }

    public PermissionItemCollection getPermissionItemsCol() throws BOSException {
        return this._provider.getPermissionItemCol(this.getContext());
    }

    public BOSObjectType getType() {
        return BOSObjectType.create((String)"WFPM");
    }
}

