/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.adapter;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.transaction.SnapshotRecorder;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Synchronizer;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.UUID;

public final class ActivitySynchronizer
implements Synchronizer {
    public static final ActivitySynchronizer INS = new ActivitySynchronizer();

    public void begin(Execution<? extends Node> e, boolean reenter) throws Exception {
        WfActivity act;
        if (reenter || Util.activityIsCreated(e)) {
            act = Util.getWfActivity(e);
            act.setPreActInstIds(e.getPriorExecutionIds());
        } else {
            ActivityDef def = Util.getDefine((VariableScope)e.getDefine());
            act = this.createActivityInst(e, def);
        }
        String priors = act.getMeta().getActInstInfo().getPreActInstList();
        if (priors != null && priors.length() > 0) {
            for (String actId : priors.split(",")) {
                WfActivity from = Util.getWfActivity((FlowContext)e.getContext(), (String)actId);
                from.innerAddPostActivity(e.getId());
            }
        }
    }

    private WfActivity createActivityInst(Execution<? extends Node> e, ActivityDef def) throws WfException {
        String fromActInst;
        String parentActInstId;
        ActivityDef actDef = def;
        String ids = e.getPriorExecutionIds();
        String[] fromActInstList = ids == null ? null : ids.split(",");
        Execution parent = e.getParent();
        String string = parentActInstId = parent.getParent() == null ? null : parent.getId();
        if (fromActInstList == null && !StringUtils.isEmpty((String)(fromActInst = (String)e.getProperty("$appendpreActinId$")))) {
            fromActInstList = new String[]{fromActInst};
        }
        WfProcess process = Util.getWfProcess(e);
        WfActivity act = process.innerCreateActivityInst(e.getId(), actDef, fromActInstList, parentActInstId);
        if (e.getProperty("$IsTransBack") != null) {
            process.getProcessContext().putDataFieldValue("$TransBack-" + act.getId(), (Object)"true");
        }
        if (parentActInstId != null) {
            String group = Util.getAppendedGroup(e);
            SnapshotRecorder recorder = SnapshotRecorder.create();
            ActInstInfo info = act.getMeta().getActInstInfo();
            recorder.snapshoot((AbstractObjectValue)info);
            info.setGroupName(group);
            String actDefName = (String)e.getProperty("actDefName");
            if (actDefName != null) {
                act.getMeta().setActDefName(LocaleUtils.locale_l1, actDefName);
                act.getMeta().setActDefName(LocaleUtils.locale_l2, actDefName);
                act.getMeta().setActDefName(LocaleUtils.locale_l3, actDefName);
            }
            recorder.snapshoot((AbstractObjectValue)info);
            recorder.recordSnapshots();
        }
        Util.bind((WfActivity)act, e);
        return act;
    }

    public void complete(Execution<? extends Node> e) throws Exception {
        if (ActivitySynchronizer.isClosed(e)) {
            return;
        }
        Util.getWfActivity(e).innerComplete();
    }

    public void terminate(Execution<? extends Node> e) throws Exception {
        if (ActivitySynchronizer.isClosed(e)) {
            return;
        }
        WfActivity act = Util.getWfActivity(e);
        if (Util.isJumped(e)) {
            act.innerTerminate();
        } else {
            act.innerAbort();
        }
    }

    public void delivered(Execution<? extends Node> e) throws Exception {
        if (ActivitySynchronizer.isClosed(e)) {
            return;
        }
        Util.getWfActivity(e).innerTerminate();
    }

    public static boolean isClosed(Execution<? extends Node> e) throws Exception {
        WfActivity act = Util.getWfActivity(e);
        return act.state().startsWith("closed");
    }

    public void fail(Execution<? extends Node> e) throws Exception {
        if (ActivitySynchronizer.isClosed(e)) {
            return;
        }
        Util.getWfActivity(e).innerSuspend();
    }

    public void resume(Execution<? extends Node> e) throws Exception {
        if (ActivitySynchronizer.isClosed(e)) {
            return;
        }
        Util.getWfActivity(e).innerResume();
    }

    public void retry(Execution<? extends Node> e) throws Exception {
        if (ActivitySynchronizer.isClosed(e)) {
            return;
        }
        Util.getWfActivity(e).innerResume();
    }

    public void suspend(Execution<? extends Node> e) throws Exception {
        if (ActivitySynchronizer.isClosed(e)) {
            return;
        }
        Util.getWfActivity(e).innerSuspend();
    }

    public String newId(VariableScope define) {
        ActivityDef def = Util.getDefine((VariableScope)define);
        if (def == null) {
            return null;
        }
        return UUID.randomUUID().toString() + WfBOSObjectTypeUtil.ACTIVITYINSTBOT.toString();
    }

    public String name() {
        return "bos-flow-sync";
    }
}

