/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.enactment.ToolActivityRunner;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfRuntimeStat;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Application;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class ToolActivityInvoker
implements Application {
    private static final Logger logger = Logger.getLogger(ToolActivityInvoker.class);

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution<? extends Node> e) throws Exception {
        WfActivity act = Util.getWfActivity(e);
        if (!act.isInited()) {
            act.setInited();
        }
        WfRuntimeStat.incCurrentBizCount();
        try {
            ToolActivityRunner runner = new ToolActivityRunner(act);
            long startTimeMilis = System.currentTimeMillis();
            runner.invoke();
            act.saveActRuntime();
            this.recordBizTime(act, startTimeMilis);
        }
        catch (Exception x) {
            WfRuntimeStat.incBizErrorCount();
            throw x;
        }
        finally {
            WfRuntimeStat.decCurrentBizCount();
        }
    }

    private void recordBizTime(WfActivity act, long startTimeMilis) {
        try {
            long endTimeMilis = System.currentTimeMillis();
            if (endTimeMilis - startTimeMilis < 1000L) {
                return;
            }
            ActivityDef activityDef = act.getDefinition();
            String actInstId = act.getId();
            String actDefName = act.getName();
            if (actDefName != null && actDefName.length() > 50) {
                actDefName = actDefName.substring(0, 50);
            }
            String procInstId = act.getProcInstId();
            ToolActivityDef innerActivityDef = (ToolActivityDef)activityDef;
            ApplicationDef applicationDef = innerActivityDef.getRelatedApplication();
            FunctionDef functionDef = applicationDef.getFunction();
            String functionName = "";
            String bizOperation = "";
            if (functionDef != null) {
                functionName = functionDef.getPackageName() + "." + functionDef.getName();
                if (functionName != null && functionName.length() > 100) {
                    functionName.substring(0, 100);
                }
                if ((bizOperation = functionDef.getOperation()) != null && bizOperation.length() > 50) {
                    bizOperation.substring(0, 50);
                }
            }
            if (!StringUtils.isEmpty((String)bizOperation)) {
                bizOperation = "." + bizOperation;
            }
            functionName = functionName + bizOperation;
            this.insertIntoDB(act, actInstId, actDefName, procInstId, functionName, bizOperation, startTimeMilis, endTimeMilis);
        }
        catch (Throwable t) {
            logger.error((Object)"recordBizTime error", t);
        }
    }

    private void insertIntoDB(WfActivity act, String actInstId, String actDefName, String procInstId, String functionName, String bizOperation, long startTimeMilis, long endTimeMilis) throws BOSException {
        String sql = "INSERT INTO T_WFR_BIZRECORD (FID,FACTINSTID, FPROCINSTID,FSTARTTIME, FENDTIME,FCOSTTIME,FFUNCNAME, FOPERATION, FACTNAME)  values  (?,?, ?, ?, ?, ?, ?, ?, ?); ";
        int[] types = new int[]{12, 12, 12, 91, 91, 3, 12, 12, 12};
        Timestamp startTime = new Timestamp(startTimeMilis);
        Timestamp endTime = new Timestamp(endTimeMilis);
        double costTime = (double)(endTimeMilis - startTimeMilis) / 1000.0;
        DecimalFormat myformat = new DecimalFormat("#.00");
        BigDecimal cost = new BigDecimal(myformat.format(costTime));
        String id = Uuid.create().toString() + "BIZRCORD";
        Object[] values = new Object[]{id, actInstId, procInstId, startTime, endTime, cost, functionName, bizOperation, actDefName};
        SQL.executeUpdate((Context)act.getContext(), (String)sql, (int[])types, (Object[])values);
    }
}

