/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.adr.common.util;

import com.kingdee.bos.Context;
import com.kingdee.portal.plt.adr.module.dto.ContactsInfo;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExportAdrUtil {
    public static HSSFWorkbook exportExcel(Context context, ArrayList<ContactsInfo> list) {
        HSSFWorkbook workbook = null;
        try {
            workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet("\u901a\u8baf\u5f55");
            ExportAdrUtil.setSheetColumnWidth(sheet);
            HSSFCellStyle style = ExportAdrUtil.createTitleStyle(workbook);
            if (list != null && !list.isEmpty()) {
                HSSFRow row = sheet.createRow(0);
                ExportAdrUtil.createCell(row, 0, style, 1, "\u5458\u5de5\u7f16\u7801");
                ExportAdrUtil.createCell(row, 1, style, 1, "\u59d3\u540d");
                ExportAdrUtil.createCell(row, 2, style, 1, "\u90e8\u95e8");
                ExportAdrUtil.createCell(row, 3, style, 1, "\u804c\u4f4d");
                ExportAdrUtil.createCell(row, 4, style, 1, "\u529e\u516c\u7535\u8bdd");
                ExportAdrUtil.createCell(row, 5, style, 1, "\u624b\u673a\u53f7\u7801");
                ExportAdrUtil.createCell(row, 6, style, 1, "\u7535\u5b50\u90ae\u7bb1");
                for (int i = 0; i < list.size(); ++i) {
                    ContactsInfo linkMan = list.get(i);
                    HSSFRow row1 = sheet.createRow((int)((short)(i + 1)));
                    ExportAdrUtil.createCell(row1, 0, style, 1, linkMan.getNumber());
                    ExportAdrUtil.createCell(row1, 1, style, 1, linkMan.getName());
                    ExportAdrUtil.createCell(row1, 2, style, 1, linkMan.getDepName());
                    ExportAdrUtil.createCell(row1, 3, style, 1, linkMan.getPosition());
                    ExportAdrUtil.createCell(row1, 4, style, 1, linkMan.getOfficePhone());
                    ExportAdrUtil.createCell(row1, 5, style, 1, linkMan.getMobile());
                    ExportAdrUtil.createCell(row1, 6, style, 1, linkMan.getEmail());
                }
            } else {
                ExportAdrUtil.createCell(sheet.createRow(0), 0, style, 1, "\u67e5\u65e0\u8d44\u6599");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    private static void setSheetColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth((short)0, (short)3000);
        sheet.setColumnWidth((short)1, (short)3000);
        sheet.setColumnWidth((short)2, (short)8000);
        sheet.setColumnWidth((short)3, (short)5000);
        sheet.setColumnWidth((short)4, (short)5000);
        sheet.setColumnWidth((short)5, (short)5000);
        sheet.setColumnWidth((short)6, (short)8000);
    }

    private static void createCell(HSSFRow row, int column, HSSFCellStyle style, int cellType, Object value) {
        HSSFCell cell = row.createCell((short)column);
        if (style != null) {
            cell.setCellStyle(style);
        }
        switch (cellType) {
            case 3: {
                break;
            }
            case 1: {
                if (value != null) {
                    cell.setCellValue(value.toString());
                    break;
                }
                cell.setCellValue("");
                break;
            }
            case 0: {
                cell.setCellType(0);
                if (value != null) {
                    try {
                        cell.setCellValue(Double.parseDouble(value.toString()));
                    }
                    catch (Exception e) {
                        cell.setCellValue("");
                    }
                    break;
                }
                cell.setCellValue("");
                break;
            }
        }
    }

    private static HSSFCellStyle createTitleStyle(HSSFWorkbook wb) {
        HSSFFont boldFont = wb.createFont();
        boldFont.setFontHeight((short)200);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFont(boldFont);
        return style;
    }
}

