/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.adr.module.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.adr.AdrTypeFactory;
import com.kingdee.eas.cp.adr.ContactCollection;
import com.kingdee.eas.cp.adr.ContactFactory;
import com.kingdee.eas.cp.adr.ContactInfo;
import com.kingdee.eas.cp.adr.ContactSetCollection;
import com.kingdee.eas.cp.adr.ContactSetFactory;
import com.kingdee.eas.cp.adr.ContactSetInfo;
import com.kingdee.eas.cp.adr.IAdrType;
import com.kingdee.eas.cp.adr.IContact;
import com.kingdee.eas.cp.adr.IContactSet;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.PersonContactMethodCollection;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.adr.common.util.ContactsUtil;
import com.kingdee.portal.plt.adr.common.util.ExportAdrUtil;
import com.kingdee.portal.plt.adr.module.dto.ContactsInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class PublicAdrAction
extends BaseAction {
    public String adrManager() {
        return "success";
    }

    public void loadCUTree() {
        String rootFlag = this.getRequest().getParameter("rootFlag");
        String parentId = this.getRequest().getParameter("id");
        JSONArray cuTreeList = this.getCUTreeNode(rootFlag, parentId);
        this.writeAjaxData(true, null, cuTreeList);
    }

    public void getchildNode() {
        String cuId = this.getRequest().getParameter("cuId");
        JSONArray NodeTree = this.getCUTreeNode(null, cuId);
        this.writeAjaxData(true, null, NodeTree);
    }

    public void getParentNode() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String nodeId = this.getRequest().getParameter("nodeId");
        String sql = this.getParentNodeSql(nodeId);
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (dataSet != null) {
                JSONObject obj = null;
                while (dataSet.next()) {
                    String id = dataSet.getString("ID");
                    if (StringUtil.isEmpty((String)id)) continue;
                    obj = new JSONObject();
                    obj.put((Object)"name", (Object)dataSet.getString("NAME"));
                    obj.put((Object)"id", (Object)id);
                    obj.put((Object)"nLevel", (Object)dataSet.getInt("LEVEL_"));
                }
                this.writeAjaxData(true, null, obj);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(true, this.handleErr((Exception)((Object)e)), null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void getStaffInfoByCuId() {
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        boolean fullPath = false;
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String cuId = this.getRequest().getParameter("cuId");
        String keyWord = this.getRequest().getParameter("keyWord");
        if (!StringUtil.isEmpty((String)keyWord)) {
            fullPath = true;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("cuId", cuId);
        param.put("keyWord", keyWord);
        String countsql = this.getSQLString(param, true);
        String sql = this.getSQLString(param, false);
        try {
            IRowSet countSet = DbUtil.executeQuery((Context)ctx, (String)countsql);
            if (countSet != null) {
                countSet.next();
            }
            if (pageNo > (totalPage = ((total = countSet.getInt("ccc")) - 1) / pageSize + 1)) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (int)((pageNo - 1) * pageSize), (int)pageSize);
            ArrayList<ContactsInfo> list = new ArrayList<ContactsInfo>();
            String flongnumber = "";
            if (ContextUtil.getCurrentAdminUnit((Context)ctx) != null) {
                flongnumber = ContextUtil.getCurrentAdminUnit((Context)ctx).getLongNumber();
            }
            while (dataSet.next()) {
                ContactsInfo contact = new ContactsInfo();
                String SourceFrom = dataSet.getString("SourceFrom");
                String id = dataSet.getString("ID");
                if ("0".equals(SourceFrom)) {
                    contact.setId(id);
                    boolean flat = this.isInUserGroup(id);
                    contact.setAdded(flat);
                    String department = ContactsUtil.getDepartment(ctx, flongnumber, id, fullPath);
                    contact.setDepName(department);
                    String position = ContactsUtil.getPosition(ctx, flongnumber, id);
                    contact.setPosition(position);
                } else {
                    contact.setDepName(dataSet.getString("company"));
                    contact.setPosition(dataSet.getString("place"));
                }
                contact.setNumber(dataSet.getString("NUMBER_"));
                contact.setName(dataSet.getString("NAME"));
                contact.setMobile(dataSet.getString("PCMMOBILE"));
                contact.setOfficePhone(dataSet.getString("PCMOFFICEPHONE"));
                contact.setEmail(dataSet.getString("PCMEMAIL"));
                contact.setIsHide(dataSet.getString("CONTACTSETISHIDDEN"));
                contact.setSourceFrom(dataSet.getString("SourceFrom"));
                list.add(contact);
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String getSQLString(Map<String, String> param, boolean isSelectCount) {
        String keyWord;
        String cuNumber;
        String cuId;
        boolean isAdmin = this.hasFunctionPermission("cp_adr_Admin_Update", null);
        StringBuffer sql = new StringBuffer();
        if (isSelectCount) {
            sql.append("select COUNT(ID) as ccc from( ");
        }
        sql.append("SELECT DISTINCT ");
        sql.append("PERSON.FID AS ID,");
        sql.append("PERSON.FNumber AS NUMBER_,");
        sql.append("PERSON.FName_l2 AS NAME,");
        sql.append("PCM.FEmail AS PCMEMAIL,");
        sql.append("PCM.FOfficePhone AS PCMOFFICEPHONE,");
        sql.append("PCM.FMobile AS PCMMOBILE,");
        sql.append("PERSON.FIndex AS INDEXOF,");
        sql.append("CONTACTSET.FisHidden AS CONTACTSETISHIDDEN,");
        sql.append("'0' AS SourceFrom,");
        sql.append("null AS company,");
        sql.append("null AS place ");
        sql.append("FROM T_BD_Person AS PERSON ");
        sql.append("INNER JOIN T_ORG_PositionMember AS PM ");
        sql.append("ON PERSON.FID = PM.FPersonID ");
        sql.append("LEFT OUTER JOIN T_HR_PersonContactMethod AS PCM ");
        sql.append("ON PERSON.FID = PCM.FPersonID ");
        sql.append("LEFT OUTER JOIN T_HR_BDEmployeeType AS EMPTYPE ");
        sql.append("ON PERSON.FEmployeeTypeID = EMPTYPE.FID ");
        sql.append("INNER JOIN T_ORG_CtrlUnit AS CU ");
        sql.append("ON PERSON.FControlUnitID = CU.FID ");
        sql.append("LEFT OUTER JOIN T_ADR_ContactSet AS CONTACTSET ");
        sql.append("ON PCM.FID = CONTACTSET.FPersonMethodIdID ");
        sql.append("INNER JOIN T_ORG_Position AS POSITION ");
        sql.append("ON PM.FPositionID = POSITION.FID ");
        sql.append("INNER JOIN T_ORG_Admin AS ADMIN ");
        sql.append("ON POSITION.FAdminOrgUnitID = ADMIN.FID ");
        sql.append("INNER JOIN T_ORG_CtrlUnit AS CU2 ");
        sql.append("ON ADMIN.FControlUnitID = CU2.FID ");
        sql.append("WHERE EMPTYPE.FinService NOT IN (0, 2, 3) AND PERSON.FDeletedStatus = 1 ");
        if (!isAdmin) {
            sql.append(" AND (CONTACTSET.FisHidden='1' or CONTACTSET.FisHidden  is null )");
        }
        if (!StringUtil.isEmpty((String)(cuId = param.get("cuId")))) {
            sql.append("and ADMIN.Fid='").append(cuId).append("'");
        }
        if (!StringUtil.isEmpty((String)(cuNumber = param.get("cuNumber")))) {
            sql.append("and ADMIN.FLongNumber like '%").append(cuNumber).append("%'");
        }
        if (!StringUtil.isEmpty((String)(keyWord = param.get("keyWord")))) {
            sql.append("and (");
            sql.append("PERSON.FName_l2 like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or PERSON.FFullNamePingYin like '%");
            sql.append(keyWord.toLowerCase());
            sql.append("%' ");
            sql.append("or PERSON.FSimpleNamePingYin like '%");
            sql.append(keyWord.toLowerCase());
            sql.append("%' ");
            sql.append("or POSITION.FName_l2 like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or PCM.FEmail like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or PCM.FBackupEMail like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or PCM.FMobile like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or PCM.FBackupMobile like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or PCM.FOfficePhone like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or PCM.FBackupOfficePhone like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or ADMIN.FName_L2 like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append(") ");
            sql.append(" union all  ");
            sql.append(this.getPersonSQLString(param));
        }
        if (!isSelectCount) {
            sql.append(" ORDER BY INDEXOF ASC ,NUMBER_ ASC");
        } else {
            sql.append(" ) as AAA");
        }
        return sql.toString();
    }

    private String getPersonSQLString(Map<String, String> param) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo personInfo = userInfo.getPerson();
        String userId = "";
        if (personInfo != null) {
            userId = personInfo.getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT ");
        sql.append("Contact.FID AS ID,");
        sql.append("null AS NUMBER,");
        sql.append("Contact.FName_L2 AS NAME,");
        sql.append("Contact.FEmail AS PCMEMAIL, ");
        sql.append("Contact.FOfficePhone AS PCMOFFICEPHONE,");
        sql.append("Contact.FMobliePhone AS PCMMOBILE,");
        sql.append("9999 AS INDEXOF,");
        sql.append("null AS CONTACTSETISHIDDEN,");
        sql.append("'1' AS SourceFrom,");
        sql.append("Contact.FCompany AS company,");
        sql.append("Contact.FPlace AS place ");
        sql.append("from T_ADR_Contact As Contact where (fsourceFrom=1 or fsourcefrom is null) ");
        sql.append("and Contact.FUserId='");
        sql.append(userId);
        sql.append("' ");
        String keyWord = param.get("keyWord");
        if (!StringUtil.isEmpty((String)keyWord)) {
            sql.append("and (");
            sql.append("Contact.FName_L2 like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or Contact.FFullNamePingYin like '%");
            sql.append(keyWord.toLowerCase());
            sql.append("%' ");
            sql.append("or Contact.FSimpleNamePingYin like '%");
            sql.append(keyWord.toLowerCase());
            sql.append("%' ");
            sql.append("or Contact.FPlace like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or Contact.FCompany like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or Contact.FEmail like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or Contact.FMobliePhone like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append("or Contact.FOfficePhone like '%");
            sql.append(keyWord);
            sql.append("%' ");
            sql.append(") ");
        }
        return sql.toString();
    }

    public String getParentNodeSql(String nodeId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("PARENT.FID AS ID,");
        sql.append("PARENT.FNumber AS NUMBER_,");
        sql.append("PARENT.FName_l2 AS NAME,");
        sql.append("PARENT.FLevel AS Level_,");
        sql.append("PARENT.FIsLeaf AS IsLeaf ");
        sql.append("FROM T_ORG_Admin AS A ");
        sql.append("INNER JOIN T_ORG_CtrlUnit AS CTRLUNIT ");
        sql.append("ON A.FControlUnitID = CTRLUNIT.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin AS PARENT ");
        sql.append("ON A.FParentID = PARENT.FID ");
        sql.append("LEFT OUTER JOIN T_HR_AdminOther AS ADMINOTHER ");
        sql.append("ON A.FID = ADMINOTHER.FAdminOrgUnitID ");
        sql.append("WHERE A.FIsSealUp = 0 ");
        sql.append("and A.FID ='");
        sql.append(nodeId);
        sql.append("'");
        return sql.toString();
    }

    public JSONArray getCUTreeNode(String rootFlag, String parentId) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("A.FID AS ID,");
        sql.append("A.FNumber AS NUMBER_,");
        sql.append("A.FName_l2 AS NAME,");
        sql.append("A.FLongNumber AS LONGNUMBER,");
        sql.append("A.FLevel AS NODELEVEL,");
        sql.append("A.FIsLeaf AS ISLEAF,");
        sql.append("A.FLevel AS LEVEL_,");
        sql.append("A.FIndex AS NODEINDEX,");
        sql.append("CTRLUNIT.FID AS CID,");
        sql.append("A.FParentID AS PID,");
        sql.append("CTRLUNIT.FLongNumber AS CLONGNUMBER,");
        sql.append("A.FDisplayName_l2 AS DISPLAYNAME ");
        sql.append("FROM T_ORG_Admin AS A ");
        sql.append("INNER JOIN T_ORG_CtrlUnit AS CTRLUNIT ");
        sql.append("ON A.FControlUnitID = CTRLUNIT.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin AS PARENT ");
        sql.append("ON A.FParentID = PARENT.FID ");
        sql.append("LEFT OUTER JOIN T_HR_AdminOther AS ADMINOTHER ");
        sql.append("ON A.FID = ADMINOTHER.FAdminOrgUnitID ");
        sql.append("WHERE A.FIsSealUp = 0 ");
        if ("true".equals(rootFlag)) {
            sql.append("and A.FLevel<=2 ");
        }
        if (!StringUtil.isEmpty((String)parentId)) {
            sql.append("and A.FParentID='").append(parentId).append("' ");
        }
        sql.append("ORDER BY A.FSortCode ASC,LONGNUMBER ASC");
        JSONArray cuTreeList = new JSONArray();
        boolean isFirstRoot = true;
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (dataSet.next()) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"name", (Object)dataSet.getString("NAME"));
                obj.put((Object)"id", (Object)dataSet.getString("ID"));
                obj.put((Object)"pId", (Object)dataSet.getString("PID"));
                obj.put((Object)"longNum", (Object)dataSet.getString("LONGNUMBER"));
                obj.put((Object)"nLevel", (Object)dataSet.getInt("LEVEL_"));
                int isLeaf = dataSet.getInt("ISLEAF");
                if (isLeaf == 1) {
                    obj.put((Object)"isParent", (Object)false);
                } else {
                    obj.put((Object)"isParent", (Object)true);
                }
                int level = dataSet.getInt("NODELEVEL");
                if (level == 1 && isFirstRoot) {
                    obj.put((Object)"open", (Object)true);
                    isFirstRoot = false;
                } else {
                    obj.put((Object)"open", (Object)false);
                }
                cuTreeList.add((Object)obj);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return cuTreeList;
    }

    public void getUserGroup() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        EntityViewInfo entity = new EntityViewInfo();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String countMark = this.getRequest().getParameter("countMark");
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.adr.app.AdrTypeQuery");
        MetaDataPK contactQueryPK = new MetaDataPK("com.kingdee.eas.cp.adr.app.ContactQuery");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo personInfo = userInfo.getPerson();
        String personId = null;
        IQueryExecutor exec = null;
        IQueryExecutor countExec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        personId = personInfo == null ? BOSUuid.create((BOSObjectType)new PersonInfo().getBOSType()).toString() : personInfo.getId().toString();
        try {
            entityViewInfo.setFilter("userId='" + personId + "'");
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            rowSet = exec.executeQuery();
            JSONArray userGroup = new JSONArray();
            if (rowSet != null) {
                while (rowSet.next()) {
                    int total = 0;
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"name", (Object)rowSet.getString("NAME"));
                    obj.put((Object)"id", (Object)rowSet.getString("ID"));
                    if (!StringUtil.isEmpty((String)countMark)) {
                        entity.setFilter("adrType.id='" + rowSet.getString("ID") + "' and userId='" + personInfo.getId() + "' ");
                        countExec = this.getQueryExecutor((IMetaDataPK)contactQueryPK, entity, ctx);
                        countRowSet = countExec.executeQuery();
                        while (countRowSet.next()) {
                            ++total;
                        }
                        obj.put((Object)"count", (Object)total);
                    }
                    userGroup.add((Object)obj);
                }
            }
            this.writeAjaxData(true, null, userGroup);
        }
        catch (ParserException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void addPersonAdr() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String personIds = this.getRequest().getParameter("personIds");
        String userGroupId = this.getRequest().getParameter("userGroupId");
        String[] idList = personIds.split(";");
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            PersonInfo personInfo = userInfo.getPerson();
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (personInfo != null) {
                boolean flat = this.isInUserGroup(personIds);
                if (!flat) {
                    IAdrType adrType = AdrTypeFactory.getLocalInstance((Context)ctx);
                    if (!StringUtil.isEmpty((String)userGroupId)) {
                        adrType.batchAddPerson(personInfo, (IObjectPK)new ObjectUuidPK(userGroupId), idList, cu.getId().toString());
                    } else {
                        adrType.batchAddPerson(personInfo, null, idList, cu.getId().toString());
                    }
                    this.writeAjaxData(true, null, null);
                } else {
                    this.writeAjaxData(false, null, null);
                }
            } else {
                this.writeAjaxData(false, null, "is not person!");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    private boolean isInUserGroup(String personIds) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo personInfo = userInfo.getPerson();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_ADR_Contact where FSourceUserID = '");
        sql.append(personIds);
        sql.append("' and FUserId='");
        sql.append(personInfo.getId().toString());
        sql.append("'");
        IRowSet countSet = null;
        try {
            countSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            return countSet != null && countSet.next();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void checkPermission() {
        boolean expor = this.hasFunctionPermission("cp_adr_Export_Update", null);
        boolean admin = this.hasFunctionPermission("cp_adr_Admin_Update", null);
        JSONObject obj = new JSONObject();
        obj.put((Object)"expor", (Object)expor);
        obj.put((Object)"admin", (Object)admin);
        this.writeAjaxData(true, null, obj);
    }

    private boolean hasFunctionPermission(String permissionKey, String cuID) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        String orgID = null;
        ObjectUuidPK orgPK = null;
        if (null == cuID) {
            orgID = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
            orgPK = new ObjectUuidPK(orgID);
        } else {
            orgPK = new ObjectUuidPK(cuID);
        }
        boolean permissionFlag = false;
        try {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            permissionFlag = service.hasPermission((IObjectPK)userPK, (IObjectPK)orgPK, permissionKey, true);
        }
        catch (Exception e) {
            permissionFlag = false;
        }
        return permissionFlag;
    }

    public void exportExcel() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        boolean expor = this.hasFunctionPermission("cp_adr_Export_Update", null);
        if (!expor) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        String cuId = this.getRequest().getParameter("cuId");
        if (StringUtil.isEmpty((String)cuId)) {
            return;
        }
        try {
            String numberSql = "select FNumber from T_ORG_Admin where FID='" + cuId + "'";
            IRowSet reultSet = DbUtil.executeQuery((Context)ctx, (String)numberSql.toString());
            String cuNumber = "000000";
            while (reultSet.next()) {
                cuNumber = reultSet.getString("FNumber");
            }
            param.put("cuNumber", cuNumber);
            String sql = this.getSQLString(param, false);
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<ContactsInfo> list = new ArrayList<ContactsInfo>();
            String flongnumber = "";
            if (ContextUtil.getCurrentAdminUnit((Context)ctx) != null) {
                flongnumber = ContextUtil.getCurrentAdminUnit((Context)ctx).getLongNumber();
            }
            while (dataSet.next()) {
                ContactsInfo contact = new ContactsInfo();
                String id = dataSet.getString("ID");
                contact.setId(id);
                boolean flat = this.isInUserGroup(id);
                contact.setAdded(flat);
                contact.setNumber(dataSet.getString("NUMBER_"));
                contact.setName(dataSet.getString("NAME"));
                String department = ContactsUtil.getDepartment(ctx, flongnumber, id, true);
                contact.setDepName(department);
                String position = ContactsUtil.getPosition(ctx, flongnumber, id);
                contact.setPosition(position);
                contact.setMobile(dataSet.getString("PCMMOBILE"));
                contact.setOfficePhone(dataSet.getString("PCMOFFICEPHONE"));
                contact.setEmail(dataSet.getString("PCMEMAIL"));
                list.add(contact);
            }
            HSSFWorkbook workbook = ExportAdrUtil.exportExcel(ctx, list);
            ServletOutputStream out = this.getResponse().getOutputStream();
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String fileName = "Contacts(" + sdf.format(date) + ").xls";
            this.getResponse().setHeader("Content-disposition", "attachment; filename=" + fileName);
            this.getResponse().setContentType("application/msexcel;charset=GB2312");
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setContactMethodConfig() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            HashSet<String> personDataSet = new HashSet<String>();
            boolean isShow = this.getRequest().getParameter("showState").equals("true");
            String personIds = this.getRequest().getParameter("personIds");
            String[] personId = personIds.split(";");
            if (personId.length > 0) {
                for (int i = 0; i < personId.length; ++i) {
                    personDataSet.add(personId[i]);
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("person.id", personDataSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                PersonContactMethodCollection psmc = PersonContactMethodFactory.getLocalInstance((Context)ctx).getPersonContactMethodCollection(viewInfo);
                PersonContactMethodInfo contactMethodInfo = null;
                HashMap<String, PersonContactMethodInfo> contactMap = new HashMap<String, PersonContactMethodInfo>();
                HashSet<String> contatctMethodIdSet = new HashSet<String>();
                int size = psmc.size();
                for (int i = 0; i < size; ++i) {
                    contactMethodInfo = psmc.get(i);
                    String contactMethodId = contactMethodInfo.getId().toString();
                    contatctMethodIdSet.add(contactMethodId);
                    contactMap.put(contactMethodId, contactMethodInfo);
                }
                IContactSet iContactSet = ContactSetFactory.getLocalInstance((Context)ctx);
                EntityViewInfo setView = new EntityViewInfo();
                FilterInfo filterSet = new FilterInfo();
                filterSet.getFilterItems().add(new FilterItemInfo("personMethodId.id", contatctMethodIdSet, CompareType.INCLUDE));
                setView.setFilter(filterSet);
                ContactSetCollection csc = iContactSet.getContactSetCollection(setView);
                ContactSetInfo setInfo = null;
                HashSet<String> existsIdSet = new HashSet<String>();
                HashSet<String> noExistsIdSet = new HashSet<String>();
                HashMap<String, ContactSetInfo> setMap = new HashMap<String, ContactSetInfo>();
                int size2 = csc.size();
                for (int i = 0; i < size2; ++i) {
                    setInfo = csc.get(i);
                    String methodInfoId = setInfo.getPersonMethodId().getId().toString();
                    existsIdSet.add(methodInfoId);
                    setMap.put(methodInfoId, setInfo);
                }
                for (String mId : contatctMethodIdSet) {
                    if (existsIdSet.contains(mId)) continue;
                    noExistsIdSet.add(mId);
                }
                ContactSetInfo csi = null;
                CoreBaseCollection container = new CoreBaseCollection();
                for (String key : existsIdSet) {
                    csi = (ContactSetInfo)setMap.get(key);
                    csi.setIsHidden(isShow);
                    container.add((CoreBaseInfo)csi);
                }
                for (String key : noExistsIdSet) {
                    PersonContactMethodInfo pcm = (PersonContactMethodInfo)contactMap.get(key);
                    csi = new ContactSetInfo();
                    csi.setPersonMethodId(pcm);
                    csi.setIsHidden(isShow);
                    container.add((CoreBaseInfo)csi);
                }
                iContactSet.save(container);
                this.writeAjaxData(true, null, null);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void getPersonMetaInfo() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String pId = this.getRequest().getParameter("pId");
        if (!StringUtil.isEmpty((String)pId)) {
            try {
                String flongnumber = "";
                if (ContextUtil.getCurrentAdminUnit((Context)ctx) != null) {
                    flongnumber = ContextUtil.getCurrentAdminUnit((Context)ctx).getLongNumber();
                }
                PersonInfo info = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(pId));
                ContactsInfo contact = new ContactsInfo();
                contact.setId(pId);
                contact.setName(info.getName());
                contact.setGender(info.getGender().getValue() == 1 ? "\u7537" : "\u5973");
                contact.setNumber(info.getNumber());
                contact.setMobile(info.getCell());
                contact.setEmail(info.getEmail());
                contact.setOfficePhone(info.getOfficePhone());
                contact.setPosition(ContactsUtil.getPosition(ctx, flongnumber, pId));
                contact.setDepName(ContactsUtil.getDepartment(ctx, flongnumber, pId, true));
                this.writeAjaxData(true, null, contact);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
        }
    }

    public void updatePersonMetaInfo() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String pId = this.getRequest().getParameter("pId");
        String mobile = this.getRequest().getParameter("mobile");
        String email = this.getRequest().getParameter("email");
        String officePhone = this.getRequest().getParameter("officePhone");
        try {
            PersonInfo info = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(pId));
            if (info != null && info.getId() != null) {
                IPerson person = PersonFactory.getLocalInstance((Context)ctx);
                info.setCell(mobile);
                info.setEmail(email);
                info.setOfficePhone(officePhone);
                person.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                IContact iContact = ContactFactory.getLocalInstance((Context)ctx);
                ContactCollection contactCollection = iContact.getContactCollection("select * where sourceuser.id = '" + pId + "'");
                if (contactCollection.size() > 0) {
                    ContactInfo contactInfo = contactCollection.get(0);
                    contactInfo.setOfficePhone(officePhone);
                    contactInfo.setMobliePhone(mobile);
                    contactInfo.setEmail(email);
                    iContact.update((IObjectPK)new ObjectUuidPK(contactInfo.getId()), (CoreBaseInfo)contactInfo);
                }
            } else {
                IUser user = UserFactory.getLocalInstance((Context)ctx);
                UserInfo userinfo = user.getUserInfo(ctx.getCaller());
                userinfo.setCell(mobile);
                userinfo.setEmail(email);
                userinfo.setOfficePhone(officePhone);
                user.update((IObjectPK)new ObjectUuidPK(userinfo.getId()), (CoreBaseInfo)userinfo);
            }
            this.writeAjaxData(true, null, null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

