/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cm.module.column.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.xt.XTUtil;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.cm.CMClassCollection;
import com.kingdee.eas.cp.eip.cm.CMClassFactory;
import com.kingdee.eas.cp.eip.cm.CMClassInfo;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMTemplateCollection;
import com.kingdee.eas.cp.eip.cm.CMTemplateFactory;
import com.kingdee.eas.cp.eip.cm.CMTemplateInfo;
import com.kingdee.eas.cp.eip.cm.ColumnTypeEnum;
import com.kingdee.eas.cp.eip.cm.ContentManageFactory;
import com.kingdee.eas.cp.eip.cm.ICMClass;
import com.kingdee.eas.cp.eip.cm.ICMTemplate;
import com.kingdee.eas.cp.eip.cm.IContentManage;
import com.kingdee.eas.cp.eip.cm.app.ProcesseInfo;
import com.kingdee.eas.cp.eip.cm.web.ColumnAndClassHandle;
import com.kingdee.eas.cp.eip.cm.web.ContentResourceHandle;
import com.kingdee.eas.cp.eip.cm.web.util.NewPortalUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseFileUploadAction;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.plt.cm.common.util.CMLicenseName;
import com.kingdee.portal.plt.cm.common.util.CmServiceLocator;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cm.module.column.dto.ClassDto;
import com.kingdee.portal.plt.cm.module.column.dto.ColumnDto;
import com.kingdee.portal.plt.cm.module.column.dto.FileModel;
import com.kingdee.portal.plt.cm.module.column.dto.RoleDto;
import com.kingdee.portal.plt.cm.module.column.dto.TreeDto;
import com.kingdee.portal.plt.cm.module.column.service.ColumnService;
import com.kingdee.portal.plt.cm.module.template.dto.CmTemplateDto;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ColumnManagerAction
extends BaseFileUploadAction {
    private static String licenseClassName = "com.kingdee.eas.cp.eip.cm.web.ColumnAndClassAction";
    private ColumnService columnService = (ColumnService)CmServiceLocator.getBean("columnService");

    public String columnManager() throws BOSException {
        boolean hasLicense = LicenseTool.checkLicense(this.getRequest(), CMLicenseName.licenseClassName);
        if (hasLicense) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
            boolean ifAdmin = iManage.ifCMAdmin();
            this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
            this.getRequest().setAttribute("ifAdmin", (Object)ifAdmin);
            return "success";
        }
        return "nolicense";
    }

    public void getColumnTree() {
        String needRoot = this.getRequest().getParameter("needRoot");
        String columnPerm = this.getRequest().getParameter("columnPerm");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        JSONArray result = null;
        ArrayList<TreeDto> treeNodes = new ArrayList<TreeDto>();
        try {
            IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
            ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
            IRowSet rowset = null;
            rowset = columnPerm.equals("admin") ? iManage.getAdminColumn() : (columnPerm.equals("read") ? iManage.getReadColumn() : (columnPerm.equals("edit") ? iManage.getEditColumn() : iManage.getAdminColumn()));
            if (needRoot.equals("true")) {
                TreeDto rootNode = new TreeDto();
                rootNode.setId("0");
                rootNode.setName("\u6240\u6709\u680f\u76ee\u5206\u7c7b");
                rootNode.setpId("00");
                rootNode.setOpen(true);
                rootNode.setType("clumn");
                treeNodes.add(rootNode);
            }
            TreeDto newArticleNode = new TreeDto();
            while (rowset.next()) {
                TreeDto treeColumnNode = new TreeDto();
                String columnId = rowset.getString(1);
                String columnName = rowset.getString(2);
                treeColumnNode.setId(columnId);
                treeColumnNode.setName(columnName);
                treeColumnNode.setpId("0");
                treeColumnNode.setOpen(false);
                treeColumnNode.setType("clumn");
                if (columnId.equals("tSFimQEREADgAAD5wKgSr7n/tuc=")) {
                    newArticleNode = treeColumnNode;
                    continue;
                }
                treeNodes.add(treeColumnNode);
                if (columnPerm.equals("edit")) {
                    IRowSet classRowSet = ContentManageFactory.getLocalInstance((Context)ctx).getAddDocClassByColumn(columnId);
                    ArrayList<String> adcLongNum = new ArrayList<String>();
                    ArrayList<String> adcId = new ArrayList<String>();
                    while (classRowSet.next()) {
                        String addDocClassId = classRowSet.getString(1);
                        String addDocClassLongNum = classRowSet.getString(3);
                        adcId.add(addDocClassId);
                        String[] longNums = addDocClassLongNum.split("!");
                        for (int i = 0; i < longNums.length; ++i) {
                            if (adcLongNum.contains(longNums[i])) continue;
                            adcLongNum.add(longNums[i]);
                        }
                    }
                    for (int j = 0; j < adcLongNum.size(); ++j) {
                        String longNum = (String)adcLongNum.get(j);
                        CMClassCollection addDocClass = iCMClass.getCMClassCollection("Where Number='" + longNum + "'");
                        if (addDocClass.size() <= 0) continue;
                        CMClassInfo classInfo = addDocClass.get(0);
                        TreeDto treeClassNode = this.classInfo2TreeDto(classInfo, columnId);
                        if (adcId.contains(classInfo.getId().toString())) {
                            treeClassNode.setPower(true);
                        } else {
                            treeClassNode.setPower(false);
                        }
                        treeNodes.add(treeClassNode);
                    }
                    continue;
                }
                CMClassCollection classCollection = iCMClass.getCMClassCollection("Where ColumnID='" + columnId + "' order by CreateTime asc ");
                int size = classCollection.size();
                for (int i = 0; i < size; ++i) {
                    CMClassInfo classInfo = classCollection.get(i);
                    TreeDto treeClassNode = this.classInfo2TreeDto(classInfo, columnId);
                    treeClassNode.setPower(true);
                    treeNodes.add(treeClassNode);
                }
            }
            treeNodes.add(newArticleNode);
            result = JSONArray.fromObject(treeNodes);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (treeNodes.size() == 0) {
            this.writeObjectData(null);
        } else {
            this.writeData2Response(result.toString());
        }
    }

    public void getTreeByColumnType() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String columnType = this.getRequest().getParameter("columnType");
        String columnPerm = this.getRequest().getParameter("columnPerm");
        JSONArray result = null;
        try {
            ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
            IRowSet rowSet = null;
            rowSet = columnPerm.equals("admin") ? this.getAdminColumn(ctx) : (columnPerm.equals("read") ? this.getReadColumn(ctx) : (columnPerm.equals("edit") ? this.getEditColumn(ctx) : this.getAdminColumn(ctx)));
            ArrayList<TreeDto> treeNodes = new ArrayList<TreeDto>();
            while (rowSet.next()) {
                if (!columnType.equals(rowSet.getString(3).trim())) continue;
                TreeDto treeColumnNode = new TreeDto();
                String columnId = rowSet.getString(1);
                String columnName = rowSet.getString(2);
                treeColumnNode.setId(columnId);
                treeColumnNode.setName(columnName);
                treeColumnNode.setpId("0");
                treeColumnNode.setOpen(false);
                treeColumnNode.setType("clumn");
                treeNodes.add(treeColumnNode);
                if (columnPerm.equals("edit")) {
                    IRowSet classRowSet = ContentManageFactory.getLocalInstance((Context)ctx).getAddDocClassByColumn(columnId);
                    ArrayList<String> adcLongNum = new ArrayList<String>();
                    ArrayList<String> adcId = new ArrayList<String>();
                    while (classRowSet.next()) {
                        String addDocClassId = classRowSet.getString(1);
                        String addDocClassLongNum = classRowSet.getString(3);
                        adcId.add(addDocClassId);
                        String[] longNums = addDocClassLongNum.split("!");
                        for (int i = 0; i < longNums.length; ++i) {
                            if (adcLongNum.contains(longNums[i])) continue;
                            adcLongNum.add(longNums[i]);
                        }
                    }
                    for (int j = 0; j < adcLongNum.size(); ++j) {
                        String longNum = (String)adcLongNum.get(j);
                        CMClassCollection addDocClass = iCMClass.getCMClassCollection("Where Number='" + longNum + "'");
                        if (addDocClass.size() <= 0) continue;
                        CMClassInfo classInfo = addDocClass.get(0);
                        TreeDto treeClassNode = this.classInfo2TreeDto(classInfo, columnId);
                        if (adcId.contains(classInfo.getId().toString())) {
                            treeClassNode.setPower(true);
                        } else {
                            treeClassNode.setPower(false);
                        }
                        treeNodes.add(treeClassNode);
                    }
                    continue;
                }
                CMClassCollection classCollection = iCMClass.getCMClassCollection("Where ColumnID='" + columnId + "'");
                int size = classCollection.size();
                for (int i = 0; i < size; ++i) {
                    CMClassInfo classInfo = classCollection.get(i);
                    TreeDto treeClassNode = this.classInfo2TreeDto(classInfo, columnId);
                    treeClassNode.setPower(true);
                    treeNodes.add(treeClassNode);
                }
            }
            result = JSONArray.fromObject(treeNodes);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.writeData2Response(result.toString());
    }

    public void getRoles() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            IRole iRole = RoleFactory.getLocalInstance((Context)ctx);
            RoleCollection roles = iRole.getRoleCollection("order by name asc");
            ArrayList<RoleDto> roleList = new ArrayList<RoleDto>();
            for (int i = 0; i < roles.size(); ++i) {
                RoleDto roleDto = new RoleDto();
                RoleInfo info = roles.get(i);
                roleDto.setId(info.getId().toString());
                roleDto.setName(info.getName());
                roleDto.setCode(info.getNumber());
                roleList.add(roleDto);
            }
            this.writeAjaxData(true, null, roleList);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void getProcessInfo() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ProcesseInfo[] eimProcessInfos = ColumnAndClassHandle.getProcessDefInfos((Context)ctx, (HttpServletRequest)this.getRequest(), (String)"com.kingdee.eas.cp.eip.cm", (String)"CMPublish", (String)"post", (int)7);
            this.writeAjaxData(true, null, eimProcessInfos);
        }
        catch (WfException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void getColumn() {
        String columnId = this.getRequest().getParameter("id");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            if (columnId != null && !columnId.equals("")) {
                IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                CMColumnInfo columnInfo = iManage.getColumnInfo(columnId.replaceAll(" ", "+"));
                boolean isEffect = columnInfo.isEffect();
                if (!StringUtils.isEmpty((String)columnInfo.getNewPortletId())) {
                    PortletDefinition portlet = NewPortalUtil.findPortletDefinitionById((Context)ctx, (String)columnInfo.getNewPortletId());
                    StatusEnum status = portlet.getStatus();
                    if (status.equals((Object)StatusEnum.DISABLE)) {
                        if (isEffect) {
                            columnInfo.setEffect(false);
                            iManage.saveColumnInfo(columnInfo);
                        }
                    } else if (!isEffect) {
                        columnInfo.setEffect(true);
                        iManage.saveColumnInfo(columnInfo);
                    }
                }
                String fileSrc = ContentResourceHandle.getColumnResourceFile((String)columnId, (Context)ctx, (ServletContext)this.getServletContext());
                ColumnDto columnDto = this.CMColumnInfoToColumn(columnInfo);
                FileModel fileModel = new FileModel();
                fileModel.setUploadFilePath(fileSrc);
                columnDto.setPicFile(fileModel);
                columnDto.setCanChangeType(true);
                ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
                CMClassCollection cM = iCMClass.getCMClassCollection(" where columnID ='" + columnId.replaceAll(" ", "+") + "'");
                int size = cM.size();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        CMClassInfo classInfo = cM.get(i);
                        Object[] params = null;
                        String sqlStr = "select top 1 FID from T_CM_Content where FClassID = ? ";
                        params = new Object[]{classInfo.getId().toString().replaceAll(" ", "+")};
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])params);
                        if (rowSet.size() <= 0) continue;
                        columnDto.setCanChangeType(false);
                        break;
                    }
                }
                this.writeAjaxData(true, null, columnDto);
            } else {
                this.writeAjaxData(true, null, null);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void saveColumn() {
        ColumnDto columnDto = this.buildColumnDto();
        try {
            String columnId = this.columnService.columnSave(columnDto, this.getRequest());
            this.writeAjaxTextData(true, columnId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxTextData(false, "");
        }
    }

    public void deleteColumn() {
        String columnId = this.getRequest().getParameter("id");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            if (columnId != null && !columnId.equals("")) {
                ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
                if (iCMClass.exists(" where columnID ='" + columnId.replaceAll(" ", "+") + "'")) {
                    this.writeAjaxData(false, null, "1");
                } else {
                    String id;
                    IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                    CMColumnInfo columnInfo = iManage.getColumnInfo(id = columnId.replaceAll(" ", "+"));
                    if (!StringUtils.isEmpty((String)columnInfo.getNewPortletId())) {
                        NewPortalUtil.deletePortletDefinitionById((Context)ctx, (String)columnInfo.getNewPortletId());
                    }
                    iManage.deleteColumn(id);
                    this.writeAjaxData(true, null, null);
                }
            } else {
                this.writeAjaxData(false, null, "0");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void getCmTemplate() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICMTemplate iCMTemplate = CMTemplateFactory.getLocalInstance((Context)ctx);
            CMTemplateCollection cMTemplateCollection = iCMTemplate.getCMTemplateCollection();
            ArrayList<CmTemplateDto> list = new ArrayList<CmTemplateDto>();
            CmTemplateDto nullCmTemplateDto = new CmTemplateDto();
            nullCmTemplateDto.setId("00");
            nullCmTemplateDto.setTitle("\u65e0");
            list.add(nullCmTemplateDto);
            for (int i = 0; i < cMTemplateCollection.size(); ++i) {
                CMTemplateInfo cmTemplateInfo = cMTemplateCollection.get(i);
                CmTemplateDto cmTemplateDto = new CmTemplateDto();
                cmTemplateDto.setId(cmTemplateInfo.getId().toString());
                cmTemplateDto.setTitle(cmTemplateInfo.getTitle());
                list.add(cmTemplateDto);
            }
            this.writeAjaxData(true, null, list);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, null);
        }
    }

    public void getClassById() {
        String classId = this.getRequest().getParameter("id");
        try {
            if (!StringUtils.isEmpty((String)classId)) {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                ClassDto classDto = new ClassDto();
                CMClassInfo classInfo = iManage.getClassInfo(classId.replaceAll(" ", "+"));
                classDto.setId(classInfo.getId().toString());
                classDto.setColumnID(classInfo.getColumnID().toString());
                if (classInfo.getTemplateID() != null) {
                    classDto.setTempletID(classInfo.getTemplateID().toString());
                } else {
                    classDto.setTempletID("");
                }
                classDto.setName(classInfo.getName(new Locale("L2")));
                classDto.setEditorRoleIDs(classInfo.getEditRoleIds());
                classDto.setEditorRoleNames(classInfo.getEditRoleNames());
                classDto.setDocAddRoleIDs(classInfo.getDocAddRoleIds());
                classDto.setDocAddRoleNames(classInfo.getDocAddRoleNames());
                classDto.setDesc(classInfo.getDescription(new Locale("L2")));
                this.writeAjaxData(true, null, classDto);
            } else {
                this.writeAjaxData(true, null, null);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void saveClass() {
        ClassDto classDto = this.buildClassDto();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
            CMClassInfo classInfo = new CMClassInfo();
            ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
            String fID = classDto.getId().replaceAll(" ", "+");
            if (StringUtils.isEmpty((String)classDto.getId())) {
                classInfo.setId(null);
                if (classDto.getParentID() != null && classDto.getParentID().length() > 0) {
                    CMClassInfo parent = (CMClassInfo)iCMClass.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)classDto.getParentID().replaceAll(" ", "+"))));
                    classInfo.setParent(parent);
                }
                CMClassCollection cM = iCMClass.getCMClassCollection("order by createtime desc");
                String FNumber = null;
                if (cM != null && cM.size() > 0) {
                    CMClassInfo cmi = cM.get(0);
                    FNumber = String.valueOf(Integer.parseInt(cmi.getNumber()) + 1);
                } else {
                    FNumber = "101";
                }
                classInfo.setNumber(FNumber);
            } else {
                classInfo = (CMClassInfo)iCMClass.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)fID)));
                if (classInfo == null) {
                    // empty if block
                }
            }
            classInfo.setColumnID(BOSUuid.read((String)classDto.getColumnID().replaceAll(" ", "+")));
            classInfo.setName(classDto.getName(), new Locale("L1"));
            classInfo.setName(classDto.getName(), new Locale("L2"));
            classInfo.setName(classDto.getName(), new Locale("L3"));
            classInfo.setName(classDto.getName());
            classInfo.setDescription(classDto.getDesc(), new Locale("L1"));
            classInfo.setDescription(classDto.getDesc(), new Locale("L2"));
            classInfo.setDescription(classDto.getDesc(), new Locale("L3"));
            classInfo.setDescription(classDto.getDesc());
            classInfo.setEditRoleIds(classDto.getEditorRoleIDs());
            classInfo.setDocAddRoleIds(classDto.getDocAddRoleIDs());
            if (classDto.getTempletID() != null && !"00".equals(classDto.getTempletID())) {
                classInfo.setTemplateID(BOSUuid.read((String)classDto.getTempletID().replaceAll(" ", "+")));
            } else {
                classInfo.setTemplateID(null);
            }
            IObjectPK pk = iManage.saveClassInfo(classInfo);
            this.writeAjaxTextData(true, pk.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (UuidException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void deleteClass() {
        String classId = this.getRequest().getParameter("id");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            if (!StringUtils.isEmpty((String)classId)) {
                ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
                if (iCMClass.exists(" where parent='" + classId + "'")) {
                    this.writeAjaxData(false, null, "2");
                } else {
                    Object[] params = null;
                    String sqlStr = "select top 1 FID from T_CM_Content where FClassID = ? ";
                    params = new Object[]{classId.replaceAll(" ", "+")};
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])params);
                    if (rowSet.size() > 0) {
                        this.writeAjaxData(false, null, "1");
                    } else {
                        String sql1;
                        IRowSet result1;
                        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                        String sql = "select FPARENTID from t_cm_class where FID = ? ";
                        String id = classId.replaceAll(" ", "+");
                        params = new Object[]{id};
                        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                        String fid = null;
                        if (result.size() > 0) {
                            while (result.next()) {
                                fid = result.getString("FPARENTID");
                            }
                        }
                        if (!StringUtil.isEmptyString(fid) && (result1 = DbUtil.executeQuery((Context)ctx, (String)(sql1 = "select FID from t_cm_class where FPARENTID = ?"), (Object[])(params = new Object[]{fid}))).size() == 1) {
                            String sql2 = "update t_cm_class set FISLEAF = 1 where FID = ?";
                            DbUtil.execute((Context)ctx, (String)sql2, (Object[])params);
                        }
                        iManage.deleClassInfo(classId);
                        this.writeAjaxData(true, null, null);
                    }
                }
            } else {
                this.writeAjaxData(false, null, "0");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public String toColumnDetail() throws BOSException {
        String columnId = this.getRequest().getParameter("id");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        boolean ifAdmin = iManage.ifCMAdmin();
        this.getRequest().setAttribute("ifAdmin", (Object)ifAdmin);
        if (columnId.trim().equals("")) {
            this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
            this.getRequest().setAttribute("operType", (Object)"add");
        } else {
            this.getRequest().setAttribute("columnid", (Object)columnId);
            this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
            this.getRequest().setAttribute("operType", (Object)"edit");
            Boolean isColumnCanEdit = iManage.isColumnCanEdit(columnId);
            this.getRequest().setAttribute("isColumnCanEdit", (Object)isColumnCanEdit);
            if (columnId.equals("tSFimQEREADgAAD5wKgSr7n/tuc=")) {
                return "newArticle";
            }
        }
        return "success";
    }

    public String toClassDetail() {
        String classId = this.getRequest().getParameter("id");
        String columnId = this.getRequest().getParameter("columnId");
        String parentId = this.getRequest().getParameter("parentId");
        if (classId.trim().equals("")) {
            this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
            this.getRequest().setAttribute("operType", (Object)"add");
            this.getRequest().setAttribute("columnId", (Object)columnId);
            this.getRequest().setAttribute("parentId", (Object)parentId);
        } else {
            this.getRequest().setAttribute("classid", (Object)classId);
            this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
            this.getRequest().setAttribute("operType", (Object)"edit");
            this.getRequest().setAttribute("columnId", (Object)columnId);
            this.getRequest().setAttribute("parentId", (Object)parentId);
        }
        return "success";
    }

    public void deletePic() {
        String columnId = this.getRequest().getParameter("columnId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        if (columnId != null && !columnId.equals("")) {
            try {
                IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                String id = columnId.replaceAll(" ", "+");
                CMColumnInfo columnInfo = iManage.getColumnInfo(id);
                String picId = columnInfo.getColumnPicture();
                if (!StringUtil.isEmptyString((String)picId)) {
                    AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
                    asm.deleteOneAssociation(columnId, picId);
                    columnInfo.setColumnPicture(null);
                    iManage.saveColumnInfo(columnInfo);
                }
                this.writeAjaxData(true, null, null);
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.writeAjaxData(false, null, null);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                this.writeAjaxData(false, null, null);
            }
        } else {
            this.writeAjaxData(false, null, null);
        }
    }

    public void getIsEnableLightApp() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        boolean result = false;
        try {
            result = XTUtil.isEnableXTNews((Context)ctx);
            this.writeData2Response(String.valueOf(result));
        }
        catch (Exception e) {
            this.writeData2Response(String.valueOf(result));
        }
    }

    public void getAllColumn() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        JSONArray result = null;
        ArrayList<TreeDto> treeNodes = new ArrayList<TreeDto>();
        try {
            IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
            IRowSet rowset = null;
            rowset = iManage.getAdminColumn();
            TreeDto newArticleNode = new TreeDto();
            while (rowset.next()) {
                TreeDto treeColumnNode = new TreeDto();
                String columnId = rowset.getString(1);
                String columnName = rowset.getString(2);
                treeColumnNode.setId(columnId);
                treeColumnNode.setName(columnName);
                treeColumnNode.setpId("0");
                treeColumnNode.setOpen(false);
                treeNodes.add(treeColumnNode);
            }
            treeNodes.add(newArticleNode);
            result = JSONArray.fromObject(treeNodes);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (treeNodes.size() == 0) {
            this.writeObjectData(null);
        } else {
            this.writeData2Response(result.toString());
        }
    }

    public void getAllClassByClumnId() {
        String columnId = this.getRequest().getParameter("columnId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        ArrayList<TreeDto> treeNodes = new ArrayList<TreeDto>();
        try {
            ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
            CMClassCollection classCollection = iCMClass.getCMClassCollection("Where ColumnID='" + columnId + "' order by CreateTime asc ");
            int size = classCollection.size();
            for (int i = 0; i < size; ++i) {
                CMClassInfo classInfo = classCollection.get(i);
                TreeDto treeClassNode = this.classInfo2TreeDto(classInfo, columnId);
                treeClassNode.setPower(true);
                treeNodes.add(treeClassNode);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        JSONArray result = JSONArray.fromObject(treeNodes);
        if (treeNodes.size() == 0) {
            this.writeObjectData(null);
        } else {
            this.writeData2Response(result.toString());
        }
    }

    private TreeDto classInfo2TreeDto(CMClassInfo classInfo, String columnId) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        TreeDto treeClassNode = new TreeDto();
        String classId = classInfo.getId().toString();
        int level = classInfo.getLevel();
        if (level == 1) {
            treeClassNode.setpId(columnId);
        } else {
            CMClassInfo parentClassInfo = classInfo.getParent();
            treeClassNode.setpId(parentClassInfo.getId().toString());
        }
        String className = classInfo.getName(ctx.getLocale());
        treeClassNode.setId(classId);
        treeClassNode.setName(className);
        treeClassNode.setOpen(false);
        treeClassNode.setType("class");
        return treeClassNode;
    }

    private ColumnDto buildColumnDto() {
        String contentHight;
        ColumnDto columnDto = new ColumnDto();
        columnDto.setID(this.getRequest().getParameter("ID"));
        columnDto.setReadRightNames(this.getRequest().getParameter("readRightNames"));
        columnDto.setColumnType(this.getRequest().getParameter("columnType"));
        columnDto.setColumnName(this.getRequest().getParameter("columnName"));
        columnDto.setReadRightIDs(this.getRequest().getParameter("readRightIDs"));
        columnDto.setProcessInfo(this.getRequest().getParameter("processInfo"));
        columnDto.setClassAdminNames(this.getRequest().getParameter("classAdminNames"));
        columnDto.setClassAdminIDs(this.getRequest().getParameter("classAdminIDs"));
        columnDto.setEffect(this.getRequest().getParameter("effect"));
        columnDto.setIsDisplayMore(this.getRequest().getParameter("displayMore"));
        columnDto.setCreatPortlet(this.getRequest().getParameter("creatPortlet"));
        columnDto.setCuFilter(this.getRequest().getParameter("cuFilter"));
        columnDto.setPublishToDesktop(this.getRequest().getParameter("publishToDesktop"));
        columnDto.setPushToXT(this.getRequest().getParameter("pushToXT"));
        columnDto.setShowInNotice(this.getRequest().getParameter("showInNotice"));
        columnDto.setInNewPortlet(this.getRequest().getParameter("inNewPortlet"));
        columnDto.setDisplayAuthor(this.getRequest().getParameter("displayAuthor"));
        columnDto.setDisplayDate(this.getRequest().getParameter("displayDate"));
        columnDto.setDisplayClass(this.getRequest().getParameter("displayClass"));
        if (columnDto.getColumnType() != null && (columnDto.getColumnType().equals(ColumnTypeEnum.PIC_NEWS.getName()) || columnDto.getColumnType().equals(ColumnTypeEnum.PICTURE.getName()) || columnDto.getColumnType().equals(ColumnTypeEnum.PIC_GROUP.getName()))) {
            columnDto.setDisplayCount(this.getRequest().getParameter("displayPicCount"));
        } else {
            columnDto.setDisplayCount(this.getRequest().getParameter("displayCount"));
        }
        columnDto.setColCount(this.getRequest().getParameter("colCount"));
        columnDto.setScrollType(this.getRequest().getParameter("scrollType"));
        columnDto.setViewCount(this.getRequest().getParameter("viewCount"));
        String contentWidth = this.getRequest().getParameter("contentWidth");
        if (contentWidth != null && !contentWidth.equals("")) {
            columnDto.setContentWidth(Integer.parseInt(this.getRequest().getParameter("contentWidth")));
        }
        if ((contentHight = this.getRequest().getParameter("contentHight")) != null && !contentHight.equals("")) {
            columnDto.setContentHight(Integer.parseInt(this.getRequest().getParameter("contentHight")));
        }
        columnDto.setPicShowType(this.getRequest().getParameter("picShowType"));
        columnDto.setCanContribute(this.getRequest().getParameter("canContribute"));
        columnDto.setSubEdit(this.getRequest().getParameter("subEdit"));
        columnDto.setLinkPicShowType(this.getRequest().getParameter("linkPicShowType"));
        columnDto.setDesc(this.getRequest().getParameter("desc"));
        File file = this.getUpload();
        if (file != null) {
            try {
                this.copyFile2UploadFolder();
                FileModel picFile = this.buildFileModel4Upload();
                columnDto.setPicFile(picFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (PortalBizException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return columnDto;
    }

    private ClassDto buildClassDto() {
        ClassDto classDto = new ClassDto();
        classDto.setId(this.getRequest().getParameter("id"));
        classDto.setName(this.getRequest().getParameter("name"));
        classDto.setDocAddRoleIDs(this.getRequest().getParameter("docAddRoleIDs"));
        classDto.setEditorRoleIDs(this.getRequest().getParameter("editorRoleIDs"));
        classDto.setTempletID(this.getRequest().getParameter("templetID"));
        classDto.setDesc(this.getRequest().getParameter("desc"));
        classDto.setColumnID(this.getRequest().getParameter("columnID"));
        classDto.setParentID(this.getRequest().getParameter("parentID"));
        return classDto;
    }

    private ColumnDto CMColumnInfoToColumn(CMColumnInfo columnInfo) {
        ColumnDto columnDto = new ColumnDto();
        columnDto.setID(columnInfo.getId().toString());
        columnDto.setReadRightNames(columnInfo.getReadroleNames());
        columnDto.setColumnType(columnInfo.getColumnType() == null ? null : String.valueOf(columnInfo.getColumnType().getName()));
        DisplayName displayName = new DisplayName();
        String nameL1 = columnInfo.getName(new Locale("L1"));
        String nameL2 = columnInfo.getName(new Locale("L2"));
        String nameL3 = columnInfo.getName(new Locale("L3"));
        columnDto.setColumnName(nameL2);
        columnDto.setReadRightIDs(columnInfo.getReadroleIds());
        columnDto.setProcessInfo(columnInfo.getProcessInfo());
        columnDto.setClassAdminNames(columnInfo.getAdminRoleNames());
        columnDto.setClassAdminIDs(columnInfo.getAdminRoleIds());
        columnDto.setEffect(Boolean.toString(columnInfo.isEffect()));
        columnDto.setIsDisplayMore(Boolean.toString(columnInfo.isDisplayMore()));
        columnDto.setCreatPortlet(Boolean.toString(columnInfo.isCreatPortlet()));
        columnDto.setCuFilter(Boolean.toString(columnInfo.isCuFilter()));
        columnDto.setPublishToDesktop(String.valueOf(columnInfo.isPublishToDesktop()));
        columnDto.setPushToXT(String.valueOf(columnInfo.isPublishToXTtop()));
        columnDto.setShowInNotice(String.valueOf(columnInfo.isShowInNotice()));
        columnDto.setInNewPortlet(String.valueOf(columnInfo.isInNewPortlet()));
        columnDto.setDisplayAuthor(Boolean.toString(columnInfo.isDisplayAuthor()));
        columnDto.setDisplayDate(String.valueOf(columnInfo.isDisplayDate()));
        columnDto.setDisplayClass(String.valueOf(columnInfo.isDisplayClass()));
        columnDto.setDisplayCount(String.valueOf(columnInfo.getDisplayCount() == 0 ? 5 : columnInfo.getDisplayCount()));
        columnDto.setColCount(String.valueOf(columnInfo.getColCount()));
        columnDto.setScrollType(columnInfo.getScrollType() == null ? null : String.valueOf(columnInfo.getScrollType().getName()));
        columnDto.setScrollCount(String.valueOf(columnInfo.getScrollCount()));
        columnDto.setDisplayPicCount(String.valueOf(columnInfo.getDisplayCount() == 0 ? 5 : columnInfo.getDisplayCount()));
        columnDto.setContentWidth(columnInfo.getContentWidth());
        columnDto.setContentHight(columnInfo.getContentHight());
        columnDto.setPicShowType(columnInfo.getPicShowType() == null ? null : String.valueOf(columnInfo.getPicShowType().getValue()));
        columnDto.setCanContribute(String.valueOf(columnInfo.isCanContribute()));
        columnDto.setSubEdit(columnInfo.getSubEditOrWorkFlow());
        columnDto.setLinkPicShowType(columnInfo.getLinkPicShowType() == null ? null : String.valueOf(columnInfo.getLinkPicShowType().getValue()));
        Description description = new Description();
        String descl1 = columnInfo.getDescription(new Locale("L1"));
        String descl2 = columnInfo.getDescription(new Locale("L2"));
        String descl3 = columnInfo.getDescription(new Locale("L3"));
        columnDto.setDesc(descl2);
        columnDto.setViewCount(String.valueOf(columnInfo.getViewCount()));
        return columnDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileModel buildFileModel4Upload() throws FileNotFoundException, IOException, PortalBizException {
        FileModel fileModel = null;
        fileModel = new FileModel();
        fileModel.setUploadFilePath(this.getUpload().getAbsolutePath());
        fileModel.setUploadFileName(this.getUploadFileName());
        fileModel.setUploadContentType(this.getUploadContentType());
        fileModel.setUploadFileContent(this.getFileContent(this.getUpload()));
        fileModel.setLength(this.getUpload().length());
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(this.getUpload());
            BufferedImage image = ImageIO.read(fileInputStream);
            if (image == null) {
                throw new PortalBizException("405");
            }
            fileModel.setHeight(image.getHeight());
            fileModel.setWidth(image.getWidth());
        }
        return fileModel;
    }

    private void writeAjaxTextData(boolean success, Object result) {
        Object tempResult = result == null ? "" : result;
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("result", tempResult);
        this.writeObjectData(JSONObject.fromObject(ajaxData).toString(), ResponseContentTypeEnum.HTML);
    }

    private void writeData2Response(String data) {
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            this.logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    private IRowSet getEditColumn(Context ctx) throws BOSException {
        String sqlStr = null;
        Object[] params = null;
        params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ctx.getCaller().toString(), ctx.getCaller().toString()};
        StringBuffer sqlBfFilter = new StringBuffer();
        sqlBfFilter.append("select distinct(FID)");
        sqlBfFilter.append(",FName_");
        sqlBfFilter.append(ctx.getLocale().toString());
        sqlBfFilter.append(",FCOLUMNTYPE");
        sqlBfFilter.append(",FSubEditOrWorkFlow");
        sqlBfFilter.append(" from T_CM_Column");
        sqlBfFilter.append(" where FEffect=1 and ( FControlUnitID = ? or FCuFilter = 1 )");
        sqlBfFilter.append(" and ((FID in (select a.FColumnID from T_CM_Class a, T_CM_ClassEditRole b, T_PM_UserRoleOrg c where a.FID=b.FClassID and b.FRoleID = c.FRoleID and c.FUserID =");
        sqlBfFilter.append("?");
        sqlBfFilter.append("))");
        sqlBfFilter.append(" or (FID in (select a.FColumnID from T_CM_Class a, T_CM_DocAddRole b, T_PM_UserRoleOrg c where a.FID=b.FClassID and b.FRoleID = c.FRoleID and c.FUserID =");
        sqlBfFilter.append("?");
        sqlBfFilter.append(")))");
        sqlBfFilter.append("  order by FName_");
        sqlBfFilter.append(ctx.getLocale().toString());
        sqlBfFilter.append(" asc");
        sqlStr = sqlBfFilter.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])params);
        return rowSet;
    }

    private IRowSet getReadColumn(Context ctx) throws BOSException {
        String sqlStr = null;
        Object[] params = null;
        params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ctx.getCaller().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
        StringBuffer sqlBfFilter = new StringBuffer();
        sqlBfFilter.append(" select distinct(FID)");
        sqlBfFilter.append(",FName_");
        sqlBfFilter.append(ctx.getLocale().toString());
        sqlBfFilter.append(",FCOLUMNTYPE");
        sqlBfFilter.append(",FSubEditOrWorkFlow");
        sqlBfFilter.append(" from (");
        sqlBfFilter.append(" select a.FID");
        sqlBfFilter.append(",a.FName_");
        sqlBfFilter.append(ctx.getLocale().toString());
        sqlBfFilter.append(",a.FCOLUMNTYPE");
        sqlBfFilter.append(",a.FSubEditOrWorkFlow");
        sqlBfFilter.append(" from T_CM_Column a, T_CM_ColumnReadRight b, T_PM_UserRoleOrg c");
        sqlBfFilter.append(" where a.FEffect=1 and (a.FControlUnitID = ? or FCuFilter = 1)");
        sqlBfFilter.append(" and a.FID = b.FColumnID and b.FRoleID = c.FRoleID");
        sqlBfFilter.append(" and c.FUserID = ?");
        sqlBfFilter.append(" union select FID ");
        sqlBfFilter.append(",FName_");
        sqlBfFilter.append(ctx.getLocale().toString());
        sqlBfFilter.append(",FSubEditOrWorkFlow ");
        sqlBfFilter.append(" from T_CM_Column where FEffect=1 and (FControlUnitID = ? or FCuFilter = 1) and FID not in ( select FColumnID from T_CM_ColumnReadRight)");
        sqlBfFilter.append(") a");
        sqlStr = sqlBfFilter.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])params);
        return rowSet;
    }

    protected IRowSet getAdminColumn(Context ctx) throws BOSException {
        String sqlStr = null;
        Object[] params = null;
        params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ctx.getCaller().toString()};
        StringBuffer sqlBfFilter = new StringBuffer();
        sqlBfFilter.append("select distinct(a.FID)");
        sqlBfFilter.append(",a.FName_");
        sqlBfFilter.append(ctx.getLocale().toString());
        sqlBfFilter.append(",FCOLUMNTYPE");
        sqlBfFilter.append(" from T_CM_Column a, T_CM_ClassAdmin b, T_PM_UserRoleOrg c");
        sqlBfFilter.append(" where a.FControlUnitID = ?");
        sqlBfFilter.append(" and a.FID = b.FColumnID and b.FRoleID = c.FRoleID");
        sqlBfFilter.append(" and c.FUserID = ?");
        sqlBfFilter.append("  order by a.FName_");
        sqlBfFilter.append(ctx.getLocale().toString());
        sqlBfFilter.append(" asc");
        sqlStr = sqlBfFilter.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])params);
        return rowSet;
    }

    public void haveClassAddPermi() {
        String nodeType = this.getRequest().getParameter("nodeType");
        String nodeId = this.getRequest().getParameter("nodeId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        IContentManage iManage = null;
        boolean canAdd = false;
        try {
            iManage = ContentManageFactory.getLocalInstance((Context)ctx);
            canAdd = iManage.ifCMAdmin();
            if (canAdd) {
                this.writeAjaxData(true, null, null);
                return;
            }
            if ("clumn".equals(nodeType) && (canAdd = iManage.isColumnCanEdit(nodeId))) {
                this.writeAjaxData(true, null, null);
                return;
            }
            if ("class".equals(nodeType) && (canAdd = this.isClassCanEdit(ctx, nodeId))) {
                this.writeAjaxData(true, null, null);
                return;
            }
            this.writeAjaxData(false, null, null);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void haveRemoveClassPermi() {
        String nodeType = this.getRequest().getParameter("nodeType");
        String nodeId = this.getRequest().getParameter("nodeId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        IContentManage iManage = null;
        boolean canRemove = false;
        try {
            iManage = ContentManageFactory.getLocalInstance((Context)ctx);
            canRemove = iManage.ifCMAdmin();
            if (canRemove) {
                this.writeAjaxData(true, null, null);
                return;
            }
            if ("class".equals(nodeType)) {
                String parentId;
                ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
                CMClassInfo info = (CMClassInfo)iCMClass.getValue((IObjectPK)new ObjectUuidPK(nodeId));
                canRemove = iManage.isColumnCanEdit(info.getColumnID().toString());
                if (canRemove) {
                    this.writeAjaxData(true, null, null);
                    return;
                }
                CMClassInfo parentInfo = info.getParent();
                if (parentInfo != null && (canRemove = this.isClassCanEdit(ctx, parentId = parentInfo.getId().toString()))) {
                    this.writeAjaxData(true, null, null);
                    return;
                }
            }
            this.writeAjaxData(false, null, null);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    protected boolean isClassCanEdit(Context ctx, String classId) throws BOSException {
        boolean flag = false;
        String sqlStr = null;
        Object[] params = null;
        params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ctx.getCaller().toString(), classId};
        StringBuffer sqlBfFilter = new StringBuffer();
        sqlBfFilter.append("select count(a.FID)");
        sqlBfFilter.append(" from T_CM_Class a, t_cm_ClassEditRole b, T_PM_UserRoleOrg c");
        sqlBfFilter.append(" where a.FControlUnitID = ?");
        sqlBfFilter.append(" and a.FID = b.FClassID and b.FRoleID = c.FRoleID");
        sqlBfFilter.append(" and c.FUserID = ?");
        sqlBfFilter.append(" and b.FClassID = ?");
        sqlStr = sqlBfFilter.toString();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])params);
            if (rowSet.next() && rowSet.getInt(1) > 0) {
                flag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }
}

