/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cm.module.comment.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMCommentFactory;
import com.kingdee.eas.cp.eip.cm.CMCommentInfo;
import com.kingdee.eas.cp.eip.cm.CMContentFactory;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ColumnTypeEnum;
import com.kingdee.eas.cp.eip.cm.ContentManageFactory;
import com.kingdee.eas.cp.eip.cm.ICMComment;
import com.kingdee.eas.cp.eip.cm.ICMContent;
import com.kingdee.eas.cp.eip.cm.IContentManage;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.plt.cm.common.util.CMLicenseName;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cm.module.column.dto.ColumnDto;
import com.kingdee.portal.plt.cm.module.comment.dto.CommentDto;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;

public class CommentAction
extends BaseAction {
    private static String licenseClassName = "com.kingdee.eas.cp.eip.cm.web.CommentManageAction";

    public String personalCommentManager() {
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        return "success";
    }

    public String adminCommentManager() {
        boolean hasLicense = LicenseTool.checkLicense(this.getRequest(), CMLicenseName.licenseClassName);
        if (!hasLicense) {
            return "noLicense";
        }
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        return "success";
    }

    public void getPersonalComment() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String userID = ctx.getCaller().toString();
        try {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("creator.id", (Object)userID);
            filterInfo.getFilterItems().add(filterItemInfo);
            FilterInfo searchFilter = this.getSearchFilter(this.getRequest());
            if (searchFilter.getFilterItems().size() > 0) {
                filterInfo.mergeFilter(searchFilter, "and");
            }
            PagingResult<CommentDto> result = this.readCommentDataByQuery(this.getRequest(), filterInfo);
            this.writePagingResult(result);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void getAdminComment() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("CU.id", (Object)user.getCU().getId().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            FilterInfo searchFilter = this.getSearchFilter(this.getRequest());
            if (searchFilter.getFilterItems().size() > 0) {
                filterInfo.mergeFilter(searchFilter, "and");
            }
            PagingResult<CommentDto> result = this.readCommentDataByQuery(this.getRequest(), filterInfo);
            this.writePagingResult(result);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    private FilterInfo getSearchFilter(HttpServletRequest request) {
        FilterInfo filter = new FilterInfo();
        String commentTheme = "";
        String commentContent = "";
        String commentator = "";
        String commentStateStr = "";
        String beginDate = "";
        String endDate = "";
        String score = "";
        commentTheme = request.getParameter("commentTitle");
        commentContent = request.getParameter("commentContent");
        commentator = request.getParameter("commentCreator");
        commentStateStr = request.getParameter("commentState");
        beginDate = request.getParameter("beginDate");
        endDate = request.getParameter("endDate");
        score = request.getParameter("score");
        if (!StringUtil.isEmptyString((String)beginDate)) {
            beginDate = beginDate + " 00:00:00.0";
        }
        if (!StringUtil.isEmptyString((String)endDate)) {
            endDate = endDate + " 23:59:59.0";
        }
        int i = 0;
        boolean mark = true;
        StringBuffer markString = new StringBuffer();
        if (commentTheme != null && !"".equals(commentTheme) && !"null".equals(commentTheme)) {
            filter.getFilterItems().add(new FilterItemInfo("CMCONTENT.TITLE", (Object)("%" + commentTheme + "%"), CompareType.LIKE));
            markString.append(" #" + i);
            mark = false;
            ++i;
        }
        if (commentContent != null && !"".equals(commentContent) && !"null".equals(commentContent)) {
            filter.getFilterItems().add(new FilterItemInfo("COMMENTCONTENT", (Object)("%" + commentContent + "%"), CompareType.LIKE));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        if (commentator != null && !"".equals(commentator) && !"null".equals(commentator)) {
            filter.getFilterItems().add(new FilterItemInfo("creator.name", (Object)("%" + commentator + "%"), CompareType.LIKE));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        if (commentStateStr != null) {
            if ("1".equals(commentStateStr)) {
                filter.getFilterItems().add(new FilterItemInfo("STATE", (Object)Integer.valueOf(commentStateStr), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("STATE", null, CompareType.EQUALS));
                if (!mark) {
                    markString.append(" and ( #" + i + " or #" + ++i + " )");
                } else {
                    markString.append(" (#" + i + " or #" + ++i + " )");
                    mark = false;
                }
                ++i;
            } else if ("2".equals(commentStateStr)) {
                filter.getFilterItems().add(new FilterItemInfo("STATE", (Object)Integer.valueOf(commentStateStr), CompareType.EQUALS));
                if (!mark) {
                    markString.append(" and #" + i);
                } else {
                    markString.append(" #" + i);
                    mark = false;
                }
                ++i;
            }
        }
        if (beginDate != null && !"".equals(beginDate) && !"null".equals(beginDate)) {
            filter.getFilterItems().add(new FilterItemInfo("COMMENTTIME", (Object)Timestamp.valueOf(beginDate), CompareType.GREATER_EQUALS));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        if (endDate != null && !"".equals(endDate) && !"null".equals(endDate)) {
            filter.getFilterItems().add(new FilterItemInfo("COMMENTTIME", (Object)Timestamp.valueOf(endDate), CompareType.LESS_EQUALS));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        if (!(score == null || "".equals(score) || "null".equals(score) || "0".equals(score))) {
            filter.getFilterItems().add(new FilterItemInfo("SCORE", (Object)Integer.valueOf(score), CompareType.EQUALS));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        filter.setMaskString(markString.toString());
        return filter;
    }

    private PagingResult<CommentDto> readCommentDataByQuery(HttpServletRequest request, FilterInfo filter) {
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String page = request.getParameter("pageNumber");
        String pageSizeStr = request.getParameter("pageSize");
        String title = request.getParameter("title");
        String orderByField = request.getParameter("sortFieldName");
        String orderType = request.getParameter("sortType");
        String operate = request.getParameter("operate");
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "commentTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        orderType = orderType.toUpperCase();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        entityViewInfo.setFilter(filter);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "CommentContentQuery");
        MetaDataPK queryCountPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "CommentContentCountQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)queryCountPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            if (countRowSet.next()) {
                total = countRowSet.getInt(1);
                this.logger.debug("record total is\uff1a" + total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<CommentDto> list = new ArrayList<CommentDto>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    CommentDto comment = new CommentDto();
                    comment.setId(rowSet.getString("id"));
                    comment.setCommentTitle(rowSet.getString("CMContent.title"));
                    String score = rowSet.getString("score");
                    if (score == null) {
                        score = "";
                    }
                    comment.setCommentScore(score);
                    comment.setCommentContent(rowSet.getString("commentContent"));
                    comment.setCommnetTime(rowSet.getString("commentTime").substring(0, 16));
                    String state = rowSet.getString("state");
                    comment.setCommentState(state);
                    comment.setCommnetCreator(rowSet.getString("creator.name"));
                    comment.setCommentContentId(rowSet.getString(8));
                    list.add(comment);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            return pagingResult;
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u627e\u5185\u5bb9\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            return null;
        }
    }

    public void deleteCommentByIds() {
        try {
            String ids = this.getRequest().getParameter("ids");
            if (ids != null && !ids.equals("")) {
                HttpServletRequest request = this.getRequest();
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
                String[] idArray = ids.split(",");
                ObjectUuidPK[] pkArray = new ObjectUuidPK[idArray.length];
                for (int i = 0; i < idArray.length; ++i) {
                    pkArray[i] = new ObjectUuidPK(idArray[i]);
                }
                ICMComment icom = CMCommentFactory.getLocalInstance((Context)ctx);
                icom.delete((IObjectPK[])pkArray);
                this.writeAjaxData(true, null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void updateCommentState() {
        String ids = this.getRequest().getParameter("ids");
        String state = this.getRequest().getParameter("state");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            IContentManage icm = ContentManageFactory.getLocalInstance((Context)ctx);
            if (state.equals("1")) {
                icm.updateCommentStateShow(ids);
            } else if (state.equals("2")) {
                icm.updateCommentStateHidden(ids);
            }
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void editComment() {
        String commentId = this.getRequest().getParameter("commentId");
        String comment = this.getRequest().getParameter("comment");
        String contentId = this.getRequest().getParameter("contentId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICMComment iCMComment = CMCommentFactory.getLocalInstance((Context)ctx);
            CMCommentInfo info = null;
            info = new CMCommentInfo();
            if (commentId == null || "null".equals(commentId) || "".equals(commentId)) {
                commentId = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
            }
            info.setState(1);
            info.setId(BOSUuid.read((String)commentId));
            info.setContentID(BOSUuid.read((String)contentId));
            info.setCommentContent(comment);
            info.setCommentTime(this.getTime());
            iCMComment.submit((CoreBaseInfo)info);
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public void getContentByCommentId() {
        String commentId = this.getRequest().getParameter("commentId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICMComment icom = CMCommentFactory.getLocalInstance((Context)ctx);
            CMCommentInfo info = icom.getCMCommentInfo((IObjectPK)new ObjectUuidPK(commentId));
            String docId = info.getContentID().toString();
            ICMContent iCm = CMContentFactory.getLocalInstance((Context)ctx);
            CMContentInfo concentInfo = iCm.getCMContentInfo((IObjectPK)new ObjectUuidPK(docId));
            String columnID = concentInfo.getColumnID().toString();
            IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
            CMColumnInfo columnInfo = iManage.getColumnInfo(columnID.replaceAll(" ", "+"));
            ColumnDto columnDto = new ColumnDto();
            columnDto.setID(columnInfo.getId().toString());
            String type = String.valueOf(columnInfo.getColumnType().getValue());
            columnDto.setColumnType(type);
            columnDto.setEffect(docId);
            if (type.equals(String.valueOf(ColumnTypeEnum.LINK.getValue()))) {
                // empty if block
            }
            columnDto.setColCount(concentInfo.getSummary());
            this.writeAjaxData(true, null, columnDto);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

