/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.document.dao.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.dm.DocWfState;
import com.kingdee.eas.cp.dm.DocumentBorrowInfo;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.DocumentReadNoteCollection;
import com.kingdee.eas.cp.dm.DocumentReadNoteFactory;
import com.kingdee.eas.cp.dm.DocumentReadNoteInfo;
import com.kingdee.eas.cp.dm.DocumentRecommendEntryInfo;
import com.kingdee.eas.cp.dm.DocumentRecommendInfo;
import com.kingdee.eas.cp.dm.IDocument;
import com.kingdee.eas.cp.dm.IDocumentReadNote;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.plt.cp.module.document.dao.DocumentDAO;
import com.kingdee.portal.plt.cp.module.document.entity.Category;
import com.kingdee.portal.plt.cp.module.document.entity.DmCategoryTreeDTO;
import com.kingdee.portal.plt.cp.module.document.entity.DmPermCacheInfo;
import com.kingdee.portal.plt.cp.module.document.entity.Document;
import com.kingdee.portal.plt.cp.module.document.entity.DocumentBorrow;
import com.kingdee.portal.plt.cp.module.document.service.PermissionUtil;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DocumentDAOImpl
extends BaseDAOImpl<Document>
implements DocumentDAO {
    @Override
    public PagingResult<Document> findMyReadList(String readerId, String searchText, PagingParam pagingParam) throws DataAccessException {
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.Document(d.id, d.summary, d.readCount, d.commentCount, d.title, d.createPersonId, d.recommendCount,p.name,d.createTime,d.version,d.number,d.contentType,d.issueTime) ");
        selectClause.append("FROM Document d, DocumentReadNote dr,Person p WHERE d.id = dr.readDocumentId and p.id=d.createPersonId ");
        StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM Document d, DocumentReadNote dr,Person p WHERE d.id = dr.readDocumentId and p.id=d.createPersonId ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AND dr.readerId = '" + readerId + "' and d.state=1 and d.wfState=3 and d.isHistory=0 ");
        if (searchText != null && !"".equals(searchText)) {
            whereClause.append(" AND ( d.title like '%" + searchText + "%' or p.name like '%" + searchText + "%') ");
        }
        StringBuilder orderClause = new StringBuilder();
        orderClause.append(" order by d.issueTime desc ");
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        return pagingResult;
    }

    @Override
    public PagingResult<DocumentBorrow> findBorrowedListByDocId(String docId, PagingParam pagingParam) throws DataAccessException {
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.DocumentBorrow(d.id, d.applyDate, d.approveDate, d.documentId, d.borrowTime, d.applyTime,d.state,d.borrowReason) ");
        selectClause.append("FROM DocumentBorrow d WHERE 1=1 ");
        StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM DocumentBorrow d WHERE 1=1 ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AND d.documentId = '" + docId + "' ");
        StringBuilder orderClause = new StringBuilder();
        orderClause.append(" order by d.createTime desc ");
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        return pagingResult;
    }

    @Override
    public PagingResult<DocumentBorrow> findMyBorrowedListByDocId(Context ctx, String docId, PagingParam pagingParam) throws DataAccessException {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.DocumentBorrow(d.id, d.applyDate, d.approveDate, d.documentId, d.borrowTime, d.applyTime,d.state,d.borrowReason) ");
        selectClause.append("FROM DocumentBorrow d WHERE 1=1 ");
        StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM DocumentBorrow d WHERE 1=1 ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AND d.borrowerId = '" + personId + "' ");
        whereClause.append("AND d.documentId = '" + docId + "' ");
        StringBuilder orderClause = new StringBuilder();
        orderClause.append(" order by d.createTime desc ");
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        return pagingResult;
    }

    @Override
    public void addDocumentBorrow(Context ctx, DocumentBorrow documentBorrow) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        DocumentBorrowInfo documentBorrowInfo = new DocumentBorrowInfo();
        BOSUuid addNewId = BOSUuid.create((BOSObjectType)documentBorrowInfo.getBOSType());
        String id = addNewId.toString();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_dm_documentborrow (fdocumentid, fborrowerid, fapplydate, fapplytime, fborrowreason, fapprovedate, fborrowtime,fstate,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fid)");
        sb.append(" values(?, ?, ?, ?, ?, ?,?, 1,?,?,?,?,?,?)");
        Object[] params = new Object[]{documentBorrow.getDocumentId(), personId, this.getCurrentTimeStr(), documentBorrow.getApplyTime(), documentBorrow.getBorrowReason(), this.getCurrentTimeStr(), documentBorrow.getApplyTime(), userId, this.getCurrentTimeStr(), userId, this.getCurrentTimeStr(), orgId, id};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    public void addDocumentBorrowWf(Context ctx, DocumentBorrow documentBorrow) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        DocumentBorrowInfo documentBorrowInfo = new DocumentBorrowInfo();
        BOSUuid addNewId = BOSUuid.create((BOSObjectType)documentBorrowInfo.getBOSType());
        String id = addNewId.toString();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_dm_documentborrow (fdocumentid, fborrowerid, fapplydate, fapplytime, fborrowreason, fstate,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fid)");
        sb.append(" values(?, ?, ?, ?, ?, 0,?,?,?,?,?,?)");
        Object[] params = new Object[]{documentBorrow.getDocumentId(), personId, this.getCurrentTimeStr(), documentBorrow.getApplyTime(), documentBorrow.getBorrowReason(), userId, this.getCurrentTimeStr(), userId, this.getCurrentTimeStr(), orgId, id};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    public void addDocumentCommend(Context ctx, String docId) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_dm_documentcommend(fid, fseq, fparentid, frecommenderid)");
        sb.append(" values(?, 0, ?, ?)");
        Object[] params = new Object[]{Uuid.randomUUID().toString(), docId, personId};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    public void addDocumentReadCount(Context ctx, String docId) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("update t_dm_document set freadcount=freadcount+1 where fid=?");
        Object[] params = new Object[]{docId};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    public int addDocumentReadNote(Context ctx, String docId) throws Exception {
        IDocument iDocument = DocumentFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(docId);
        DocumentInfo docInfo = (DocumentInfo)iDocument.getValue((IObjectPK)pk);
        int readCount = 0;
        if (!docInfo.getWfState().equals((Object)DocWfState.PUBLISH)) {
            return 0;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuffer oql = new StringBuffer("select id, readDocument.id ");
        oql.append(" where readDocument.id='").append(docId).append("'");
        oql.append(" and reader.id='").append(user.getPerson().getId().toString()).append("'");
        IDocumentReadNote iDocumentReadNote = DocumentReadNoteFactory.getLocalInstance((Context)ctx);
        DocumentReadNoteCollection docRnColl = iDocumentReadNote.getDocumentReadNoteCollection(oql.toString());
        readCount = docInfo.getReadCount();
        if (0 == docRnColl.size()) {
            docInfo.setReadCount(++readCount);
            iDocument.update((IObjectPK)pk, (CoreBaseInfo)docInfo);
            DocumentReadNoteInfo docReadNoteModel = new DocumentReadNoteInfo();
            docReadNoteModel.setReadDocument(docInfo);
            docReadNoteModel.setFirstReadTime(new Timestamp(System.currentTimeMillis()));
            docReadNoteModel.setReader(user.getPerson());
            iDocumentReadNote.addnew(docReadNoteModel);
        } else {
            docRnColl.get(0).setFirstReadTime(new Timestamp(System.currentTimeMillis()));
            iDocumentReadNote.update((IObjectPK)new ObjectUuidPK(docRnColl.get(0).getId().toString()), docRnColl.get(0));
        }
        return readCount;
    }

    @Override
    public void addDocumentBookMark(Context ctx, String docId) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_dm_docbookmark(fpersonid, freadcount, ftype, fdocumentid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fid)");
        sb.append(" values(?, 0, 0,?, ?,?,?,?,?,?)");
        Object[] params = new Object[]{personId, docId, userId, this.getCurrentTimeStr(), userId, this.getCurrentTimeStr(), orgId, Uuid.randomUUID().toString()};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    public String addDocumentRecommend(Context ctx, String docId) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        DocumentRecommendInfo documentRecommendInfo = new DocumentRecommendInfo();
        BOSUuid addNewId = BOSUuid.create((BOSObjectType)documentRecommendInfo.getBOSType());
        String id = addNewId.toString();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_dm_documentrecommend(fid,fpersonid,fstate,fdocid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid)");
        sb.append(" values(?,?,1,?,?,?,?,?,?)");
        Object[] params = new Object[]{id, personId, docId, userId, this.getCurrentTimeStr(), userId, this.getCurrentTimeStr(), orgId};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        return id;
    }

    @Override
    public void addDocumentRecommendEntry(Context ctx, String personId, String parentId) throws Exception {
        DocumentRecommendEntryInfo documentRecommendEntryInfo = new DocumentRecommendEntryInfo();
        BOSUuid addNewId = BOSUuid.create((BOSObjectType)documentRecommendEntryInfo.getBOSType());
        String id = addNewId.toString();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_dm_documentrecommendentry(fparentid,fpersonid,fid,fstate)");
        sb.append(" values(?,?,?,1)");
        Object[] params = new Object[]{parentId, personId, id};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    public void cancelDocumentBookMark(Context ctx, String docId) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("delete from t_dm_docbookmark where fpersonid=? and fdocumentid=?");
        Object[] params = new Object[]{personId, docId};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    public boolean isDocumentCommended(Context ctx, String docId) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String sql = "select a.fid id from t_dm_documentcommend a where a.fparentid =? and a.frecommenderid=?";
        Object[] param = new Object[]{docId, personId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        boolean result = false;
        if (rs.next()) {
            result = true;
        }
        return result;
    }

    @Override
    public int commendCount(Context ctx, String docId) throws Exception {
        String sql = "select count(a.fid) count from t_dm_documentcommend a where a.fparentid =? ";
        Object[] param = new Object[]{docId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        int result = 0;
        if (rs.next()) {
            result = rs.getInt("count");
        }
        return result;
    }

    @Override
    public void delDocumentCommend(Context ctx, String docId) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("delete t_dm_documentcommend where fparentid =? and frecommenderid=? ");
        Object[] params = new Object[]{docId, personId};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    public boolean isDocumentBookMarked(Context ctx, String docId) throws Exception {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String sql = "select a.fid id from t_dm_docbookmark a where a.fdocumentid =? and a.fpersonid=?";
        Object[] param = new Object[]{docId, personId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        boolean result = false;
        if (rs.next()) {
            result = true;
        }
        return result;
    }

    private Timestamp getCurrentTimeStr() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataStr = format.format(new Date());
        return Timestamp.valueOf(dataStr);
    }

    @Override
    public PagingResult<Document> findMyBookMarkList(String personId, String searchText, PagingParam pagingParam) throws DataAccessException {
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.Document(d.id, d.summary, d.readCount, d.commentCount, d.title, d.createPersonId, d.recommendCount,p.name,d.createTime,d.version,d.number,d.contentType,d.issueTime) ");
        selectClause.append("FROM Document d, DocumentBookMark bm,Person p WHERE d.id = bm.documentId and p.id=d.createPersonId ");
        StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM Document d, DocumentBookMark bm,Person p WHERE d.id = bm.documentId and p.id=d.createPersonId ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AND bm.personId = '" + personId + "' and d.state=1 and d.wfState=3 and d.isHistory=0 ");
        if (searchText != null && !"".equals(searchText)) {
            whereClause.append(" AND ( d.title like '%" + searchText + "%' or p.name like '%" + searchText + "%') ");
        }
        StringBuilder orderClause = new StringBuilder();
        orderClause.append(" order by d.issueTime desc ");
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        return pagingResult;
    }

    @Override
    public PagingResult<Document> findMyBorrowedList(Context ctx, String personId, String searchText, PagingParam pagingParam) throws Exception {
        String borrowIds = this.getBorrowIds(ctx, personId);
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.Document(d.id, d.summary, d.readCount, d.commentCount, d.title, d.createPersonId, d.recommendCount,p.name,d.createTime,d.version,d.number,d.contentType,db.applyDate,db.approveDate,db.applyTime,db.state,db.id,d.issueTime) ");
        selectClause.append("FROM Document d, DocumentBorrow db,Person p WHERE d.id = db.documentId and p.id=d.createPersonId ");
        StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM Document d, DocumentBorrow db,Person p WHERE d.id = db.documentId and p.id=d.createPersonId ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AND db.borrowerId = '" + personId + "' and d.state=1 and d.wfState=3 and d.isHistory=0 ");
        if (borrowIds != null && !"".equals(borrowIds)) {
            whereClause.append(" and db.id in (" + borrowIds + ")");
        }
        if (searchText != null && !"".equals(searchText)) {
            whereClause.append(" AND ( d.title like '%" + searchText + "%' or p.name like '%" + searchText + "%') ");
        }
        StringBuilder orderClause = new StringBuilder();
        orderClause.append(" order by d.issueTime desc ");
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        return pagingResult;
    }

    @Override
    public PagingResult<Document> findMySendList(String personId, String searchText, PagingParam pagingParam) throws DataAccessException {
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.Document(d.id, d.summary, d.readCount, d.commentCount, d.title, d.createPersonId, d.recommendCount,p.name,d.createTime,d.version,d.number,d.contentType,dr.createTime,dr.id,d.issueTime) ");
        selectClause.append("FROM Document d, DocumentRecommend dr,Person p WHERE d.id = dr.docId and p.id=d.createPersonId ");
        StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM Document d, DocumentRecommend dr,Person p WHERE d.id = dr.docId and p.id=d.createPersonId ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AND dr.personId = '" + personId + "' and d.state=1 and d.wfState=3 and d.isHistory=0 ");
        if (searchText != null && !"".equals(searchText)) {
            whereClause.append(" AND ( d.title like '%" + searchText + "%' or p.name like '%" + searchText + "%') ");
        }
        StringBuilder orderClause = new StringBuilder();
        orderClause.append(" order by d.issueTime desc ");
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        return pagingResult;
    }

    @Override
    public PagingResult<Document> findMyReceiveList(String personId, String searchText, PagingParam pagingParam) throws DataAccessException {
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.Document(d.id, d.summary, d.readCount, d.commentCount, d.title, d.createPersonId, d.recommendCount,p.name,d.createTime,d.version,d.number,d.contentType,dr.createTime,dr.id,d.issueTime) ");
        selectClause.append("FROM Document d, DocumentRecommend dr,Person p,DocumentRecommendEntry dre WHERE d.id = dr.docId and p.id=d.createPersonId and dre.parentId=dr.id ");
        StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM Document d, DocumentRecommend dr,Person p,DocumentRecommendEntry dre WHERE d.id = dr.docId and p.id=d.createPersonId and dre.parentId=dr.id ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AND dre.personId = '" + personId + "' and d.state=1 and d.wfState=3 and d.isHistory=0 ");
        if (searchText != null && !"".equals(searchText)) {
            whereClause.append(" AND ( d.title like '%" + searchText + "%' or p.name like '%" + searchText + "%') ");
        }
        StringBuilder orderClause = new StringBuilder();
        orderClause.append(" order by d.issueTime desc ");
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        return pagingResult;
    }

    @Override
    public String getRecommend2Persons(Context ctx, String documentRecommendId) throws Exception {
        String sql = "select b.fname_l2 personName from t_dm_documentrecommendentry a,t_bd_person b where a.fparentid=? and a.fpersonid=b.fid";
        Object[] param = new Object[]{documentRecommendId};
        String personNames = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        while (rs.next()) {
            personNames = personNames + "\uff0c" + rs.getString("personName");
        }
        if (personNames.length() > 0) {
            personNames = personNames.substring(1);
        }
        return personNames;
    }

    @Override
    public String getFWfBorrowProcess(Context ctx, String documentId) throws Exception {
        String sql = "SELECT FWfBorrowProcess from T_DM_Category where fid = (select fcategoryid from T_DM_Document where fid = '" + documentId + "')";
        Object[] param = new Object[]{};
        String wfBorrowProcess = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        if (rs.next()) {
            wfBorrowProcess = rs.getString("FWfBorrowProcess");
        }
        return wfBorrowProcess;
    }

    @Override
    public String getRecommendSenderName(Context ctx, String documentRecommendId) throws Exception {
        String sql = "select b.fname_l2 personName from t_dm_documentrecommend a,t_bd_person b where a.fid=? and a.fpersonid=b.fid";
        Object[] param = new Object[]{documentRecommendId};
        String personNames = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        while (rs.next()) {
            personNames = personNames + "\uff0c" + rs.getString("personName");
        }
        if (personNames.length() > 0) {
            personNames = personNames.substring(1);
        }
        return personNames;
    }

    @Override
    public Document getDocumentById(Context ctx, String docId) throws Exception {
        Document document = new Document();
        StringBuffer sql = new StringBuffer();
        sql.append("select");
        sql.append(" a.fid id,").append("a.fcreatetime createtime,");
        sql.append("a.FSummary summary,").append("a.fauthorId authorId,");
        sql.append("a.FReadCount readcount,").append("a.FCommentCount commentCount,");
        sql.append("a.FTitle title,").append("b.FName_l2 personName,");
        sql.append("a.FRecommendCount recommendCount,").append("a.FVersion version,");
        sql.append("a.FNumber number,").append("a.FContentType contentType,");
        sql.append("a.FCanDownload canDownload,").append("a.FIsPrintAttach isPrintAttach,");
        sql.append("a.FCategoryID categoryID,").append("a.FCanCopy canCopy,");
        sql.append("a.FState state").append(",a.FDocMarkNumber docMarkNumber,");
        sql.append("a.fcreatepersonid createpersonid,a.fwfstate wfstate");
        sql.append(" from t_dm_document a,t_bd_person b where a.fcreatepersonid=b.fid and a.fid=?");
        Object[] param = new Object[]{docId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        if (rs.next()) {
            document.setId(rs.getString("id"));
            document.setSummary(rs.getString("summary"));
            document.setReadCount(rs.getString("readcount"));
            document.setCommentCount(rs.getString("commentCount"));
            document.setTitle(rs.getString("title"));
            document.setPeronName(rs.getString("personName"));
            document.setRecommendCount(rs.getString("recommendCount"));
            document.setVersion(rs.getString("version"));
            document.setNumber(rs.getString("number"));
            document.setContentType(rs.getString("contentType"));
            document.setAuthorId(rs.getString("authorId"));
            document.setCreateTime(rs.getTimestamp("createtime"));
            document.setCanDownload(rs.getInt("canDownload"));
            document.setIsPrintAttach(rs.getInt("isPrintAttach"));
            document.setCategoryId(rs.getString("categoryID"));
            document.setCanCopy(rs.getInt("canCopy"));
            document.setState(rs.getString("state"));
            document.setDocMarkNumber(rs.getString("docMarkNumber"));
            document.setCreatePersonId(rs.getString("createpersonid"));
            document.setWfState(rs.getString("wfstate"));
        }
        return document;
    }

    @Override
    public Category getCategoryById(Context ctx, String categoryId) throws Exception {
        Category category = new Category();
        String sql = "select a.fid id,a.FName_l2 name, a.fborrowDays fborrowDays,a.fisAnonymous isAnonymous,a.fisprintattach isprintattach,a.fisShowCreatorDeptCom isShowCreatorDeptCom,a.fisShowAuthorDeptCom isShowAuthorDeptCom,a.fcandownload canDownload from t_dm_category a where a.fid=?";
        Object[] param = new Object[]{categoryId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        if (rs.next()) {
            category.setId(rs.getString("id"));
            category.setName(rs.getString("name"));
            category.setBorrowDays(rs.getInt("fborrowDays"));
            category.setIsAnonymous(rs.getInt("isAnonymous"));
            category.setIsPrintAttach(rs.getInt("isPrintAttach"));
            category.setIsShowAuthorDeptCom(rs.getInt("isShowAuthorDeptCom"));
            category.setIsShowCreatorDeptCom(rs.getInt("isShowCreatorDeptCom"));
            category.setCanDownload(rs.getInt("canDownload"));
        }
        return category;
    }

    @Override
    public String getEnterpriseDocName(Context ctx) throws Exception {
        String enterpriseDocName = "";
        String sql = "select fenterpriseDocName enterpriseDocName from t_dm_DocManageParametersSet where fid='nDz0XDd6SnKFCh82gWEx7BgOPPE='";
        Object[] param = new Object[0];
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        if (rs.next()) {
            enterpriseDocName = rs.getString("enterpriseDocName");
        }
        return enterpriseDocName;
    }

    @Override
    public List getAuthorDocs(Context ctx, String authorId, String docId) throws Exception {
        Document document = new Document();
        String sql = "select a.fid id,a.ftitle title from t_dm_document a where a.fauthorid =? and a.fid<>?";
        Object[] param = new Object[]{authorId, docId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        ArrayList result = new ArrayList();
        while (rs.next()) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("id", rs.getString("id"));
            hm.put("title", rs.getString("title"));
            result.add(hm);
        }
        return result;
    }

    public String getBorrowIds(Context ctx, String personId) throws Exception {
        Document document = new Document();
        HashMap<String, String> hm = new HashMap<String, String>();
        String sql = "select fdocumentId documentid,fid id from t_dm_documentborrow where fborrowerid=? order by fapplydate asc";
        Object[] param = new Object[]{personId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        while (rs.next()) {
            hm.put(rs.getString("documentid"), rs.getString("id"));
        }
        String borrowIds = "";
        Iterator iterator = hm.keySet().iterator();
        while (iterator.hasNext()) {
            borrowIds = borrowIds + "'" + hm.get(iterator.next()) + "',";
        }
        if (borrowIds.endsWith(",")) {
            borrowIds = borrowIds.substring(0, borrowIds.length() - 1);
        }
        this.logger.error("getBorrowIds:" + borrowIds);
        return borrowIds;
    }

    @Override
    public String getLatestBorrowId(Context ctx, String docId) throws Exception {
        String borrowId = "";
        String sql = "select fid id from t_dm_documentborrow where fdocumentid=? order by fcreateTime desc";
        Object[] param = new Object[]{docId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        if (rs.next()) {
            borrowId = rs.getString("id");
        }
        return borrowId;
    }

    @Override
    public List<DmCategoryTreeDTO> findDmCategoryListByDocAreaId(Context ctx, String docAreaId, List<DmPermCacheInfo> list) throws PortalBizException {
        ArrayList<DmCategoryTreeDTO> dmTreeList = new ArrayList<DmCategoryTreeDTO>();
        if (null == list || list.size() == 0) {
            return dmTreeList;
        }
        StringBuffer getCategoryByDocareaIdSQL = new StringBuffer("select fid,fname_l2,fparentid,fnumber,flongnumber,fisleaf,flevel ,fdescription_l2,fdocareaid  from t_dm_category  where FState = 1 and flevel = 1 and fdocareaid='");
        getCategoryByDocareaIdSQL.append(docAreaId);
        getCategoryByDocareaIdSQL.append("'  order by findex");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getCategoryByDocareaIdSQL.toString());
            this.logger.info("\u6839\u636e\u6587\u6863\u533aid\u83b7\u53d6\u4e00\u7ea7\u680f\u76ee\u7684\u4fe1\u606f\uff0cgetCategoryByDocareaIdSQL = " + getCategoryByDocareaIdSQL.toString());
            String flongnumber = "";
            String fdocareaid = "";
            while (rs.next()) {
                flongnumber = rs.getString("flongnumber");
                fdocareaid = rs.getString("fdocareaid");
                getCategoryByDocareaIdSQL = new StringBuffer("select fid,fname_l2,fparentid,fnumber,flongnumber,fisleaf,flevel ,fdescription_l2,fdocareaid  from t_dm_category  where FState = 1 and fdocareaid='");
                getCategoryByDocareaIdSQL.append(fdocareaid);
                getCategoryByDocareaIdSQL.append("' and  (flongnumber like '");
                getCategoryByDocareaIdSQL.append(flongnumber);
                getCategoryByDocareaIdSQL.append("!%'  and flevel>'1') or (flongnumber = '");
                getCategoryByDocareaIdSQL.append(flongnumber);
                getCategoryByDocareaIdSQL.append("' and flevel='1') order by flevel desc, findex asc");
                try {
                    this.logger.info("\u6839\u636e\u4e00\u7ea7\u680f\u76ee\u7684longnumber\u83b7\u53d6\u5176\u4e0b\u6240\u6709\u7684\u680f\u76ee\u7684\u4fe1\u606f\uff0cgetCategoryByDocareaIdSQL = " + getCategoryByDocareaIdSQL.toString());
                    IRowSet rsByDocareaId = DbUtil.executeQuery((Context)ctx, (String)getCategoryByDocareaIdSQL.toString());
                    String[] perm = null;
                    String longnumberMax = "";
                    String flongnumbervar = "";
                    DmCategoryTreeDTO dto = null;
                    block7: while (rsByDocareaId.next()) {
                        for (int i = 0; i < list.size(); ++i) {
                            DmPermCacheInfo doc = list.get(i);
                            flongnumbervar = rsByDocareaId.getString("flongnumber");
                            if (!"".equals(longnumberMax) && !longnumberMax.equals(flongnumbervar) && longnumberMax.indexOf(flongnumbervar) != -1) {
                                dto = new DmCategoryTreeDTO();
                                dto.setId(rsByDocareaId.getString("fid"));
                                dto.setName(rsByDocareaId.getString("fname_l2"));
                                dto.setParentId(null == rsByDocareaId.getString("fparentid") ? docAreaId : rsByDocareaId.getString("fparentid"));
                                dto.setLevel(rsByDocareaId.getInt("flevel"));
                                dto.setLongNumber(flongnumbervar);
                                dto.setLeaf(rsByDocareaId.getBoolean("fisleaf"));
                                dto.setDesc(rsByDocareaId.getString("fdescription_l2"));
                                dto.setNumber(rsByDocareaId.getString("fnumber"));
                                dto.setType("category");
                                longnumberMax = "".equals(longnumberMax) ? flongnumbervar : longnumberMax;
                                dmTreeList.add(dto);
                                continue block7;
                            }
                            String[] stringArray = perm = null != doc.getPermList() ? doc.getPermList().split(",") : null;
                            if (null != doc.getDocID() || null == doc.getCatID() || !doc.getCatID().equals(rsByDocareaId.getString("fid")) || null == doc.getDocAreaID() || null == perm || perm.length <= 0) continue;
                            for (int j = 0; j < perm.length; ++j) {
                                if (!perm[j].equals("4") && !perm[j].equals("5")) continue;
                                dto = new DmCategoryTreeDTO();
                                dto.setId(rsByDocareaId.getString("fid"));
                                dto.setName(rsByDocareaId.getString("fname_l2"));
                                dto.setParentId(null == rsByDocareaId.getString("fparentid") ? docAreaId : rsByDocareaId.getString("fparentid"));
                                dto.setLevel(rsByDocareaId.getInt("flevel"));
                                dto.setLongNumber(rsByDocareaId.getString("flongnumber"));
                                dto.setLeaf(true);
                                dto.setDesc(rsByDocareaId.getString("fdescription_l2"));
                                dto.setNumber(rsByDocareaId.getString("fnumber"));
                                dto.setType("category");
                                longnumberMax = "".equals(longnumberMax) ? flongnumbervar : longnumberMax;
                                dmTreeList.add(dto);
                                continue block7;
                            }
                            continue block7;
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dmTreeList;
    }

    @Override
    public List<DmCategoryTreeDTO> findDmDocAreaListByPersonId(Context ctx, List<DmPermCacheInfo> list) throws PortalBizException {
        ArrayList<DmCategoryTreeDTO> dmTreeList = null;
        if (null != list && list.size() > 0) {
            ArrayList<String> docaredIds = new ArrayList<String>();
            String[] perm = null;
            block3: for (int i = 0; i < list.size(); ++i) {
                DmPermCacheInfo doc = list.get(i);
                String[] stringArray = perm = null != doc.getPermList() ? doc.getPermList().split(",") : null;
                if (null != doc.getDocID() || null == doc.getCatID() || null == doc.getDocAreaID() || null == perm || perm.length <= 0) continue;
                for (int j = 0; j < perm.length; ++j) {
                    if (!perm[j].equals("4") && !perm[j].equals("5")) continue;
                    if (docaredIds.contains(doc.getDocAreaID())) continue block3;
                    docaredIds.add(doc.getDocAreaID());
                    continue block3;
                }
            }
            StringBuffer sql = new StringBuffer("select findex,fid,fname_l2,fnumber,FDescription_l2 from t_dm_docarea where FState =1  and fid in");
            sql.append(PermissionUtil.getStrFromList(docaredIds));
            sql.append(" order by fname_l2 asc ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                this.logger.info("\u83b7\u53d6\u7528\u6237\u6709\u6743\u9650\u7684\u6587\u6863\u533a\u4fe1\u606f\uff0csql = " + sql.toString());
                dmTreeList = new ArrayList<DmCategoryTreeDTO>(rs.size());
                this.logger.info("getDmPermListCacheBySql: rs.size()=" + rs.size());
                DmCategoryTreeDTO dto = null;
                while (rs.next()) {
                    dto = new DmCategoryTreeDTO();
                    dto.setId(rs.getString("fid"));
                    dto.setName(rs.getString("fname_l2"));
                    dto.setParentId("root");
                    dto.setLevel(1);
                    dto.setLongNumber(rs.getString("findex"));
                    dto.setLeaf(false);
                    dto.setDesc(rs.getString("FDescription_l2"));
                    dto.setNumber(rs.getString("findex"));
                    dto.setType("docarea");
                    dmTreeList.add(dto);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return dmTreeList;
    }

    @Override
    public PagingResult<Document> findMySpecialList(String personId, String searchText, PagingParam pagingParam) throws DataAccessException {
        List list = PermissionUtil.getDmPermListCache();
        if (null == list || list.size() == 0) {
            return this.getEmptyDefaultPagingResult();
        }
        ArrayList<String> docIds = new ArrayList<String>();
        String[] perm = null;
        block0: for (int i = 0; i < list.size(); ++i) {
            DmPermCacheInfo doc = (DmPermCacheInfo)list.get(i);
            String[] stringArray = perm = null != doc.getPermList() ? doc.getPermList().split(",") : null;
            if (null == doc.getDocID() || null == perm || perm.length <= 0) continue;
            for (int j = 0; j < perm.length; ++j) {
                if (!perm[j].equals("4") && !perm[j].equals("5")) continue;
                docIds.add(doc.getDocID());
                continue block0;
            }
        }
        if (docIds.size() > 0) {
            StringBuilder selectClause = new StringBuilder();
            selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.Document(d.id, d.summary, d.readCount, d.commentCount, d.title, d.createPersonId, d.recommendCount,p.name,d.createTime,d.version,d.number,d.contentType,d.issueTime) ");
            selectClause.append("FROM Document d, Person p WHERE p.id=d.createPersonId ");
            StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM Document d,Person p WHERE  p.id=d.createPersonId ");
            StringBuilder whereClause = new StringBuilder();
            whereClause.append(" and d.state=1 and d.wfState=3 and d.isHistory=0 AND  d.id in ");
            whereClause.append(PermissionUtil.getStrFromList(docIds));
            if (searchText != null && !"".equals(searchText)) {
                whereClause.append(" AND ( d.title like '%" + searchText + "%' or p.name like '%" + searchText + "%') ");
            }
            StringBuilder orderClause = new StringBuilder();
            orderClause.append(" order by d.issueTime desc ");
            selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
            countClause.append((CharSequence)whereClause);
            PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
            PermissionUtil.clearDmPermListCache();
            return pagingResult;
        }
        PermissionUtil.clearDmPermListCache();
        return this.getEmptyDefaultPagingResult();
    }

    @Override
    public PagingResult<Document> findDocsList(Context ctx, String searchText, PagingParam pagingParam, String type, String docareaIdOrCategoryId) throws PortalBizException, DataAccessException {
        List list = PermissionUtil.getDmPermListCache();
        if (null == list || list.size() == 0) {
            return this.getEmptyDefaultPagingResult();
        }
        ArrayList<String> categoryIds = new ArrayList<String>();
        if (null != type && "docarea".equals(type) && null != docareaIdOrCategoryId) {
            String[] perm = null;
            block0: for (int i = 0; i < list.size(); ++i) {
                DmPermCacheInfo doc = (DmPermCacheInfo)list.get(i);
                String[] stringArray = perm = null != doc.getPermList() ? doc.getPermList().split(",") : null;
                if (null != doc.getDocID() || null == perm || perm.length <= 0 || !doc.getDocAreaID().equals(docareaIdOrCategoryId)) continue;
                for (int j = 0; j < perm.length; ++j) {
                    if (!perm[j].equals("4") && !perm[j].equals("5")) continue;
                    categoryIds.add(doc.getCatID());
                    continue block0;
                }
            }
        } else {
            DmPermCacheInfo doc;
            int i;
            String currentCategoryLongnumber = "";
            String[] perm = null;
            for (i = 0; i < list.size(); ++i) {
                doc = (DmPermCacheInfo)list.get(i);
                String[] stringArray = perm = null != doc.getPermList() ? doc.getPermList().split(",") : null;
                if (null == doc.getDocID() && null != perm && perm.length > 0 && doc.getCatID().equals(docareaIdOrCategoryId)) {
                    for (int j = 0; j < perm.length; ++j) {
                        if (!perm[j].equals("4") && !perm[j].equals("5")) continue;
                        currentCategoryLongnumber = doc.getCatLongNumber();
                        break;
                    }
                }
                if (!"".equals(currentCategoryLongnumber)) break;
            }
            block4: for (i = 0; i < list.size(); ++i) {
                String tempLongNum;
                doc = (DmPermCacheInfo)list.get(i);
                String[] stringArray = perm = null != doc.getPermList() ? doc.getPermList().split(",") : null;
                if (doc.getCatLongNumber() == null || currentCategoryLongnumber.length() <= 0) continue;
                boolean isBelongCat = false;
                if (doc.getCatLongNumber().equals(currentCategoryLongnumber)) {
                    isBelongCat = true;
                } else if (doc.getCatLongNumber().length() > currentCategoryLongnumber.length() && (tempLongNum = doc.getCatLongNumber().substring(0, currentCategoryLongnumber.length() + 1)).equals(currentCategoryLongnumber + "!")) {
                    isBelongCat = true;
                }
                if (null != doc.getDocID() || null == perm || perm.length <= 0 || !isBelongCat) continue;
                for (int j = 0; j < perm.length; ++j) {
                    if (!perm[j].equals("4") && !perm[j].equals("5")) continue;
                    categoryIds.add(doc.getCatID());
                    continue block4;
                }
            }
        }
        if (categoryIds.size() > 0) {
            StringBuilder selectClause = new StringBuilder();
            selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.Document(d.id, d.summary, d.readCount, d.commentCount, d.title, d.createPersonId, d.recommendCount,p.name,d.createTime,d.version,d.number,d.contentType,d.isTop,d.isRed,d.isLatest,d.topStartTime,d.topEndTime,d.redStartTime,d.redEndTime,d.latestStartTime,d.latestEndTime,d.issueTime) ");
            selectClause.append("FROM Document d, Person p WHERE p.id=d.createPersonId ");
            StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM Document d,Person p WHERE  p.id=d.createPersonId ");
            StringBuilder whereClause = new StringBuilder();
            whereClause.append(" and d.state=1 and d.isHistory=0 and d.wfState=3 AND  d.categoryId in ");
            whereClause.append(PermissionUtil.getStrFromList(categoryIds));
            if (searchText != null && !"".equals(searchText)) {
                whereClause.append(" AND ( d.title like '%" + searchText + "%' or p.name like '%" + searchText + "%') ");
            }
            StringBuilder orderClause = new StringBuilder();
            orderClause.append(" order by d.issueTime desc ");
            selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
            countClause.append((CharSequence)whereClause);
            PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
            PermissionUtil.clearDmPermListCache();
            return pagingResult;
        }
        PermissionUtil.clearDmPermListCache();
        return this.getEmptyDefaultPagingResult();
    }

    @Override
    public PagingResult<Document> findPortletDocsList(Context ctx, String searchText, PagingParam pagingParam, Set categoryIds) throws PortalBizException, DataAccessException {
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.plt.cp.module.document.entity.Document(d.id, d.summary, d.readCount, d.commentCount, d.title, d.createPersonId, d.recommendCount,p.name,d.createTime,d.version,d.number,d.contentType,d.isTop,d.isRed,d.isLatest,d.topStartTime,d.topEndTime,d.redStartTime,d.redEndTime,d.latestStartTime,d.latestEndTime,d.issueTime,d.categoryId,d.docSerialNO) ");
        selectClause.append("FROM Document d, Person p WHERE p.id=d.createPersonId ");
        StringBuilder countClause = new StringBuilder("SELECT count(d.id) FROM Document d,Person p WHERE  p.id=d.createPersonId ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append(" and d.state=1 and d.isHistory=0 and d.wfState=3 AND  d.categoryId in ");
        whereClause.append(this.getStrFromSet(categoryIds));
        if (searchText != null && !"".equals(searchText)) {
            whereClause.append(" AND ( d.title like '%" + searchText + "%' or p.name like '%" + searchText + "%') ");
        }
        StringBuilder orderClause = new StringBuilder();
        orderClause.append(" order by d.issueTime desc ");
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        List records = pagingResult.getRecords();
        ArrayList<Document> _records = new ArrayList<Document>();
        ArrayList<Document> topRecords = new ArrayList<Document>();
        for (Document document : records) {
            if (!this.ifTop(document)) {
                _records.add(document);
                continue;
            }
            topRecords.add(document);
        }
        for (Document document : topRecords) {
            if (Integer.parseInt(document.getDocSerialNO()) == 0) {
                _records.add(0, document);
                continue;
            }
            if (Integer.parseInt(document.getDocSerialNO()) >= records.size()) {
                _records.add(document);
                continue;
            }
            _records.add(Integer.parseInt(document.getDocSerialNO()) - 1, document);
        }
        pagingResult.setRecords(_records);
        PermissionUtil.clearDmPermListCache();
        return pagingResult;
    }

    private boolean ifTop(Document document) {
        long now = new Date().getTime();
        return document.getIsTop().equals("1") && now > document.getTopStart().getTime() && now < document.getTopEnd().getTime() && document.getDocSerialNO() != null && Integer.parseInt(document.getDocSerialNO()) >= 0;
    }

    @Override
    public Set getEnableCates(Context ctx, Set categoryIds) throws Exception {
        String sql = "select fid id from t_dm_category where fstate=1 and fid in " + this.getStrFromSet(categoryIds);
        Object[] param = new Object[]{};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        HashSet<String> catIdSet = new HashSet<String>();
        while (rs.next()) {
            catIdSet.add(rs.getString("id"));
        }
        return catIdSet;
    }

    private String getStrFromSet(Set set) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        int len = set.size();
        for (Object key : set) {
            sb.append("'").append((String)key).append("'");
            if (i < len - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private PagingResult<Document> getEmptyDefaultPagingResult() {
        PagingParam pp = new PagingParam();
        pp.setOrder(null);
        pp.setPageNo(1);
        pp.setPageSize(10);
        pp.setSortField(null);
        PagingResult tempResult = new PagingResult();
        tempResult.setTotalCount(0);
        tempResult.setRecords(new ArrayList());
        tempResult.setPagingParam(pp);
        return tempResult;
    }
}

