/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cm.common.util.ChechPersonTool;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSettingAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(BaseSettingAction.class);

    public String baseSettingManager() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        boolean isPerson = ChechPersonTool.checPerson((HttpServletRequest)this.getRequest());
        if (!isPerson) {
            return "noPerson";
        }
        String[] amodulePer = new String[]{"cp_stamp_amodule_set"};
        String[] documentControlSettingPer = new String[]{"cp_stamp_documentControlSetting_save"};
        String[] ImInfoPer = new String[]{"cp_uc_ImInfo_Update"};
        String[] ConfidentialPer = new String[]{"cp_arcm_Confidential_View", "cp_arcm_Confidential_Delete", "cp_arcm_Confidential_Update"};
        String[] ThematicPer = new String[]{"cp_arcm_Thematic_View", "cp_arcm_Thematic_Update", "cp_arcm_Thematic_Delete"};
        String[] LatestPRSPer = new String[]{"cp_odm_LatestOdmPRS"};
        String[][] all = new String[][]{amodulePer, documentControlSettingPer, ImInfoPer, ConfidentialPer, ThematicPer, LatestPRSPer};
        List<Boolean> ls = this.whichListHasPermission(all, ctx);
        boolean amodule = ls.get(0);
        boolean documentControlSetting = ls.get(1);
        boolean globleSet = false;
        globleSet = amodule || documentControlSetting;
        boolean imInfo = ls.get(2);
        boolean confidential = ls.get(3);
        boolean thematic = ls.get(4);
        boolean latestPRS = ls.get(5);
        String urltype = this.getRequest().getParameter("type");
        if (StringUtil.isEmpty((String)urltype)) {
            urltype = "";
        }
        this.getRequest().setAttribute("odmUrl", (Object)(urltype.equals("odm") ? 1 : 0));
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        this.getRequest().setAttribute("amodule", (Object)amodule);
        this.getRequest().setAttribute("documentControlSetting", (Object)documentControlSetting);
        this.getRequest().setAttribute("globleSet", (Object)globleSet);
        this.getRequest().setAttribute("imInfo", (Object)imInfo);
        this.getRequest().setAttribute("confidential", (Object)confidential);
        this.getRequest().setAttribute("thematic", (Object)thematic);
        this.getRequest().setAttribute("latestPRS", (Object)latestPRS);
        logger.info("amodule=" + amodule + " documentControlSetting=" + documentControlSetting + " globleSet=" + globleSet + " confidential=" + confidential + " thematic=" + thematic + " latestPRS=" + latestPRS);
        return "success";
    }

    private List<Boolean> whichListHasPermission(String[][] permNameList, Context ctx) {
        ArrayList<Boolean> resList = new ArrayList<Boolean>();
        for (String[] ls : permNameList) {
            resList.add(this.perListCheck(ls, ctx));
        }
        return resList;
    }

    private boolean perListCheck(String[] perList, Context ctx) {
        boolean re = false;
        for (String str : perList) {
            try {
                this.checkFunctionPermission(str, (OrgUnitInfo)ContextUtil.getCurrentCtrlUnit((Context)ctx));
                re = true;
                return re;
            }
            catch (EASBizException eASBizException) {
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return re;
    }

    private void checkFunctionPermission(String permItemName, OrgUnitInfo mainOrg) throws BOSException, EASBizException {
        IPermission perm = PermissionFactory.getRemoteInstance();
        Context uiContext = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        ObjectUuidPK orgPK = null;
        OrgUnitInfo org = mainOrg;
        if (org != null) {
            orgPK = new ObjectUuidPK(org.getId());
        }
        ObjectUuidPK userPK = null;
        CoreBaseInfo user = (CoreBaseInfo)uiContext.get((Object)"UserInfo");
        if (user != null) {
            userPK = new ObjectUuidPK(user.getId());
        }
        if (orgPK == null) {
            throw new EASBizException(new NumericExceptionSubItem("007", "\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6821\u9a8c\u6743\u9650\u3002"));
        }
        perm.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemName);
    }
}

